﻿/*
	Name:			XenoN Core Framework Header
	Version:		1.0.1.0 Dark Issue
	Update:			2011-04-24
	Copyright:		Copyright © 2007-2011 XenoN Core by PsichiX. All rights reserved.
	Author:			PsichiX
	Website:		http://www.xenon.psichix.com
	Description:	XenoN Core 4D World Engine Framework Header
*/

/*
	== EN ==
	This file is part of Xenon Core Framework.
	You may distribute it further, but you can not modify it.
	Please do not use in modified form.
	The principles of XenoN Core License available in the file LICENSE_CORE_EN.TXT or visit: http://www.xenon.psichix.com.

	== PL ==
	Ten plik jest czescia XenoN Core Framework.
	Mozesz go rozpowszechniac dalej, jednak nie mozesz go modyfikowac.
	Nalezy uzytkowac w nie zmodyfikowanej formie.
	Nalezy przestrzegac zasad Licencji XenoN Core dostepnej w pliku LICENSE_CORE_PL.TXT oraz na stronie: http://www.xenon.psichix.com.
*/

#ifndef XENON_CORE_FRAMEWORK_H
#define XENON_CORE_FRAMEWORK_H

#include "../XeCore/XenonCore.h"
#if defined(XE_COMPILE_STATIC)&&!defined(XE_ALREADY_IMPLEMENTED)
#define XE_CANIMP
#endif /* XE_COMPILE_STATIC */
#include <shellapi.h>
#include <limits>
#pragma comment(lib,"winmm.lib")

//! \namespace XeCore	Przestrzen nazw XenoN Core
namespace XeCore
{

#define PI						3.1415926535897932384626433832795

#define XeMain()				WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
#define XeMainConsole()			main(int argc,char* argv[])
#define XE_MAIN_BEGIN			int XeMain(){XeInitiation();XeMainParams.Set(lpCmdLine);
#define XE_MAIN_CONSOLE_BEGIN	int XeMainConsole(){XeInitiation();for(int __i__=1;__i__<argc;__i__++){XeMainParams<<argv[__i__];if(__i__<argc-1)XeMainParams<<" ";}
#define XE_MAIN_END				XeClosure();return(true);}
#define repeat(times)			for(int __c_o_u_n_t_e_r__=0;__c_o_u_n_t_e_r__<((int)times);__c_o_u_n_t_e_r__++)
#define uswitch(var)			for(unsigned int __t_e_m_p__=0,__p_t_r__=(unsigned int)&var;__t_e_m_p__<1;__t_e_m_p__++)
#define ucase(type,val)			if(*(type*)__p_t_r__==val)
#define PROGRESS(name)			void name(HWND win,void* inout)
#define SCENE(name)				void name()

#define XEF_RES_FRAMEWORK		1025
#define XEF_RES_MAIN_ICON		1

#define XE_MOUSE_ANY			0x00
#define XE_MOUSE_LEFT			0x01
#define XE_MOUSE_RIGHT			0x02
#define XE_MOUSE_MIDDLE			0x03
#define XE_MOUSE_WHEELUP		0x04
#define XE_MOUSE_WHEELDOWN		0x05
#define XE_KEY_ANY				0x00
#define XE_KEY_MOUSELEFT		0x01
#define XE_KEY_MOUSERIGHT		0x02
#define XE_KEY_MOUSEMIDDLE		0x04
#define XE_KEY_BACKSPACE		0x08
#define XE_KEY_TAB				0x09
#define XE_KEY_ENTER			0x0D
#define XE_KEY_SHIFT			0x10
#define XE_KEY_CTRL				0x11
#define XE_KEY_ALT				0x12
#define XE_KEY_PAUSE			0x13
#define XE_KEY_CAPSLOCK			0x14
#define XE_KEY_ESC				0x1B
#define XE_KEY_SPACE			0x20
#define XE_KEY_PAGEUP			0x21
#define XE_KEY_PAGEDOWN			0x22
#define XE_KEY_END				0x23
#define XE_KEY_HOME				0x24
#define XE_KEY_LEFT				0x25
#define XE_KEY_UP				0x26
#define XE_KEY_RIGHT			0x27
#define XE_KEY_DOWN				0x28
#define XE_KEY_PRINTSCREEN		0x2C
#define XE_KEY_INSERT			0x2D
#define XE_KEY_DELETE			0x2E
#define XE_KEY_0				0x30
#define XE_KEY_1				0x31
#define XE_KEY_2				0x32
#define XE_KEY_3				0x33
#define XE_KEY_4				0x34
#define XE_KEY_5				0x35
#define XE_KEY_6				0x36
#define XE_KEY_7				0x37
#define XE_KEY_8				0x38
#define XE_KEY_9				0x39
#define XE_KEY_A				0x41
#define XE_KEY_B				0x42
#define XE_KEY_C				0x43
#define XE_KEY_D				0x44
#define XE_KEY_E				0x45
#define XE_KEY_F				0x46
#define XE_KEY_G				0x47
#define XE_KEY_H				0x48
#define XE_KEY_I				0x49
#define XE_KEY_J				0x4A
#define XE_KEY_K				0x4B
#define XE_KEY_L				0x4C
#define XE_KEY_M				0x4D
#define XE_KEY_N				0x4E
#define XE_KEY_O				0x4F
#define XE_KEY_P				0x50
#define XE_KEY_Q				0x51
#define XE_KEY_R				0x52
#define XE_KEY_S				0x53
#define XE_KEY_T				0x54
#define XE_KEY_U				0x55
#define XE_KEY_V				0x56
#define XE_KEY_W				0x57
#define XE_KEY_X				0x58
#define XE_KEY_Y				0x59
#define XE_KEY_Z				0x5A
#define XE_KEY_WINLEFT			0x5B
#define XE_KEY_WINRIGHT			0x5C
#define XE_KEY_SLEEP			0x5F
#define XE_KEY_NUMPAD0			0x60
#define XE_KEY_NUMPAD1			0x61
#define XE_KEY_NUMPAD2			0x62
#define XE_KEY_NUMPAD3			0x63
#define XE_KEY_NUMPAD4			0x64
#define XE_KEY_NUMPAD5			0x65
#define XE_KEY_NUMPAD6			0x66
#define XE_KEY_NUMPAD7			0x67
#define XE_KEY_NUMPAD8			0x68
#define XE_KEY_NUMPAD9			0x69
#define XE_KEY_MULTIPLY			0x6A
#define XE_KEY_ADD				0x6B
#define XE_KEY_SEPARATOR		0x6C
#define XE_KEY_SUBTRACT			0x6D
#define XE_KEY_DECIMAL			0x6E
#define XE_KEY_DIVIDE			0x6F
#define XE_KEY_F1				0x70
#define XE_KEY_F2				0x71
#define XE_KEY_F3				0x72
#define XE_KEY_F4				0x73
#define XE_KEY_F5				0x74
#define XE_KEY_F6				0x75
#define XE_KEY_F7				0x76
#define XE_KEY_F8				0x77
#define XE_KEY_F9				0x78
#define XE_KEY_F10				0x79
#define XE_KEY_F11				0x7A
#define XE_KEY_F12				0x7B
#define XE_KEY_F13				0x7C
#define XE_KEY_F14				0x7D
#define XE_KEY_F15				0x7E
#define XE_KEY_F16				0x7F
#define XE_KEY_F17				0x80H
#define XE_KEY_F18				0x81H
#define XE_KEY_F19				0x82H
#define XE_KEY_F20				0x83H
#define XE_KEY_F21				0x84H
#define XE_KEY_F22				0x85H
#define XE_KEY_F23				0x86H
#define XE_KEY_F24				0x87H
#define XE_KEY_NUMLOCK			0x90
#define XE_KEY_SCROLLLOCK		0x91
#define XE_KEY_SHIFTLEFT		0xA0
#define XE_KEY_SHIFTRIGHT		0xA1
#define XE_KEY_CTRLLEFT			0xA2
#define XE_KEY_CTRTRIGHT		0xA3
#define XE_KEY_ALTLEFT			0xA4
#define XE_KEY_ALTRIGHT			0xA5
#define XE_KEY_SEMICOLON		0xBA
#define XE_KEY_EQUAL			0xBB
#define XE_KEY_COMMA			0xBC
#define XE_KEY_DASH				0xBD
#define XE_KEY_POINT			0xBE
#define XE_KEY_SHLASH			0xBF
#define XE_KEY_SQRBRACKETLEFT	0xDB
#define XE_KEY_BACKSLASH		0xDC
#define XE_KEY_SQRBRACKETRIGHT	0xDD
#define XE_KEY_APOSTROPHE		0xDE

#define XE_TRAY					0x8000
#define XE_TRAY_OVER			0x200
#define XE_TRAY_LEFT_PRESS		0x201
#define XE_TRAY_LEFT_RELEASE	0x202
#define XE_TRAY_RIGHT_PRESS		0x204
#define XE_TRAY_RIGHT_RELEASE	0x205
#define XE_TRAY_MIDDLE_PRESS	0x207
#define XE_TRAY_MIDDLE_RELEASE	0x208
#define XE_USER_BEGIN			0x8001
#define XE_USER_END				0xBFFF

#ifdef XE_CANIMP
XE_STRING XeMainParams;
unsigned int XeTrayCount=0;
#endif /* XE_CANIMP */
LRESULT	CALLBACK XeWndProc(HWND,UINT,WPARAM,LPARAM);
bool BoxCollision(XE_VECTOR b1,XE_VECTOR e1,XE_VECTOR b2,XE_VECTOR e2);
bool RectCollision(XE_VECTOR p,XE_VECTOR b,XE_VECTOR e);

enum XEF_ESTATE
{
XEF_NULL,
XEF_LOCATE,
XEF_CREATE,
XEF_DESTROY,
XEF_FIND,
XEF_CPU,
XEF_GPU,
XEF_BOX,
XEF_CIRCLE,
XEF_SHAPE,
XEF_OPEN,
XEF_SAVE,
XEF_ASM,
XEF_SL,
XEF_SERVER,
XEF_CLIENT,
XEF_HTTP_REQUEST,
XEF_HEADER,
XEF_KEEP,
XEF_DONE,
XEF_SEND
};

#define XEF_FLAG_EMPTY						0x00000000
#define XEF_FLAG_USED_TEXTURE				0x00000001
#define XEF_FLAG_USED_POINT_SPRITE			0x00000002
#define XEF_FLAG_OVERVRITE_PROMPT			0x00000001
#define XEF_FLAG_NO_PLACES_BAR				0x00000002
#define XEF_FLAG_MULTI_SELECT				0x00000004
#define XEF_FLAG_NO_READONLY_SELECT			0x00000008
#define XEF_FLAG_STATIC						0x00000000
#define XEF_FLAG_DYNAMIC					0x00000001
#define XEF_FLAG_STREAM						0x00000002
#define XEF_FLAG_DRAW						0x00000004
#define XEF_FLAG_WRITE						0x00000004
#define XEF_FLAG_READ						0x00000008
#define XEF_FLAG_COPY						0x00000010
#define	XEF_FLAG_FIT_TO_EDGE_TOP			0x00000001
#define	XEF_FLAG_FIT_TO_EDGE_BOTTOM			0x00000002
#define	XEF_FLAG_FIT_TO_EDGE_LEFT			0x00000004
#define	XEF_FLAG_FIT_TO_EDGE_RIGHT			0x00000008
#define	XEF_FLAG_FIT_TO_EDGE				XEF_FLAG_FIT_TO_EDGE_TOP|XEF_FLAG_FIT_TO_EDGE_BOTTOM|XEF_FLAG_FIT_TO_EDGE_LEFT|XEF_FLAG_FIT_TO_EDGE_RIGHT
#define	XEF_FLAG_INHERIT_WIDTH				0x00000010
#define	XEF_FLAG_INHERIT_HEIGHT				0x00000020
#define	XEF_FLAG_INHERIT_SIZE				XEF_FLAG_INHERIT_WIDTH|XEF_FLAG_INHERIT_HEIGHT
#define	XEF_FLAG_DOCK_TO_EDGE_TOP			0x00000040
#define	XEF_FLAG_DOCK_TO_EDGE_BOTTOM		0x00000080
#define	XEF_FLAG_DOCK_TO_EDGE_LEFT			0x00000100
#define	XEF_FLAG_DOCK_TO_EDGE_RIGHT			0x00000200
#define	XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE	0x00000400
#define	XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE	0x00000800
#define XEF_FLAG_DOCK_TO_CENTER				0x00001000
#define XEF_FLAG_DOCK_TO_MIDDLE				0x00002000
#define XEF_FLAG_CENTRALIZE					XEF_FLAG_DOCK_TO_CENTER|XEF_FLAG_DOCK_TO_MIDDLE
#define	XEF_FLAG_CAPTION_BAR				0x00000001
#define	XEF_FLAG_BUTTON_CLOSE				0x00000002
#define	XEF_FLAG_BUTTON_MINIMALIZE			0x00000004
#define	XEF_FLAG_BUTTON_FULLSCREEN			0x00000008
#define XEF_FLAG_CHILDS						0x00000001
#define XEF_FLAG_ME							0x00000002
#define	XEF_FLAG_EVENT_IDLE					0x00000000
#define	XEF_FLAG_EVENT_KEY_PRESS			0x00000001
#define	XEF_FLAG_EVENT_KEY_HOLD				0x00000002
#define	XEF_FLAG_EVENT_KEY_RELEASE			0x00000004
#define	XEF_FLAG_EVENT_KEY_BUTTONS			XEF_FLAG_EVENT_KEY_RELEASE|XEF_FLAG_EVENT_KEY_HOLD|XEF_FLAG_EVENT_KEY_PRESS
#define	XEF_FLAG_EVENT_MOUSE_PRESS			0x00000008
#define	XEF_FLAG_EVENT_MOUSE_HOLD			0x00000010
#define	XEF_FLAG_EVENT_MOUSE_RELEASE		0x00000020
#define	XEF_FLAG_EVENT_MOUSE_ENTER			0x00000040
#define	XEF_FLAG_EVENT_MOUSE_LEAVE			0x00000080
#define	XEF_FLAG_EVENT_MOUSE_OVER			0x00000100
#define	XEF_FLAG_EVENT_MOUSE_OUT			0x00000200
#define	XEF_FLAG_EVENT_MOUSE_MOVE			0x00000400
#define	XEF_FLAG_EVENT_MOUSE_BUTTONS		XEF_FLAG_EVENT_MOUSE_RELEASE|XEF_FLAG_EVENT_MOUSE_HOLD|XEF_FLAG_EVENT_MOUSE_PRESS
#define	XEF_FLAG_EVENT_MOUSE_SPACE			XEF_FLAG_EVENT_MOUSE_MOVE|XEF_FLAG_EVENT_MOUSE_OUT|XEF_FLAG_EVENT_MOUSE_OVER|XEF_FLAG_EVENT_MOUSE_LEAVE|XEF_FLAG_EVENT_MOUSE_ENTER
#define	XEF_FLAG_EVENT_MOUSE				XEF_FLAG_EVENT_MOUSE_BUTTONS|XEF_FLAG_EVENT_MOUSE_SPACE
#define XEF_FLAG_EVENT_USER					0x00000800
#define XEF_FLAG_EVENT_USER_LAST			0x80000000
#define XEF_FLAG_ALL						0xFFFFFFFF

/*====================*/
/*=== DECLARATIONS ===*/
/*====================*/

/*--- XE_S124I4 ---*/
/*! Klasa lancucha 124 znaków i indeksu 4-bajtowego. */
class XE_S124I4
{
public:
//! 124-znakowy cstring.
char string[124];
//! 4-bajtowy indeks.
unsigned int index;
XE_S124I4();
};

#ifdef XE_CANIMP

XE_S124I4::XE_S124I4()
{
string[0]=0;
index=0;
}

#endif /* XE_CANIMP */

/*--- XE_CONTAINER ---*/
/*! Klasa kontenera z dostepem do danych poprzez 124-znakowe nazwy. */
template <typename T>
class XE_CONTAINER
{
private:
XE_ELEMENTS<XE_S124I4> Names;
XE_ELEMENTS<T> Elements;
unsigned int Unique;
public:
/*! Ustala czy pamiec kontenera jest statyczna (jesli true to podczas niszczenia kontenera nie zostaje zwalniana jego pamiec). */
bool Static;
/*! Konstruktor domyslny. */
XE_CONTAINER();
/*! Destruktor. */
~XE_CONTAINER();
/*! Czysci kontener. */
void Clear();
/*! Zwraca referencje na dane elementu.
\param name Nazwa elementu.
\param id Identyfikator nazwy elementu.
\return Referencja na dane elementu.
*/
T& Access(char* name,unsigned int id=0);
/*! Zwraca referencje na dane elementu.
\param type Typ akcji na elemencie. Dostepne wartosci:<br>
XEF_LOCATE: Lokalizuj element.<br>
XEF_CREATE: Lokalizuj element lub utworz nowy jesli nie znajdzie.<br>
XEF_DESTROY: Zniszcz element.<br>
XEF_FIND: Szukaj pierwszego elementu.
\param name Nazwa elementu.
\param id Identyfikator nazwy elementu.
\return Referencja na dane elementu.
*/
T& Access(XEF_ESTATE type,char* name,unsigned int id=0);
/*! Zwraca ilosc elementow w kontenerze.
\param name Nazwa elementow.
\return Liczba elementow w kontenerze jesli name ma wartosc NULL, lub liczba elementow o danej nazwie jesli name jest rozne od NULL.
*/
unsigned int Count(char* name=NULL);
/*! Zwraca pierwszy element.
\return Pierwszy element w kontenerze.
*/
XE_ELEMENT_POINTER<T> FirstPointer();
/*! Zwraca ostatni element.
\return Ostatni element w kontenerze.
*/
XE_ELEMENT_POINTER<T> LastPointer();
/*! Przenosi wszystkie elementy do innego kontenera.
\param con Referencja na docelowy kontener.
*/
void Send(XE_CONTAINER<T>& con);
/*! Przenosi dany element do innego kontenera.
\param elm Referencja na element do przeniesienia.
\param con Referencja na docelowy kontener.
*/
void Send(XE_ELEMENT_POINTER<T>& elm,XE_CONTAINER<T>& con);
/*! Usuwa element o tych samych danych.
\param data Referencja na dane do porownania.
\return true jesli operacja powiodla sie.
*/
bool Remove(T& data);
/*! Usuwa element o tych samych danych (wariant ze wskaznikiem).
\param data Wskaznik na dane do porownania.
\return true jesli operacja powiodla sie.
*/
bool RemovePtr(T* data);
/*! Zwraca unikatowy identyfikator.
\return Zwraca unikalny identyfikator.
*/
unsigned int MakeUnique();
/*! Sortuje elementy uzywajac funkcji porownujacej.
\param foo Wskaznik na funkcje porownujaca dwa sasiednie elementy. Funkcja musi zwracac wartosc wieksza niz 0 dla wlasciwej kolejnosci, 0 dla identycznych wartosci, lub -1 dla niewlasciwej kolejnosci.
*/
void Sort(int(*foo)(T*,T*));
/*! Operator dostepu.
\param name Nazwa elementu.
\param id Identyfikator nazwy elementu.
\return Element kontenera.
*/
XE_ELEMENT_POINTER<T> operator() (char* name,unsigned int id=0);
/*! Operator dostepu.
\param type Typ akcji na elemencie. Dostepne wartosci:<br>
XEF_LOCATE: Lokalizuj element.<br>
XEF_CREATE: Lokalizuj element lub utworz nowy jesli nie znajdzie.<br>
XEF_DESTROY: Zniszcz element.<br>
XEF_FIND: Szukaj pierwszego elementu.
\param name Nazwa elementu.
\param id Identyfikator nazwy elementu.
\return Element kontenera.
*/
XE_ELEMENT_POINTER<T> operator() (XEF_ESTATE type,char* name,unsigned int id=0);
};

/*--- XE_WINDOW ---*/
/*! Klasa okna. */
class XE_WINDOW
{
private:
NOTIFYICONDATA Tray;
XE_ELM_RENDERTARGET RenderTarget;
bool captured;
HWND Window;
HINSTANCE Instance;
bool Fullscreen;
int Refresh;
public:
//! Szerokosc.
int Width;
//! Wysokosc.
int Height;
//! Aspekt obrazu.
float Aspect;
//! Pozycja X.
int X;
//! Pozycja Y.
int Y;
//! Glebia kolorow (8;16;24;32).
int ColorDepth;
//! Bufor glebi (8;16;24;32).
int Zdepth;
//! Ustala czy okno ma byc widoczne.
bool Show;
//! Ustala czy okno ma byc na pasku zadan.
bool OnBar;
//! Ustala czy okno ma byc w tray'u.
bool OnTray;
//! Nazwa okna
XE_STRING Name;
//! Przezroczystosc okna.
float Alpha;
//! Kolor przezroczysty.
XE_DWORD Tcolor;
//! Ustala czy okno ma miec wlaczona przezroczystosc dla koloru przezroczystego.
bool Transparent;
//! Ustala czy okno ma byc warstwowe (polprzezroczyste).
bool Layered;
//! Ustala czy okno ma byc ciagle na wierzchu ponad innymi oknami.
bool TopMost;
/*! Konstruktor domyslny. */
XE_WINDOW();
/*! Tworzy okno.
\param share RenderTarget z ktorym ma wspoldzielic zasoby.
\return true jesli operacja powiodla sie.
*/
bool Create(XE_ELM_RENDERTARGET share=XE_ELM_RENDERTARGET());
/*! Niszczy okno. */
void Destroy();
/*! Przechwytuje okno.
\param win Uchwyt okna do przechwycenia.
\param share RenderTarget z ktorym ma wspoldzielic zasoby.
*/
bool Capture(HWND win,XE_ELM_RENDERTARGET share=XE_ELM_RENDERTARGET());
/*! Zwalnia przechwycone okno. */
void Uncapture();
/*! Sprawdza czy okno jest przechwycone.
\return true jesli okno jest przechwycone.
*/
bool IsCaptured();
/*! Pobiera rozdzielczosc monitora. */
void FromDisplay();
/*! Pobiera pozycje i rozmiar z przestrzeni dostepnej dla okna (powierzchnia bez taskbaru). */
void FromWorkArea();
/*! Aktualizuje okno.
\return true jesli operacja powiodla sie.
*/
bool Update();
/*! Zwraca uchwyt okna.
\return Uchwyt okna.
*/
HWND GetWindow();
/*! Zwraca element RenderTarget okna.
\return Element RenderTarget.
*/
XE_ELM_RENDERTARGET GetTarget();
/*! Ustawia wlasciwosci ekranu: Tryb pelnoekranowy oraz odswierzanie ekranu.
\param fullscreen Tryb pelnoekranowy. -1: bez zmian; 0: wylaczony; 1: wlaczony.
\param refresh Odswierzanie ekranu jesli wieksze od zera, inaczej pozostawia bez zmian.
*/
void SetScreen(int fullscreen=-1,int refresh=0);
/*! Sprawdza czy wlaczony jest tryb pelnoekranowy.
\return true jesli tryb pelnoekranowy jest wlaczony.
*/
bool GetFullscreen();
/*! Zwraca wartosc odswierzania ekranu.
\return Wartosc odswierzania ekranu.
*/
int GetRefresh();
};

/*--- XE_IO ---*/
/*! Klasa interfejsu (klawiatura i mysz). Singleton. */
class XE_IO
{
friend class XE_EVENTS;
friend LRESULT CALLBACK XeWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
private:
XE_IO();
XE_IO(const XE_IO&);
bool Key[256];
bool KeyPressed[256];
bool KeyReleased[256];
bool KeyAfter[256];
bool MouseLb;
bool MouseMb;
bool MouseRb;
bool MouseLbPressed;
bool MouseMbPressed;
bool MouseRbPressed;
bool MouseLbReleased;
bool MouseMbReleased;
bool MouseRbReleased;
bool MouseLbAfter;
bool MouseMbAfter;
bool MouseRbAfter;
int MouseWheel;
bool MouseWheelUp;
bool MouseWheelDown;
int MouseWheelSteps;
POINT Mouse;
XE_ELEMENTS<char> Characters;
public:
//! Ostatnio wcisniety klawisz.
char KeyLast;
//! Ustala czy wcisniecie ma dzialac tylko raz (bez odnawiania stanu przy dluzszym trzymaniu przycisku).
bool PressOnce;
//! Zwraca referencje na instancje.
static XE_IO& Use();
/*! Pobiera pozycje myszy z systemu.
\return Wektor pozycji myszy.
*/
static XE_VECTOR MouseGetPos();
/*! Ustala pozycje myszy w systemie.
\param mx Pozycja X.
\param my Pozycja Y.
\return true jesli operacja powiodla sie.
*/
static bool MouseSetPos(int mx,int my);
/*! Pobiera pozycje X myszy.
\return Pozycja X.
*/
static int MouseGetX();
/*! Pobiera pozycje Y myszy.
\return Pozycja Y.
*/
static int MouseGetY();
/*! Pobiera pozycje X myszy wzgledem okna.
\return Pozycja X.
*/
static int MouseGetWinX(XE_WINDOW* wnd);
/*! Pobiera pozycje Y myszy wzgledem okna.
\return Pozycja Y.
*/
static int MouseGetWinY(XE_WINDOW* wnd);
/*! Sprawdza czy klawisz jest wcisniety.
\param key Klawisz.
\return Stan klawisza.
*/
static bool KeyboardGet(int key);
/*! Ustala czy klawisz jest wcisniety.
\param key Klawisz.
\param state Stan klawisza.
\return Nowy stan klawisza.
*/
static bool KeyboardSet(int key,bool state);
/*! Sprawdza czy klawisz zostal wcisniety.
\param key Klawisz.
\return Stan klawisza.
*/
static bool KeyboardGetPressed(int key);
/*! Ustala czy klawisz zostal wcisniety.
\param key Klawisz.
\param state Stan klawisza.
\return Nowy stan klawisza.
*/
static bool KeyboardSetPressed(int key,bool state);
/*! Sprawdza czy klawisz zostal zwolniony.
\param key Klawisz.
\return Stan klawisza.
*/
static bool KeyboardGetReleased(int key);
/*! Ustala czy klawisz zostal zwolniony.
\param key Klawisz.
\param state Stan klawisza.
\return Nowy stan klawisza.
*/
static bool KeyboardSetReleased(int key,bool state);
/*! Ustala czy stan klawisza ma byc wyczyszczony przed kolejna ramka.
\param key Klawisz.
\return Wyczyszczenie stanu klawisza.
*/
static bool KeyboardClearAfter(int key);
/*! Sprawdza czy przycisk myszy jest wcisniety.
\param button Przycisk myszy.
\return Stan przycisku myszy.
*/
static bool MouseGet(int button);
/*! Ustala czy przycisk myszy jest wcisniety.
\param button Przycisk myszy.
\param state Stan przycisku.
\return Nowy stan przycisku.
*/
static bool MouseSet(int button,bool state);
/*! Sprawdza czy przycisk myszy zostal wcisniety.
\param button Przycisk myszy.
\return Stan przycisku myszy.
*/
static bool MouseGetPressed(int button);
/*! Ustala czy przycisk myszy zostal wcisniety.
\param button Przycisk myszy.
\param state Stan przycisku.
\return Nowy stan przycisku.
*/
static bool MouseSetPressed(int button,bool state);
/*! Sprawdza czy przycisk myszy zostal zwolniony.
\param button Przycisk myszy.
\return Stan przycisku myszy.
*/
static bool MouseGetReleased(int button);
/*! Ustala czy przycisk myszy zostal zwolniony.
\param button Przycisk myszy.
\param state Stan przycisku.
\return Nowy stan przycisku.
*/
static bool MouseSetReleased(int button,bool state);
/*! Ustala czy stan przycisku myszy ma byc wyczyszczony przed kolejna ramka.
\param button Przycisk myszy.
\return Wyczyszczenie stanu przycisku.
*/
static bool MouseClearAfter(int button);
/*! Czysci stan przyciskow klawiatury i myszy.
\param allstates Jesli true, to czysci wszystkie stany, jesli false to czysci stany Pressed oraz Released.
\return true jesli operacja powiodla sie.
*/
static bool Clear(bool allstates);
/*! Zdejmuje znak ze stosu zapamietanych znakow klawiatury.
\param character Referencja na znak do ktorego zwroci pobrana wartosc.
\return true jesli operacja powiodla sie.
*/
static bool CharactersPop(char& character);
/*! Zdejmuje znaki ze stosu zapamietanych znakow klawiatury i wpisuje je do stringa.
\param string Referencja na string do ktorego zwroci pobrane znaki.
\param leave Ustala czy po pobraniu stringa ma pozostawic zapamietane znaki klawiatury.
\return true jesli operacja powiodla sie.
*/
static bool CharactersPopString(XE_STRING& string,bool leave=false);
/*! Zwraca ilosc zapamietanych znakow klawiatury.
\return Ilosc zapamietanych znakow.
*/
static unsigned int CharactersCount();
/*! Czysci zapamietane znaki klawiatury. */
static void CharactersClear();
};

/*--- XE_EVENTS ---*/
/*! Klasa zdarzen. Singleton. */
class XE_EVENTS
{
private:
float ftlmin;
float ftlmax;
float firt;
bool canrender;
float fiut;
bool canupdate;
XE_EVENTS();
XE_EVENTS(const XE_EVENTS&);
public:
//! Aktualny czas systemowy (od uruchomienia systemu).
float Time;
//! Czas nowej ramki.
float NewTime;
//! Roznica czasu pomiedzy ramkami
float DeltaTime;
//! Liczba ramek na sekunde.
float FPS;
//! Liczba wyrenderowanych ramek na sekunde.
float FPSRendered;
//! Liczba zaktualizowanych ramek na sekunde.
float FPSUpdated;
//! Aktualny czas trwania ramki.
float FPSTime;
//! Limit czasu wyswietlania ramki. Jesli rowne 0 to brak limitu.
float FrameTimeLimit;
//! Limit czasu pomiedzy renderowaniem kolejnych ramek. Jesli rowne 0 to brak limitu.
float FrameIntervalRenderLimit;
//! Limit czasu pomiedzy aktualizacja kolejnych ramek. Jesli rowne 0 to brak limitu.
float FrameIntervalUpdateLimit;
//! Ustala czy aplikacja ma zabierac mniej procent zuzycia procesora podczas czekania na kolejna ramke.
bool LowerCPUconsumption;
//! Liczba naliczonych ramek w danej sekundzie.
unsigned int Frames;
//! Liczba naliczonych wyrenderowanych ramek w danej sekundzie.
unsigned int FramesRendered;
//! Liczba naliczonych zaktualizowanych ramek w danej sekundzie.
unsigned int FramesUpdated;
//! Automatyczne czyszczenie stanow klawiatury i myszy.
bool AutoIOcleanup;
//! Automatyczne czyszczenie zapamietanych znakow.
bool AutoCharsCleanup;
//! Kominikaty.
MSG Msg;
//! Ustala czy zdarzenie postepu ramki ma sie wykonywac.
bool DoIt;
//! Wskaznik na funkcje przy aktywacji ikonki tray'a. HWND: Uchwyt okna; int: WPARAM; int: LPARAM.
void (*Tray)(HWND,int,int);
//! Wskaznik na funkcje uzytkownika. HWND: Uchwyt okna; unsigned int: Wiadomosc; int: WPARAM; int: LPARAM.
void (*User)(HWND,unsigned int,int,int);
//! Wskaznik na rozszerzenie procedur okna. HWND: Uchwyt okna; unsigned int: Wiadomosc; int: WPARAM; int: LPARAM.
void (*CustomWindowProc)(HWND,unsigned int,int,int);
/*! Wywolaj postep zdarzenia.
\param Progress Wskaznik na funkcje postepu zdarzenia. HWND: Uchwyt okna; void*: Wakaznik na dane wejsciowe/wyjsciowe.
\param InOut Wskaznik na dane wejsciowe/wyjsciowe.
\return true jesli operacja powiodla sie.
*/
static bool Execute(void(*Progress)(HWND,void*),void* InOut=0);
/*! Aktualizacja czasu wyswietlania ramki. */
static void FrameTimeUpdate();
/*! Sprawdza czy w bierzacej ramce mozna renderowac obraz (brane pod uwage przy FrameIntervalRenderLimit wiekszym od 0).
\return true jesli mozna renderowac obraz w bierzacej ramce
*/
static bool CanRender();
/*! Sprawdza czy w bierzacej ramce mozna aktualizowac logike gry (brane pod uwage przy FrameIntervalUpdateLimit wiekszym od 0).
\return true jesli mozna aktualizowac logike gry w bierzacej ramce
*/
static bool CanUpdate();
/*! Zwraca referencje na instancje obiektu.
\return Referencja na instancje obiektu.
*/
static XE_EVENTS& Use();
};

#ifdef XE_COMPILE_PHOTON

/*--- XE_SPRITE ---*/
/*! Klasa sprajta. */
class XE_SPRITE
{
private:
bool prepared;
XE_ELEMENTS<XE_ELM_TEXTURE> Textures;
XE_ELEMENT_POINTER<XE_ELM_TEXTURE> Current;
float CurrentID;
public:
//! Ilosc kolumn podklatek sprajta w teksturze.
int SubCols;
//! Ilosc wierszy podklatek sprajta w teksturze.
int SubRows;
//! Bierzaca faza podklatki sprajta.
float SubCurrentPhase;
//! Szerokosc.
int Width;
//! Wysokosc.
int Height;
//! Przesuniecie srodka w osi X.
int Xoffset;
//! Przesuniecie srodka w osi Y.
int Yoffset;
//! Szerokosc prostokata kolizji.
int BboxWidth;
//! Wysokosc prostokata kolizji.
int BboxHeight;
//! Przesuniecie srodka w osi X prostokata kolizji.
int BboxXoffset;
//! Przesuniecie srodka w osi Y prostokata kolizji.
int BboxYoffset;
//! Tablica wierzcholkow sprajta.
XE_PERVERTEX Rect[4];
//! Konstruktor domyslny.
XE_SPRITE();
/*! Przygotowuje sprajta.
\param filenames Nazwy plikow tekstur oddzielone srednikiem (";").
\param transparent Ustala czy ma uwzgledniac przezroczystosc.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\param xoff Przesuniecie srodka w osi X.
\param yoff Przesuniecie srodka w osi Y.
\param bw Szerokosc prostokata kolizji.
\param bh Wysokosc prostokata kolizji.
\param bxoff Przesuniecie srodka w osi X prostokata kolizji.
\param byoff Przesuniecie srodka w osi Y prostokata kolizji.
\return true jesli operacja powiodla sie.
*/
bool Prepare(char* filenames,bool transparent=true,XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST,int xoff=0,int yoff=0,int bw=-1,int bh=-1,int bxoff=0,int byoff=0);
/*! Przygotowuje sprajta z pamieci.
\param texdatav Tablica wskaznikow na dane tekstur.
\param count Ilosc tekstur w tablicy.
\param transparent Ustala czy ma uwzgledniac przezroczystosc.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\param xoff Przesuniecie srodka w osi X.
\param yoff Przesuniecie srodka w osi Y.
\param bw Szerokosc prostokata kolizji.
\param bh Wysokosc prostokata kolizji.
\param bxoff Przesuniecie srodka w osi X prostokata kolizji.
\param byoff Przesuniecie srodka w osi Y prostokata kolizji.
\return true jesli operacja powiodla sie.
*/
bool PrepareFromMemory(void** texdatav,int count,bool transparent=true,XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST,int xoff=0,int yoff=0,int bw=0,int bh=0,int bxoff=0,int byoff=0);
/*! Przygotowuje sprajta z renderu.
\param x Pozycja X.
\param y Pozycja Y.
\param width Szerokosc.
\param height Wysokosc.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\param xoff Przesuniecie srodka w osi X.
\param yoff Przesuniecie srodka w osi Y.
\param bw Szerokosc prostokata kolizji.
\param bh Wysokosc prostokata kolizji.
\param bxoff Przesuniecie srodka w osi X prostokata kolizji.
\param byoff Przesuniecie srodka w osi Y prostokata kolizji.
\return true jesli operacja powiodla sie.
*/
bool PrepareFromRender(int x,int y,int width,int height,XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST,int xoff=0,int yoff=0,int bw=0,int bh=0,int bxoff=0,int byoff=0);
/*! Przygotowuje pustego sprajta.
\param width Szerokosc.
\param height Wysokosc.
\param transparent Ustala czy ma uwzgledniac przezroczystosc.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\param xoff Przesuniecie srodka w osi X.
\param yoff Przesuniecie srodka w osi Y.
\param bw Szerokosc prostokata kolizji.
\param bh Wysokosc prostokata kolizji.
\param bxoff Przesuniecie srodka w osi X prostokata kolizji.
\param byoff Przesuniecie srodka w osi Y prostokata kolizji.
\return true jesli operacja powiodla sie.
*/
bool PrepareEmpty(int width,int height,bool transparent=true,XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST,int xoff=0,int yoff=0,int bw=0,int bh=0,int bxoff=0,int byoff=0);
/*! Zapisuje bierzaca teksture sprajta do pliku.
\param fname Sciezka do pliku.
\return true jesli operacja powiodla sie.
*/
bool SaveCurrent(char* fname);
#ifdef XE_COMPILE_CORE_VIRTUAL_FILE
/*! Zapisuje animacje sprajta do pliku.
\param fname Sciezka do pliku.
\return true jesli operacja powiodla sie.
*/
bool SaveAnimation(char* fname);
#endif /* XE_COMPILE_CORE_VIRTUAL_FILE */
/*! Ustala kolor sprajta.
\param col Kolor.
*/
void SetColor(XE_HALFVECTOR col=XE_HALFVECTOR(1,1,1));
/*! Zwraca kolor sprajta.
\return Kolor.
*/
XE_HALFVECTOR GetColor();
/*! Rysowanie sprajta o danej pozycji, obrotowi oraz skali.
\param position Pozycja sprajta.
\param angle Kat obrotu.
\param scale Skala.
*/
void Draw(XE_VECTOR position=XE_VECTOR(),XE_ANGLEVECTOR angle=XE_ANGLEVECTOR(),XE_VECTOR scale=XE_VECTOR(1,1,1));
/*! Rysowanie rozciagnietego sprajta.
\param start Poczatek prostokata.
\param end Koniec prostokata.
\param repeatx Powielanie tekstury w osi X.
\param repeaty Powielanie tekstury w osi Y.
*/
void DrawStretched(XE_HALFVECTOR start,XE_HALFVECTOR end,float repeatx=1,float repeaty=1);
/*! Rysowanie powielonego sprajta.
\param start Poczatek prostokata.
\param end Koniec prostokata.
\param scalex Skalowanie tekstury w osi X.
\param scaley Skalowanie tekstury w osi Y.
*/
void DrawTiled(XE_HALFVECTOR start,XE_HALFVECTOR end,float scalex=1,float scaley=1);
/*! Rysowanie fragmentu sprajta.
\param start Poczatek prostokata.
\param end Koniec prostokata.
\param coordstart Poczatkowe koordynaty.
\param coordend Koncowe koordynaty.
*/
void DrawPart(XE_HALFVECTOR start,XE_HALFVECTOR end,XE_HALFVECTOR coordstart,XE_HALFVECTOR coordend);
/*! Aktualizacja czworokatu sprite'a. */
void RectUpdate();
/*! Aktualizacja koordynatow tekstury sprite'a. */
void CoordsUpdate();
/*! Aktualizacja czworokatu kolizyjnego z ustawien sprite'a. */
void BboxUpdate();
/*! Aktualizacja sprite'a. */
void Update();
/*! Ustala bierzącą teksturę po indeksie.
\param index Indeks tekstury.
\return true jesli operacja powiodla sie.
*/
bool SetCurrent(float index);
/*! Zraca bierzącą teksturę.
\return Element tekstury.
*/
XE_ELM_TEXTURE GetCurrent();
/*! Zraca wskaznik na bierzącą teksturę.
\return Wskaznik na element tekstury.
*/
XE_ELM_TEXTURE* GetCurrentPointer();
/*! Zraca ID bierzącej tekstury.
\return ID tekstury.
*/
float GetCurrentId();
/*! Animuje sprajta.
\param relative Wzgledna ilosc klatek do animmowania.
*/
void Animate(float relative);
/*! Animuje podklatki sprajta.
\param relative Wzgledna ilosc podklatek do animmowania.
*/
void SubAnimate(float relative);
/*! Dodaje teksture.
\param tex Element tekstury.
\return true jesli operacja powiodla sie.
*/
bool AddTexture(XE_ELM_TEXTURE tex);
/*! Usuwa teksture.
\param tex Element tekstury.
\return true jesli operacja powiodla sie.
*/
bool RemoveTexture(XE_ELM_TEXTURE tex);
/*! Zraca ilosc tekstur.
\return Ilos tekstur.
*/
int Count();
/*! Otwiera strumien pikseli bierzacej tekstury do odczytu/zapisu.
\param width Wskaznik na zwracana szerokosc otwartej tekstury.
\param height Wskaznik na zwracana wysokosc otwartej tekstury.
\return Wskaznik na bufor strumienia.
*/
void* StreamOpen(unsigned int* width=0,unsigned int* height=0);
/*! Zamyka strumien pikseli bierzacej tekstury.
\param updatepixels Ustala czy ma zaktualizowac piksele w teksturze uzywajac pikseli z bufora strumienia.
*/
void StreamClose(bool updatepixels=true);
/*! Usuwa tekstury (zaladowane metoda Prepare lub PrepareFromMemory).
\param leavetex Ustala czy ma skasowac tylko liste, nie niszczac tekstur.
*/
void Cleanup(bool leavetex=false);
/*! Centruje przesuniecie srodka sprajta. */
void Centralize();
/*! Nadaje sprajtowi wlasciwosc przygotowanego z pliku/pamieci.
\param mode Wartosc wlasciwosci przygotowania z pliku/pamieci.
*/
void ForcePrepared(bool mode=true);
};

#endif /* XE_COMPILE_PHOTON */

/*--- XE_SHAPE ---*/
/*! Klasa ksztaltu. */
class XE_SHAPE
{
public:
//! Wierzcholki.
XE_VECTOR* Vertices;
//! Liczba wierzcholkow.
unsigned int Count;
//! Konstruktor domyslny.
XE_SHAPE();
};

/*--- XE_ACTOR ---*/
/*! Klasa aktora. */
class XE_ACTOR
{
public:
//! Opis obiektu
XE_S124I4 Desc;
//! Kolejnosc przy sortowaniu.
float Order;
//! Wektor pozycji.
XE_VECTOR Position;
//! Wektor kierunku. Parametr Length wykorzystywany jest jako zasieg pola kolizji kulistej.
XE_ANGLEVECTOR Direction;
//! Wektor skali.
XE_VECTOR Scale;
/*! Konstruktor domyslny. */
XE_ACTOR();
/*! Destruktor. */
virtual ~XE_ACTOR(){};
/*! Zwraca identyfikator obiektu.
\return ID obiektu.
*/
unsigned int ID();
/*! Aktualizacja. Metoda wirtualna. */
virtual void Update(){};
/*! Renderowanie. Metoda wirtualna. */
virtual void Render(){};
};

#ifdef XE_COMPILE_PHOTON

/*--- XE_ACTOR2D ---*/
/*! Rozszerzenie klasy aktora: Aktor 2D. */
class XE_ACTOR2D : public XE_ACTOR
{
public:
//! Sprajt.
XE_SPRITE Sprite;
//! Ksztalt kolizyjny.
XE_VECTOR Shape[4];
//! Konstruktor domyslny.
XE_ACTOR2D();
/*! Rysuje sprajta. */
void DrawSprite();
/*! Rysuje sprajta optymalnie.
\param x Pozycja X prostokata widocznosci.
\param y Pozycja Y prostokata widocznosci.
\param w Szerokosc prostokata widocznosci.
\param h Wysokosc prostokata widocznosci.
*/
void DrawSpriteOpti(float x,float y,float w,float h);
/*! Aktualizuje ksztalt aktora. */
void UpdateShape();
/*! Sprawdza metoda porownania prostokatow czy koliduje z innym aktorem 2D.
\param act Wskaznik na aktora 2D.
\param relative Wektor przesuniecia.
\return true jesli koliduja ze soba.
*/
bool CheckCollisionBox(XE_ACTOR2D* act,XE_VECTOR relative=XE_VECTOR());
/*! Sprawdza metoda porownania odleglosci czy koliduje z innym aktorem 2D.
\param act Wskaznik na aktora 2D.
\return true jesli koliduja ze soba.
*/
bool CheckCollisionCircle(XE_ACTOR2D* act);
#ifdef XE_COMPILE_CHAOS
/*! Sprawdza metoda porownania ksztaltow czy koliduje z innym aktorem 2D.
\param act Wskaznik na aktora 2D.
\return true jesli koliduja ze soba.
*/
bool CheckCollisionShape(XE_ACTOR2D* act);
#endif /* XE_COMPILE_CHAOS */
};

#endif /* XE_COMPILE_PHOTON */

/*--- XE_VOIDPROC ---*/
/*! Klasa procedur (dla scen).*/
class XE_VOIDPROC
{
public:
//! Wskaznik na funkcje.
void (*Proc)();
//! Konstruktor domyslny.
XE_VOIDPROC();
//! Konstruktor kopiujacy. void (*proc)(): Wskaznik na funkcje.
XE_VOIDPROC(void (*proc)());
};
//! Definicja elementu procedury.
typedef XE_ELEMENT_POINTER<XE_VOIDPROC> XE_ELM_VOIDPROC;

/*--- XE_SCENES ---*/
/*! Klasa scen. */
class XE_SCENES
{
public:
//! Kontener elementow procedur.
XE_CONTAINER<XE_VOIDPROC> Scenes;
//! Aktywna procedura sceny.
XE_ELM_VOIDPROC Active;
//! Automatyczne przejscie pomiedzy scenami.
bool Autonext;
//! Aktywacja automatycznego przejscia pomiedzy scenami tylko przy najblizszym przelaczeniu scen.
bool Autoactivate;
/*! Konstruktor domyslny. */
XE_SCENES();
/*! Destruktor. */
~XE_SCENES();
/*! Czysci kontener procedur scen. */
void Clear();
/*! Odtwarza sceny. */
void Play();
};

/*--- XE_RESOURCE ---*/
/*! Klasa zasobow. */
class XE_RESOURCE
{
private:
int Type;
HGLOBAL Res;
void* Buffer;
unsigned int Size;
public:
/*! Konstruktor domyslny. */
XE_RESOURCE();
/*! Laduje zasob z pamieci modulu.
\param module Uchwyt modulu.
\param name Nazwa zasobu.
\param type Nazwa typu.
\return true jesli operacja powiodla sie.
*/
bool Load(HMODULE module,LPCTSTR name,LPCTSTR type);
/*! Zwalnia zasob. */
void Free();
/*! Zwraca wskaznik na dane bufora.
\return Wskaznik na dane.
*/
void* GetData();
/*! Zwraca rozmiar bufora.
\return Rozmiar bufora.
*/
unsigned int GetSize();
/*! Sprawdza czy zasow jest pusty.
\return true jesli operacja powiodla sie.
*/
bool IsEmpty();
/*! Sprawdza czy zasow jest plikiem.
\return true jesli operacja powiodla sie.
*/
bool IsFile();
/*! Sprawdza czy zasow jest modulem.
\return true jesli operacja powiodla sie.
*/
bool IsModule();
};

#ifdef XE_COMPILE_PHOTON

/*--- XE_FONT ---*/
/*! Klasa czcionki. */
class XE_FONT
{
private:
bool prepared;
public:
enum ENUM
{
TOP=-1,
MIDDLE=0,
BOTTOM=1,
LEFT=-1,
CENTER=0,
RIGHT=1
};
//! Wyrownanie pionowe.
ENUM Valign;
//! Wyrownanie poziome.
ENUM Halign;
//! Tekstura.
XE_ELM_TEXTURE Texture;
//! Lista wyswietlania.
XE_ELM_DISPLAYLIST Dlist;
//! Mapa czcionki.
XE_FONTMAP* Map;
/*! Konstruktor domyslny. */
XE_FONT();
/*! Dokonuje ustawien tekstu dla generowanych czcionek bez map znakow.
\param width Szerokosc znaku.
\param height Wysokosc znaku.
\param sepx Poziomy odstep pomiedzy znakami.
\param sepy Pionowy odstep pomiedzy znakami.
\return true jesli operacja powiodla sie.
*/
static bool Setup(double width=32,double height=32,double sepx=0,double sepy=0);
/*! Przygotowuje czcionke.
\param texfname Nazwa pliku z tekstura czcionki.
\param mapfname Nazwa pliku z mapa czcionki.
\param newline Znak nowej linii.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\return true jesli operacja powiodla sie.
*/
bool Prepare(char* texfname,char* mapfname=0,int newline='\n',XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST);
/*! Przygotowuje czcionke z pamieci.
\param texdata Wskaznik na dane z tekstura czcionki.
\param mapdata Wskaznik na dane z mapa czcionki.
\param mapsize Rozmiar danych mapy czcionki.
\param newline Znak nowej linii.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\return true jesli operacja powiodla sie.
*/
bool PrepareFromMemory(void* texdata,void* mapdata=0,unsigned int mapsize=0,int newline='\n',XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST);
/*! Wypisuje tekst.
\param text Cstring z tekstem.
\param pos Pozycja.
\param scale Skala.
\param rot Obrot.
*/
void Draw(char* text,XE_VECTOR pos=XE_VECTOR(),XE_VECTOR scale=XE_VECTOR(1,1,1,1),XE_ANGLEVECTOR rot=XE_ANGLEVECTOR());
/*! Zwraca wymiary tekstu.
\param text Wskaznik na cstring zawierajacy tekst do zmierzenia.
\return Wektor z wymiarami tekstu.
*/
XE_VECTOR TextSize(char* text);
/*! Usuwa teksture i liste wyswietlania (utworzone metoda Prepare lub PrepareFromMemory). */
void Cleanup();
/*! Nadaje czcionce wlasciwosc przygotowanej z pliku/pamieci.
\param mode Wartosc wlasciwosci przygotowania z pliku/pamieci.
*/
void ForcePrepared(bool mode=true);
};

#endif /* XE_COMPILE_PHOTON */

/*--- XE_RECT ---*/
struct XE_RECT
{
XE_VECTOR Vertices[4];
};

#ifdef XE_COMPILE_PHOTON
#ifdef XE_COMPILE_CORE_MATH

/*--- Particles ---*/
class XE_PARTICLE_STREAM;

/*--- XE_PARTICLE_UNIT ---*/
/*! Klasa jednostki czastki. */
class XE_PARTICLE_UNIT
{
friend class XE_PARTICLE_STREAM;
private:
XE_HALFVECTOR* Position;
XE_HALFVECTOR* Color;
public:
//! Identyfikator czastki.
unsigned int ID;
//! Czas zycia.
float LifeTime;
//! Dlugosc zycia czastki.
float LifeTimeLimit;
//! Predkosc i kierunek czasteczki.
XE_HALFVECTOR Velocity;
//! Szybkosc zmiany predkosci i kierunku czasteczki.
XE_HALFVECTOR VelocityRate;
//! Wspolczynnik przezroczystosci.
float AlphaFactor;
/*! Konstruktor. */
XE_PARTICLE_UNIT();
/*! Aktualizacja.
\param factor Wspolczynnik.
\param program Funkcja bedaca zastepczym programem aktualizacji czastek.
\param extend Ustala czy funkcja ma byc tylko rozszerzeniem istniejacego programu.
*/
void Update(float factor,void(*program)(XE_PARTICLE_UNIT*)=0,bool extend=false);
XE_HALFVECTOR* GetPosition();
XE_HALFVECTOR* GetColor();
};

#ifdef XE_CANIMP

XE_PARTICLE_UNIT::XE_PARTICLE_UNIT()
{
ID=0;
Position=NULL;
Color=NULL;
LifeTime=0;
LifeTimeLimit=0;
AlphaFactor=1;
}

void XE_PARTICLE_UNIT::Update(float factor,void(*program)(XE_PARTICLE_UNIT*),bool extend)
{
if(!Position||!Color)return;
if(LifeTimeLimit<=0)return;
if(!program||(program&&extend))
{
*Position+=Velocity*XE_NUMBER(factor);
Velocity+=VelocityRate*XE_NUMBER(factor);
float l=1-min(1,max(0,LifeTime/LifeTimeLimit));
Color->W=l*AlphaFactor;
if(extend)program(this);
}
else
program(this);
}

XE_HALFVECTOR* XE_PARTICLE_UNIT::GetPosition()
{
return(Position);
}

XE_HALFVECTOR* XE_PARTICLE_UNIT::GetColor()
{
return(Color);
}

#endif /* XE_CANIMP */

/*--- XE_PARTICLE_RESPAWNDESC ---*/
//! Struktura opisu tworzenia czastek.
struct XE_PARTICLE_RESPAWNDESC
{
XE_HALFVECTOR EmitterPosition;
XE_HALFVECTOR EmitterPositionLast;
float EmitterStepSize;
XE_ANGLEVECTOR EmitterDirectionMin;
XE_ANGLEVECTOR EmitterDirectionMax;
float EmitterSpeedMin;
float EmitterSpeedMax;
XE_HALFVECTOR EmitterStartOffsetMin;
XE_HALFVECTOR EmitterStartOffsetMax;
float ParticleLifetimeMin;
float ParticleLifetimeMax;
XE_HALFVECTOR ParticleVelocityRateMin;
XE_HALFVECTOR ParticleVelocityRateMax;
XE_HALFVECTOR ParticleColorMin;
XE_HALFVECTOR ParticleColorMax;
bool ParticleDifferentColorPerChannel;
float ParticleAlphaFactor;
XE_PARTICLE_RESPAWNDESC();
};

#ifdef XE_CANIMP

XE_PARTICLE_RESPAWNDESC::XE_PARTICLE_RESPAWNDESC()
{
EmitterStepSize=0;
EmitterSpeedMin=0;
EmitterSpeedMax=0;
ParticleColorMin=XE_HALFVECTOR(1,1,1,1);
ParticleColorMax=XE_HALFVECTOR(1,1,1,1);
ParticleLifetimeMin=0;
ParticleLifetimeMax=0;
ParticleDifferentColorPerChannel=false;
ParticleAlphaFactor=1;
}

#endif /* XE_CANIMP */

//// PROTOTYPE
/*--- XE_PARTICLE_STREAM ---*/
/*! Klasa strumienia czastek. */
class XE_PARTICLE_STREAM
{
// PROTOTYPE
private:
XE_ELEMENTS<XE_PARTICLE_UNIT*> freecells;
XE_ELEMENTS<XE_PARTICLE_UNIT*> existscells;
XE_ARRAY<XE_PARTICLE_UNIT> Particles;
XE_ARRAY<XE_HALFVECTOR> Positions;
XE_ARRAY<XE_HALFVECTOR> Colors;
XE_ARRAY<XE_DWORD> Indices;
//XE_NSWITCH<XE_ELM_VERTEXBUFFER,1> Buffers;
bool vboavailable;
public:
//! Ustala czy strumien jest aktywny.
bool Active;
//! Technika generowania czastek.
XEF_ESTATE Technique;
//! Typ mieszania dla koloru zrodlowego.
XE_ESTATE BlendSrc;
//! Typ mieszania dla koloru docelowego.
XE_ESTATE BlendDst;
//! Rownanie mieszania kolorow.
XE_ESTATE BlendEq;
//! Ustala czy punkty maja byc smukle (okragle).
bool Smooth;
//! Ustala czy ma generowac czastki gdy emiter nie porusza sie.
bool GenWhenNotMoving;
//! Rozmiar czastek.
double PointSpriteSize;
//! Opis tworzenia czasteczek.
XE_PARTICLE_RESPAWNDESC RespawnDesc;
//! Tekstura czastek.
XE_ELM_TEXTURE Texture;
//! Stan wstrzymania generowania.
bool Suspend;
//! Czas pozostaly do wygenerowania czastki.
float TimeLeft;
//! Czas potrzebny na wygenerowanie czastki.
float RespawnTime;
//! Ilosc generowanych czastek.
int RespawnCount;
//! Zdarzenie tworzenia czastki
void(*Create)(XE_PARTICLE_UNIT*);
//! Zdarzenie usuniecia czastki
void(*Destroy)(XE_PARTICLE_UNIT*);
/*! Konstruktor. */
XE_PARTICLE_STREAM();
/*! Destruktor. */
~XE_PARTICLE_STREAM();
/*! Dodanie czastki do strumienia.
\param unit Czastka.
\param pos Pozycja.
\param col Kolor.
*/
void Add(XE_PARTICLE_UNIT unit,XE_HALFVECTOR pos,XE_HALFVECTOR col);
/*! Usuwa wszystkie czastki. */
void Free();
/*! Zwraca maksymalna ilosc czastek.
\return Ilosc elementow.
*/
unsigned int Max();
/*! Zwraca ilosc czastek.
\return Ilosc elementow.
*/
unsigned int Count();
/*! Usuwa czastki i tworzy miejsce o nowej pojemnosci.
\param count Ilosc elementoe do rezerwacji.
\param accelerated Ustala czy ma wlaczyc przyspieszone renderowanie czastek jesli jest taka mozliwosc.
*/
void Set(unsigned int count,bool accelerated=true);
/*! Dodanie czastki do strumienia poprzez wygenerowanie jej z opisu tworzenia.
\param pos Pozycja czastki.
*/
void Generate(XE_HALFVECTOR pos);
/*! Aktualizacja czasteczek.
\param program Funkcja bedaca zastepczym programem aktualizacji czastek.
\param extend Ustala czy funkcja ma byc tylko rozszerzeniem istniejacego programu.
*/
void Update(void(*program)(XE_PARTICLE_UNIT*)=0,bool extend=false);
/*! Renderuje czastki. */
void Draw();
/*! Sprawdza czy uzywa przyspieszenia dla renderowania. */
bool IsAccelerated();
};

#ifdef XE_CANIMP

XE_PARTICLE_STREAM::XE_PARTICLE_STREAM()
{
Active=true;
Technique=XEF_CPU;
BlendSrc=XE_RENDER_BLEND_SRC_ALPHA;
BlendDst=XE_RENDER_BLEND_ONE_MINUS_SRC_ALPHA;
BlendEq=XE_RENDER_BLEND_ADD;
Smooth=false;
GenWhenNotMoving=true;
PointSpriteSize=1;
Suspend=false;
TimeLeft=0;
RespawnTime=0;
RespawnCount=0;
Create=NULL;
Destroy=NULL;
vboavailable=Photon::XeVertexBufferInit();
}

XE_PARTICLE_STREAM::~XE_PARTICLE_STREAM()
{
Free();
}

void XE_PARTICLE_STREAM::Add(XE_PARTICLE_UNIT unit,XE_HALFVECTOR pos,XE_HALFVECTOR col)
{
if(freecells.Size()==0)return;
XE_ELEMENT_POINTER<XE_PARTICLE_UNIT*> freeelm=freecells.FirstPointer();
if(freeelm.IsEmpty())return;
unsigned int id=(*freeelm.iPointer())->ID;
existscells.Capture(freeelm);
Particles[id]=unit;
Particles[id].ID=id;
Particles[id].Position=&Positions[id];
Particles[id].Color=&Colors[id];
*Particles[id].Position=pos;
*Particles[id].Color=col;
if(Create)Create(&Particles[id]);
}

void XE_PARTICLE_STREAM::Free()
{
// PROTOTYPE
Particles.Free();
Positions.Free();
Colors.Free();
Indices.Free();
freecells.Clear();
existscells.Clear();
//Photon::XeVertexBufferDestroy(Buffers[0]);
//Photon::XeVertexBufferDestroy(Buffers[1]);
}

unsigned int XE_PARTICLE_STREAM::Max()
{
return(Particles.Size());
}

unsigned int XE_PARTICLE_STREAM::Count()
{
return(existscells.Size());
}

void XE_PARTICLE_STREAM::Set(unsigned int count,bool accelerated)
{
// PROTOTYPE
Particles.Reserve(count);
Positions.Reserve(count);
Colors.Reserve(count);
Indices.Reserve(count);
freecells.Clear();
existscells.Clear();
//Photon::XeVertexBufferDestroy(Buffers[0]);
//Photon::XeVertexBufferDestroy(Buffers[1]);
for(unsigned int i=0;i<count;i++)
{
Particles[i].ID=i;
Particles[i].Position=NULL;
Particles[i].Color=NULL;
Particles[i].LifeTime=0;
Particles[i].LifeTimeLimit=0;
Positions[i]=XE_HALFVECTOR(std::numeric_limits<float>::infinity(),std::numeric_limits<float>::infinity(),std::numeric_limits<float>::infinity());
Colors[i]=XE_HALFVECTOR(0,0,0,0);
freecells.AddPointer(&Particles[i]);
}
//if(!accelerated)vboavailable=false;
vboavailable=false;
if(vboavailable)
{
//Photon::XeVertexBufferCreate(&Buffers[0],sizeof(XE_HALFVECTOR)*(int)count*2,0,XE_VERTEXBUFFER_STREAM_DRAW,sizeof(XE_DWORD)*(int)count,0,XE_VERTEXBUFFER_STREAM_DRAW);
//Photon::XeVertexBufferCreate(&Buffers[1],sizeof(XE_HALFVECTOR)*(int)count*2,0,XE_VERTEXBUFFER_STREAM_DRAW,sizeof(XE_DWORD)*(int)count,0,XE_VERTEXBUFFER_STREAM_DRAW);
}
}

void XE_PARTICLE_STREAM::Generate(XE_HALFVECTOR pos)
{
if(!freecells.Size())return;
XE_ELEMENT_POINTER<XE_PARTICLE_UNIT*> freeelm=freecells.FirstPointer();
if(freeelm.IsEmpty())return;
unsigned int id=(*freeelm.iPointer())->ID;
existscells.Capture(freeelm);
XE_PARTICLE_UNIT part;
XE_HALFVECTOR temp;
XE_ANGLEVECTOR _temp;
part.ID=id;
part.Position=&Positions[id];
part.Color=&Colors[id];
temp.X=RespawnDesc.EmitterStartOffsetMin.X+(float)XE_MATH::Random(RespawnDesc.EmitterStartOffsetMax.X-RespawnDesc.EmitterStartOffsetMin.X);
temp.Y=RespawnDesc.EmitterStartOffsetMin.Y+(float)XE_MATH::Random(RespawnDesc.EmitterStartOffsetMax.Y-RespawnDesc.EmitterStartOffsetMin.Y);
temp.Z=RespawnDesc.EmitterStartOffsetMin.Z+(float)XE_MATH::Random(RespawnDesc.EmitterStartOffsetMax.Z-RespawnDesc.EmitterStartOffsetMin.Z);
*part.Position=pos+temp;
part.LifeTimeLimit=RespawnDesc.ParticleLifetimeMin+(float)XE_MATH::Random(RespawnDesc.ParticleLifetimeMax-RespawnDesc.ParticleLifetimeMin);
float spd=RespawnDesc.EmitterSpeedMin+(float)XE_MATH::Random(RespawnDesc.EmitterSpeedMax-RespawnDesc.EmitterSpeedMin);
_temp.Alpha=RespawnDesc.EmitterDirectionMin.Alpha+XE_MATH::Random(RespawnDesc.EmitterDirectionMax.Alpha-RespawnDesc.EmitterDirectionMin.Alpha);
_temp.Beta=RespawnDesc.EmitterDirectionMin.Beta+XE_MATH::Random(RespawnDesc.EmitterDirectionMax.Beta-RespawnDesc.EmitterDirectionMin.Beta);
_temp.Gamma=RespawnDesc.EmitterDirectionMin.Gamma+XE_MATH::Random(RespawnDesc.EmitterDirectionMax.Gamma-RespawnDesc.EmitterDirectionMin.Gamma);
part.Velocity=XE_VECTOHALF(XeLengthdirLen(_temp,spd));
temp.X=RespawnDesc.ParticleVelocityRateMin.X+(float)XE_MATH::Random(RespawnDesc.ParticleVelocityRateMax.X-RespawnDesc.ParticleVelocityRateMin.X);
temp.Y=RespawnDesc.ParticleVelocityRateMin.Y+(float)XE_MATH::Random(RespawnDesc.ParticleVelocityRateMax.Y-RespawnDesc.ParticleVelocityRateMin.Y);
temp.Z=RespawnDesc.ParticleVelocityRateMin.Z+(float)XE_MATH::Random(RespawnDesc.ParticleVelocityRateMax.Z-RespawnDesc.ParticleVelocityRateMin.Z);
part.VelocityRate=temp;
if(!RespawnDesc.ParticleDifferentColorPerChannel)
{
double f=XE_MATH::Random();
temp.X=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.X,RespawnDesc.ParticleColorMax.X,f);
temp.Y=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.Y,RespawnDesc.ParticleColorMax.Y,f);
temp.Z=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.Z,RespawnDesc.ParticleColorMax.Z,f);
temp.W=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.W,RespawnDesc.ParticleColorMax.W,f);
}
else
{
temp.X=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.X,RespawnDesc.ParticleColorMax.X,XE_MATH::Random());
temp.Y=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.Y,RespawnDesc.ParticleColorMax.Y,XE_MATH::Random());
temp.Z=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.Z,RespawnDesc.ParticleColorMax.Z,XE_MATH::Random());
temp.W=(float)XE_MATH::Amount(RespawnDesc.ParticleColorMin.W,RespawnDesc.ParticleColorMax.W,XE_MATH::Random());
}
*part.Color=temp;
part.AlphaFactor=RespawnDesc.ParticleAlphaFactor;
Particles[id]=part;
if(Create)Create(&Particles[id]);
}

void XE_PARTICLE_STREAM::Update(void(*program)(XE_PARTICLE_UNIT*),bool extend)
{
// PROTOTYPE
if(!Active)return;
if(!Suspend)
if(RespawnTime>0)
{
TimeLeft-=XE_EVENTS::Use().DeltaTime;
if(TimeLeft<=0)
{
while(TimeLeft<=0)
{
TimeLeft+=RespawnTime;
repeat(RespawnCount)
{
if(RespawnDesc.EmitterStepSize>0)
{
XE_FORLINEHALF(RespawnDesc.EmitterPositionLast,RespawnDesc.EmitterPosition,cur,RespawnDesc.EmitterStepSize,0,GenWhenNotMoving)
Generate(cur);
}
else
Generate(RespawnDesc.EmitterPosition);
}
}
RespawnDesc.EmitterPositionLast=RespawnDesc.EmitterPosition;
}
}
if(vboavailable)
{
XE_HALFVECTOR* buff=NULL;
XE_HALFVECTOR* _positions=NULL;
XE_HALFVECTOR* _colors=NULL;
//Photon::XeVertexBufferActivate(*Buffers.Current(),XE_VERTEXBUFFER_ARRAY);
//buff=(XE_HALFVECTOR*)Photon::XeVertexBufferMap(XE_VERTEXBUFFER_ARRAY,XE_VERTEXBUFFER_WRITE);
if(buff)
{
_positions=buff;
_colors=(XE_HALFVECTOR*)((unsigned int)buff+sizeof(XE_HALFVECTOR)*Positions.Size());
memcpy_s(_positions,sizeof(XE_HALFVECTOR)*Positions.Size(),Positions.Get(),sizeof(XE_HALFVECTOR)*Positions.Size());
memcpy_s(_colors,sizeof(XE_HALFVECTOR)*Positions.Size(),Colors.Get(),sizeof(XE_HALFVECTOR)*Positions.Size());
//if(vboavailable&&buff)Photon::XeVertexBufferUnmap(XE_VERTEXBUFFER_ARRAY);
}
}
XE_FOREACH(XE_PARTICLE_UNIT*,existscells,elm)
{
if((*elm.iPointer())->LifeTime<(*elm.iPointer())->LifeTimeLimit)
{
(*elm.iPointer())->LifeTime+=XE_EVENTS::Use().DeltaTime;
(*elm.iPointer())->Update(XE_EVENTS::Use().DeltaTime,program,extend);
}
if((*elm.iPointer())->LifeTimeLimit>0)
if((*elm.iPointer())->LifeTime>=(*elm.iPointer())->LifeTimeLimit)
{
(*elm.iPointer())->Position=NULL;
(*elm.iPointer())->Color=NULL;
(*elm.iPointer())->LifeTime=0;
(*elm.iPointer())->LifeTimeLimit=0;
Positions[(*elm.iPointer())->ID]=std::numeric_limits<float>::infinity();
Colors[(*elm.iPointer())->ID]=XE_HALFVECTOR(0,0,0,0);
XE_ELEMENT_POINTER<XE_PARTICLE_UNIT*> _elm=elm;
elm.Next();
freecells.Capture(_elm);
}
}
}


void XE_PARTICLE_STREAM::Draw()
{
// PROTOTYPE
if(!Active||!Particles.Size()||!existscells.Size())return;
if(!Texture.IsEmpty())
Photon::XeTextureActivate(Texture);
else
Photon::XeTextureUnactivate();
if(PointSpriteSize>1)XeSetState(XE_RENDER_POINT_SIZE,PointSpriteSize);
if(Smooth)XeSetState(XE_RENDER_POINT_SMOOTH,XE_TRUE);
if(!Texture.IsEmpty())
{
XeSetState(XE_RENDER_POINT_SPRITES_MODE,XE_TRUE);
XeSetState(XE_RENDER_POINT_SPRITES_COORD_REPLACE,XE_TRUE);
}
XeSetState(XE_RENDER_BLEND_TYPE,BlendSrc,BlendDst);
XeSetState(XE_RENDER_BLEND_EQUATION,BlendEq);
if(vboavailable)
{
//Photon::XeVertexBufferActivate(*Buffers.Current(),XE_VERTEXBUFFER_ARRAY);
//Photon::XeDrawData(XE_POINTS,0,(int)Positions.Size(),0,(void*)(sizeof(XE_HALFVECTOR)*Particles.Size()),0,0,XE_SINGLE,0,0,0,0,0,true,true);
//Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ARRAY);
}
else
Photon::XeDrawData(XE_POINTS,0,(int)Particles.Size(),Positions.Get(),Colors.Get(),0,0,0,0,XE_SINGLE);
XeSetState(XE_RENDER_BLEND_TYPE,XE_RENDER_BLEND_SRC_ALPHA,XE_RENDER_BLEND_ONE_MINUS_SRC_ALPHA);
XeSetState(XE_RENDER_BLEND_EQUATION,XE_RENDER_BLEND_ADD);
if(PointSpriteSize>1)XeSetState(XE_RENDER_POINT_SIZE,1);
if(Smooth)XeSetState(XE_RENDER_POINT_SMOOTH,XE_FALSE);
if(!Texture.IsEmpty())
{
XeSetState(XE_RENDER_POINT_SPRITES_MODE,XE_FALSE);
XeSetState(XE_RENDER_POINT_SPRITES_COORD_REPLACE,XE_FALSE);
}
XeSetState(XE_COLOR,XE_VECTOR(1,1,1,1));
}

bool XE_PARTICLE_STREAM::IsAccelerated()
{
return(vboavailable);
}

#endif /* XE_CANIMP */

#endif /* XE_COMPILE_CORE_MATH */

/*--- XE_EFFECT ---*/
//! Klasa efektu (shadera).
class XE_EFFECT
{
private:
struct PASS
{
XEF_ESTATE Type;
XE_ELM_SHADER Vert;
XE_ELM_SHADER Frag;
XE_ELM_SHADER Prog;
};
XE_ARRAY<PASS> Passes;
XE_ARRAY<XE_STRING> Logs;
public:
//! Definicja typu kontenera danych wejsciowych.
typedef XE_CONTAINER<void*> INPUT;
/*! Konstruktor domyslny. */
XE_EFFECT();
/*! Inicjuje tryb efektow.
\return true jesli operacja powiodla sie.
*/
static bool Init();
/*! Zwraca wersje modelu efektow (Shader Model).
\return Wersja modelu efektow.
*/
static int Model();
/*! Zwraca ilosc przebiegow.
\return Ilosc przebiegow.
*/
unsigned int Count();
/*! Laduje efekt z plikow.
\param pass Indeks przebiegu.
\param type Typ efektu. Dostepne wartosci:<br>
XEF_ASM: GPU assembler (ARB).<br>
XEF_SL: GL Shading Language.
\param vertname Sciezka do pliku Vertex Shadera.
\param fragname Sciezka do pliku Fragment Shadera.
\param vertprepend Dodatkowe dane na poczatku bufora vertex shadera (wartosc NULL jesli brak danych).
\param fragprepend Dodatkowe dane na poczatku bufora fragment shadera(wartosc NULL jesli brak danych).
\return true jesli operacja powiodla sie.
*/
bool Load(int pass,XEF_ESTATE type,char* vertname,char* fragname,char* vertprepend=0,char* fragprepend=0);
/*! Laduje efekt z pamieci.
\param pass Indeks przebiegu.
\param type Typ efektu. Dostepne wartosci:<br>
XEF_ASM: GPU assembler (ARB).<br>
XEF_SL: GL Shading Language.
\param vertdata Wskaznik na dane Vertex Shadera.
\param fragdata Wskaznik na dane Fragment Shadera.
\param vertprepend Dodatkowe dane na poczatku bufora vertex shadera (wartosc NULL jesli brak danych).
\param fragprepend Dodatkowe dane na poczatku bufora fragment shadera(wartosc NULL jesli brak danych).
\return true jesli operacja powiodla sie.
*/
bool LoadFromMemory(int pass,XEF_ESTATE type,char* vertdata,char* fragdata,char* vertprepend=0,char* fragprepend=0);
/*! Niszczy efekt. */
void Cleanup();
/*! Pobiera log akcji efektu.
\param pass Indeks przebiegu.
\param log Referencja na string wynikowy.
*/
void GetLog(int pass,XE_STRING& log);
/*! Aktywuje dany przebieg efektu.
\param pass Indeks przebiegu.
\return true jesli operacja powiodla sie.
*/
bool Activate(int pass);
/*! Dezaktywuje efekt. */
static void Unactivate();
/*! Ustawia wartosc zmiennej aktywnego shadera.
\param type Typ aktywnego shadera.
\param id Indeks zmiennej.
\param val Wektor wartosci.
\param subs Liczba komponentow do przeslania.
\return true jesli operacja powiodla sie.
*/
static bool SetVariable(XEF_ESTATE type,int id,XE_HALFVECTOR val,int subs=4);
/*! Ustawia wartosc calkowita zmiennej aktywnego shadera.
\param type Typ aktywnego shadera.
\param id Indeks zmiennej.
\param val Tablica wartosci typu calkowitego.
\param subs Liczba komponentow do przeslania.
\return true jesli operacja powiodla sie.
*/
static bool SetVariable(XEF_ESTATE type,int id,int val[4],int subs=4);
/*! Ustawia wartosc macierzowa zmiennej aktywnego shadera.
\param id Indeks zmiennej.
\param val Tablica wektorow wartosci.
\param trans Ustala czy macierz ma byc przetransponowana.
\return true jesli operacja powiodla sie.
*/
static bool SetVariable(int id,XE_HALFVECTOR val[4],bool trans=false);
/*! Ustawia jednostke teksturujaca samplera aktywnego shadera.
\param id Indeks zmiennej.
\param unit Indeks jednostki teksturujacej..
\return true jesli operacja powiodla sie.
*/
static bool SetTexture(int id,int unit);
/*! Szuka indeksu zmiennej shadera po nazwie.
\param pass Indeks przebiegu.
\param name Nazwa zmiennej.
\return Indeks zmiennej.
*/
int FindVariable(int pass,char* name);
/*! Ustawia wartosc atrybutu aktywnego shadera.
\param id Indeks atrybutu.
\param val Wektor wartosci.
\param subs Liczba komponentow do przeslania.
\return true jesli operacja powiodla sie.
*/
static bool SetAttribute(int id,XE_HALFVECTOR val,int subs=4);
/*! Szuka indeksu atrybutu shadera po nazwie.
\param pass Indeks przebiegu.
\param name Nazwa atrybutu.
\return Indeks atrybutu.
*/
int FindAttribute(int pass,char* name);
};

#ifdef XE_COMPILE_CORE_INTUICIO
#ifdef XE_COMPILE_CORE_MATH

/*--- XE_TECHNIQUE ---*/
#ifdef XE_CANIMP

const char XE_TECHNIQUE_Itc_TechniqueShaderDef[]="!EXTERNAL: TechniqueShader\n\
!KEYWORDS: FALSE TRUE COLOR DEPTH STENCIL ACCUM ENABLE DISABLE MODEL SCENE ZERO ONE SRC_COLOR ONE_MINUS_SRC_COLOR DST_COLOR ONE_MINUS_DST_COLOR SRC_ALPHA ONE_MINUS_SRC_ALPHA DST_ALPHA ONE_MINUS_DST_ALPHA SRC_ALPHA_SATURATE CONSTANT_COLOR ONE_MINUS_CONSTANT_COLOR CONSTANT_ALPHA ONE_MINUS_CONSTANT_ALPHA FLOAT VEC2 VEC3 VEC4 INT IVEC2 IVEC3 IVEC4 TEXTURE CANVAS\n\
!DEFINITIONS: 10d\n\
EXECUTE	VARIABLE\n\
CLEAR	KEYWORD\n\
PASS	KEYWORD VARIABLE VARIABLE\n\
CANVAS	KEYWORD	VARIABLE KEYWORD\n\
RECT	KEYWORD VARIABLE VARIABLE VARIABLE KEYWORD\n\
IMAGE	VARIABLE VARIABLE KEYWORD\n\
COLOR	KEYWORD VARIABLE\n\
BLEND	KEYWORD KEYWORD\n\
PARAM	KEYWORD VARIABLE VARIABLE VARIABLE\n\
ATTRIB	KEYWORD VARIABLE VARIABLE VARIABLE\n\
!END\n\
";

XE_HANDLE XE_TECHNIQUE_Itc_DefList=0;

#endif /* XE_CANIMP */

//! Klasa techniki efektu (bazuje na Intuicio).
class XE_TECHNIQUE
{
private:
enum Itc_KEYWORDS;
XE_INTUICIO_PROGRAM Itc_Program;
bool Compiled;
//// Intuicio Kernel Extensions:
static XE_INTUICIO_EXTERNAL(Itc_EXECUTE);
static XE_INTUICIO_EXTERNAL(Itc_CLEAR);
static XE_INTUICIO_EXTERNAL(Itc_PASS);
static XE_INTUICIO_EXTERNAL(Itc_CANVAS);
static XE_INTUICIO_EXTERNAL(Itc_RECT);
static XE_INTUICIO_EXTERNAL(Itc_IMAGE);
static XE_INTUICIO_EXTERNAL(Itc_COLOR);
static XE_INTUICIO_EXTERNAL(Itc_BLEND);
static XE_INTUICIO_EXTERNAL(Itc_PARAM);
static XE_INTUICIO_EXTERNAL(Itc_ATTRIB);
public:
//! Definicja typu bufora danych wejsciowych.
typedef XE_ARRAY<void*> INPUT;
/*! Konstruktor domyslny. */
XE_TECHNIQUE();
/*! Inicjacja trybu technik efektow. */
static void Init();
/*! Kompiluje skrypt techniki z pliku.
\param fname Sciezka do pliku.
\return true jesli operacja powiodla sie.
*/
bool CompileScript(char* fname);
/*! Kompiluje skrypt techniki z pamieci.
\param data Wskaznik na tresc skryptu techniki.
\param size Rozmiar tresci skryptu.
\return true jesli operacja powiodla sie.
*/
bool CompileScriptFromMemory(void* data,unsigned int size);
/*! Kompiluje do pliku skrypt techniki z pliku.
\param script Sciezka do pliku skryptu.
\param fname Sciezka do wynikowego pliku programu techniki.
\return true jesli operacja powiodla sie.
*/
static bool CompileScriptToFile(char* script,char* fname);
/*! Kompiluje do pliku skrypt techniki z pamieci.
\param data Wskaznik na tresc skryptu techniki.
\param size Rozmiar tresci skryptu.
\param fname Sciezka do wynikowego pliku programu techniki.
\return true jesli operacja powiodla sie.
*/
static bool CompileScriptFromMemoryToFile(void* data,unsigned int size,char* fname);
/*! Wykonuje program techniki.
\param params Wskzanik na bufor danych wejsciowych programu.
\return true jesli operacja powiodla sie.
*/
bool ExecuteProgram(INPUT* params=0);
/*! Laduje program techniki z pliku.
\param fname Sciezka do pliku programu techniki.
\return true jesli operacja powiodla sie.
*/
bool LoadProgram(char* fname);
/*! Laduje program techniki z pamieci.
\param data Wskaznik na tresc skryptu techniki.
\param size Rozmiar tresci skryptu.
\return true jesli operacja powiodla sie.
*/
bool LoadProgramFromMemory(void* data,unsigned int size);
/*! Zwalnia program z pamieci. */
void FreeProgram();
};

#undef FALSE
#undef TRUE

enum XE_TECHNIQUE::Itc_KEYWORDS
{
FALSE,
TRUE,
COLOR,
DEPTH,
STENCIL,
ACCUM,
ENABLE,
DISABLE,
MODEL,
SCENE,
ZERO,
ONE,
SRC_COLOR,
ONE_MINUS_SRC_COLOR,
DST_COLOR,
ONE_MINUS_DST_COLOR,
SRC_ALPHA,
ONE_MINUS_SRC_ALPHA,
DST_ALPHA,
ONE_MINUS_DST_ALPHA,
SRC_ALPHA_SATURATE,
CONSTANT_COLOR,
ONE_MINUS_CONSTANT_COLOR,
CONSTANT_ALPHA,
ONE_MINUS_CONSTANT_ALPHA,
FLOAT,
VEC2,
VEC3,
VEC4,
INT,
IVEC2,
IVEC3,
IVEC4,
TEXTURE,
CANVAS
};

#define FALSE 0
#define TRUE 1

#endif /* XE_COMPILE_CORE_MATH */
#endif /* XE_COMPILE_CORE_INTUICIO */

#ifdef XE_COMPILE_CORE_MATH

/*--- XE_CANVAS ---*/
//! Klasa powierzchni rysowania (bufora ramki).
class XE_CANVAS
{
private:
XE_ELM_FRAMEBUFFER Canvas;
XE_MATRIX LastProjMat;
public:
/*! Konstruktor domyslny. */
XE_CANVAS();
/*! Tworzy powierzchnie rysowania.
\param width Szerokosc.
\param height Wysokosc.
\param type Typ tekstury. Dostepne wartosci:<br>
XE_2D: Tekstura 2D.<br>
XE_DATA: Tekstura float.
\param forcednofbo Ustala czy bufor ramki ma bazowac wylacznie na teksturze, nawet gdy obsluguje FBO.
\return true jesli operacja powiodla sie.
*/
bool Create(int width,int height,XE_ESTATE type=XE_2D,bool forcednofbo=false);
/*! Tworzy powierzchnie rysowania dla danej tekstury.
\param tex Element tekstury
\param forcednofbo Ustala czy bufor ramki ma bazowac wylacznie na teksturze, nawet gdy obsluguje FBO.
\return true jesli operacja powiodla sie.
*/
bool Create(XE_ELM_TEXTURE tex,bool forcednofbo=false);
/*! Niszczy powierzchnie rysowania.
\return true jesli operacja powiodla sie,
*/
bool Destroy();
/*! Aktywuje powierzchnie rysowania.
\param invert Ustala czy os Y ma byc odwrocona.
\return true jesli operacja powiodla sie,
*/
bool Activate(bool invert=true);
/*! Deaktywuje powierzchnie rysowania.
\param mipmap Ustala czy powierzchnia ma wygenerowac mipmapy dla swojej tekstury.
*/
void Unactivate(bool mipmap=false);
/*! Aktywuje teksture powierzchni rysowania.
\return true jesli operacja powiodla sie.
*/
bool ActivateTexture();
/*! Zwraca szerokosc powierzchni rysowania.
\return Szerokosc.
*/
int Width();
/*! Zwraca wysokosc powierzchni rysowania.
\return Wysokosc.
*/
int Height();
/*! Zwraca teksture powierzchni rysowania.
\return Element tekstury.
*/
XE_ELM_TEXTURE Texture();
/*! Podmienia zawartosc z dana tekstura.
\param tex Tekstura do podmiany.
\return true jesli operacja powiodla sie.
*/
bool Swap(XE_ELM_TEXTURE tex);
/*! Sprawdza czy powierzchnia rysowania uzywa FBO.
\return true jesli uzywa FBO.
*/
bool Accelerated();
};

/*--- XE_VERTICES ---*/
//! Klasa bufora wierzcholkow (oraz indeksow).
class XE_VERTICES
{
private:
XE_ELM_VERTEXBUFFER Buffer;
XE_ARRAY<XE_PERVERTEX> VertData;
XE_ARRAY<unsigned int> IndData;
bool UseVBO;
XE_ESTATE Mode;
public:
/*! Konstruktor domyslny. */
XE_VERTICES();
/*! Tworzy bufor wierzcholkow.
\param mode Typ prymitywow. Dostepne wartosci:<br>
XE_POINTS: Punkty.<br>
XE_LINES: Linie.<br>
XE_LINELOOP: Petla linii.<br>
XE_LINESTRIP: Tasma linii.<br>
XE_TRIANGLES: Trojkaty.<br>
XE_TRIANGLESTRIP: Tasma trojkatow.<br>
XE_TRIANGLEFAN: Wachlaz trojkatow.<br>
XE_QUADS: Czworokaty.<br>
XE_QUADSTRIP: Tasma czworokatow.<br>
XE_POLYGON: Wielokat.
\param vertdata Wskaznik na tablice wierzcholkow.
\param vertcount Liczba elementow tablicy wierzcholkow.
\param inddata Wskaznik na tablice indeksow.
\param indcount Liczba elementow tablicy indeksow.
\param vertflags Flagi obslugi bufora wierzcholkow (flagi laczymy znakiem '|'). Dostepne wartosci:<br>
XEF_FLAG_STATIC: Bufor bedzie modyfikowany rzadko lub nigdy.<br>
XEF_FLAG_DYNAMIC: Bufor bedzie modyfikowany czesto.<br>
XEF_FLAG_STREAM: Bufor bedzie modyfikowany co klatke.<br>
XEF_FLAG_DRAW: Transmisja danych z aplikacji do GPU.<br>
XEF_FLAG_READ: Transmisja danych z GPU do aplikacji.<br>
XEF_FLAG_COPY: Transmisja danych z GPU do GPU.
\param indflags Flagi obslugi bufora indeksow (flagi laczymy znakiem '|'). Dostepne wartosci:<br>
XEF_FLAG_STATIC: Bufor bedzie modyfikowany rzadko lub nigdy.<br>
XEF_FLAG_DYNAMIC: Bufor bedzie modyfikowany czesto.<br>
XEF_FLAG_STREAM: Bufor bedzie modyfikowany co klatke.<br>
XEF_FLAG_DRAW: Transmisja danych z aplikacji do GPU.<br>
XEF_FLAG_READ: Transmisja danych z GPU do aplikacji.<br>
XEF_FLAG_COPY: Transmisja danych z GPU do GPU.
\param forcednovbo Ustala czy ma utworzyc bufor w pamieci RAM, zamiast VRAM.
\return true jesli operacja powiodla sie.
*/
bool Create(XE_ESTATE mode,XE_PERVERTEX* vertdata,int vertcount,unsigned int* inddata=0,int indcount=0,unsigned int vertflags=4,unsigned int indflags=4,bool forcednovbo=false);
/*! Niszczy bufor. */
void Destroy();
/*! Rysuje bufor wierzcholkow. */
void Draw();
/*! Zwraca ilosc wierzcholkow w buforze.
\return Ilosc wierzcholkow.
*/
unsigned int CountV();
/*! Zwraca ilosc indeksow w buforze.
\return Ilosc indeksow.
*/
unsigned int CountI();
/*! Otwiera strumien wierzcholkow i zwraca wskaznik na dane gotowe do modyfikacji lub wartosc NULL jesli sie nie uda.
\param access Flagi dostepu do bufora (flagi laczymy znakiem '|'). Dostepne wartosci:<br>
XEF_FLAG_READ: Odczyt z bufora.<br>
XEF_FLAG_WRITE: Zapis do bufora.
\return Wskaznik na bufor otwartego strmienia.
*/
XE_PERVERTEX* OpenStreamV(unsigned int access=XEF_FLAG_READ|XEF_FLAG_WRITE);
/*! Otwiera strumien indeksow i zwraca wskaznik na dane gotowe do modyfikacji lub wartosc NULL jesli sie nie uda.
\param access Flagi dostepu do bufora (flagi laczymy znakiem '|'). Dostepne wartosci:<br>
XEF_FLAG_READ: Odczyt z bufora.<br>
XEF_FLAG_WRITE: Zapis do bufora.
\return Wskaznik na bufor otwartego strmienia.
*/
unsigned int* OpenStreamI(unsigned int access=XEF_FLAG_READ|XEF_FLAG_WRITE);
/*! Zamyka strumien wierzcholkow. */
void CloseStreamV();
/*! Zamyka strumien indeksow. */
void CloseStreamI();
/*! Sprawdza czy bufory sa akcelerowane sprzetowo (trzymane w VRAM zamiast w RAM).
\return true jesli bufory sa akcelerowane.
*/
bool Accelerated();
};

/*--- XE_CAMERA ---*/
//! Klasa kamery.
class XE_CAMERA
{
public:
//! Szerokosc widoku.
float Width;
//! Wysokosc widoku
float Height;
//! Pozycja kamery.
XE_VECTOR Position;
//! Kierunek (obrot) kamery.
XE_ANGLEVECTOR Direction;
//! Ustala czy oko ma patrzec na punkt pozycji kamery.
bool LookToPoint;
//! Ustala czy kamera jest w trybie perspektywy.
bool PerspectiveMode;
/*! Konstruktor domyslny. */
XE_CAMERA();
/*! Aktualizacja kamery. */
void Update();
/*! Ustawia granice zasiegu widocznosci.
\param znear Najblizsza granica widocznosci.
\param zfar Najdalsza granica widocznosci.
*/
void SetNearFar(double znear,double zfar);
/*! Buduje macierz na bazie ustawien.
\param matrix Referencja na docelowa macierz.
*/
void BuildMatrix(XE_MATRIX& matrix);
/*! Buduje macierz float na bazie ustawien.
\param matrix Referencja na docelowa macierz float.
*/
void BuildMatrix(XE_HALFMATRIX& matrix);
};

#endif /* XE_COMPILE_CORE_MATH */

#ifdef XE_COMPILE_CORE_DNA
#ifdef XE_COMPILE_CHAOS
#ifdef XE_COMPILE_CORE_MATH

/*--- XE_DNA_MODEL ---*/
//! Klasa modelu DNA
class XE_DNA_MODEL
{
public:
//! Struktura sprajta miesnia.
struct MUSCLESPRITE
{
//! Tekstura sprajta.
XE_ELM_TEXTURE Texture;
//! Wskaznik na wlasciciela.
XE_ELM_COVALENCE_FORCE* Muscle;
//! Przesuniecie srodka w osi X.
int Xoffset;
//! Przesuniecie srodka w osi Y.
int Yoffset;
//! Szerokosc.
int Width;
//! Wysokosc.
int Height;
//! Ustala czy kierunek jest przeciwny.
bool Inverted;
//! Ustala czy dlugosc sprajta ma sie dopasowywac do dlugosci miesnia.
bool Streched;
//! Ostatni kierunek sprajta.
double LastDir;
};
private:
XE_ELM_DNA Dna;
XE_ARRAY<MUSCLESPRITE> Sprites;
public:
/*! Konstruktor domyslny. */
XE_DNA_MODEL();
/*! Tworzy model.
\return true jesli operacja powiodla sie.
*/
bool Create();
/*! Przygotowuje model.
\param cells Ilosc komorek.
\param skin Ilosc skory.
\param muscles Ilosc miesni.
\param sprites Ilosc sprajtow.
*/
void Prepare(unsigned int cells,unsigned int skin,unsigned int muscles,unsigned int sprites);
/*! Laduje model EBM z pliku.
\param fname Sciezka do pliku.
\param sprites Wskaznik na kontener sprajtow, dla tekstur skory i sprajtow modelu.
\param transform Wskaznik na macierz transformacji.
\param sprscale Wektor skali sprajtow.
\param massfactor Wspolczynnik masy komorek.
\param rangefactor Wspolczynnik promieni komorek.
\param resilfactor Wspolczynnik sprezystosci miesni.
\return true jesli operacja powiodla sie.
*/
bool LoadEBM(char* fname,XE_CONTAINER<XE_SPRITE>* sprites=0,XE_MATRIX* transform=0,XE_VECTOR sprscale=XE_VECTOR(1,1,1),double massfactor=1,double rangefactor=1,double resilfactor=1);
/*! Laduje model EBM z pamieci.
\param buff Wskaznik na dane modelu.
\param size Rozmiar bufora danych modelu.
\param sprites Wskaznik na kontener sprajtow, dla tekstur skory i sprajtow modelu.
\param transform Wskaznik na macierz transformacji.
\param sprscale Wektor skali sprajtow.
\param massfactor Wspolczynnik masy komorek.
\param rangefactor Wspolczynnik promieni komorek.
\param resilfactor Wspolczynnik sprezystosci miesni.
\return true jesli operacja powiodla sie.
*/
bool LoadEBMfromMemory(char* buff,unsigned int size,XE_CONTAINER<XE_SPRITE>* sprites=0,XE_MATRIX* transform=0,XE_VECTOR sprscale=XE_VECTOR(1,1,1),double massfactor=1,double rangefactor=1,double resilfactor=1);
/*! Laduje tekstury modelu EBM z pliku.
\param fname Sciezka do pliku.
\param directory Sciezka do folderu w ktorym znajduja sie tekstury modelu.
\param sprites Referencja na kontener sprajtow do ktorego zaladuje tekstury.
\return true jesli operacja powiodla sie.
*/
bool LoadEBMtextures(char* fname,char* directory,XE_CONTAINER<XE_SPRITE>& sprites);
/*! Laduje tekstury modelu EBM z pamieci.
\param buff Wskaznik na dane modelu.
\param size Rozmiar bufora danych modelu.
\param directory Sciezka do folderu w ktorym znajduja sie tekstury modelu.
\param sprites Referencja na kontener sprajtow do ktorego zaladuje tekstury.
\return true jesli operacja powiodla sie.
*/
bool LoadEBMfromMemoryTextures(char* buff,unsigned int size,char* directory,XE_CONTAINER<XE_SPRITE>& sprites);
/*! Laduje model EBM z pliku.
\param fname Sciezka do pliku.
\param directory Sciezka do folderu w ktorym znajduja sie tekstury modelu.
\param sprites Wskaznik na kontener sprajtow, dla tekstur skory i sprajtow modelu.
\param transform Wskaznik na macierz transformacji.
\param sprscale Wektor skali sprajtow.
\param massfactor Wspolczynnik masy komorek.
\param rangefactor Wspolczynnik promieni komorek.
\param resilfactor Wspolczynnik sprezystosci miesni.
\return true jesli operacja powiodla sie.
*/
bool LoadEBMcomplete(char* fname,char* directory,XE_CONTAINER<XE_SPRITE>& sprites,XE_MATRIX* transform=0,XE_VECTOR sprscale=XE_VECTOR(1,1,1),double massfactor=1,double rangefactor=1,double resilfactor=1);
/*! Laduje model EBM z pliku.
\param buff Wskaznik na dane modelu.
\param size Rozmiar bufora danych modelu.
\param directory Sciezka do folderu w ktorym znajduja sie tekstury modelu.
\param sprites Wskaznik na kontener sprajtow, dla tekstur skory i sprajtow modelu.
\param transform Wskaznik na macierz transformacji.
\param sprscale Wektor skali sprajtow.
\param massfactor Wspolczynnik masy komorek.
\param rangefactor Wspolczynnik promieni komorek.
\param resilfactor Wspolczynnik sprezystosci miesni.
\return true jesli operacja powiodla sie.
*/
bool LoadEBMfromMemoryComplete(char* buff,unsigned int size,char* directory,XE_CONTAINER<XE_SPRITE>& sprites,XE_MATRIX* transform=0,XE_VECTOR sprscale=XE_VECTOR(1,1,1),double massfactor=1,double rangefactor=1,double resilfactor=1);
/*! Zwalnia model z pamieci. */
void Free();
/*! Rysuje model. */
void Draw();
/*! Przypisuje substancje danej komorce modelu.
\param id Indeks komorki.
\param cell Element substancji.
\return true jesli operacja powiodla sie.
*/
bool SetCell(unsigned int id,XE_ELM_SUBSTANCE cell);
/*! Przypisuje powierzchnie danej skorze modelu.
\param id Indeks skory.
\param skin Element powierzchni.
\return true jesli operacja powiodla sie.
*/
bool SetSkin(unsigned int id,XE_ELM_SURFACE skin);
/*! Przypisuje sile kowalencyjna danemu miesniowi modelu.
\param id Indeks miesnia.
\param muscle Element sily kowalencyjnej.
\return true jesli operacja powiodla sie.
*/
bool SetMuscle(unsigned int id,XE_ELM_COVALENCE_FORCE muscle);
/*! Przypisuje globalna teksture ciala modelu.
\param tex Element tekstury.
\return true jesli operacja powiodla sie.
*/
bool SetBodyTexture(XE_ELM_TEXTURE tex);
/*! Przypisuje sprajt miesnia modelowi.
\param id Indeks sprajta miesnia.
\param sprite Sprajt miesnia.
\return true jesli operacja powiodla sie.
*/
bool SetMuscleSprite(unsigned int id,MUSCLESPRITE sprite);
/*! Zwraca wskaznik na tablice komorek.
\return Wskaznik na talbice komorek.
*/
XE_ELM_SUBSTANCE* GetCells();
/*! Zwraca wskaznik na tablice skory.
\return Wskaznik na talbice skory.
*/
XE_ELM_SURFACE* GetSkin();
/*! Zwraca wskaznik na tablice miesni.
\return Wskaznik na talbice miesni.
*/
XE_ELM_COVALENCE_FORCE* GetMuscles();
/*! Zwraca globalna teksture ciala modelu.
\return Element tekstury.
*/
XE_ELM_TEXTURE GetBodyTexture();
/*! Zwraca wskaznik na tablice sprajtow miesni.
\return Wskaznik na talbice sprajtow miesni.
*/
MUSCLESPRITE* GetMusclesSprites();
/*! Zwraca ilosc komorek.
\return Ilosc komorek.
*/
unsigned int CellsCount();
/*! Zwraca ilosc skory.
\return Ilosc skory.
*/
unsigned int SkinCount();
/*! Zwraca ilosc miesni.
\return Ilosc miesni.
*/
unsigned int MusclesCount();
/*! Zwraca ilosc sprajtow miesni.
\return Ilosc sprajtow miesni.
*/
unsigned int MusclesSpritesCount();
};

#endif /* XE_COMPILE_CORE_MATH */
#endif /* XE_COMPILE_CHAOS */
#endif /* XE_COMPILE_CORE_DNA */

#endif /* XE_COMPILE_PHOTON */

#ifdef XE_COMPILE_CORE_VIRTUAL_FILE

/*--- XE_ARCHIVE ---*/
//! Klasa opisu archiwum.
class XE_ARCHIVE
{
friend class XE_FILE;
public:
//! Klasa pliku wirtualnego.
class VIRTUAL
{
public:
//! Nazwa pliku.
XE_STRING Name;
//! Wskaznik na plik.
XE_FILE* File;
/*! Konstruktor domyslny. */
VIRTUAL();
};
private:
XE_STRING Path;
XE_ARRAY<XVF_INFO> FilesInfo;
public:
/*! Konstruktor domyslny. */
XE_ARCHIVE();
/*! Otwiera archiwum. */
bool Open(char* fname);
/*! Zamyka archiwum. */
void Close();
/*! Zwraca nazwe danego pliku. */
char* FileName(XE_HANDLE handle);
/*! Zwraca rozmiar danego pliku. */
unsigned int FileSize(XE_HANDLE handle);
/*! Laduje plik z archiwum do pamieci. */
bool LoadFile(XE_FILE* file,XE_HANDLE handle);
/*! Zapisuje pliki z pamieci do archiwum. */
static bool SaveFiles(char* fname,VIRTUAL* files,unsigned int count);
/*! Szuka plik w archiwum. */
bool Find(char* name,XE_HANDLE& result);
/*! Zwraca ilosc plikow w archiwum. */
unsigned int Count();
};

#endif /* XE_COMPILE_CORE_VIRTUAL_FILE */

#ifdef XE_COMPILE_PHOTON

/*--- XE_GUI ---*/
//! Klasa Graficznego Interfejsu Uzytkownika.
class XE_GUI
{
public:
class STYLE;
class SKIN;
class CONTROL;
friend class XE_GUI::CONTROL;
private:
typedef XE_ELEMENT_POINTER<XE_ELM_TEXTURE> TEXTURE_ELM;
typedef XE_CONTAINER<XE_ELM_TEXTURE> TEXTURE_NAMES;
typedef XE_ELEMENT_POINTER<XE_FONT> FONT_ELM;
typedef XE_CONTAINER<XE_FONT> FONT_NAMES;
public:
//! Klasa stylu.
class STYLE
{
friend class XE_GUI;
public:
//! Definicja typu elementu stylu
typedef XE_ELEMENT_POINTER<STYLE> ELM;
//! Definicja typu kontenera nazw stylow.
typedef XE_CONTAINER<STYLE> NAMES;
//! Tekstura obszaru - top-left.
XE_ELM_TEXTURE AreaTextureTL;
//! Tekstura obszaru - top-center.
XE_ELM_TEXTURE AreaTextureTC;
//! Tekstura obszaru - top-right.
XE_ELM_TEXTURE AreaTextureTR;
//! Tekstura obszaru - middle-left.
XE_ELM_TEXTURE AreaTextureML;
//! Tekstura obszaru - middle-center.
XE_ELM_TEXTURE AreaTextureMC;
//! Tekstura obszaru - middle-right.
XE_ELM_TEXTURE AreaTextureMR;
//! Tekstura obszaru - bottom-left.
XE_ELM_TEXTURE AreaTextureBL;
//! Tekstura obszaru - bottom-center.
XE_ELM_TEXTURE AreaTextureBC;
//! Tekstura obszaru - bottom-right.
XE_ELM_TEXTURE AreaTextureBR;
//! Koordynaty obszaru - top-left.
XE_HALFVECTOR AreaCoordsTL[4];
//! Koordynaty obszaru - top-center.
XE_HALFVECTOR AreaCoordsTC[4];
//! Koordynaty obszaru - top-right.
XE_HALFVECTOR AreaCoordsTR[4];
//! Koordynaty obszaru - middle-left.
XE_HALFVECTOR AreaCoordsML[4];
//! Koordynaty obszaru - middle-center.
XE_HALFVECTOR AreaCoordsMC[4];
//! Koordynaty obszaru - middle-right.
XE_HALFVECTOR AreaCoordsMR[4];
//! Koordynaty obszaru - bottom-left.
XE_HALFVECTOR AreaCoordsBL[4];
//! Koordynaty obszaru - bottom-center.
XE_HALFVECTOR AreaCoordsBC[4];
//! Koordynaty obszaru - bottom-right.
XE_HALFVECTOR AreaCoordsBR[4];
//! Rozmiar kafelkowania - top-left.
XE_HALFVECTOR AreaTiledTL;
//! Rozmiar kafelkowania - top-center.
XE_HALFVECTOR AreaTiledTC;
//! Rozmiar kafelkowania - top-right.
XE_HALFVECTOR AreaTiledTR;
//! Rozmiar kafelkowania - middle-left.
XE_HALFVECTOR AreaTiledML;
//! Rozmiar kafelkowania - middle-center.
XE_HALFVECTOR AreaTiledMC;
//! Rozmiar kafelkowania - middle-right.
XE_HALFVECTOR AreaTiledMR;
//! Rozmiar kafelkowania - bottom-left.
XE_HALFVECTOR AreaTiledBL;
//! Rozmiar kafelkowania - bottom-center.
XE_HALFVECTOR AreaTiledBC;
//! Rozmiar kafelkowania - bottom-right.
XE_HALFVECTOR AreaTiledBR;
//! Przesuniecie kafelkowania - top-left.
XE_HALFVECTOR AreaOffsetTL;
//! Przesuniecie kafelkowania - top-center.
XE_HALFVECTOR AreaOffsetTC;
//! Przesuniecie kafelkowania - top-right.
XE_HALFVECTOR AreaOffsetTR;
//! Przesuniecie kafelkowania - middle-left.
XE_HALFVECTOR AreaOffsetML;
//! Przesuniecie kafelkowania - middle-center.
XE_HALFVECTOR AreaOffsetMC;
//! Przesuniecie kafelkowania - middle-right.
XE_HALFVECTOR AreaOffsetMR;
//! Przesuniecie kafelkowania - bottom-left.
XE_HALFVECTOR AreaOffsetBL;
//! Przesuniecie kafelkowania - bottom-center.
XE_HALFVECTOR AreaOffsetBC;
//! Przesuniecie kafelkowania - bottom-right.
XE_HALFVECTOR AreaOffsetBR;
//! Kolory obszaru - top-left.
XE_HALFVECTOR AreaColorsTL[4];
//! Kolory obszaru - top-center.
XE_HALFVECTOR AreaColorsTC[4];
//! Kolory obszaru - top-right.
XE_HALFVECTOR AreaColorsTR[4];
//! Kolory obszaru - middle-left.
XE_HALFVECTOR AreaColorsML[4];
//! Kolory obszaru - middle-center.
XE_HALFVECTOR AreaColorsMC[4];
//! Kolory obszaru - middle-right.
XE_HALFVECTOR AreaColorsMR[4];
//! Kolory obszaru - bottom-left.
XE_HALFVECTOR AreaColorsBL[4];
//! Kolory obszaru - bottom-center.
XE_HALFVECTOR AreaColorsBC[4];
//! Kolory obszaru - bottom-right.
XE_HALFVECTOR AreaColorsBR[4];
//! Globalny filtr koloru
XE_HALFVECTOR AreaColorFilter;
//! Rozmiar dzielnikow brzegow - top.
float AreaSplitTop;
//! Rozmiar dzielnikow brzegow - bottom.
float AreaSplitBottom;
//! Rozmiar dzielnikow brzegow - left.
float AreaSplitLeft;
//! Rozmiar dzielnikow brzegow - right.
float AreaSplitRight;
//! Typ dzielnikow brzegow - top.
XE_BYTE AreaSplitTopType;
//! Typ dzielnikow brzegow - bottom.
XE_BYTE AreaSplitBottomType;
//! Typ dzielnikow brzegow - left.
XE_BYTE AreaSplitLeftType;
//! Typ dzielnikow brzegow - right.
XE_BYTE AreaSplitRightType;
//! Wskaznik na czcionke tekstu.
XE_FONT* TextFont;
//! Przesuniecie tekstu.
XE_VECTOR TextOffset;
//! Skala tekstu.
XE_VECTOR TextScale;
//! Kolor tekstu.
XE_VECTOR TextColor;
//! Kolor obwodki tekstu.
XE_VECTOR TextBorderColor;
//! Rozmiar obwodki tekstu.
float TextBorderSize;
//! Jakosc obwodki tekstu.
int TextBorderQuality;
//! Wyrownanie poziome tekstu.
XE_FONT::ENUM TextHalign;
//! Wyrownanie pionowe tekstu.
XE_FONT::ENUM TextValign;
//! Wierzcholki ikony.
XE_HALFVECTOR IconRect[4];
//! Ustala czy obszar jest obramowaniem.
bool AsBorder;
/*! Konstruktor domyslny. */
STYLE();
};
//! Klasa skorki.
class SKIN
{
friend class XE_GUI;
public:
//! Definicja typu elementu skorki
typedef XE_ELEMENT_POINTER<SKIN> ELM;
//! Definicja typu kontenera nazw skorek.
typedef XE_CONTAINER<SKIN> NAMES;
//! Kontener nazw stylow.
XE_CONTAINER<XE_STRING> StyleNames;
};
//! Klasa kontrolki.
class CONTROL
{
friend class XE_GUI;
public:
//! Definicja typu elementu kontrolki.
typedef XE_NODE<XE_SMART<CONTROL> >::NODE ELM;
//! Definicja typu nazwanego elementu kontrolki.
typedef XE_ELEMENT_POINTER<CONTROL*> NAME;
//! Definicja typu drzewa kontrolki.
typedef XE_NODE<XE_SMART<CONTROL> > TREE;
//! Definicja typu kontenera nazw kontrolek.
typedef XE_CONTAINER<CONTROL*> NAMES;
private:
XE_HALFVECTOR RectTL[4];
XE_HALFVECTOR RectTC[4];
XE_HALFVECTOR RectTR[4];
XE_HALFVECTOR RectML[4];
XE_HALFVECTOR RectMC[4];
XE_HALFVECTOR RectMR[4];
XE_HALFVECTOR RectBL[4];
XE_HALFVECTOR RectBC[4];
XE_HALFVECTOR RectBR[4];
XE_GUI* Gui;
TREE* Node;
bool CurrentUnactive;
XE_DWORD LastEvents;
void Draw(XE_VECTOR cutmin,XE_VECTOR cutmax,bool forcedunactive=false);
void Update();
static int SortFunc(CONTROL** a,CONTROL** b);
public:
//! Glebokosc (Z-pozycja) kontrolki.
float Order;
//! Flagi zdarzen.
XE_DWORD Events;
//! Flagi zachowan.
XE_DWORD Behaviour;
//! Pozycja wzgledem kontrolki rodzica.
XE_HALFVECTOR Position;
//! Rozmiar.
XE_HALFVECTOR Size;
//! Przesuniecie wzgledem kontrolki rodzica.
XE_HALFVECTOR Offset;
//! Przesuniecie kontrolek-dzieci wzgledem tej kontrolki.
XE_HALFVECTOR ChildOffset;
//! Margines gorny.
float MarginTop;
//! Margines dolny.
float MarginBottom;
//! Margines lewy.
float MarginLeft;
//! Margines prawy.
float MarginRight;
//! Przycinajacy margines gorny.
float CutMarginTop;
//! Przycinajacy margines dolny.
float CutMarginBottom;
//! Przycinajacy margines lewy.
float CutMarginLeft;
//! Przycinajacy margines prawy.
float CutMarginRight;
//! Ustala czy kontrolka jest aktywna (reaguje na zdarzenia).
bool Active;
//! Ustala czy kontrolka jest widoczna (i jej dzieci rowniez).
bool Visible;
//! Ustala czy kontrolka jest podatna na testy trafien do korekcji zdarzen.
bool Hitable;
//! Ustala czy kontrolka nie jest podatna na korekcje zdarzen.
bool NonCorrected;
//! Ustala czy kontrolka przycina obszar aktywnosci do swojego obszaru.
bool CutArea;
//! Tekst.
XE_STRING Text;
//! Rozszerzone dane.
XE_FILE Extend;
//! Ikona.
XE_ELM_TEXTURE Icon;
//! Styl kontrolki aktywnej.
STYLE::ELM StyleActive;
//! Styl kontrolki nieaktywnej.
STYLE::ELM StyleUnactive;
/*! Konstruktor domyslny. */
CONTROL();
/*! Destruktor. */
virtual ~CONTROL(){};
/*! Wykonuje obsluge zdarzen. */
virtual void DoEvents(){};
/*! Renderuje wewnatrz kontrolki. */
virtual void RenderInside(){};
/*! Wyrejestrowuje kontrolke z interfejsu. */
void Unregister();
/*! Sprawdza czy dana kontrolka jest ta sama co bierzaca kontrolka.
\param control Wskaznik na sprawdzana kontrolke.
\return true jesli kontrolki sa te same.
*/
bool Identify(CONTROL::TREE* control);
/*! Sprawdza czy dany wskaznik na kontrolke odpowiada bierzacej kontrolce.
\param control Wskaznik na sprawdzana kontrolke.
\return true jesli kontrolki sa te same.
*/
bool Identify(CONTROL* control);
/*! Zwraca realna pozycje pola kontrolki.
\return Realna pozycja.
*/
XE_HALFVECTOR RealPos();
/*! Zwraca realny rozmiar pola kontrolki.
\return Realny rozmiar.
*/
XE_HALFVECTOR RealSize();
/*! Sprawdza czy kontrolka w bierzacej ramce renderowania jest nieaktywna,
\return true jesli kontrolka jest nieaktywna.
*/
bool IsCurrentUnactive();
/*! Zwraca ostatnie zapamietane flagi zdarzen.
\return Flagi zdarzen.
*/
XE_DWORD GetLastEvents();
/*! Zwraca wskaznik na interfejs kontrolki.
\return Wskaznik na interfejs.
*/
XE_GUI* GetGui();
/*! Zwraca wskaznik na rodzica kontrolki.
\return Wskaznik na rodzica.
*/
CONTROL* GetParent();
/*! Zwraca wskaznik na drzewo bierzacej kontrolki.
return Wskaznik na drzewo kontrolki.
*/
TREE* GetNode();
};
private:
XE_WINDOW* Window;
CONTROL::TREE Controls;
XE_ELEMENTS<CONTROL::TREE*> ToUnregister;
CONTROL* LastMouseAt;
XE_VECTOR LastMousePos;
XE_VECTOR MouseMoveVec;
class __default : public CONTROL
{
public:
void DoEvents(){};
};
class __window : public CONTROL
{
public:
bool Dragged;
XE_HALFVECTOR LastPos;
XE_HALFVECTOR LastSize;
__window();
void DoEvents();
};
class __button : public CONTROL
{
public:
STYLE::ELM OverStyle;
STYLE::ELM OutStyle;
void DoEvents();
};
class __scroll : public CONTROL
{
public:
bool Dragged;
float DraggedOffset;
float ContentSize;
__scroll();
void DoEvents();
};
class __list : public CONTROL
{
public:
bool Selected;
STYLE::ELM SelectStyle;
STYLE::ELM OverStyle;
STYLE::ELM OutStyle;
__list();
void DoEvents();
};
class __check : public CONTROL
{
public:
bool Selected;
STYLE::ELM OnStyleA;
STYLE::ELM OffStyleA;
STYLE::ELM OnStyleU;
STYLE::ELM OffStyleU;
__check();
void DoEvents();
};
class __option : public CONTROL
{
public:
bool Selected;
STYLE::ELM OnStyleA;
STYLE::ELM OffStyleA;
STYLE::ELM OnStyleU;
STYLE::ELM OffStyleU;
__option();
void DoEvents();
};
class __slider : public CONTROL
{
public:
bool Dragged;
__slider();
void DoEvents();
};
class __menu : public CONTROL
{
public:
void DoEvents();
};
class __edit : public CONTROL
{
public:
bool Editable;
float Carrage;
bool CarrageChange;
bool CarrageMode;
XE_STRING Pre;
XE_STRING Post;
bool PassMode;
__edit();
~__edit();
void DoEvents();
};
class __combo : public CONTROL
{
public:
CONTROL* Selected;
__combo();
void DoEvents();
};
class __comboitem : public CONTROL
{
public:
STYLE::ELM OverStyle;
STYLE::ELM OutStyle;
void DoEvents();
};
public:
//! Kontener nazw styli.
STYLE::NAMES Styles;
//! Kontener nazw skorek.
SKIN::NAMES Skins;
//! Kontener nazw kontrolek.
CONTROL::NAMES ControlNames;
//! Kontener nazw Tekstur.
TEXTURE_NAMES TextureNames;
//! Kontener nazw czcionek.
FONT_NAMES FontNames;
//! Funkcja ladujaca teksture innego typu niz XET.
bool(*CallbackLoadTextureOtherType)(XE_ELM_TEXTURE,char*);
//! Flagi  korekcji testu trafien.
unsigned int CorrectionFlags;
/*! Konstruktor domyslny. */
XE_GUI();
/*! Wykonuje ustawienia interfejsu.
\param win Wskanzik na okno kontrolki.
\return true jesli operacja powiodla sie.
*/
bool Setup(XE_WINDOW* win);
/*! Rejestruje kontrolke w interfejsie.
\param control Wskaznik na nowa kontrolke.
\param parent Wskaznik na kontrolke rodzica.
\return Wskanzik na zarejestrowana kontrolke lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* Register(CONTROL* control,CONTROL* parent=0);
/*! Wyrejestrowuje kontrolki czekajace na usuniecie. */
void Unregister();
/*! Aktualizuje kontrolki. */
void Update();
/*! Postep nasluchu zdarzen.
\param control Wskaznik na kontrolke od ktorej zaczyna nasluch.
\param cutmin Pozycja minimalna obszaru sprawdzanego.
\param cutmax Pozycja maxymalna obszaru sprawdzanego.
*/
void ProgressListen(CONTROL* control=0,XE_VECTOR cutmin=0,XE_VECTOR cutmax=0);
/*! Wylacza dane zdarzenia wszystkich kontrolek poza podana.
\param without Wskaznik na kontrolke ktora pomija w poprawkach.
\param exclude Zdarzenia do wylaczenia.
\param control Wskaznik na kontrolke od ktorej zaczyna poprawki.
*/
void ProgressCorrect(CONTROL* without,unsigned int exclude,CONTROL* control=0);
/*! Postep wykonywania zdarzen.
\param control Wskaznik na kontrolke od ktorej zaczyna wykonywanie zdarzen.
*/
void ProgressEvents(CONTROL* control=0);
/*! Postep interfejsu. */
void Progress();
/*! Rysuje interfejs.
\param achancare Ustala czy ma dbac o przezroczystosc interfejsu.
*/
void Draw(bool achancare=false);
/*! Sprawdza czy dana kontrolka istnieje w interfejsie.
\param control Wskaznik na drzewo szukanej kontrolki.
\return true jesli kontrolka istnieje.
*/
bool Validate(CONTROL::TREE* control);
/*! Sprawdza czy dana kontrolka istnieje w interfejsie.
\param control Wskaznik na szukana kontrolke.
\return true jesli kontrolka istnieje.
*/
bool Validate(CONTROL* control);
/*! Usuwa z listy nazw pola, ktorych kontrolki nie istnieja. */
void Synchronize();
/*! Wywoluje i wykonuje zdarzenia na danej kontrolce.
\param control Wskaznik na kontrolke.
\param events Zdarzenia.
\param who Ustala kto odbierze zdarzenia. Dostepne wartosci:<br>
XEF_FLAG_ME: Dla danej kontrolki.<br>
XEF_FLAG_CHILDS: Dzieci danej kontrolki.<br>
Wartosci mozna laczyc operatorem logicznym "|".
\param validate Ustala czy ma sprawdzac czy kontrolka istnieje.
\param cleanafter Ustala czy zdarzenia maja byc wyczyszczone po wywolaniu obslugi zdarzen.
*/
void Perform(CONTROL* control,XE_DWORD events,XE_DWORD who,bool validate=true,bool cleanafter=true);
/*! Przenosi kontrolke na wierzch przed innymi kontrolkami w danej galezi.
\param control Wskaznik na kontrolke do przeniesienia.
\param reorder Ustala czy dana kontrolka ma miec kolejnosc rowna -1, a reszta kontrolek w galezi kolejnosc rowna 0.
*/
void MoveOnTop(CONTROL* control,bool reorder=false);
/*! Czysci interfejs. */
void Cleanup();
/*! Zwraca wskaznik na okno interfejsu.
\return Wskaznik na okno.
*/
XE_WINDOW* GetWindow();
/*! Zwraca ostatnia pozycje myszy w interfejsie.
\return Wektor ostatniej pozycji myszy.
*/
XE_VECTOR GetLastMousePos();
/*! Zwraca wektor przesuniecia myszy od ostatniej aktualizacji.
\return Wektor przesuniecia myszu.
*/
XE_VECTOR GetMouseMoveVec();
/*! Laduje motyw z pliku XML.
\param fname Sciezka do pliku.
\param theme Nazwa motywu do zaladowania.
\return true jesli operacja powiodls sie.
*/
bool LoadTheme(char* fname,char* theme);
/*! Tworzy okno.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param caption Tresc paska tytulowego.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param flags Flagi opcji dodatkowych okna. Dostepne wartosci:<br>
XEF_FLAG_CAPTION_BAR: Pasek tytulowy.<br>
XEF_FLAG_BUTTON_CLOSE: Przycisk zamkniecia okna.<br>
XEF_FLAG_BUTTON_FULLSCREEN: Przycisk powiekszenia do maksymalnych rozmiarow.<br>
XEF_FLAG_BUTTON_MINIMALIZE: Przycisk pomniejszenia do minimalnych rozmiarow.<br>
Wartosci mozna laczyc operatorem logicznym "|".
\param icontex Tekstura ikony.
\param margintop Gorny margines pola.
\param marginbottom Dolny margines pola.
\param marginleft Lewy margines pola.
\param marginright Prawy margines pola.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzona kontrolke okna lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* WindowCreate(char* skin,char* name,char* caption,XE_HALFVECTOR pos,XE_HALFVECTOR size,unsigned int flags=0,XE_ELM_TEXTURE icontex=XE_ELM_TEXTURE(),float margintop=0,float marginbottom=0,float marginleft=0,float marginright=0,CONTROL* parent=0);
/*! Niszczy okno.
\param control Wskaznik na kontrolke okna.
\return true jesli operacja powiodla sie.
*/
bool WindowDestroy(CONTROL* control);
/*! Tworzy przycisk.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param text Tresc przycisku.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param icontex Tekstura ikony.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzona kontrolke przycisku lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* ButtonCreate(char* skin,char* name,char* text,XE_HALFVECTOR pos,XE_HALFVECTOR size,XE_ELM_TEXTURE icontex=XE_ELM_TEXTURE(),CONTROL* parent=0);
/*! Niszczy przycisk.
\param control Wskaznik na kontrolke przycisku.
\return true jesli operacja powiodla sie.
*/
bool ButtonDestroy(CONTROL* control);
/*! Zmienia styl przycisku na podswietlony.
\param control Wskaznik na kontrolke przycisku.
\return true jesli operacja powiodla sie.
*/
bool ButtonMakeOver(CONTROL* control);
/*! Zmienia styl przycisku na normalny.
\param control Wskaznik na kontrolke przycisku.
\return true jesli operacja powiodla sie.
*/
bool ButtonMakeOut(CONTROL* control);
/*! Tworzy pole przewijane.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param scrsize Grubosc paskow przewijania.
\param consize Rozmiar zawartosci wewnetrznej pola.
\param margintop Gorny margines pola.
\param marginbottom Dolny margines pola.
\param marginleft Lewy margines pola.
\param marginright Prawy margines pola.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzona kontrolke pola przewijania lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* ScrollCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,XE_HALFVECTOR scrsize,XE_HALFVECTOR consize,float margintop=0,float marginbottom=0,float marginleft=0,float marginright=0,CONTROL* parent=0);
/*! Niszczy pole przewijania.
\param control Wskaznik na kontrolke pola przewijania.
\return true jesli operacja powiodla sie.
*/
bool ScrollDestroy(CONTROL* control);
/*! Ustawia rozmiar zawartosci pola przewijania.
\param control Wskaznik na kontrolke pola przewijania.
\param size Rozmiar zawartosci.
\return true jesli operacja powiodla sie.
*/
bool ScrollSetContentSize(CONTROL* control,XE_HALFVECTOR size);
/*! Zwraca rozmiar zawartosci pola przewijania.
\param control Wskaznik na kontrolke pola przewijania.
\return Rozmiar pola przewijania.
*/
XE_HALFVECTOR ScrollGetContentSize(CONTROL* control);
/*! Zwraca kontrolke glowna pola przewijania.
\param control Wskaznik na kontrolke pola przewijania.
\return Wskaznik na kontrolke glowna pola przewijania.
*/
CONTROL* ScrollGetArea(CONTROL* control);
/*! Tworzy kontrolke statyczna.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param text Tresc kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzona kontrolke statyczna lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* StaticCreate(char* skin,char* name,char* text,XE_HALFVECTOR pos,XE_HALFVECTOR size,CONTROL* parent=0);
/*! Niszczy kontrolke statyczna.
\param control Wskaznik na kontrolke statyczna.
\return true jesli operacja powiodla sie.
*/
bool StaticDestroy(CONTROL* control);
/*! Tworzy pasek postepu.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param margintop Gorny margines pola.
\param marginbottom Dolny margines pola.
\param marginleft Lewy margines pola.
\param marginright Prawy margines pola.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzony pasek postepu lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* ProgressBarCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent=0);
/*! Niszczy pasek postepu.
\param control Wskaznik na pasek postepu.
\return true jesli operacja powiodla sie.
*/
bool ProgressBarDestroy(CONTROL* control);
/*! Ustala procent zapelnienia paska postepu.
\param control Wskaznik na pasek postepu.
\param phase Procent zapelnienia.
\return true jesli operacja powiodla sie.
*/
bool ProgressBarSetPhase(CONTROL* control,float phase);
/*! Zwraca procent zapelnienia paska postepu.
\return Procent zapelnienia paska.
*/
float ProgressBarGetPhase(CONTROL* control);
/*! Tworzy liste.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param scrsize Grubosc paska przewijania.
\param margintop Margines gorny.
\param marginbottom Margines dolny.
\param marginleft Margines lewy.
\param marginright Margines prawy.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzona kontrolke listy lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* ListBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float scrsize,float margintop=0,float marginbottom=0,float marginleft=0,float marginright=0,CONTROL* parent=0);
/*! Niszczy liste.
\param control Wskaznik na kontrolke listy.
\return true jesli operacja powiodla sie.
*/
bool ListBoxDestroy(CONTROL* control);
/*! Dodaje komorke do listy.
\param skin Nazwa skorki.
\param text Tresc komorki.
\param size Wysokosc komorki.
\param list Kontrolka listy.
\return Wskaznik na utworzona komorke listy lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* ListBoxAddCell(char* skin,char* text,float size,CONTROL* list);
/*! Usuwa komorke listy o danym ID.
\param list Kontrolka listy.
\param id Indeks komorki w liscie.
\return true jesli operacja powiodla sie.
*/
bool ListBoxRemoveCell(CONTROL* list,unsigned int id);
/*! Usuwa wszystkie komorki listy.
\param list Kontrolka listy.
\return true jesli operacja powiodla sie.
*/
bool ListBoxClear(CONTROL* list);
/*! Zwraca ilosc komorek listy.
\param list Kontrolka listy.
\return Liczba komorek listy.
*/
unsigned int ListBoxCellCount(CONTROL* list);
/*! Zwraca do listy wskazniki na kontrolki komorek listy.
\param list Kontrolka listy.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool ListBoxGetCells(CONTROL* list,XE_ELEMENTS<CONTROL*>& con);
/*! Zwraca do listy wskazniki na zaznaczone kontrolki komorek listy.
\param list Kontrolka listy.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool ListBoxGetSelected(CONTROL* list,XE_ELEMENTS<CONTROL*>& con);
/*! Zwraca do listy wskazniki na niezaznaczone kontrolki komorek listy.
\param list Kontrolka listy.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool ListBoxGetUnselected(CONTROL* list,XE_ELEMENTS<CONTROL*>& con);
/*! Tworzy pole wyboru.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param margintop Margines gorny.
\param marginbottom Margines dolny.
\param marginleft Margines lewy.
\param marginright Margines prawy.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzone pole wyboru lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* CheckBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float margintop=0,float marginbottom=0,float marginleft=0,float marginright=0,CONTROL* parent=0);
/*! Niszczy pole wyboru.
\param control Wskaznik na pole wyboru.
\return true jesli operacja powiodla sie.
*/
bool CheckBoxDestroy(CONTROL* control);
/*! Dodaje komorke do pola wyboru.
\param skin Nazwa skorki.
\param text Tresc komorki.
\param size Rozmiar komorki.
\param chksize Rozmiar przycisku wyboru.
\param check Kontrolka listy.
\return Wskaznik na utworzona komorke pola wyboru lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* CheckBoxAddCell(char* skin,char* text,float size,XE_HALFVECTOR chksize,CONTROL* check);
/*! Usuwa komorke pola wyboru o danym ID.
\param check Kontrolka pola wyboru.
\param id Indeks komorki w polu wyboru.
\return true jesli operacja powiodla sie.
*/
bool CheckBoxRemoveCell(CONTROL* check,unsigned int id);
/*! Usuwa wszystkie komorki pola wyboru.
\param check Kontrolka pola wyboru.
\return true jesli operacja powiodla sie.
*/
bool CheckBoxClear(CONTROL* check);
/*! Zwraca ilosc komorek pola wyboru.
\param check Kontrolka pola wyboru.
\return Liczba komorek pola wyboru.
*/
unsigned int CheckBoxCellCount(CONTROL* check);
/*! Zwraca do listy wskazniki na kontrolki komorek pola wyboru.
\param check Kontrolka pola wyboru.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool CheckBoxGetCells(CONTROL* check,XE_ELEMENTS<CONTROL*>& con);
/*! Zwraca do listy wskazniki na zaznaczone kontrolki komorek pola wyboru.
\param check Kontrolka pola wyboru.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool CheckBoxGetSelected(CONTROL* check,XE_ELEMENTS<CONTROL*>& con);
/*! Zwraca do listy wskazniki na niezaznaczone kontrolki komorek pola wyboru.
\param check Kontrolka pola wyboru.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool CheckBoxGetUnselected(CONTROL* check,XE_ELEMENTS<CONTROL*>& con);
/*! Tworzy pole opcji.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param margintop Margines gorny.
\param marginbottom Margines dolny.
\param marginleft Margines lewy.
\param marginright Margines prawy.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzone pole opcji lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* OptionBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float margintop=0,float marginbottom=0,float marginleft=0,float marginright=0,CONTROL* parent=0);
/*! Niszczy pole opcji.
\param control Wskaznik na pole opcji.
\return true jesli operacja powiodla sie.
*/
bool OptionBoxDestroy(CONTROL* control);
/*! Dodaje komorke do pola opcji.
\param skin Nazwa skorki.
\param text Tresc komorki.
\param size Rozmiar komorki.
\param optsize Rozmiar przycisku opcji.
\param option Kontrolka listy.
\return Wskaznik na utworzona komorke pola opcji lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* OptionBoxAddCell(char* skin,char* text,float size,XE_HALFVECTOR optsize,CONTROL* option);
/*! Usuwa komorke pola opcji o danym ID.
\param option Kontrolka pola opcji.
\param id Indeks komorki w polu opcji.
\return true jesli operacja powiodla sie.
*/
bool OptionBoxRemoveCell(CONTROL* option,unsigned int id);
/*! Usuwa wszystkie komorki pola opcji.
\param option Kontrolka pola opcji.
\return true jesli operacja powiodla sie.
*/
bool OptionBoxClear(CONTROL* option);
/*! Zwraca ilosc komorek pola opcji.
\param option Kontrolka pola opcji.
\return Liczba komorek pola opcji.
*/
unsigned int OptionBoxCellCount(CONTROL* option);
/*! Zwraca do listy wskazniki na kontrolki komorek pola opcji.
\param option Kontrolka pola opcji.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool OptionBoxGetCells(CONTROL* option,XE_ELEMENTS<CONTROL*>& con);
/*! Zwraca do listy wskazniki na zaznaczone kontrolki komorek pola opcji.
\param option Kontrolka pola opcji.
\return Wskaznik na zaznaczona komorke lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* OptionBoxGetSelected(CONTROL* option);
/*! Zwraca do listy wskazniki na niezaznaczone kontrolki komorek pola opcji.
\param option Kontrolka pola opcji.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool OptionBoxGetUnselected(CONTROL* option,XE_ELEMENTS<CONTROL*>& con);
/*! Tworzy suwak.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzony suwak lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* SliderCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,CONTROL* parent=0);
/*! Niszczy suwak.
\param control Wskaznik na suwak.
\return true jesli operacja powiodla sie.
*/
bool SliderDestroy(CONTROL* control);
/*! Zwraca wspolczynnik pozycji w suwaku.
\param control Wskaznik na suwak.
\return Wspolczynnik pozycji z zakresu: <0;1>.
*/
float SliderGetFactor(CONTROL* control);
/*! Ustala wspolczynnik pozycji w suwaku.
\param control Wskaznik na suwak.
\param factor Wspolczynnik pozycji z zakresu: <0;1>.
\return true jesli operacja powiodla sie.
*/
bool SliderSetFactor(CONTROL* control,float factor);
/*! Tworzy menu.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param text Tresc menu.
\param icon Tekstura ikony kontrolki.
\param listdocktype Sposob dokowania rozwijanej listy menu.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzone menu lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* MenuCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,char* text,XE_ELM_TEXTURE icon=XE_ELM_TEXTURE(),unsigned int listdocktype=XEF_FLAG_DOCK_TO_EDGE_BOTTOM,CONTROL* parent=0);
/*! Niszczy menu.
\param control Wskaznik na kontrolke menu.
\return true jesli operacja powiodla sie.
*/
bool MenuDestroy(CONTROL* control);
/*! Dodaje przycisk do rozwijanej listy menu.
\param menu Wskaznik na menu do ktorego ma dodac przycisk.
\param skin Nazwa skorki.
\param size Rozmiar.
\param text Tresc przycisku.
\param icon Tekstura ikony przycisku.
\return Wskaznik na utworzony przycisk lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* MenuAddItemButton(CONTROL* menu,char* skin,XE_HALFVECTOR size,char* text,XE_ELM_TEXTURE icon=XE_ELM_TEXTURE());
/*! Tworzy podmenu do rozwijanej listy menu.
\param menu Wskaznik na menu do ktorego ma dodac przycisk.
\param skin Nazwa skorki.
\param size Rozmiar.
\param text Tresc menu.
\param icon Tekstura ikony kontrolki.
\param listdocktype Sposob dokowania rozwijanej listy menu.
\return Wskaznik na utworzone podmenu lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* MenuAddItemMenu(CONTROL* menu,char* skin,XE_HALFVECTOR size,char* text,XE_ELM_TEXTURE icon=XE_ELM_TEXTURE(),unsigned int listdocktype=XEF_FLAG_DOCK_TO_EDGE_RIGHT);
/*! Zamyka drzewo menu.
\param menu Wskaznik na kontrolke menu.
\return true jesli operacja powiodla sie.
*/
bool MenuCollapse(CONTROL* menu);
/*! Otwiera drzewo menu.
\param menu Wskaznik na kontrolke menu.
\return true jesli operacja powiodla sie.
*/
bool MenuExpand(CONTROL* menu);
/*! Tworzy pole tekstowe.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param text Tresc pola tekstowego.
\param password Ustala czy tresc pola ma byc maskowana gwiazdkami.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzone pole tekstowe lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* EditBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,char* text,bool password=false,CONTROL* parent=0);
/*! Niszczy pole tekstowe.
\param control Wskaznik na pole tekstowe.
\return true jesli operacja powiodla sie.
*/
bool EditBoxDestroy(CONTROL* control);
/*! Ustawia tryb maskowania tresci pola tekstowego.
\param edit Wskaznik na pole tekstowe.
\param mode Ustala czy tresc pola ma byc maskowana gwiazdkami.
\return true jesli operacja powiodla sie.
*/
bool EditBoxPasswordMode(CONTROL* edit,bool mode);
/*! Ustawia tryb edycji tresci pola tekstowego.
\param edit Wskaznik na pole tekstowe.
\param mode Ustala czy tresc pola ma byc edytowalna.
\return true jesli operacja powiodla sie.
*/
bool EditBoxEditMode(CONTROL* edit,bool mode);
/*! Pobiera tresc pola tekstowego.
\param edit Wskaznik na pole tekstowe.
\param text Referencja na docelowy string.
\return true jesli operacja powiodla sie.
*/
bool EditBoxGetText(CONTROL* edit,XE_STRING& text);
/*! Ustala tresc pola tekstowego.
\param edit Wskaznik na pole tekstowe.
\param text Wskaznik na cstring nowej tresci pola tekstowego.
\return true jesli operacja powiodla sie.
*/
bool EditBoxSetText(CONTROL* edit,char* text);
/*! Tworzy pole grupy.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param text Tresc legendy.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzone pole grupy lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* GroupCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,char* text,CONTROL* parent=0);
/*! Niszczy pole grupy.
\param control Wskaznik na pole grupy.
\return true jesli operacja powiodla sie.
*/
bool GroupDestroy(CONTROL* control);
/*! Tworzy liset rozwijana.
\param skin Nazwa skorki.
\param name Nazwa kontrolki.
\param pos Pozycja wzgledem kontrolki rodzica.
\param size Rozmiar.
\param listsize Rozmiar listy rozwijanej.
\param scrsize Grubosc paska przewijania.
\param text Poczatkowa tresc pola.
\param listdocktype Sposob dokowania rozwijanej listy.
\param margintop Margines gorny.
\param marginbottom Margines dolny.
\param marginleft Margines lewy.
\param marginright Margines prawy.
\param parent Wskaznik na kontrolke rodzica.
\return Wskaznik na utworzona liste rozwijana lub 0 jesli operacja nie powiodla sie.
*/
template<typename T>
CONTROL* ComboBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,XE_HALFVECTOR listsize,float scrsize,char* text,unsigned int listdocktype=XEF_FLAG_DOCK_TO_EDGE_BOTTOM,float margintop=0,float marginbottom=0,float marginleft=0,float marginright=0,CONTROL* parent=0);
/*! Niszczy liste rozwijana.
\param control Wskaznik na liste rozwijana.
\return true jesli operacja powiodla sie.
*/
bool ComboBoxDestroy(CONTROL* control);
/*! Dodaje komorke do listy rozwijanej.
\param skin Nazwa skorki.
\param text Tresc komorki.
\param size Wysokosc komorki.
\param combo Kontrolka listy rozwijanej.
\return Wskaznik na utworzona komorke listy lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* ComboBoxAddCell(char* skin,char* text,float size,CONTROL* combo);
/*! Usuwa komorke listy rozwijanej o danym ID.
\param combo Kontrolka listy rozwijanej.
\param id Indeks komorki w liscie.
\return true jesli operacja powiodla sie.
*/
bool ComboBoxRemoveCell(CONTROL* combo,unsigned int id);
/*! Usuwa wszystkie komorki listy rozwijanej.
\param combo Kontrolka listy rozwijanej.
\return true jesli operacja powiodla sie.
*/
bool ComboBoxClear(CONTROL* combo);
/*! Zwraca ilosc komorek listy rozwijanej.
\param combo Kontrolka listy.
\return Liczba komorek listy.
*/
unsigned int ComboBoxCellCount(CONTROL* combo);
/*! Zwraca do listy wskazniki na kontrolki komorek listy rozwijanej.
\param combo Kontrolka listy rozwijanej.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool ComboBoxGetCells(CONTROL* combo,XE_ELEMENTS<CONTROL*>& con);
/*! Zwraca do listy wskazniki na zaznaczone kontrolki komorek listy rozwijanej.
\param combo Kontrolka listy rozwijanej.
\return Wskaznik na zaznaczona komorke lub 0 jesli operacja nie powiodla sie.
*/
CONTROL* ComboBoxGetSelected(CONTROL* combo);
/*! Zwraca do listy wskazniki na niezaznaczone kontrolki komorek listy rozwijanej.
\param combo Kontrolka listy rozwijanej.
\param con Referencja na liste wskaznikow na kontrolki.
\return true jesli operacja powiodla sie.
*/
bool ComboBoxGetUnselected(CONTROL* combo,XE_ELEMENTS<CONTROL*>& con);
};

#endif /* XE_COMPILE_PHOTON */

#ifdef XE_COMPILE_ETHER

/*--- XE_SESSION ---*/
//! Klasa sesji sieciowej.
class XE_SESSION
{
public:
//! Struktura statusu zadania.
struct REQUEST
{
//! Status zadania.
XEF_ESTATE Status;
//! Calkowity rozmiar tresci odpowiedzi.
unsigned int Size;
//! Bierzacy rozmiar pobranej odpowiedzi.
unsigned int Current;
/*! Konstruktor domyslny. */
REQUEST(){Status=XEF_NULL;Size=0;Current=0;};
};
private:
XEF_ESTATE Type;
XE_ELM_SOCKET Server;
XE_ELEMENTS<XE_ELM_SOCKET> Clients;
XE_ELM_SOCKET Incoming;
public:
//! Wskaznik na procedure zdarzenia akceptacji klienta na serwerze.
bool (*OnServerClientAccept)(XE_SESSION*,XE_ELM_SOCKET*);
//! Wskaznik na procedure zdarzenia aktualizacji klienta na serwerze.
void (*OnServerClientUpdate)(XE_SESSION*,XE_ELM_SOCKET*,XE_FILE*);
//! Wskaznik na procedure zdarzenia odlaczenia klienta na serwerze.
void (*OnServerClientDisconnect)(XE_SESSION*,XE_ELM_SOCKET*);
//! Wskaznik na procedure zdarzenia akceptacji klienta.
bool (*OnClientAccept)(XE_SESSION*);
//! Wskaznik na procedure zdarzenia aktualizacji klienta.
void (*OnClientUpdate)(XE_SESSION*,XE_FILE*);
//! Wskaznik na procedure zdarzenia odlaczenia klienta.
void (*OnClientDisconnect)(XE_SESSION*);
/*! Konstruktor domyslny. */
XE_SESSION();
/*! Rozpoczecie trybu sieciowego.
\return true jesli operacja powiodla sie.
*/
static bool Start();
/*! Zakonczenie trybu sieciowego. */
static void Stop();
/*! Hostuje sesje.
\param port Numer portu.
\param maxconnections Maksymalna liczba dozwolonych polaczen.
\return true jesli operacja powiodla sie.
*/
bool Host(XE_WORD port,int maxconnections);
/*! Dolacza do sesji.
\param address Adres hosta.
\param port Numer portu.
\param udp Ustala czy typem transmisji danych ma byc UDP.
\return true jesli operacja powiodla sie.
*/
bool Join(char* address,XE_WORD port,bool udp=false);
/*! Rozlacza klienta.
\param sock Element gniazda klienta.
\return true jesli operacja powiodla sie.
*/
bool Disconnect(XE_ELM_SOCKET sock);
/*! Konczy sesje. */
void Exit();
/*! Postep sesji.
\return true jesli operacja powiodla sie.
*/
bool Progress();
/*! Wysyla dane do gniazda, lub do serwera/klientow jesli dane gniazdo jest puste.
\param buffer Referencja na bufor danych do wyslania.
\param to Element docelowego gniazda siecowego.
\param allwithout Ustala czy ma wyslac do wszystkich klientow poza danym.
\param offset Pozycja od ktorej zaczyna wysylac dane bufora.
\param size Rozmiar wysylanych danych (0 jesli ma wyslac caly bufor).
\return Rozmiar wyslanych danych jesli operacja powiodla sie, lub 0 jesli nie.
*/
unsigned int Send(XE_FILE& buffer,XE_ELM_SOCKET to=XE_ELM_SOCKET(),bool allwithout=false,unsigned int offset=0,unsigned int size=0);
/*! Odbiera dane z gniazda, lub z serwera jesli dane gniazdo jest puste.
\param buffer Referencja na docelowy bufor danych.
\param from Element zrodlowego gniazda siecowego.
\return Rozmiar odebranych danych jesli operacja powiodla sie, lub 0 jesli nie.
*/
unsigned int Receive(XE_FILE& buffer,XE_ELM_SOCKET from=XE_ELM_SOCKET());
/*! Czysci bufor po zakonczonej operacji pobierania pakietu danych.
\param buffer Referencja na docelowy bufor danych.
*/
void ReceiveEnd(XE_FILE& buffer);
/*! Zwraca typ sesji.
\return Typ sesji.
*/
XEF_ESTATE GetType();
/*! Zwraca element gniazda serwera.
\return Element gniazda sieciowego.
*/
XE_ELM_SOCKET GetServer();
/*! Zwraca ilosc klientow serwera.
\return Liczba klientow.
*/
unsigned int ClientsCount();
/*! Wysyla zadanie do serwera i pobiera odpowiedz do bufora pliku.
\param server Adres serwera.
\param request Referencja na bufor z trescia zadania.
\param result Referencja na docelowy bufor pliku do ktorego trafi odpowiedz z serwera.
\param data Wskaznik na dane zadania wysylane tuz po naglowku.
\param port Numer portu.
\param onlybody Ustala czy ma pobrac tylko tresc odpowiedzi, bez naglowka.
\param resheader Wskaznik na string do ktorego zostanie zwrocona tresc naglowka, jesli wartosc rozna niz NULL oraz argument onlybody jest rowny true.
\param packetsize Maksymalny rozmiar pakietu pobieranego jednorazowo.
\return true jesli operacja powiodla sie.
*/
bool HTTPrequest(char* server,XE_FILE& request,XE_FILE& result,XE_FILE* data=0,XE_WORD port=80,bool onlybody=false,XE_STRING* resheader=0,unsigned int packetsize=10240);
/*! Wysyla zadanie do serwera by pobrac asynchronicznie odpowiedz do bufora pliku (bez naglowka).
\param status Referencja na status zadania.
\param server Adres serwera.
\param request Referencja na bufor z trescia zadania.
\param datasize Calkowity rozmiar danych wysylanych tuz po naglowku.
\param port Numer portu.
\return true jesli operacja powiodla sie.
*/
bool HTTPrequestAsync(REQUEST& status,char* server,XE_FILE& request,unsigned int datasize=0,XE_WORD port=80);
/*! Pobiera asynchronicznie odpowiedz od serwera na zadanie wyslane funkcja HTTPrequestAsync().
\param status Referencja na status zadania.
\param result Referencja na docelowy bufor pliku do ktorego trafi odpowiedz z serwera.
\param data Wskaznik na dane zadania wysylane tuz po naglowku.
\param packetsize Maksymalny rozmiar pakietu pobieranego jednorazowo.
\return true jesli operacja powiodla sie.
*/
bool HTTPrequestAsyncKeep(REQUEST& status,XE_FILE& result,XE_FILE* data=0,unsigned int packetsize=10240);
/*! Przerywa pobieranie odpowiedzi z serwera.
\param status Referencja na status zadania.
\return true jesli operacja powiodla sie.
*/
bool HTTPrequestAsyncTerminate(REQUEST& status);
/*! Wykonuje operacje pobrania pliku uzywajac protokolu HTTP.
\param server Adres serwera.
\param fname Sciezka do pliku na serwerze.
\param file Referencja na bufor pliku do ktorego pobierze plik.
\param port Numer portu na ktorym dziala serwer HTTP.
\param packetsize Maksymalny rozmiar pakietu pobieranego jednorazowo.
\return true jesli operacja powiodla sie.
*/
bool HTTPdownload(char* server,char* fname,XE_FILE& file,XE_WORD port=80,unsigned int packetsize=10240);
/*! Rozpoczyna wykonanywanie operacji asynchronicznego pobrania pliku uzywajac protokolu HTTP.
\param status Referencja na status zadania.
\param server Adres serwera.
\param fname Sciezka do pliku na serwerze.
\param port Numer portu na ktorym dziala serwer HTTP.
\return true jesli operacja powiodla sie.
*/
bool HTTPdownloadAsync(REQUEST& status,char* server,char* fname,XE_WORD port=80);
/*! Odbiera pakiet pliku na zadanie wyslane funkcja HTTPdownloadAsync(). Status XEF_NULL oznacza nie rozpoczete / zatrzymane pobieranie, XEF_HEADER oznacza czekanie na naglowek, XEF_KEEP oznacza trwanie pobierania pakietow pliku, zas XEF_DONE oznacza pomyslne zakonczenie pobierania pliku.
\param status Referencja na status zadania.
\param file Referencja na bufor pliku do ktorego pobierze plik.
\param packetsize Maksymalny rozmiar pakietu pobieranego jednorazowo.
\return true jesli operacja powiodla sie.
*/
bool HTTPdownloadAsyncKeep(REQUEST& status,XE_FILE& file,unsigned int packetsize=10240);
/*! Przerywa pobieranie pliku.
\param status Referencja na status zadania.
\return true jesli operacja powiodla sie.
*/
bool HTTPdownloadAsyncTerminate(REQUEST& status);
/*! Wykonuje operacje wyslania danych formularza oraz pobrania pliku uzywajac protokolu HTTP.
\param server Adres serwera.
\param fname Sciezka do pliku na serwerze.
\param post Ciag znakow z danymi formularza.
\param file Referencja na bufor pliku do ktorego pobierze plik.
\param port Numer portu na ktorym dziala serwer HTTP.
\param packetsize Maksymalny rozmiar pakietu pobieranego jednorazowo.
\return true jesli operacja powiodla sie.
*/
bool HTTPsend(char* server,char* fname,char* post,XE_FILE& file,XE_WORD port=80,unsigned int packetsize=10240);
/*! Rozpoczyna wykonanywanie operacji wyslania danych formularza oraz asynchronicznego pobrania pliku uzywajac protokolu HTTP.
\param status Referencja na status zadania.
\param server Adres serwera.
\param fname Sciezka do pliku na serwerze.
\param post Ciag znakow z danymi formularza.
\param port Numer portu na ktorym dziala serwer HTTP.
\return true jesli operacja powiodla sie.
*/
bool HTTPsendAsync(REQUEST& status,char* server,char* fname,char* post,XE_WORD port=80);
/*! Odbiera pakiet pliku na zadanie wyslane funkcja HTTPsendAsync(). Status XEF_NULL oznacza nie rozpoczete / zatrzymane pobieranie, XEF_HEADER oznacza czekanie na naglowek, XEF_KEEP oznacza trwanie pobierania pakietow pliku, zas XEF_DONE oznacza pomyslne zakonczenie pobierania pliku.
\param status Referencja na status zadania.
\param file Referencja na bufor pliku do ktorego pobierze plik.
\param packetsize Maksymalny rozmiar pakietu pobieranego jednorazowo.
\return true jesli operacja powiodla sie.
*/
bool HTTPsendAsyncKeep(REQUEST& status,XE_FILE& file,unsigned int packetsize=10240);
/*! Przerywa pobieranie pliku.
\param status Referencja na status zadania.
\return true jesli operacja powiodla sie.
*/
bool HTTPsendAsyncTerminate(REQUEST& status);
};

#endif /* XE_COMPILE_ETHER */

#ifdef XE_COMPILE_PHOTON

/*--- XE_MODEL ---*/
//! Klasa modelu.
class XE_MODEL
{
private:
bool prepared;
public:
//! Struktura grupy wierzcholkow.
class GROUP
{
public:
//! Tablica tekstur (tekstura na dana jednostke teksturujaca).
XE_ARRAY<XE_ELM_TEXTURE> Textures;
//! Wskaznik na efekt;
XE_EFFECT* Effect;
//! Bufor wierzcholkow.
XE_VERTICES Vertices;
/*! Konstruktor domyslny. */
GROUP();
};
//! Kontener grup wierzcholkow.
XE_ELEMENTS<GROUP> Groups;
/*! Konstruktor domyslny. */
XE_MODEL();
/*! Przygotowuje model z pliku OBJ.
\param fname Sciezka do pliku OBJ.
\param mtlpath Sciezka do katalogu z plikami MTL.
\param minfilter Filtr pomniejszajacy.
\param magfilter Filtr powiekszajacy.
\param accessflag Flagi dostepu do bufora wierzcholkow.
\param forcednovbo Ustala czy model ma nie uzywac VBO.
\return true jesli operacja powiodla sie.
*/
bool Prepare(char* fname,char* mtlpath,XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST,XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST,unsigned int accessflag=4,bool forcednovbo=false);
/*! Rysuje model.
\param position Pozycja.
\param angle Katy obrotu.
\param scale Skala.
*/
void Draw(XE_VECTOR position=0,XE_ANGLEVECTOR angle=0,XE_VECTOR scale=XE_VECTOR(1,1,1));
/*! Czysci model.
\param leavetex Ustala czy tekstury maja byc nie usuwane.
*/
void Cleanup(bool leavetex=false);
/*! Nadaje modelowi wlasciwosc przygotowanego z pliku/pamieci.
\param mode Wartosc wlasciwosci przygotowania z pliku/pamieci.
*/
void ForcePrepared(bool mode=true);
};

/*--- XE_ACTOR3D ---*/
/*! Rozszerzenie klasy aktora: Aktor 2D. */
class XE_ACTOR3D : public XE_ACTOR
{
public:
//! Model.
XE_MODEL Model;
/*! Konstruktor domyslny. */
XE_ACTOR3D();
/*! Rysuje model. */
void DrawModel();
};

#endif /* XE_COMPILE_PHOTON */

/*===================*/
/*=== DEFINITIONS ===*/
/*===================*/

bool XeMouseCheckRectPos(int x1,int y1,int x2,int y2);
bool XeMouseCheckRectWinPos(XE_WINDOW* _wnd,int x1,int y1,int x2,int y2);
inline double GetFromRGBA(int color,int type);
inline int VecToRGBA(XE_VECTOR color);
inline XE_VECTOR RGBAtoVec(int color);
bool BoxCollision(XE_VECTOR b1,XE_VECTOR e1,XE_VECTOR b2,XE_VECTOR e2);
bool RectCollision(XE_VECTOR p,XE_VECTOR b,XE_VECTOR e);

#ifdef XE_CANIMP

/*--- XE_CONTAINER ---*/
template <typename T>
XE_CONTAINER<T>::XE_CONTAINER()
{
Static=false;
Unique=0;
}

template <typename T>
XE_CONTAINER<T>::~XE_CONTAINER()
{
if(!Static)Clear();
}

template <typename T>
void XE_CONTAINER<T>::Clear()
{
Names.Clear();
Elements.Clear();
}

template <typename T>
T& XE_CONTAINER<T>::Access(char* name,unsigned int id)
{
return(*(*this)(name,id).iPointer());
}

template <typename T>
T& XE_CONTAINER<T>::Access(XEF_ESTATE type,char* name,unsigned int id)
{
return(*(*this)(type,name,id).iPointer());
}

template <typename T>
unsigned int XE_CONTAINER<T>::Count(char* name)
{
if(!name)
return(Elements.Size());
else
{
unsigned int count=0;
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while(!n.IsEmpty()&&!e.IsEmpty())
{
if(!strcmp(n.iPointer()->string,name))
count++;
n.Next();
e.Next();
}
return(count);
}
}

template <typename T>
XE_ELEMENT_POINTER<T> XE_CONTAINER<T>::FirstPointer()
{
return(Elements.FirstPointer());
}

template <typename T>
XE_ELEMENT_POINTER<T> XE_CONTAINER<T>::LastPointer()
{
return(Elements.LastPointer());
}

template <typename T>
void XE_CONTAINER<T>::Send(XE_CONTAINER<T>& con)
{
if(Names.Size()&&Elements.Size())
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> elm=Elements.FirstPointer();
while(!n.IsEmpty()&&!elm.IsEmpty()&&Names.Size()&&Elements.Size())
{
con.Names.Capture(n);
con.Elements.Capture(elm);
n=Names.FirstPointer();
elm=Elements.FirstPointer();
}
}
}

template <typename T>
void XE_CONTAINER<T>::Send(XE_ELEMENT_POINTER<T>& elm,XE_CONTAINER<T>& con)
{
if(!elm.IsEmpty())
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while(!n.IsEmpty()&&!e.IsEmpty())
{
if(e==elm)
{
con.Names.Capture(n);
con.Elements.Capture(e);
return;
}
n.Next();
e.Next();
}
}
}

template <typename T>
bool XE_CONTAINER<T>::Remove(T& data)
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while(!n.IsEmpty()&&!e.IsEmpty())
{
if(e.iClone()==data)
{
Names.ErasePointer(n);
Elements.ErasePointer(e);
return(true);
}
n.Next();
e.Next();
}
return(false);
}

template <typename T>
bool XE_CONTAINER<T>::RemovePtr(T* data)
{
if(!data)return(false);
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while(!n.IsEmpty()&&!e.IsEmpty())
{
if(memcmp(e.iPointer(),data,sizeof(T))==0)
{
Names.ErasePointer(n);
Elements.ErasePointer(e);
return(true);
}
n.Next();
e.Next();
}
return(false);
}

template <typename T>
unsigned int XE_CONTAINER<T>::MakeUnique()
{
if(Unique==0xFFFFFFFF)Unique=0x00000000;
return(Unique++);
}

template <typename T>
void XE_CONTAINER<T>::Sort(int(*foo)(T*,T*))
{
if(!foo)return;
bool change=true;
XE_ELEMENT_POINTER<XE_S124I4> n;
XE_ELEMENT_POINTER<T> e;
XE_ELEMENT_POINTER<XE_S124I4> nt;
XE_ELEMENT_POINTER<T> et;
while(change)
{
change=false;
n=Names.FirstPointer();
e=Elements.FirstPointer();
nt=n;
nt.Next();
et=e;
et.Next();
while(!n.IsEmpty()&&!nt.IsEmpty()&&!e.IsEmpty()&&!et.IsEmpty())
{
if(foo(e.iPointer(),et.iPointer())<0)
{
Names.Swap(n,nt);
Elements.Swap(e,et);
change=true;
}
n.Next();
e.Next();
nt.Next();
et.Next();
}
n=Names.LastPointer();
e=Elements.LastPointer();
nt=n;
nt.Prev();
et=e;
et.Prev();
while(!n.IsEmpty()&&!nt.IsEmpty()&&!e.IsEmpty()&&!et.IsEmpty())
{
if(foo(e.iPointer(),et.iPointer())>0)
{
Names.Swap(n,nt);
Elements.Swap(e,et);
change=true;
}
n.Prev();
e.Prev();
nt.Prev();
et.Prev();
}
}
}

template <typename T>
XE_ELEMENT_POINTER<T> XE_CONTAINER<T>::operator() (XEF_ESTATE type,char* name,unsigned int id)
{
if(strlen(name)>=124)return(XE_ELEMENT_POINTER<T>());
if(type==XEF_LOCATE)
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while(!n.IsEmpty()&&!e.IsEmpty())
{
if(!strcmp(n.iPointer()->string,name))
if(n.iPointer()->index==id)
return(e);
n.Next();
e.Next();
}
}
if(type==XEF_CREATE)
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while((!n.IsEmpty())&&(!e.IsEmpty()))
{
if(!strcmp(n.iPointer()->string,name))
if(n.iPointer()->index==id)
return(e);
n.Next();
e.Next();
}
XE_S124I4 tn;
memset(&tn,0,sizeof(XE_S124I4));
strcpy_s(tn.string,123,name);
tn.index=id;
T te;
if(Names.AddPointer(tn).IsEmpty())return(XE_ELEMENT_POINTER<T>());
return(Elements.AddPointer(te));
}
if(type==XEF_DESTROY)
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while((!n.IsEmpty())&&(!e.IsEmpty()))
{
if(!strcmp(n.iPointer()->string,name))
if(n.iPointer()->index==id)
{
Names.ErasePointer(n);
Elements.ErasePointer(e);
return(XE_ELEMENT_POINTER<T>());
}
n.Next();
e.Next();
}
}
if(type==XEF_FIND)
{
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while(!n.IsEmpty()&&!e.IsEmpty())
{
if(!strcmp(n.iPointer()->string,name))
return(e);
n.Next();
e.Next();
}
}
return(XE_ELEMENT_POINTER<T>());
}

template <typename T>
XE_ELEMENT_POINTER<T> XE_CONTAINER<T>::operator() (char* name,unsigned int id)
{
if(strlen(name)>=124)return(XE_ELEMENT_POINTER<T>());
XE_ELEMENT_POINTER<XE_S124I4> n=Names.FirstPointer();
XE_ELEMENT_POINTER<T> e=Elements.FirstPointer();
while((!n.IsEmpty())&&(!e.IsEmpty()))
{
if(!strcmp(n.iPointer()->string,name))
if(n.iPointer()->index==id)
return(e);
n.Next();
e.Next();
}
XE_S124I4 tn;
memset(&tn,0,sizeof(XE_S124I4));
strcpy_s(tn.string,123,name);
tn.index=id;
T te;
if(Names.AddPointer(tn).IsEmpty())return(XE_ELEMENT_POINTER<T>());
return(Elements.AddPointer(te));
}

/*--- XE_WINDOW ---*/
XE_WINDOW::XE_WINDOW()
{
captured=false;
Window=NULL;
Instance=NULL;
Width=1;
Height=1;
Aspect=1;
HDC thdc=GetDC(NULL);
if(thdc)
Refresh=GetDeviceCaps(thdc,VREFRESH);
else
Refresh=0;
ReleaseDC(NULL,thdc);
X=0;
Y=0;
ColorDepth=32;
Zdepth=16;
Fullscreen=false;
Show=true;
OnBar=true;
OnTray=false;
Tray.cbSize=sizeof(NOTIFYICONDATA);
Tray.uCallbackMessage=XE_TRAY;
Tray.hWnd=0;
Name="XenoN Core Framework";
Name.Static=true;
Alpha=1;
Tcolor=0x00000000;
Transparent=false;
Layered=false;
TopMost=false;
}
 
bool XE_WINDOW::Create(XE_ELM_RENDERTARGET share)
{
WNDCLASS wc;
DWORD dwExStyle;
DWORD dwStyle;
RECT WindowRect;
WindowRect.left=(long)X;
WindowRect.right=(long)Width+(long)X;
WindowRect.top=(long)Y;
WindowRect.bottom=(long)Height+(long)Y;

Instance=GetModuleHandle(NULL);
wc.style=CS_OWNDC|CS_HREDRAW|CS_VREDRAW;
wc.lpfnWndProc=(WNDPROC) XeWndProc;
wc.cbClsExtra=0;
wc.cbWndExtra=0;
wc.hInstance=Instance;
wc.hIcon=LoadIcon(Instance,MAKEINTRESOURCE(XEF_RES_MAIN_ICON));
wc.hCursor=LoadCursor(NULL,IDC_ARROW);
wc.hbrBackground=NULL;
wc.lpszMenuName=NULL;
wc.lpszClassName=Name.Get();

if(!RegisterClass(&wc))
return(false);

HDC thdc=GetDC(NULL);
if(thdc)Refresh=GetDeviceCaps(thdc,VREFRESH);
ReleaseDC(NULL,thdc);

dwExStyle=0;
if(!OnBar)dwExStyle=WS_EX_TOOLWINDOW;
if(OnBar)dwExStyle=WS_EX_APPWINDOW;
if(TopMost)dwExStyle|=WS_EX_TOPMOST;
if(Layered||Alpha<1||Transparent)dwExStyle|=WS_EX_LAYERED;
dwStyle=WS_POPUP;

AdjustWindowRectEx(&WindowRect,dwStyle,false,dwExStyle);

if(!(Window=CreateWindowEx(dwExStyle,Name.Get(),Name.Get(),dwStyle|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,WindowRect.left,WindowRect.top,WindowRect.right-WindowRect.left,WindowRect.bottom-WindowRect.top,NULL,NULL,Instance,NULL)))
{
Destroy();
return(false);
}

if(Alpha<1||Transparent)
{
if(Alpha<1)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_ALPHA);
if(Transparent)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_COLORKEY);
if(Alpha<1&&Transparent)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_ALPHA|LWA_COLORKEY);
}

if(Show)
{
ShowWindow(Window,SW_SHOW);
SetForegroundWindow(Window);
SetFocus(Window);
SetActiveWindow(Window);
}

if(OnTray)
{
Tray.hWnd=Window;
Tray.uID=XeTrayCount++;
Tray.uFlags=NIF_ICON|NIF_MESSAGE|NIF_TIP;
Tray.hIcon=LoadIcon(Instance,MAKEINTRESOURCE(XEF_RES_MAIN_ICON));
strcpy_s((char*)Tray.szTip,128,Name.Get());
Shell_NotifyIcon(NIM_ADD,&Tray);
}

#ifdef XE_COMPILE_PHOTON
if(!Photon::XeRenderTargetCreate(&RenderTarget,Window,Layered?XE_DRAW_TO_LAYER:XE_DRAW_TO_WINDOW,ColorDepth,Zdepth))
{
if(Layered)
{
Layered=false;
if(!OnBar)dwExStyle=WS_EX_TOOLWINDOW;
if(OnBar)dwExStyle=WS_EX_APPWINDOW;
if(TopMost)dwExStyle|=WS_EX_TOPMOST;
SetWindowLong(Window,GWL_EXSTYLE,dwExStyle);
if(!Photon::XeRenderTargetCreate(&RenderTarget,Window,XE_DRAW_TO_WINDOW,ColorDepth,Zdepth))
{
Destroy();
return(false);
}
}
else
{
Destroy();
return(false);
}
}
if(!Photon::XeRenderTargetArea(RenderTarget,0,0,Width,Height))
{
Destroy();
return(false);
}
if(!share.IsEmpty())Photon::XeRenderTargetShare(RenderTarget,share);
#endif /* XE_COMPILE_PHOTON */

return(true);
}

void XE_WINDOW::Destroy()
{
if(Fullscreen)
{
ChangeDisplaySettings(NULL,0);
Fullscreen=false;
}
#ifdef XE_COMPILE_PHOTON
Photon::XeRenderTargetDestroy(RenderTarget);
#endif /* XE_COMPILE_PHOTON */

if(OnTray)
{
Tray.uFlags=0;
Shell_NotifyIcon(NIM_DELETE,&Tray);
Tray.hWnd=0;
}

DestroyWindow(Window);
Window=NULL;
UnregisterClass((LPCSTR)Name.Get(),Instance);
Instance=NULL;
captured=false;
}

bool XE_WINDOW::Capture(HWND win,XE_ELM_RENDERTARGET share)
{
DWORD dwExStyle;
DWORD dwStyle;
RECT WindowRect;
WindowRect.left=(long)X;
WindowRect.right=(long)Width+(long)X;
WindowRect.top=(long)Y;
WindowRect.bottom=(long)Height+(long)Y;

Instance=GetModuleHandle(NULL);

HDC thdc=GetDC(NULL);
if(thdc)Refresh=GetDeviceCaps(thdc,VREFRESH);
ReleaseDC(NULL,thdc);

dwExStyle=0;
if(!OnBar)dwExStyle=WS_EX_TOOLWINDOW;
if(OnBar)dwExStyle=WS_EX_APPWINDOW;
if(TopMost)dwExStyle|=WS_EX_TOPMOST;
dwStyle=WS_POPUP;

AdjustWindowRectEx(&WindowRect,dwStyle,false,dwExStyle);

Window=win;

if(Alpha<1||Transparent)
{
SetWindowLong(Window,GWL_EXSTYLE,dwExStyle|WS_EX_LAYERED);
if(Alpha<1)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_ALPHA);
if(Transparent)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_COLORKEY);
if(Alpha<1&&Transparent)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_ALPHA|LWA_COLORKEY);
}

if(Show)
{
ShowWindow(Window,SW_SHOW);
SetForegroundWindow(Window);
SetFocus(Window);
SetActiveWindow(Window);
}

if(OnTray)
{
Tray.hWnd=Window;
Tray.uID=XeTrayCount++;
Tray.uFlags=NIF_ICON|NIF_MESSAGE|NIF_TIP;
Tray.hIcon=LoadIcon(Instance,MAKEINTRESOURCE(XEF_RES_MAIN_ICON));
strcpy_s((char*)Tray.szTip,128,Name.Get());
Shell_NotifyIcon(NIM_ADD,&Tray);
}

#ifdef XE_COMPILE_PHOTON
if(!Photon::XeRenderTargetCreate(&RenderTarget,Window,Layered?XE_DRAW_TO_LAYER:XE_DRAW_TO_WINDOW,ColorDepth,Zdepth))
{
if(Layered)
{
Layered=false;
if(!OnBar)dwExStyle=WS_EX_TOOLWINDOW;
if(OnBar)dwExStyle=WS_EX_APPWINDOW;
if(TopMost)dwExStyle|=WS_EX_TOPMOST;
SetWindowLong(Window,GWL_EXSTYLE,dwExStyle);
if(!Photon::XeRenderTargetCreate(&RenderTarget,Window,XE_DRAW_TO_WINDOW,ColorDepth,Zdepth))
{
Destroy();
return(false);
}
}
else
{
Destroy();
return(false);
}
}
if(!share.IsEmpty())Photon::XeRenderTargetShare(RenderTarget,share);
#endif /* XE_COMPILE_PHOTON */

captured=true;
return(true);
}

void XE_WINDOW::Uncapture()
{
if(Fullscreen)ChangeDisplaySettings(NULL,0);
#ifdef XE_COMPILE_PHOTON
Photon::XeRenderTargetDestroy(RenderTarget);
#endif /* XE_COMPILE_PHOTON */

if(OnTray)
{
Tray.uFlags=0;
Shell_NotifyIcon(NIM_DELETE,&Tray);
Tray.hWnd=0;
}

Window=NULL;
Instance=NULL;
captured=false;
}

bool XE_WINDOW::IsCaptured()
{
return(captured);
}

void XE_WINDOW::FromDisplay()
{
X=0;
Y=0;
Width=GetSystemMetrics(SM_CXSCREEN);
Height=GetSystemMetrics(SM_CYSCREEN);
Aspect=(float)Width/(float)Height;
HDC thdc=GetDC(NULL);
if(thdc)Refresh=GetDeviceCaps(thdc,VREFRESH);
ReleaseDC(NULL,thdc);
}

void XE_WINDOW::FromWorkArea()
{
RECT workrect;
SystemParametersInfo(SPI_GETWORKAREA,0,&workrect,0);
X=workrect.left;
Y=workrect.top;
Width=workrect.right-workrect.left;
Height=workrect.bottom-workrect.top;
}

bool XE_WINDOW::Update()
{
RECT WindowRect;
DWORD dwExStyle;
DWORD dwStyle;
WindowRect.left=(long)X;
WindowRect.right=(long)Width+(long)X;
WindowRect.top=(long)Y;
WindowRect.bottom=(long)Height+(long)Y;
HDC thdc=GetDC(NULL);
if(thdc)Refresh=GetDeviceCaps(thdc,VREFRESH);
ReleaseDC(NULL,thdc);
dwExStyle=GetWindowLong(Window,GWL_EXSTYLE);
bool reshow=false;
if(OnBar&&(dwExStyle&WS_EX_TOOLWINDOW))reshow=true;
if(!OnBar&&(dwExStyle&WS_EX_APPWINDOW))reshow=true;
if(!OnBar)dwExStyle=WS_EX_TOOLWINDOW;
if(OnBar)dwExStyle=WS_EX_APPWINDOW;
if(TopMost)dwExStyle|=WS_EX_TOPMOST;
dwStyle=WS_POPUP;
if(reshow)ShowWindow(Window,SW_HIDE);
if(Alpha<1||Transparent||Layered)
{
SetWindowLong(Window,GWL_EXSTYLE,dwExStyle|WS_EX_LAYERED);
if(Alpha<1)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_ALPHA);
if(Transparent)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_COLORKEY);
if(Alpha<1&&Transparent)SetLayeredWindowAttributes(Window,(COLORREF)Tcolor,(BYTE)(max(0,min(1,Alpha))*255),LWA_ALPHA|LWA_COLORKEY);
}
else
SetWindowLong(Window,GWL_EXSTYLE,dwExStyle);
if(reshow)ShowWindow(Window,SW_SHOW);
MoveWindow(Window,X,Y,Width,Height,true);
AdjustWindowRectEx(&WindowRect,dwStyle,false,dwExStyle);
if(Tray.hWnd)
{
if(OnTray)
Shell_NotifyIcon(NIM_MODIFY,&Tray);
else
{
Tray.uFlags=0;
Shell_NotifyIcon(NIM_DELETE,&Tray);
Tray.hWnd=0;
}
}
else
if(OnTray)
{
Tray.hWnd=Window;
Tray.uID=XeTrayCount++;
Tray.uFlags=NIF_ICON|NIF_MESSAGE|NIF_TIP;
Tray.hIcon=LoadIcon(Instance,MAKEINTRESOURCE(XEF_RES_MAIN_ICON));
strcpy_s((char*)Tray.szTip,128,Name.Get());
Shell_NotifyIcon(NIM_ADD,&Tray);
}
UpdateWindow(Window);
#ifdef XE_COMPILE_PHOTON
int* w=(int*)Photon::XeRenderTargetGet(RenderTarget,XE_RENDERTARGET_WIDTH);
int* h=(int*)Photon::XeRenderTargetGet(RenderTarget,XE_RENDERTARGET_HEIGHT);
XE_ESTATE* m=(XE_ESTATE*)Photon::XeRenderTargetGet(RenderTarget,XE_RENDERTARGET_DRAW_MODE);
if(*w!=Width||*h!=Height||(*m==XE_DRAW_TO_WINDOW&&Layered)||(*m==XE_DRAW_TO_LAYER&&!Layered))
{
Photon::XeRenderTargetChange(RenderTarget,Layered?XE_DRAW_TO_LAYER:XE_DRAW_TO_WINDOW);
Photon::XeRenderTargetArea(RenderTarget,0,0,Width,Height);
}
Photon::XeRenderTargetActivate(RenderTarget);
#endif /* XE_COMPILE_PHOTON */
return(true);
}

HWND XE_WINDOW::GetWindow()
{
return(Window);
}

XE_ELM_RENDERTARGET XE_WINDOW::GetTarget()
{
return(RenderTarget);
}

void XE_WINDOW::SetScreen(int fullscreen,int refresh)
{
if(!fullscreen)
{
ChangeDisplaySettings(NULL,0);
Fullscreen=false;
HDC thdc=GetDC(NULL);
if(thdc)Refresh=GetDeviceCaps(thdc,VREFRESH);
ReleaseDC(NULL,thdc);
}
else
{
DEVMODE dmScreenSettings;
memset(&dmScreenSettings,0,sizeof(dmScreenSettings));
dmScreenSettings.dmSize=sizeof(dmScreenSettings);
if(fullscreen>0)
{
dmScreenSettings.dmPelsWidth=Width;
dmScreenSettings.dmPelsHeight=Height;
dmScreenSettings.dmBitsPerPel=ColorDepth;
dmScreenSettings.dmFields|=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
Fullscreen=true;
}
if(refresh>0)
{
dmScreenSettings.dmDisplayFrequency=refresh;
dmScreenSettings.dmFields|=DM_DISPLAYFREQUENCY;
}
if(ChangeDisplaySettings(&dmScreenSettings,0)!=DISP_CHANGE_SUCCESSFUL)
Fullscreen=false;
HDC thdc=GetDC(NULL);
if(thdc)Refresh=GetDeviceCaps(thdc,VREFRESH);
ReleaseDC(NULL,thdc);
}
}

bool XE_WINDOW::GetFullscreen()
{
return(Fullscreen);
}

int XE_WINDOW::GetRefresh()
{
return(Refresh);
}

/*--- XE_IO ---*/
XE_IO::XE_IO()
{
ZeroMemory(Key,sizeof(Key));
ZeroMemory(KeyPressed,sizeof(KeyPressed));
ZeroMemory(KeyReleased,sizeof(KeyReleased));
ZeroMemory(KeyAfter,sizeof(KeyAfter));
MouseLb=false;
MouseMb=false;
MouseRb=false;
MouseLbPressed=false;
MouseMbPressed=false;
MouseRbPressed=false;
MouseLbReleased=false;
MouseMbReleased=false;
MouseRbReleased=false;
MouseLbAfter=false;
MouseMbAfter=false;
MouseRbAfter=false;
MouseWheel=0;
MouseWheelUp=false;
MouseWheelDown=false;
MouseWheelSteps=0;
Mouse.x=0;
Mouse.y=0;
KeyLast=0;
PressOnce=false;
}

XE_IO& XE_IO::Use()
{
static XE_IO Instance;
return(Instance);
}

XE_VECTOR XE_IO::MouseGetPos()
{
if(GetCursorPos(&(XE_IO::Use().Mouse)))
return(XE_VECTOR(XE_IO::Use().Mouse.x,XE_IO::Use().Mouse.y));
return(XE_VECTOR());
}

bool XE_IO::MouseSetPos(int mx,int my)
{
XE_IO::Use().Mouse.x=mx;
XE_IO::Use().Mouse.y=my;
if(SetCursorPos(mx,my))
return(true);
return(false);
}

int XE_IO::MouseGetX()
{
return(XE_IO::Use().Mouse.x);
}

int XE_IO::MouseGetY()
{
return(XE_IO::Use().Mouse.y);
}

int XE_IO::MouseGetWinX(XE_WINDOW* wnd)
{
return(XE_IO::Use().Mouse.x-wnd->X);
}

int XE_IO::MouseGetWinY(XE_WINDOW* wnd)
{
return(XE_IO::Use().Mouse.y-wnd->Y);
}

bool XE_IO::KeyboardGet(int key)
{
if(key==XE_KEY_ANY)
{
for(int _i=1;_i<256;_i++)
if(XE_IO::Use().Key[_i])
return(true);
return(false);
}
return(XE_IO::Use().Key[key]);
}

bool XE_IO::KeyboardSet(int key,bool state)
{
return(XE_IO::Use().Key[key]=state);
}

bool XE_IO::KeyboardGetPressed(int key)
{
if(key==XE_KEY_ANY)
{
for(int _i=1;_i<256;_i++)
if(XE_IO::Use().KeyPressed[_i])
return(true);
return(false);
}
return(XE_IO::Use().KeyPressed[key]);
}

bool XE_IO::KeyboardSetPressed(int key,bool state)
{
return(XE_IO::Use().KeyPressed[key]=state);
}

bool XE_IO::KeyboardGetReleased(int key)
{
if(key==XE_KEY_ANY)
{
for(int _i=1;_i<256;_i++)
if(XE_IO::Use().KeyReleased[_i])
return(true);
return(false);
}
return(XE_IO::Use().KeyReleased[key]);
}

bool XE_IO::KeyboardSetReleased(int key,bool state)
{
return(XE_IO::Use().KeyReleased[key]=state);
}

bool XE_IO::KeyboardClearAfter(int key)
{
return(XE_IO::Use().KeyAfter[key]=true);
}

bool XE_IO::MouseGet(int button)
{
if(button==XE_MOUSE_ANY)
{
if(XE_MOUSE_LEFT)if(XE_IO::Use().MouseLb)return(true);
if(XE_MOUSE_RIGHT)if(XE_IO::Use().MouseRb)return(true);
if(XE_MOUSE_MIDDLE)if(XE_IO::Use().MouseMb)return(true);
if(XE_MOUSE_WHEELUP)if(XE_IO::Use().MouseWheelUp)return(true);
if(XE_MOUSE_WHEELDOWN)if(XE_IO::Use().MouseWheelDown)return(true);
return(false);
}
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLb);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRb);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMb);
case(XE_MOUSE_WHEELUP):
return(XE_IO::Use().MouseWheelUp);
case(XE_MOUSE_WHEELDOWN):
return(XE_IO::Use().MouseWheelDown);
}
return(false);
}

bool XE_IO::MouseSet(int button,bool state)
{
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLb=state);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRb=state);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMb=state);
case(XE_MOUSE_WHEELUP):
return(XE_IO::Use().MouseWheelUp=state);
case(XE_MOUSE_WHEELDOWN):
return(XE_IO::Use().MouseWheelDown=state);
}
return(false);
}

bool XE_IO::MouseGetPressed(int button)
{
if(button==XE_MOUSE_ANY)
{
if(XE_MOUSE_LEFT)if(XE_IO::Use().MouseLbPressed)return(true);
if(XE_MOUSE_RIGHT)if(XE_IO::Use().MouseRbPressed)return(true);
if(XE_MOUSE_MIDDLE)if(XE_IO::Use().MouseMbPressed)return(true);
return(false);
}
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLbPressed);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRbPressed);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMbPressed);
}
return(false);
}

bool XE_IO::MouseSetPressed(int button,bool state)
{
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLbPressed=state);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRbPressed=state);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMbPressed=state);
}
return(false);
}

bool XE_IO::MouseGetReleased(int button)
{
if(button==XE_MOUSE_ANY)
{
if(XE_MOUSE_LEFT)if(XE_IO::Use().MouseLbReleased)return(true);
if(XE_MOUSE_RIGHT)if(XE_IO::Use().MouseRbReleased)return(true);
if(XE_MOUSE_MIDDLE)if(XE_IO::Use().MouseMbReleased)return(true);
return(false);
}
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLbReleased);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRbReleased);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMbReleased);
}
return(false);
}

bool XE_IO::MouseSetReleased(int button,bool state)
{
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLbReleased=state);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRbReleased=state);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMbReleased=state);
}
return(false);
}

bool XE_IO::MouseClearAfter(int button)
{
switch(button)
{
case(XE_MOUSE_LEFT):
return(XE_IO::Use().MouseLbAfter=true);
case(XE_MOUSE_RIGHT):
return(XE_IO::Use().MouseRbAfter=true);
case(XE_MOUSE_MIDDLE):
return(XE_IO::Use().MouseMbAfter=true);
}
return(false);
}

bool XE_IO::Clear(bool allstates)
{
if(allstates)
{
for(int ___i=0;___i<256;___i++)
XE_IO::Use().Key[___i]=false;
XE_IO::Use().MouseLb=false;
XE_IO::Use().MouseMb=false;
XE_IO::Use().MouseRb=false;
}
for(int ___i=0;___i<256;___i++)
if(XE_IO::Use().KeyAfter[___i]==true)
{
XE_IO::Use().KeyAfter[___i]=false;
XE_IO::Use().Key[___i]=false;
}
ZeroMemory(XE_IO::Use().KeyPressed,sizeof(XE_IO::Use().KeyPressed));
ZeroMemory(XE_IO::Use().KeyReleased,sizeof(XE_IO::Use().KeyReleased));
if(XE_IO::Use().MouseLbAfter)XE_IO::Use().MouseLb=false;
if(XE_IO::Use().MouseMbAfter)XE_IO::Use().MouseMb=false;
if(XE_IO::Use().MouseRbAfter)XE_IO::Use().MouseRb=false;
XE_IO::Use().MouseLbPressed=false;
XE_IO::Use().MouseMbPressed=false;
XE_IO::Use().MouseRbPressed=false;
XE_IO::Use().MouseLbReleased=false;
XE_IO::Use().MouseMbReleased=false;
XE_IO::Use().MouseRbReleased=false;
XE_IO::Use().MouseWheelUp=false;
XE_IO::Use().MouseWheelDown=false;
return(true);
}

bool XE_IO::CharactersPop(char& character)
{
if(!XE_IO::Use().Characters.Size())return(false);
character=XE_IO::Use().Characters.LastPointer().iClone();
XE_IO::Use().Characters.ErasePointer(XE_IO::Use().Characters.LastPointer());
return(true);
}

bool XE_IO::CharactersPopString(XE_STRING& string,bool leave)
{
if(!XE_IO::Use().Characters.Size())return(false);
XE_ARRAY<char> temp(XE_IO::Use().Characters.Size()+1);
XE_FOREACH(char,XE_IO::Use().Characters,elm)
temp.Write(elm.iPointer(),1);
if(!leave)XE_IO::Use().Characters.Clear();
temp[temp.Size()-1]=0;
string<<temp.Get();
temp.Free();
return(true);
}

unsigned int XE_IO::CharactersCount()
{
return(XE_IO::Use().Characters.Size());
}

void XE_IO::CharactersClear()
{
XE_IO::Use().Characters.Clear();
}

/*--- XE_EVENTS ---*/
XE_EVENTS::XE_EVENTS()
{
ftlmin=0;
ftlmax=0;
firt=0;
canrender=false;
fiut=0;
canupdate=false;
FrameTimeLimit=0;
LowerCPUconsumption=false;
FrameIntervalRenderLimit=0;
FrameIntervalUpdateLimit=0;
FPS=0;
FPSRendered=0;
FPSUpdated=0;
DoIt=true;
Tray=NULL;
User=NULL;
CustomWindowProc=NULL;
AutoIOcleanup=true;
AutoCharsCleanup=true;
}

bool XE_EVENTS::Execute(void(*Progress)(HWND,void*),void* InOut)
{
bool turn=0;
XE_EVENTS::FrameTimeUpdate();
XE_EVENTS::Use().Time=XE_TIME::GetSecs();
XE_EVENTS::Use().FPSTime=0;
XE_EVENTS::Use().Frames=0;
XE_EVENTS::Use().FramesRendered=0;
XE_EVENTS::Use().FramesUpdated=0;
XE_EVENTS::Use().Msg.message=WM_NULL;
XE_EVENTS::Use().firt=0;
XE_EVENTS::Use().canrender=true;
XE_EVENTS::Use().fiut=0;
XE_EVENTS::Use().canupdate=true;
if(XE_EVENTS::Use().DoIt)
{
while(XE_EVENTS::Use().DoIt)
{
if(PeekMessage(&XE_EVENTS::Use().Msg,NULL,0,0,PM_REMOVE))
{
if(XE_EVENTS::Use().Msg.message==WM_QUIT)
XE_EVENTS::Use().DoIt=false;
else
{
TranslateMessage(&XE_EVENTS::Use().Msg);
DispatchMessage(&XE_EVENTS::Use().Msg);
}
}
else
{
XE_IO::MouseGetPos();
if(Progress!=NULL)Progress(XE_EVENTS::Use().Msg.hwnd,InOut);
if(XE_EVENTS::Use().AutoIOcleanup)
{
for(int ___i=0;___i<256;___i++)
if(XE_IO::Use().KeyAfter[___i]==true)
{
XE_IO::Use().KeyAfter[___i]=false;
XE_IO::Use().Key[___i]=false;
}
ZeroMemory(XE_IO::Use().KeyPressed,sizeof(XE_IO::Use().KeyPressed));
ZeroMemory(XE_IO::Use().KeyReleased,sizeof(XE_IO::Use().KeyReleased));
if(XE_IO::Use().MouseLbAfter)XE_IO::Use().MouseLb=false;
if(XE_IO::Use().MouseMbAfter)XE_IO::Use().MouseMb=false;
if(XE_IO::Use().MouseRbAfter)XE_IO::Use().MouseRb=false;
XE_IO::Use().MouseLbPressed=false;
XE_IO::Use().MouseMbPressed=false;
XE_IO::Use().MouseRbPressed=false;
XE_IO::Use().MouseLbReleased=false;
XE_IO::Use().MouseMbReleased=false;
XE_IO::Use().MouseRbReleased=false;
XE_IO::Use().MouseWheelUp=false;
XE_IO::Use().MouseWheelDown=false;
}
if(XE_EVENTS::Use().AutoCharsCleanup)XE_IO::Use().CharactersClear();
XE_EVENTS::Use().NewTime=XE_TIME::GetSecs();
turn=!turn;
if(!XE_EVENTS::Use().LowerCPUconsumption)
{
if(XE_EVENTS::Use().FrameTimeLimit>0)
while((XE_EVENTS::Use().NewTime-XE_EVENTS::Use().Time)*1000<((turn)?(XE_EVENTS::Use().ftlmin):(XE_EVENTS::Use().ftlmax)))
XE_EVENTS::Use().NewTime=XE_TIME::GetSecs();
}
else
{
if(XE_EVENTS::Use().FrameTimeLimit>0)
Sleep((int)max(1,XE_EVENTS::Use().FrameTimeLimit-(XE_EVENTS::Use().DeltaTime*1000.0f)));
}
XE_EVENTS::Use().DeltaTime=XE_EVENTS::Use().NewTime-XE_EVENTS::Use().Time;
XE_EVENTS::Use().Time=XE_EVENTS::Use().NewTime;
XE_EVENTS::Use().Frames++;
XE_EVENTS::Use().FPSTime+=XE_EVENTS::Use().DeltaTime;
XE_EVENTS::Use().firt+=XE_EVENTS::Use().DeltaTime;
XE_EVENTS::Use().canrender=false;
XE_EVENTS::Use().fiut+=XE_EVENTS::Use().DeltaTime;
XE_EVENTS::Use().canupdate=false;
if(XE_EVENTS::Use().FrameIntervalRenderLimit<=0||XE_EVENTS::Use().firt>=XE_EVENTS::Use().FrameIntervalRenderLimit)
{
XE_EVENTS::Use().canrender=true;
XE_EVENTS::Use().firt=fmod(XE_EVENTS::Use().firt,XE_EVENTS::Use().FrameIntervalRenderLimit);
XE_EVENTS::Use().FramesRendered++;
}
if(XE_EVENTS::Use().FrameIntervalUpdateLimit<=0||XE_EVENTS::Use().fiut>=XE_EVENTS::Use().FrameIntervalUpdateLimit)
{
XE_EVENTS::Use().canupdate=true;
XE_EVENTS::Use().fiut=fmod(XE_EVENTS::Use().fiut,XE_EVENTS::Use().FrameIntervalUpdateLimit);
XE_EVENTS::Use().FramesUpdated++;
}
if(XE_EVENTS::Use().FPSTime>=1.0f)
{
XE_EVENTS::Use().FPS=(float)XE_EVENTS::Use().Frames/XE_EVENTS::Use().FPSTime;
XE_EVENTS::Use().Frames=0;
XE_EVENTS::Use().FPSRendered=(float)XE_EVENTS::Use().FramesRendered/XE_EVENTS::Use().FPSTime;
XE_EVENTS::Use().FramesRendered=0;
XE_EVENTS::Use().FPSUpdated=(float)XE_EVENTS::Use().FramesUpdated/XE_EVENTS::Use().FPSTime;
XE_EVENTS::Use().FramesUpdated=0;
XE_EVENTS::Use().FPSTime=fmod(XE_EVENTS::Use().FPSTime,1.0f);
}
}
}
XE_EVENTS::Use().DoIt=true;
}
return(true);
}

void XE_EVENTS::FrameTimeUpdate()
{
XE_EVENTS::Use().ftlmin=0;
XE_EVENTS::Use().ftlmax=0;
float t1=XE_TIME::GetSecs();
float t2=t1;
float ftl=(float)XE_EVENTS::Use().FrameTimeLimit+1;
float factor=(ftl>14.0f)?(1.0f):(2.0f);
if(XE_EVENTS::Use().FrameTimeLimit>0)
while((t2-t1)*1000<ftl)
{
t2=XE_TIME::GetSecs();
if((t2-t1)*1000<ftl-factor)XE_EVENTS::Use().ftlmin=(t2-t1)*1000;
XE_EVENTS::Use().ftlmax=(XE_TIME::GetSecs()-t1)*1000;
}
}

bool XE_EVENTS::CanRender()
{
return(XE_EVENTS::Use().canrender);
}

bool XE_EVENTS::CanUpdate()
{
return(XE_EVENTS::Use().canupdate);
}

XE_EVENTS& XE_EVENTS::Use()
{
static XE_EVENTS Instance;
return(Instance);
}

#ifdef XE_COMPILE_PHOTON

/*--- XE_SPRITE ---*/
XE_SPRITE::XE_SPRITE()
{
prepared=false;
Rect[0].Coord=XE_HALFVECTOR(0,0);
Rect[1].Coord=XE_HALFVECTOR(1,0);
Rect[2].Coord=XE_HALFVECTOR(1,1);
Rect[3].Coord=XE_HALFVECTOR(0,1);
Rect[0].Color=XE_HALFVECTOR(1,1,1);
Rect[1].Color=XE_HALFVECTOR(1,1,1);
Rect[2].Color=XE_HALFVECTOR(1,1,1);
Rect[3].Color=XE_HALFVECTOR(1,1,1);
Rect[0].NormalX=0;
Rect[0].NormalY=0;
Rect[0].NormalZ=1;
Rect[1].NormalX=0;
Rect[1].NormalY=0;
Rect[1].NormalZ=1;
Rect[2].NormalX=0;
Rect[2].NormalY=0;
Rect[2].NormalZ=1;
Rect[3].NormalX=0;
Rect[3].NormalY=0;
Rect[3].NormalZ=1;
CurrentID=-1;
SubCols=1;
SubRows=1;
SubCurrentPhase=0;
Width=0;
Height=0;
Xoffset=0;
Yoffset=0;
BboxWidth=0;
BboxHeight=0;
BboxXoffset=0;
BboxYoffset=0;
}

bool XE_SPRITE::Prepare(char* filenames,bool transparent,XE_ESTATE minfilter,XE_ESTATE magfilter,int xoff,int yoff,int bw,int bh,int bxoff,int byoff)
{
if(!filenames)return(false);
XE_ELM_TEXTURE temp;
char* next;
char* fname=strtok_s(filenames,";",&next);
while(fname!=NULL)
{
Photon::XeTextureCreate(&temp);
if(!temp.IsEmpty())
if(Photon::XeTextureLoad(temp,fname,transparent))
{
Photon::XeTextureActivate(temp);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
Photon::XeTextureUnactivate();
AddTexture(temp);
Width=max(Width,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_WIDTH));
Height=max(Height,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_HEIGHT));
}
fname=strtok_s(NULL,";",&next);
}
SetCurrent(0);
Xoffset=xoff;
Yoffset=yoff;
BboxWidth=bw;
BboxHeight=bh;
BboxXoffset=bxoff;
BboxYoffset=byoff;
if(BboxWidth<0){BboxWidth=Width;BboxXoffset=Xoffset;}
if(BboxHeight<0){BboxHeight=Height;BboxYoffset=Yoffset;}
RectUpdate();
CoordsUpdate();
prepared=true;
return(true);
}

bool XE_SPRITE::PrepareFromMemory(void** texdatav,int count,bool transparent,XE_ESTATE minfilter,XE_ESTATE magfilter,int xoff,int yoff,int bw,int bh,int bxoff,int byoff)
{
if(!texdatav)return(false);
if(count<=0)return(false);
XE_ELM_TEXTURE temp;
for(int i=0;i<count;i++)
if(texdatav[i])
{
Photon::XeTextureCreate(&temp);
if(!temp.IsEmpty())
if(Photon::XeTextureLoadFromMemory(temp,texdatav[i],transparent))
{
Photon::XeTextureActivate(temp);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
Photon::XeTextureUnactivate();
AddTexture(temp);
Width=max(Width,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_WIDTH));
Height=max(Height,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_HEIGHT));
}
}
SetCurrent(0);
Xoffset=xoff;
Yoffset=yoff;
BboxWidth=bw;
BboxHeight=bh;
BboxXoffset=bxoff;
BboxYoffset=byoff;
if(BboxWidth<0){BboxWidth=Width;BboxXoffset=Xoffset;}
if(BboxHeight<0){BboxHeight=Height;BboxYoffset=Yoffset;}
RectUpdate();
CoordsUpdate();
prepared=true;
return(true);
}

bool XE_SPRITE::PrepareFromRender(int x,int y,int width,int height,XE_ESTATE minfilter,XE_ESTATE magfilter,int xoff,int yoff,int bw,int bh,int bxoff,int byoff)
{
XE_ELM_TEXTURE temp;
Photon::XeTextureCreate(&temp);
if(!temp.IsEmpty())
if(Photon::XeTextureFromRender(temp,x,y,width,height,true))
{
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
Photon::XeTextureUnactivate();
AddTexture(temp);
Width=max(Width,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_WIDTH));
Height=max(Height,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_HEIGHT));
}
SetCurrent(0);
Xoffset=xoff;
Yoffset=yoff;
BboxWidth=bw;
BboxHeight=bh;
BboxXoffset=bxoff;
BboxYoffset=byoff;
if(BboxWidth<0){BboxWidth=Width;BboxXoffset=Xoffset;}
if(BboxHeight<0){BboxHeight=Height;BboxYoffset=Yoffset;}
RectUpdate();
CoordsUpdate();
prepared=true;
return(true);
}

bool XE_SPRITE::PrepareEmpty(int width,int height,bool transparent,XE_ESTATE minfilter,XE_ESTATE magfilter,int xoff,int yoff,int bw,int bh,int bxoff,int byoff)
{
if(width<=0||height<=0)return(false);
XE_ELM_TEXTURE temp;
Photon::XeTextureCreate(&temp);
if(!temp.IsEmpty())
if(Photon::XeTextureLoadEmpty(temp,width,height,true))
{
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
Photon::XeTextureUnactivate();
AddTexture(temp);
Width=max(Width,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_WIDTH));
Height=max(Height,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_HEIGHT));
}
SetCurrent(0);
Xoffset=xoff;
Yoffset=yoff;
BboxWidth=bw;
BboxHeight=bh;
BboxXoffset=bxoff;
BboxYoffset=byoff;
if(BboxWidth<0){BboxWidth=Width;BboxXoffset=Xoffset;}
if(BboxHeight<0){BboxHeight=Height;BboxYoffset=Yoffset;}
RectUpdate();
CoordsUpdate();
prepared=true;
return(true);
}

bool XE_SPRITE::SaveCurrent(char* fname)
{
void* buff=Photon::XeTextureLock(Current.iClone(),true);
if(!buff)return(false);
unsigned int size=*(unsigned int*)Photon::XeTextureGet(Current.iClone(),XE_TEXTURE_PIXELS_SIZE);
XE_FILE file;
file.Write(buff,size);
bool status=file.Save(fname);
file.Free();
Photon::XeTextureUnlock(Current.iClone(),false);
return(status);
}

#ifdef XE_COMPILE_CORE_VIRTUAL_FILE

bool XE_SPRITE::SaveAnimation(char* fname)
{
XE_ARRAY<XE_ARCHIVE::VIRTUAL> virt(Textures.Size());
XE_ARRAY<XE_FILE> files(Textures.Size());
unsigned int i=0;
XE_FOREACH(XE_ELM_TEXTURE,Textures,elm)
{
void* buff=Photon::XeTextureLock(elm.iClone(),true);
if(!buff)continue;
unsigned int size=*(unsigned int*)Photon::XeTextureGet(elm.iClone(),XE_TEXTURE_PIXELS_SIZE);
files[i].Write(buff,size);
virt[i].File=&files[i];
virt[i].Name.Format("%u",i);
i++;
}
bool status=XE_ARCHIVE::SaveFiles(fname,virt.Get(),i);
XE_FOREACH(XE_ELM_TEXTURE,Textures,elm)
Photon::XeTextureUnlock(elm.iClone(),false);
virt.Free();
files.Free();
return(status);
}

#endif /* XE_COMPILE_CORE_VIRTUAL_FILE */

void XE_SPRITE::SetColor(XE_HALFVECTOR col)
{
Rect[0].Color=col;
Rect[1].Color=col;
Rect[2].Color=col;
Rect[3].Color=col;
}

XE_HALFVECTOR XE_SPRITE::GetColor()
{
return(Rect[0].Color);
}

void XE_SPRITE::Draw(XE_VECTOR position,XE_ANGLEVECTOR angle,XE_VECTOR scale)
{
if(!Current.IsEmpty())
{
Photon::XeMatrixPush();
Photon::XeMatrixIdentity();
Photon::XeMatrixTranslate(position.X,position.Y,position.Z);
Photon::XeMatrixRotate(angle.Gamma,1,0,0);
Photon::XeMatrixRotate(angle.Beta,0,1,0);
Photon::XeMatrixRotate(angle.Alpha,0,0,1);
Photon::XeMatrixScale(scale.X,scale.Y,scale.Z);
Photon::XeTextureActivate(*Current.iPointer());
Photon::XeDrawDataStruct(XE_QUADS,0,4,Rect);
Photon::XeMatrixPop();
}
}

void XE_SPRITE::DrawStretched(XE_HALFVECTOR start,XE_HALFVECTOR end,float repeatx,float repeaty)
{
if(!Current.IsEmpty())
{
XE_PERVERTEX v[4];
memcpy_s(v,sizeof(XE_PERVERTEX)*4,Rect,sizeof(XE_PERVERTEX)*4);
v[0].Vertex=XE_HALFVECTOR(start.X,start.Y);
v[1].Vertex=XE_HALFVECTOR(end.X,start.Y);
v[2].Vertex=XE_HALFVECTOR(end.X,end.Y);
v[3].Vertex=XE_HALFVECTOR(start.X,end.Y);
v[0].Coord=XE_HALFVECTOR(0,0);
v[1].Coord=XE_HALFVECTOR(repeatx,0);
v[2].Coord=XE_HALFVECTOR(repeatx,repeaty);
v[3].Coord=XE_HALFVECTOR(0,repeaty);
Photon::XeTextureActivate(*Current.iPointer());
Photon::XeDrawDataStruct(XE_QUADS,0,4,v);
}
}

void XE_SPRITE::DrawTiled(XE_HALFVECTOR start,XE_HALFVECTOR end,float scalex,float scaley)
{
if(!Current.IsEmpty())
{
XE_PERVERTEX v[4];
memcpy_s(v,sizeof(XE_PERVERTEX)*4,Rect,sizeof(XE_PERVERTEX)*4);
v[0].Vertex=XE_HALFVECTOR(start.X,start.Y);
v[1].Vertex=XE_HALFVECTOR(end.X,start.Y);
v[2].Vertex=XE_HALFVECTOR(end.X,end.Y);
v[3].Vertex=XE_HALFVECTOR(start.X,end.Y);
v[0].Coord=XE_HALFVECTOR(0,0);
v[1].Coord=XE_HALFVECTOR((end.X-start.X)/(float)Width*scalex,0);
v[2].Coord=XE_HALFVECTOR((end.X-start.X)/(float)Width*scalex,(end.Y-start.Y)/(float)Height*scaley);
v[3].Coord=XE_HALFVECTOR(0,(end.Y-start.Y)/(float)Height*scaley);
Photon::XeTextureActivate(*Current.iPointer());
Photon::XeDrawDataStruct(XE_QUADS,0,4,v);
}
}

void XE_SPRITE::DrawPart(XE_HALFVECTOR start,XE_HALFVECTOR end,XE_HALFVECTOR coordstart,XE_HALFVECTOR coordend)
{
if(!Current.IsEmpty())
{
XE_PERVERTEX v[4];
memcpy_s(v,sizeof(XE_PERVERTEX)*4,Rect,sizeof(XE_PERVERTEX)*4);
v[0].Vertex=XE_HALFVECTOR(start.X,start.Y);
v[1].Vertex=XE_HALFVECTOR(end.X,start.Y);
v[2].Vertex=XE_HALFVECTOR(end.X,end.Y);
v[3].Vertex=XE_HALFVECTOR(start.X,end.Y);
v[0].Coord=XE_HALFVECTOR(coordstart.X/(float)Width,coordstart.Y/(float)Height);
v[1].Coord=XE_HALFVECTOR(coordend.X/(float)Width,coordstart.Y/(float)Height);
v[2].Coord=XE_HALFVECTOR(coordend.X/(float)Width,coordend.Y/(float)Height);
v[3].Coord=XE_HALFVECTOR(coordstart.X/(float)Width,coordend.Y/(float)Height);
Photon::XeTextureActivate(*Current.iPointer());
Photon::XeDrawDataStruct(XE_QUADS,0,4,v);
}
}

void XE_SPRITE::RectUpdate()
{
if(SubCols<=1&&SubRows<=1)
{
Rect[0].Vertex=XE_HALFVECTOR(-(float)Xoffset,-(float)Yoffset);
Rect[1].Vertex=XE_HALFVECTOR((float)Width-(float)Xoffset,-(float)Yoffset);
Rect[2].Vertex=XE_HALFVECTOR((float)Width-(float)Xoffset,(float)Height-(float)Yoffset);
Rect[3].Vertex=XE_HALFVECTOR(-(float)Xoffset,(float)Height-(float)Yoffset);
}
else
{
float c=1.0f/(float)max(SubCols,1);
float r=1.0f/(float)max(SubRows,1);
Rect[0].Vertex=XE_HALFVECTOR(-(float)Xoffset,-(float)Yoffset);
Rect[1].Vertex=XE_HALFVECTOR((float)Width*c-(float)Xoffset,-(float)Yoffset);
Rect[2].Vertex=XE_HALFVECTOR((float)Width*c-(float)Xoffset,(float)Height*r-(float)Yoffset);
Rect[3].Vertex=XE_HALFVECTOR(-(float)Xoffset,(float)Height*r-(float)Yoffset);
}
}

void XE_SPRITE::CoordsUpdate()
{
if(SubCols<=1&&SubRows<=1)
{
Rect[0].Coord=XE_HALFVECTOR(0,0);
Rect[1].Coord=XE_HALFVECTOR(1,0);
Rect[2].Coord=XE_HALFVECTOR(1,1);
Rect[3].Coord=XE_HALFVECTOR(0,1);
}
else
{
float pc=SubCurrentPhase;
float pr=0;
while(pc>(float)SubCols)
{
pr++;
pc-=(float)SubCols;
}
float c=1.0f/(float)max(SubCols,1);
float r=1.0f/(float)max(SubRows,1);
float cb=floor(pc)*c;
float rb=floor(pr)*r;
float ce=floor(pc+1.0f)*c;
float re=floor(pr+1.0f)*r;
Rect[0].Coord=XE_HALFVECTOR(cb,rb);
Rect[1].Coord=XE_HALFVECTOR(ce,rb);
Rect[2].Coord=XE_HALFVECTOR(ce,re);
Rect[3].Coord=XE_HALFVECTOR(cb,re);
}
}

void XE_SPRITE::BboxUpdate()
{
BboxXoffset=(int)(-Rect[0].Vertex.X);
BboxYoffset=(int)(-Rect[0].Vertex.Y);
BboxWidth=(int)(Rect[2].Vertex.X-Rect[0].Vertex.X);
BboxHeight=(int)(Rect[2].Vertex.Y-Rect[0].Vertex.Y);
}

void XE_SPRITE::Update()
{
RectUpdate();
CoordsUpdate();
BboxUpdate();
}

bool XE_SPRITE::SetCurrent(float index)
{
if((int)index<0||(int)index>=(int)Textures.Size()||Textures.Size()==0)
{
Current.Unref();
CurrentID=-1;
return(false);
}
Current=Textures.FirstPointer();
CurrentID=index;
for(int i=0;i<(int)Textures.Size();i++)
{
if(i==(int)index)return(true);
Current.Next();
}
return(false);
}

XE_ELM_TEXTURE XE_SPRITE::GetCurrent()
{
return(Current.iClone());
}

XE_ELM_TEXTURE* XE_SPRITE::GetCurrentPointer()
{
return(Current.iPointer());
}

float XE_SPRITE::GetCurrentId()
{
return(CurrentID);
}

void XE_SPRITE::Animate(float relative)
{
if(Textures.Size()>0)
{
int i=(int)CurrentID;
int j=(int)(CurrentID+relative);
int r=j-i;
if(r>0)
for(int a=0;a<r;a++)
{
Current.Next();
if(Current.IsEmpty())Current=Textures.FirstPointer();
}
if(r<0)
for(int a=0;a>r;a--)
{
Current.Prev();
if(Current.IsEmpty())Current=Textures.LastPointer();
}
}
else
{
Current.Unref();
CurrentID=0;
}
CurrentID+=relative;
CurrentID=fmod(CurrentID,(float)Textures.Size());
}

void XE_SPRITE::SubAnimate(float relative)
{
SubCurrentPhase+=relative;
SubCurrentPhase=fmod(SubCurrentPhase,(float)SubCols*(float)SubRows);
CoordsUpdate();
}

bool XE_SPRITE::AddTexture(XE_ELM_TEXTURE tex)
{
if(tex.IsEmpty())return(false);
Textures.AddPointer(tex);
return(true);
}

bool XE_SPRITE::RemoveTexture(XE_ELM_TEXTURE tex)
{
if(tex.IsEmpty())return(false);
XE_FOREACH(XE_ELM_TEXTURE,Textures,elm)
if(elm.iClone()==tex)
{
Textures.ErasePointer(elm);
return(true);
}
return(false);
}

int XE_SPRITE::Count()
{
return(Textures.Size());
}

void* XE_SPRITE::StreamOpen(unsigned int* width,unsigned int* height)
{
void* buff=Photon::XeTextureLock(Current.iClone());
if(!buff)return(0);
if(width)*width=*(unsigned int*)Photon::XeTextureGet(Current.iClone(),XE_TEXTURE_WIDTH);
if(height)*height=*(unsigned int*)Photon::XeTextureGet(Current.iClone(),XE_TEXTURE_HEIGHT);
return(buff);
}

void XE_SPRITE::StreamClose(bool updatepixels)
{
Photon::XeTextureUnlock(Current.iClone(),updatepixels);
}

void XE_SPRITE::Cleanup(bool leavetex)
{
if(prepared)
{
prepared=false;
if(!leavetex)
{
XE_ELEMENT_POINTER<XE_ELM_TEXTURE> temp=Textures.FirstPointer();
while(!temp.IsEmpty())
{
Photon::XeTextureDestroy(temp.iClone());
Textures.ErasePointer(temp);
temp=Textures.FirstPointer();
}
}
}
Textures.Clear();
SetCurrent(-1);
}

void XE_SPRITE::Centralize()
{
if(SubCols<=1&&SubRows<=1)
{
Xoffset=Width/2;
Yoffset=Height/2;
RectUpdate();
}
else
{
Xoffset=(Width/2)/max(SubCols,1);
Yoffset=(Height/2)/max(SubRows,1);
RectUpdate();
}
}

void XE_SPRITE::ForcePrepared(bool mode)
{
prepared=mode;
}

#endif /* XE_COMPILE_PHOTON */

/*--- XE_SHAPE ---*/
XE_SHAPE::XE_SHAPE()
{
Vertices=NULL;
Count=0;
}

/*--- XE_ACTOR ---*/
XE_ACTOR::XE_ACTOR()
{
memset(&Desc,0,sizeof(XE_S124I4));
Order=0;
Scale.Set(1,1,1,1);
}

unsigned int XE_ACTOR::ID()
{
return(Desc.index);
}

#ifdef XE_COMPILE_PHOTON

/*--- XE_ACTOR2D ---*/
XE_ACTOR2D::XE_ACTOR2D()
{
}

void XE_ACTOR2D::DrawSprite()
{
Sprite.Draw(Position,Direction,Scale);
}

void XE_ACTOR2D::DrawSpriteOpti(float x,float y,float w,float h)
{
float _r=0;
int _s=0;
if(Sprite.Xoffset<Sprite.Width/2&&Sprite.Yoffset<Sprite.Height/2)_s=1;
if(Sprite.Xoffset>Sprite.Width/2&&Sprite.Yoffset<Sprite.Height/2)_s=2;
if(Sprite.Xoffset>Sprite.Width/2&&Sprite.Yoffset>Sprite.Height/2)_s=3;
if(Sprite.Xoffset<Sprite.Width/2&&Sprite.Yoffset>Sprite.Height/2)_s=4;
if(_s==0)_r=sqrt((float)(Sprite.Xoffset^2)+(float)(Sprite.Yoffset^2));
if(_s==3)_r=sqrt((float)(Sprite.Xoffset^2)+(float)(Sprite.Yoffset^2));
if(_s==4)_r=sqrt((float)((Sprite.Width-Sprite.Xoffset)^2)+(float)(Sprite.Yoffset^2));
if(_s==1)_r=sqrt((float)((Sprite.Width-Sprite.Xoffset)^2)+(float)((Sprite.Height-Sprite.Yoffset)^2));
if(_s==2)_r=sqrt((float)(Sprite.Xoffset^2)+(float)((Sprite.Height-Sprite.Yoffset)^2));
if(Position.X+_r>x)
if(Position.Y+_r>y)
if(Position.X-_r<x+w)
if(Position.Y-_r<y+h)
DrawSprite();
}

void XE_ACTOR2D::UpdateShape()
{
Shape[0]=XE_VECTOR(-Sprite.BboxXoffset,-Sprite.BboxYoffset);
Shape[1]=XE_VECTOR(-Sprite.BboxXoffset+Sprite.BboxWidth,-Sprite.BboxYoffset);
Shape[2]=XE_VECTOR(-Sprite.BboxXoffset+Sprite.BboxWidth,-Sprite.BboxYoffset+Sprite.BboxHeight);
Shape[3]=XE_VECTOR(-Sprite.BboxXoffset,-Sprite.BboxYoffset+Sprite.BboxHeight);
XE_MATRIX m;
m=m.Translate(Position.X,Position.Y,Position.Z);
m=m.RotateX(Direction.Gamma);
m=m.RotateY(Direction.Beta);
m=m.RotateZ(Direction.Alpha);
m=m.Scale(Scale.X,Scale.Y,Scale.Z);
Shape[0]=m*Shape[0];
Shape[1]=m*Shape[1];
Shape[2]=m*Shape[2];
Shape[3]=m*Shape[3];
}

bool XE_ACTOR2D::CheckCollisionBox(XE_ACTOR2D* act,XE_VECTOR relative)
{
XE_VECTOR b1,e1,b2,e2;
b1.X=relative.X+Position.X+Sprite.BboxWidth*Scale.X-Sprite.BboxXoffset*Scale.X;
b1.Y=relative.Y+Position.Y+Sprite.BboxHeight*Scale.Y-Sprite.BboxYoffset*Scale.Y;
e1.X=relative.X+Position.X-Sprite.BboxXoffset*Scale.X;
e1.Y=relative.Y+Position.Y-Sprite.BboxYoffset*Scale.Y;
b2.X=act->Position.X+act->Sprite.BboxWidth*act->Scale.X-act->Sprite.BboxXoffset*act->Scale.X;
b2.Y=act->Position.Y+act->Sprite.BboxHeight*act->Scale.Y-act->Sprite.BboxYoffset*act->Scale.Y;
e2.X=act->Position.X-act->Sprite.BboxXoffset*act->Scale.X;
e2.Y=act->Position.Y-act->Sprite.BboxYoffset*act->Scale.Y;
return(BoxCollision(b1,e1,b2,e2));
}

bool XE_ACTOR2D::CheckCollisionCircle(XE_ACTOR2D* act)
{
if((Position-act->Position).Length()<Direction.Length+act->Direction.Length)
return(true);
return(false);
}

#ifdef XE_COMPILE_CHAOS

bool XE_ACTOR2D::CheckCollisionShape(XE_ACTOR2D* act)
{
return(Chaos::XePolygonsCollision2D(Shape,4,act->Shape,4));
}

#endif /* XE_COMPILE_CHAOS */

#endif /* XE_COMPILE_PHOTON */

/*--- XE_VOIDPROC ---*/
XE_VOIDPROC::XE_VOIDPROC()
{
Proc=NULL;
}

XE_VOIDPROC::XE_VOIDPROC(void (*proc)())
{
Proc=proc;
}

/*--- XE_SCENES ---*/
XE_SCENES::XE_SCENES()
{
Active.Unref();
Autonext=true;
Autoactivate=false;
}

XE_SCENES::~XE_SCENES()
{
Scenes.Clear();
}

void XE_SCENES::Clear()
{
Scenes.Clear();
}

void XE_SCENES::Play()
{
if(Scenes.Count())
{
while(!Active.IsEmpty())
{
if(Active.iPointer()->Proc!=NULL)Active.iPointer()->Proc();
if(Autonext)Active.Next();
if(Autoactivate)
{
Autoactivate=false;
Autonext=true;
}
}
}
}

/*--- XE_RESOURCE ---*/
XE_RESOURCE::XE_RESOURCE()
{
Res=0;
Buffer=0;
Size=0;
}

bool XE_RESOURCE::Load(HMODULE module,LPCTSTR name,LPCTSTR type)
{
Res=LoadResource(module,FindResource(module,name,type));
if(!Res)return(false);
Buffer=LockResource(Res);
Size=SizeofResource(module,FindResource(module,name,type));
if(Buffer&&Size)
return(true);
Free();
return(false);
}

void XE_RESOURCE::Free()
{
if(Res)
{
UnlockResource(Res);
FreeResource(Res);
}
Buffer=0;
Size=0;
}

void* XE_RESOURCE::GetData()
{
return(Buffer);
}

unsigned int XE_RESOURCE::GetSize()
{
return(Size);
}

bool XE_RESOURCE::IsEmpty()
{
if(!Buffer||!Size)return(true);
return(false);
}

#ifdef XE_COMPILE_PHOTON

/*--- XE_FONT ---*/
XE_FONT::XE_FONT()
{
prepared=false;
Map=0;
Valign=TOP;
Halign=LEFT;
}

bool XE_FONT::Setup(double width,double height,double sepx,double sepy)
{
return(XeSetState(XE_RENDER_TEXT_SETTINGS,width,height,sepx,sepy));
}

bool XE_FONT::Prepare(char* texfname,char* mapfname,int newline,XE_ESTATE minfilter,XE_ESTATE magfilter)
{
if(!texfname)return(false);
XeSetState(XE_RENDER_TEXT_NEWLINE,newline);
Photon::XeTextureCreate(&Texture);
if(Texture.IsEmpty())return(false);
if(Photon::XeTextureLoad(Texture,texfname,true))
{
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
Photon::XeTextureUnactivate();
if(mapfname)
{
Map=new XE_FONTMAP;
if(!Map)
{
Photon::XeTextureDestroy(Texture);
return(false);
}
if(!Map->Compile(mapfname))
{
delete Map;
Map=0;
Photon::XeTextureDestroy(Texture);
return(false);
}
}
if(Photon::XeGenerateFont(&Dlist,Map))
{
prepared=true;
return(true);
}
return(false);
}
return(false);
}

bool XE_FONT::PrepareFromMemory(void* texdata,void* mapdata,unsigned int mapsize,int newline,XE_ESTATE minfilter,XE_ESTATE magfilter)
{
if(!texdata)return(false);
XeSetState(XE_RENDER_TEXT_NEWLINE,newline);
Photon::XeTextureCreate(&Texture);
if(Texture.IsEmpty())return(false);
if(Photon::XeTextureLoadFromMemory(Texture,texdata,true))
{
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
Photon::XeTextureUnactivate();
if(mapdata&&mapsize)
{
Map=new XE_FONTMAP;
if(!Map)
{
Photon::XeTextureDestroy(Texture);
return(false);
}
if(!Map->CompileFromMemory(mapdata,mapsize))
{
delete Map;
Map=0;
Photon::XeTextureDestroy(Texture);
return(false);
}
}
if(Photon::XeGenerateFont(&Dlist,Map))
{
prepared=true;
return(true);
}
return(false);
}
return(false);
}

void XE_FONT::Draw(char* text,XE_VECTOR pos,XE_VECTOR scale,XE_ANGLEVECTOR rot)
{
if(text!=NULL)
if(!Texture.IsEmpty())
if(!Dlist.IsEmpty())
{
if(Valign==TOP&&Halign==LEFT)
{
Photon::XeMatrixPush();
Photon::XeMatrixTranslate(pos.X,pos.Y,pos.Z);
Photon::XeMatrixRotate(rot.Gamma,1,0,0);
Photon::XeMatrixRotate(rot.Beta,0,1,0);
Photon::XeMatrixRotate(rot.Alpha,0,0,1);
Photon::XeMatrixScale(scale.X,scale.Y,scale.Z);
Photon::XeTextureActivate(Texture);
Photon::XeDrawFont(Dlist,text);
Photon::XeMatrixPop();
}
else
{
char newline[2]={0};
if(Map)
newline[0]=Map->NewLine;
else
newline[0]=*(char*)XeGetState(XE_RENDER_TEXT_NEWLINE);
unsigned int linesc=0;
XE_STRING temp=text;
XE_STRING line;
unsigned int p=temp.Search(line,newline);
linesc++;
while(p)
{
p=temp.Search(line,newline,p);
linesc++;
}
unsigned int i=0;
p=temp.Search(line,newline);
bool more=true;
while(more)
{
more=false;
XE_VECTOR size=TextSize(line);
XE_VECTOR offset;
if(Valign==TOP)offset.Y=(float)i*size.Y;
if(Valign==MIDDLE)offset.Y=(float)i*size.Y-((float)linesc*size.Y/2);
if(Valign==BOTTOM)offset.Y=(float)i*size.Y-((float)linesc*size.Y);
if(Halign==LEFT)offset.X=0;
if(Halign==CENTER)offset.X=-size.X/2;
if(Halign==RIGHT)offset.X=-size.X;
Photon::XeMatrixPush();
Photon::XeMatrixTranslate(pos.X,pos.Y,pos.Z);
Photon::XeMatrixRotate(rot.Gamma,1,0,0);
Photon::XeMatrixRotate(rot.Beta,0,1,0);
Photon::XeMatrixRotate(rot.Alpha,0,0,1);
Photon::XeMatrixScale(scale.X,scale.Y,scale.Z);
Photon::XeMatrixTranslate(offset.X,offset.Y,0);
Photon::XeTextureActivate(Texture);
Photon::XeDrawFont(Dlist,line);
Photon::XeMatrixPop();
if(p)
{
more=true;
p=temp.Search(line,newline,p);
i++;
}
}
}
}
}

XE_VECTOR XE_FONT::TextSize(char* text)
{
if(!text)return(XE_VECTOR());
if(Map)
{
char* pos=text;
XE_VECTOR line;
XE_VECTOR size;
while(*pos!=0)
{
if(*pos!=Map->NewLine)
{
line.X+=Map->Desc[*pos].Advance+Map->Xsep;
line.Y=Map->Size+Map->Ysep;
}
else
{
size.X=max(size.X,line.X);
size.Y+=line.Y;
line=XE_VECTOR();
}
pos++;
}
size.X=max(size.X,line.X);
size.Y+=line.Y;
return(size);
}
else
{
double sizex=*(double*)XeGetState(XE_RENDER_TEXT_SIZE_X);
double sizey=*(double*)XeGetState(XE_RENDER_TEXT_SIZE_Y);
char newline=*(char*)XeGetState(XE_RENDER_TEXT_NEWLINE);
double sepx=*(double*)XeGetState(XE_RENDER_TEXT_SEP_X);
double sepy=*(double*)XeGetState(XE_RENDER_TEXT_SEP_Y);
char* pos=text;
XE_VECTOR line;
XE_VECTOR size;
while(*pos!=0)
{
if(*pos!=newline)
{
line.X+=sizex+sepx;
line.Y=max(line.Y,sizey+sepy);
}
else
{
size.X=max(size.X,line.X);
size.Y+=line.Y;
line=XE_VECTOR();
}
pos++;
}
size.X=max(size.X,line.X);
size.Y+=line.Y;
return(size);
}
}

void XE_FONT::Cleanup()
{
if(!prepared)return;
prepared=false;
Photon::XeTextureDestroy(Texture);
Texture.Unref();
Photon::XeDisplaylistDestroy(Dlist);
Dlist.Unref();
if(Map)delete Map;
Map=0;
}

void XE_FONT::ForcePrepared(bool mode)
{
prepared=mode;
}

/*--- XE_EFFECT ---*/
XE_EFFECT::XE_EFFECT()
{
}

bool XE_EFFECT::Init()
{
return(Photon::XeShaderInit());
}

int XE_EFFECT::Model()
{
return(Photon::XeShaderModel());
}

unsigned int XE_EFFECT::Count()
{
return(Passes.Size());
}

bool XE_EFFECT::Load(int pass,XEF_ESTATE type,char* vertname,char* fragname,char* vertprepend,char* fragprepend)
{
if(pass<0)return(false);
if(pass>=(int)Passes.Size())
{
Passes.Resize(pass+1);
Logs.Resize(pass+1);
Logs[pass].Clear();
}
if(type==XEF_ASM)
{
Passes[pass].Type=XEF_ASM;
Photon::XeShaderCreate(&Passes[pass].Vert);
Photon::XeShaderCreate(&Passes[pass].Frag);
Photon::XeShaderLoad(Passes[pass].Vert,XE_SHADER_VP_ARB,vertname,0);
Photon::XeShaderLoad(Passes[pass].Frag,XE_SHADER_FP_ARB,fragname,0);
return(true);
}
else
if(type==XEF_SL)
{
Passes[pass].Type=XEF_SL;
char* str=0;
Photon::XeShaderCreate(&Passes[pass].Prog);
Photon::XeShaderCreate(&Passes[pass].Vert);
Photon::XeShaderCreate(&Passes[pass].Frag);
Photon::XeShaderLoad(Passes[pass].Vert,XE_SHADER_VP_SL,vertname,vertprepend);
str=Photon::XeShaderLastLog();
if(str[0])
Logs[pass]<<"Load Vertex Shader: Failed! "<<str<<"\r\n";
else
Logs[pass]<<"Load Vertex Shader: Successful!\r\n";
Photon::XeShaderLoad(Passes[pass].Frag,XE_SHADER_FP_SL,fragname,fragprepend);
str=Photon::XeShaderLastLog();
if(str[0])
Logs[pass]<<"Load Fragment Shader: Failed! "<<str<<"\r\n";
else
Logs[pass]<<"Load Fragment Shader: Successful!\r\n";
Photon::XeShaderMakeProgram(Passes[pass].Prog,&Passes[pass].Vert,2);
str=Photon::XeShaderLastLog();
if(str[0])
Logs[pass]<<"Make Shader Program: Failed! "<<str<<"\r\n";
else
Logs[pass]<<"Make Shader Program: Successful!\r\n";
Photon::XeShaderDestroy(Passes[pass].Vert);
Photon::XeShaderDestroy(Passes[pass].Frag);
return(true);
}
return(false);
}

bool XE_EFFECT::LoadFromMemory(int pass,XEF_ESTATE type,char* vertdata,char* fragdata,char* vertprepend,char* fragprepend)
{
if(pass<0)return(false);
if(pass>=(int)Passes.Size())
{
Passes.Resize(pass+1);
Logs.Resize(pass+1);
Logs[pass].Clear();
}
if(type==XEF_ASM)
{
Passes[pass].Type=XEF_ASM;
Photon::XeShaderCreate(&Passes[pass].Vert);
Photon::XeShaderCreate(&Passes[pass].Frag);
Photon::XeShaderLoadFromMemory(Passes[pass].Vert,XE_SHADER_VP_ARB,vertdata,0);
Photon::XeShaderLoadFromMemory(Passes[pass].Frag,XE_SHADER_FP_ARB,fragdata,0);
return(true);
}
else
if(type==XEF_SL)
{
Passes[pass].Type=XEF_SL;
char* str=0;
Photon::XeShaderCreate(&Passes[pass].Prog);
Photon::XeShaderCreate(&Passes[pass].Vert);
Photon::XeShaderCreate(&Passes[pass].Frag);
Photon::XeShaderLoadFromMemory(Passes[pass].Vert,XE_SHADER_VP_SL,vertdata,vertprepend);
str=Photon::XeShaderLastLog();
if(str[0])
Logs[pass]<<"Load Vertex Shader: Failed! "<<str<<"\r\n";
else
Logs[pass]<<"Load Vertex Shader: Successful!\r\n";
Photon::XeShaderLoadFromMemory(Passes[pass].Frag,XE_SHADER_FP_SL,fragdata,fragprepend);
str=Photon::XeShaderLastLog();
if(str[0])
Logs[pass]<<"Load Fragment Shader: Failed! "<<str<<"\r\n";
else
Logs[pass]<<"Load Fragment Shader: Successful!\r\n";
Photon::XeShaderMakeProgram(Passes[pass].Prog,&Passes[pass].Vert,2);
str=Photon::XeShaderLastLog();
if(str[0])
Logs[pass]<<"Make Shader Program: Failed! "<<str<<"\r\n";
else
Logs[pass]<<"Make Shader Program: Successful!\r\n";
Photon::XeShaderDestroy(Passes[pass].Vert);
Photon::XeShaderDestroy(Passes[pass].Prog);
return(true);
}
return(false);
}

void XE_EFFECT::Cleanup()
{
for(unsigned int i=0;i<Passes.Size();i++)
{
if(Passes[i].Type==XEF_ASM)
{
Photon::XeShaderDestroy(Passes[i].Vert);
Photon::XeShaderDestroy(Passes[i].Frag);
}
else
if(Passes[i].Type==XEF_SL)
{
Photon::XeShaderDestroy(Passes[i].Prog);
}
}
Passes.Free();
for(unsigned int i=0;i<Logs.Size();i++)
Logs[i].Clear();
Logs.Free();
}

void XE_EFFECT::GetLog(int pass,XE_STRING& log)
{
log.Set(Logs[pass].Get());
}

bool XE_EFFECT::Activate(int pass)
{
if(pass<0)return(false);
if(pass>=(int)Passes.Size())return(false);
if(Passes[pass].Type==XEF_ASM)
{
Photon::XeShaderActivate(Passes[pass].Vert);
Photon::XeShaderActivate(Passes[pass].Frag);
return(true);
}
else
if(Passes[pass].Type==XEF_SL)
{
Photon::XeShaderActivate(Passes[pass].Prog);
return(true);
}
return(false);
}

void XE_EFFECT::Unactivate()
{
Photon::XeShaderUnactivate(XE_SHADER_VP_ARB);
Photon::XeShaderUnactivate(XE_SHADER_FP_ARB);
Photon::XeShaderUnactivate(XE_SHADER_PROGRAM_SL);
}

bool XE_EFFECT::SetVariable(XEF_ESTATE type,int id,XE_HALFVECTOR val,int subs)
{
if(type==XEF_ASM)
{
if(!(subs&0x1))Photon::XeShaderLocalParam(XE_SHADER_VP_ARB,id,val);
if(!(subs&0x2))Photon::XeShaderLocalParam(XE_SHADER_FP_ARB,id,val);
return(true);
}
else
if(type==XEF_SL)
{
Photon::XeShaderUniform(id,val,subs);
return(true);
}
else
return(false);
}

bool XE_EFFECT::SetVariable(XEF_ESTATE type,int id,int val[4],int subs)
{
if(type==XEF_ASM)
{
if(!(subs&0x1))Photon::XeShaderLocalParam(XE_SHADER_VP_ARB,id,XE_HALFVECTOR((float)val[0],(float)val[1],(float)val[2],(float)val[3]));
if(!(subs&0x2))Photon::XeShaderLocalParam(XE_SHADER_FP_ARB,id,XE_HALFVECTOR((float)val[0],(float)val[1],(float)val[2],(float)val[3]));
return(true);
}
else
if(type==XEF_SL)
{
Photon::XeShaderUniformInteger(id,val,subs);
return(true);
}
else
return(false);
}

bool XE_EFFECT::SetVariable(int id,XE_HALFVECTOR val[4],bool trans)
{
Photon::XeShaderUniformMatrix(id,val,trans);
return(true);
}

bool XE_EFFECT::SetTexture(int id,int unit)
{
int val[1]={unit};
Photon::XeShaderUniformInteger(id,val,1);
return(true);
}

int XE_EFFECT::FindVariable(int pass,char* name)
{
if(pass<0)return(-1);
if(pass>=(int)Passes.Size())return(-1);
if(Passes[pass].Type!=XEF_SL)return(-1);
return(Photon::XeShaderUniformLocation(Passes[pass].Prog,name));
}

bool XE_EFFECT::SetAttribute(int id,XE_HALFVECTOR val,int subs)
{
Photon::XeShaderAttribute(id,val,subs);
return(true);
}

int XE_EFFECT::FindAttribute(int pass,char* name)
{
if(pass<0)return(-1);
if(pass>=(int)Passes.Size())return(-1);
if(Passes[pass].Type!=XEF_SL)return(-1);
return(Photon::XeShaderAttributeLocation(Passes[pass].Prog,name));
}

#ifdef XE_COMPILE_CORE_INTUICIO
#ifdef XE_COMPILE_CORE_MATH

/*--- XE_TECHNIQUE ---*/
XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_EXECUTE)
{
XE_INTUICIO_POINTER(void*,proc);
if(proc&&*proc)
{
void(*func)(void)=(void(*)(void))(*proc);
if(func)func();
}
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_CLEAR)
{
XE_INTUICIO_KEYWORD(key);
if(key==COLOR)Photon::XeRenderScene(XE_FLAG_COLORBUFF);
if(key==DEPTH)Photon::XeRenderScene(XE_FLAG_DEPTHBUFF);
if(key==STENCIL)Photon::XeRenderScene(XE_FLAG_STENCILBUFF);
if(key==ACCUM)Photon::XeRenderScene(XE_FLAG_ACCUMBUFF);
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_PASS)
{
XE_INTUICIO_KEYWORD(key);
XE_INTUICIO_POINTER(XE_EFFECT*,eff);
XE_INTUICIO_POINTER(XE_INTEGER,id);
if(key==ENABLE)(*eff)->Activate(*id);
if(key==DISABLE)XE_EFFECT::Unactivate();
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_CANVAS)
{
XE_INTUICIO_KEYWORD(key);
XE_INTUICIO_POINTER(XE_CANVAS*,canv);
XE_INTUICIO_KEYWORD(opt);
if(key==ENABLE)(*canv)->Activate((opt==TRUE)?true:false);
if(key==DISABLE)(*canv)->Unactivate((opt==TRUE)?true:false);
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_RECT)
{
XE_INTUICIO_KEYWORD(key);
XE_INTUICIO_POINTER(void*,source);
XE_INTUICIO_POINTER(XE_RECT*,vert);
XE_INTUICIO_POINTER(XE_RECT*,coord);
XE_INTUICIO_KEYWORD(mode);
if(key==TEXTURE)
{
XE_ELM_TEXTURE* tex=*(XE_ELM_TEXTURE**)source;
XE_RECT temp;
if(mode==TRUE)
{
temp=**coord;
(*coord)->Vertices[0]=temp.Vertices[3];
(*coord)->Vertices[1]=temp.Vertices[2];
(*coord)->Vertices[2]=temp.Vertices[1];
(*coord)->Vertices[3]=temp.Vertices[0];
}
Photon::XeTextureActivate(*tex);
Photon::XeDrawData(XE_QUADS,0,4,(*vert)->Vertices,0,(*coord)->Vertices,0,0,0,XE_DOUBLE);
Photon::XeTextureUnactivate();
if(mode==TRUE)
**coord=temp;
}
else
if(key==CANVAS)
{
XE_CANVAS* canv=*(XE_CANVAS**)source;
XE_RECT temp;
if(mode==TRUE)
{
temp=**coord;
(*coord)->Vertices[0]=temp.Vertices[3];
(*coord)->Vertices[1]=temp.Vertices[2];
(*coord)->Vertices[2]=temp.Vertices[1];
(*coord)->Vertices[3]=temp.Vertices[0];
}
canv->ActivateTexture();
Photon::XeDrawData(XE_QUADS,0,4,(*vert)->Vertices,0,(*coord)->Vertices,0,0,0,XE_DOUBLE);
Photon::XeTextureUnactivate();
if(mode==TRUE)
**coord=temp;
}
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_IMAGE)
{
XE_INTUICIO_POINTER(XE_ELM_TEXTURE*,tex);
XE_INTUICIO_POINTER(XE_RECT*,rect);
XE_INTUICIO_KEYWORD(asnew);
Photon::XeTextureFromRender(**tex,(int)(*rect)->Vertices[0].X,(int)(*rect)->Vertices[0].Y,(int)(*rect)->Vertices[2].X,(int)(*rect)->Vertices[2].Y,(asnew==TRUE)?true:false);
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_COLOR)
{
XE_INTUICIO_KEYWORD(mode);
XE_INTUICIO_POINTER(XE_VECTOR*,color);
if(mode==SCENE)XeSetState(XE_SCENE_COLOR,**color);
if(mode==MODEL)XeSetState(XE_COLOR,**color);
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_BLEND)
{
XE_INTUICIO_KEYWORD(keysrc);
XE_INTUICIO_KEYWORD(keydest);
XE_ESTATE src=XE_NULL;
if(keysrc==ZERO)src=XE_RENDER_BLEND_ZERO;
if(keysrc==ONE)src=XE_RENDER_BLEND_ONE;
if(keysrc==SRC_COLOR)src=XE_RENDER_BLEND_SRC_COLOR;
if(keysrc==ONE_MINUS_SRC_COLOR)src=XE_RENDER_BLEND_ONE_MINUS_SRC_COLOR;
if(keysrc==DST_COLOR)src=XE_RENDER_BLEND_DST_COLOR;
if(keysrc==ONE_MINUS_DST_COLOR)src=XE_RENDER_BLEND_ONE_MINUS_DST_COLOR;
if(keysrc==SRC_ALPHA)src=XE_RENDER_BLEND_SRC_ALPHA;
if(keysrc==ONE_MINUS_SRC_ALPHA)src=XE_RENDER_BLEND_ONE_MINUS_SRC_ALPHA;
if(keysrc==DST_ALPHA)src=XE_RENDER_BLEND_DST_ALPHA;
if(keysrc==ONE_MINUS_DST_ALPHA)src=XE_RENDER_BLEND_ONE_MINUS_DST_ALPHA;
if(keysrc==SRC_ALPHA_SATURATE)src=XE_RENDER_BLEND_SRC_ALPHA_SATURATE;
if(keysrc==CONSTANT_COLOR)src=XE_RENDER_BLEND_CONSTANT_COLOR;
if(keysrc==ONE_MINUS_CONSTANT_COLOR)src=XE_RENDER_BLEND_ONE_MINUS_CONSTANT_COLOR;
if(keysrc==CONSTANT_ALPHA)src=XE_RENDER_BLEND_CONSTANT_ALPHA;
if(keysrc==ONE_MINUS_CONSTANT_ALPHA)src=XE_RENDER_BLEND_ONE_MINUS_CONSTANT_ALPHA;
XE_ESTATE dest=XE_NULL;
if(keydest==ZERO)dest=XE_RENDER_BLEND_ZERO;
if(keydest==ONE)dest=XE_RENDER_BLEND_ONE;
if(keydest==SRC_COLOR)dest=XE_RENDER_BLEND_SRC_COLOR;
if(keydest==ONE_MINUS_SRC_COLOR)dest=XE_RENDER_BLEND_ONE_MINUS_SRC_COLOR;
if(keydest==DST_COLOR)dest=XE_RENDER_BLEND_DST_COLOR;
if(keydest==ONE_MINUS_DST_COLOR)dest=XE_RENDER_BLEND_ONE_MINUS_DST_COLOR;
if(keydest==SRC_ALPHA)dest=XE_RENDER_BLEND_SRC_ALPHA;
if(keydest==ONE_MINUS_SRC_ALPHA)dest=XE_RENDER_BLEND_ONE_MINUS_SRC_ALPHA;
if(keydest==DST_ALPHA)dest=XE_RENDER_BLEND_DST_ALPHA;
if(keydest==ONE_MINUS_DST_ALPHA)dest=XE_RENDER_BLEND_ONE_MINUS_DST_ALPHA;
if(keydest==SRC_ALPHA_SATURATE)dest=XE_RENDER_BLEND_SRC_ALPHA_SATURATE;
if(keydest==CONSTANT_COLOR)dest=XE_RENDER_BLEND_CONSTANT_COLOR;
if(keydest==ONE_MINUS_CONSTANT_COLOR)dest=XE_RENDER_BLEND_ONE_MINUS_CONSTANT_COLOR;
if(keydest==CONSTANT_ALPHA)dest=XE_RENDER_BLEND_CONSTANT_ALPHA;
if(keydest==ONE_MINUS_CONSTANT_ALPHA)dest=XE_RENDER_BLEND_ONE_MINUS_CONSTANT_ALPHA;
XeSetState(XE_RENDER_BLEND_TYPE,src,dest);
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_PARAM)
{
XE_INTUICIO_KEYWORD(type);
XE_INTUICIO_POINTER(XE_EFFECT*,eff);
XE_INTUICIO_POINTER(XE_INTEGER*,id);
XE_INTUICIO_POINTER(void*,val);
if(type==FLOAT)
(*eff)->SetVariable(XEF_SL,**id,**(XE_HALFVECTOR**)val,1);
else
if(type==VEC2)
(*eff)->SetVariable(XEF_SL,**id,**(XE_HALFVECTOR**)val,2);
else
if(type==VEC3)
(*eff)->SetVariable(XEF_SL,**id,**(XE_HALFVECTOR**)val,3);
else
if(type==VEC4)
(*eff)->SetVariable(XEF_SL,**id,**(XE_HALFVECTOR**)val,4);
else
if(type==INT)
(*eff)->SetVariable(XEF_SL,**id,*(int**)val,1);
else
if(type==IVEC2)
(*eff)->SetVariable(XEF_SL,**id,*(int**)val,2);
else
if(type==IVEC3)
(*eff)->SetVariable(XEF_SL,**id,*(int**)val,3);
else
if(type==IVEC4)
(*eff)->SetVariable(XEF_SL,**id,*(int**)val,4);
}

XE_INTUICIO_EXTERNAL(XE_TECHNIQUE::Itc_ATTRIB)
{
XE_INTUICIO_KEYWORD(type);
XE_INTUICIO_POINTER(XE_EFFECT*,eff);
XE_INTUICIO_POINTER(XE_INTEGER*,id);
XE_INTUICIO_POINTER(void*,val);
if(type==FLOAT)
(*eff)->SetAttribute(**id,**(XE_HALFVECTOR**)val,1);
else
if(type==VEC2)
(*eff)->SetAttribute(**id,**(XE_HALFVECTOR**)val,2);
else
if(type==VEC3)
(*eff)->SetAttribute(**id,**(XE_HALFVECTOR**)val,3);
else
if(type==VEC4)
(*eff)->SetAttribute(**id,**(XE_HALFVECTOR**)val,4);
}

XE_TECHNIQUE::XE_TECHNIQUE()
{
Compiled=false;
}

void XE_TECHNIQUE::Init()
{
XeIntuicioUnlinkDefinitions();
XeIntuicioFreeDefinitionList(XE_TECHNIQUE_Itc_DefList);
if(XeIntuicioLinkDefinition("TechniqueShader",(void*)XE_TECHNIQUE_Itc_TechniqueShaderDef,strlen(XE_TECHNIQUE_Itc_TechniqueShaderDef)))
XE_TECHNIQUE_Itc_DefList=XeIntuicioBuildDefinitionList();
XeIntuicioUnlinkDefinitions();
XeIntuicioClearDefinitionsProc();
XeIntuicioAddDefinitionProc("TechniqueShader","EXECUTE",Itc_EXECUTE);
XeIntuicioAddDefinitionProc("TechniqueShader","CLEAR",Itc_CLEAR);
XeIntuicioAddDefinitionProc("TechniqueShader","PASS",Itc_PASS);
XeIntuicioAddDefinitionProc("TechniqueShader","CANVAS",Itc_CANVAS);
XeIntuicioAddDefinitionProc("TechniqueShader","RECT",Itc_RECT);
XeIntuicioAddDefinitionProc("TechniqueShader","IMAGE",Itc_IMAGE);
XeIntuicioAddDefinitionProc("TechniqueShader","COLOR",Itc_COLOR);
XeIntuicioAddDefinitionProc("TechniqueShader","BLEND",Itc_BLEND);
XeIntuicioAddDefinitionProc("TechniqueShader","PARAM",Itc_PARAM);
XeIntuicioAddDefinitionProc("TechniqueShader","ATTRIB",Itc_ATTRIB);
}

bool XE_TECHNIQUE::CompileScript(char* fname)
{
FreeProgram();
if(XeIntuicioCompileFile(&Itc_Program,fname,XE_TECHNIQUE_Itc_DefList))
{
Compiled=true;
return(true);
}
return(false);
}

bool XE_TECHNIQUE::CompileScriptFromMemory(void* data,unsigned int size)
{
FreeProgram();
if(XeIntuicioCompile(&Itc_Program,(char*)data,size,XE_TECHNIQUE_Itc_DefList))
{
Compiled=true;
return(true);
}
return(false);
}

bool XE_TECHNIQUE::CompileScriptToFile(char* script,char* fname)
{
return(XeIntuicioCompileFileToFile(script,fname,XE_TECHNIQUE_Itc_DefList));
}

bool XE_TECHNIQUE::CompileScriptFromMemoryToFile(void* data,unsigned int size,char* fname)
{
return(XeIntuicioCompileToFile((char*)data,size,fname,XE_TECHNIQUE_Itc_DefList));
}

bool XE_TECHNIQUE::ExecuteProgram(INPUT* params)
{
if(Itc_Program.IsEmpty())return(false);
if(params)
return(XeIntuicioExecute(&Itc_Program,params->Get(),params->SizeBytes(),XE_TECHNIQUE_Itc_DefList));
else
return(XeIntuicioExecute(&Itc_Program,0,0,XE_TECHNIQUE_Itc_DefList));
}

bool XE_TECHNIQUE::LoadProgram(char* fname)
{
XE_FILE file;
file.Load(fname);
FreeProgram();
Itc_Program.Reserve(file.Size());
memcpy(Itc_Program.Get(),file.Data(),Itc_Program.Size());
file.Free();
return(true);
}

bool XE_TECHNIQUE::LoadProgramFromMemory(void* data,unsigned int size)
{
if(!data||!size)return(false);
FreeProgram();
Itc_Program.Reserve(size);
memcpy(&Itc_Program,data,Itc_Program.Size());
return(true);
}

void XE_TECHNIQUE::FreeProgram()
{
if(!Itc_Program.Size())return;
if(Compiled)
XeIntuicioFree(&Itc_Program);
else
Itc_Program.Free();
}

#endif /* XE_COMPILE_CORE_MATH */
#endif /* XE_COMPILE_CORE_INTUICIO */

#ifdef XE_COMPILE_CORE_MATH

/*--- XE_CANVAS ---*/
XE_CANVAS::XE_CANVAS()
{
}

bool XE_CANVAS::Create(int width,int height,XE_ESTATE type,bool forcednofbo)
{
return(Photon::XeFrameBufferCreate(&Canvas,width,height,type,forcednofbo));
}

bool XE_CANVAS::Create(XE_ELM_TEXTURE tex,bool forcednofbo)
{
return(Photon::XeFrameBufferCreateFromTexture(&Canvas,tex,forcednofbo));
}

bool XE_CANVAS::Destroy()
{
return(Photon::XeFrameBufferDestroy(Canvas));
}

bool XE_CANVAS::Activate(bool invert)
{
bool status=Photon::XeFrameBufferActivate(Canvas);
if(status)
{
Photon::XeMatrixSave(XE_MATRIX_PROJECTION,LastProjMat.Cell);
if(invert)
XeCameraOrtho(0,*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_HEIGHT),*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_WIDTH),-*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_HEIGHT),0);
else
XeCameraOrtho(0,0,*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_WIDTH),*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_HEIGHT),0);
return(true);
}
return(false);
}

void XE_CANVAS::Unactivate(bool mipmap)
{
Photon::XeFrameBufferUnactivate(Canvas);
if(mipmap)Photon::XeFrameBufferMipmap(Canvas);
Photon::XeMatrixMode(XE_MATRIX_PROJECTION);
Photon::XeMatrixLoad(LastProjMat.Cell);
Photon::XeMatrixMode(XE_MATRIX_MODELVIEW);
}

bool XE_CANVAS::ActivateTexture()
{
return(Photon::XeFrameBufferActivateTexture(Canvas));
}

int XE_CANVAS::Width()
{
return(*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_WIDTH));
}

int XE_CANVAS::Height()
{
return(*(int*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_HEIGHT));
}

XE_ELM_TEXTURE XE_CANVAS::Texture()
{
return(*(XE_ELM_TEXTURE*)Photon::XeFrameBufferGet(Canvas,XE_FRAMEBUFFER_TEXTURE));
}

bool XE_CANVAS::Swap(XE_ELM_TEXTURE tex)
{
return(Photon::XeFrameBufferSwapTexture(Canvas,tex));
}

bool XE_CANVAS::Accelerated()
{
return(Photon::XeFrameBufferUseFBO(Canvas));
}

/*--- XE_VERTICES ---*/
XE_VERTICES::XE_VERTICES()
{
UseVBO=false;
Mode=XE_NULL;
}

bool XE_VERTICES::Create(XE_ESTATE mode,XE_PERVERTEX* vertdata,int vertcount,unsigned int* inddata,int indcount,unsigned int vertflags,unsigned int indflags,bool forcednovbo)
{
if(!Buffer.IsEmpty())return(false);
Mode=mode;
UseVBO=false;
if(!forcednovbo&&Photon::XeVertexBufferInit())UseVBO=true;
if(UseVBO)
{
XE_ESTATE verttype=XE_VERTEXBUFFER_STATIC_DRAW;
if(vertflags&(XEF_FLAG_STATIC|XEF_FLAG_DRAW))XE_ESTATE verttype=XE_VERTEXBUFFER_STATIC_DRAW;
if(vertflags&(XEF_FLAG_STATIC|XEF_FLAG_READ))XE_ESTATE verttype=XE_VERTEXBUFFER_STATIC_READ;
if(vertflags&(XEF_FLAG_STATIC|XEF_FLAG_COPY))XE_ESTATE verttype=XE_VERTEXBUFFER_STATIC_COPY;
if(vertflags&(XEF_FLAG_DYNAMIC|XEF_FLAG_DRAW))XE_ESTATE verttype=XE_VERTEXBUFFER_DYNAMIC_DRAW;
if(vertflags&(XEF_FLAG_DYNAMIC|XEF_FLAG_READ))XE_ESTATE verttype=XE_VERTEXBUFFER_DYNAMIC_READ;
if(vertflags&(XEF_FLAG_DYNAMIC|XEF_FLAG_COPY))XE_ESTATE verttype=XE_VERTEXBUFFER_DYNAMIC_COPY;
if(vertflags&(XEF_FLAG_STREAM|XEF_FLAG_DRAW))XE_ESTATE verttype=XE_VERTEXBUFFER_STREAM_DRAW;
if(vertflags&(XEF_FLAG_STREAM|XEF_FLAG_READ))XE_ESTATE verttype=XE_VERTEXBUFFER_STREAM_READ;
if(vertflags&(XEF_FLAG_STREAM|XEF_FLAG_COPY))XE_ESTATE verttype=XE_VERTEXBUFFER_STREAM_COPY;
XE_ESTATE indtype=XE_VERTEXBUFFER_STATIC_DRAW;
if(indflags&(XEF_FLAG_STATIC|XEF_FLAG_DRAW))XE_ESTATE indtype=XE_VERTEXBUFFER_STATIC_DRAW;
if(indflags&(XEF_FLAG_STATIC|XEF_FLAG_READ))XE_ESTATE indtype=XE_VERTEXBUFFER_STATIC_READ;
if(indflags&(XEF_FLAG_STATIC|XEF_FLAG_COPY))XE_ESTATE indtype=XE_VERTEXBUFFER_STATIC_COPY;
if(indflags&(XEF_FLAG_DYNAMIC|XEF_FLAG_DRAW))XE_ESTATE indtype=XE_VERTEXBUFFER_DYNAMIC_DRAW;
if(indflags&(XEF_FLAG_DYNAMIC|XEF_FLAG_READ))XE_ESTATE indtype=XE_VERTEXBUFFER_DYNAMIC_READ;
if(indflags&(XEF_FLAG_DYNAMIC|XEF_FLAG_COPY))XE_ESTATE indtype=XE_VERTEXBUFFER_DYNAMIC_COPY;
if(indflags&(XEF_FLAG_STREAM|XEF_FLAG_DRAW))XE_ESTATE indtype=XE_VERTEXBUFFER_STREAM_DRAW;
if(indflags&(XEF_FLAG_STREAM|XEF_FLAG_READ))XE_ESTATE indtype=XE_VERTEXBUFFER_STREAM_READ;
if(indflags&(XEF_FLAG_STREAM|XEF_FLAG_COPY))XE_ESTATE indtype=XE_VERTEXBUFFER_STREAM_COPY;
if(Photon::XeVertexBufferCreate(&Buffer,sizeof(XE_PERVERTEX)*vertcount,vertdata,verttype,sizeof(unsigned int)*indcount,inddata,indtype))
{
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ARRAY);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ELEMENT);
return(true);
}
else
{
UseVBO=false;
return(false);
}
}
else
{
VertData.Free();
IndData.Free();
if(vertcount)
{
VertData.Reserve(vertcount);
if(vertdata)VertData.Write(vertdata,vertcount);
VertData.Seek(0);
}
if(indcount)
{
IndData.Reserve(indcount);
if(inddata)IndData.Write(inddata,indcount);
IndData.Seek(0);
}
if(!VertData.IsEmpty()||!IndData.IsEmpty())
return(true);
return(false);
}
}

void XE_VERTICES::Destroy()
{
if(UseVBO)
{
Photon::XeVertexBufferDestroy(Buffer);
Buffer.Unref();
}
else
{
VertData.Free();
IndData.Free();
}
}

void XE_VERTICES::Draw()
{
if(UseVBO)
{
if(Buffer.IsEmpty())return;
int vertsize=sizeof(XE_PERVERTEX);
int indsize=sizeof(unsigned int);
Photon::XeVertexBufferActivate(Buffer,XE_VERTEXBUFFER_ARRAY);
if(Photon::XeVertexBufferHasBuffer(Buffer,XE_VERTEXBUFFER_ELEMENT))
{
Photon::XeVertexBufferActivate(Buffer,XE_VERTEXBUFFER_ELEMENT);
Photon::XeDrawData(Mode,0,Photon::XeVertexBufferSize(Buffer,XE_VERTEXBUFFER_ELEMENT)/indsize,((char*)44),((char*)16),((char*)0),((char*)32),0,0,XE_SINGLE,vertsize,vertsize,vertsize,vertsize,0,0,0,false,true,true,true,true,true);
}
else
Photon::XeDrawData(Mode,0,Photon::XeVertexBufferSize(Buffer,XE_VERTEXBUFFER_ARRAY)/vertsize,((char*)44),((char*)16),((char*)0),((char*)32),0,0,XE_SINGLE,vertsize,vertsize,vertsize,vertsize,0,0,0,false,true,true,true,true,false);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ARRAY);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ELEMENT);
}
else
{
if(VertData.IsEmpty())return;
if(IndData.IsEmpty())
Photon::XeDrawDataStruct(Mode,0,VertData.Size(),VertData.Get());
else
Photon::XeDrawDataStruct(Mode,0,IndData.Size(),VertData.Get(),IndData.Get());
}
}

unsigned int XE_VERTICES::CountV()
{
if(UseVBO)
return(Photon::XeVertexBufferSize(Buffer,XE_VERTEXBUFFER_ARRAY)/sizeof(XE_PERVERTEX));
else
return(VertData.Size());
}

unsigned int XE_VERTICES::CountI()
{
if(UseVBO)
return(Photon::XeVertexBufferSize(Buffer,XE_VERTEXBUFFER_ELEMENT)/sizeof(unsigned int));
else
return(IndData.Size());
}

XE_PERVERTEX* XE_VERTICES::OpenStreamV(unsigned int access)
{
if(UseVBO)
{
Photon::XeVertexBufferActivate(Buffer,XE_VERTEXBUFFER_ARRAY);
XE_ESTATE mode=XE_VERTEXBUFFER_READWRITE;
if((access&XEF_FLAG_READ)&&!(access&XEF_FLAG_WRITE))mode=XE_VERTEXBUFFER_READ;
if((access&XEF_FLAG_WRITE)&&!(access&XEF_FLAG_READ))mode=XE_VERTEXBUFFER_WRITE;
void* ptr=Photon::XeVertexBufferMap(XE_VERTEXBUFFER_ARRAY,mode);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ARRAY);
return((XE_PERVERTEX*)ptr);
}
else
return(VertData.Get());
}

unsigned int* XE_VERTICES::OpenStreamI(unsigned int access)
{
if(UseVBO)
{
Photon::XeVertexBufferActivate(Buffer,XE_VERTEXBUFFER_ELEMENT);
XE_ESTATE mode=XE_VERTEXBUFFER_READWRITE;
if((access&XEF_FLAG_READ)&&!(access&XEF_FLAG_WRITE))mode=XE_VERTEXBUFFER_READ;
if((access&XEF_FLAG_WRITE)&&!(access&XEF_FLAG_READ))mode=XE_VERTEXBUFFER_WRITE;
void* ptr=Photon::XeVertexBufferMap(XE_VERTEXBUFFER_ELEMENT,mode);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ELEMENT);
return((unsigned int*)ptr);
}
else
return(IndData.Get());
}

void XE_VERTICES::CloseStreamV()
{
if(!UseVBO)return;
Photon::XeVertexBufferActivate(Buffer,XE_VERTEXBUFFER_ARRAY);
Photon::XeVertexBufferUnmap(XE_VERTEXBUFFER_ARRAY);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ARRAY);
}

void XE_VERTICES::CloseStreamI()
{
if(!UseVBO)return;
Photon::XeVertexBufferActivate(Buffer,XE_VERTEXBUFFER_ELEMENT);
Photon::XeVertexBufferUnmap(XE_VERTEXBUFFER_ELEMENT);
Photon::XeVertexBufferUnactivate(XE_VERTEXBUFFER_ELEMENT);
}

bool XE_VERTICES::Accelerated()
{
return(UseVBO);
}

/*--- XE_CAMERA ---*/
XE_CAMERA::XE_CAMERA()
{
Width=0;
Height=0;
LookToPoint=0;
PerspectiveMode=0;
}

void XE_CAMERA::Update()
{
if(!PerspectiveMode)
XeCameraOrtho(Position.X,Position.Y,Width,Height,Direction.Alpha);
else
XeCameraPerspective(Direction,Position,LookToPoint);
}

void XE_CAMERA::SetNearFar(double znear,double zfar)
{
(*(double*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_ZNEAR))=znear;
(*(double*)Photon::XeRenderTargetGet(*(XE_ELM_RENDERTARGET*)XeGetState(XE_RENDERTARGET),XE_RENDERTARGET_ZFAR))=zfar;
}

void XE_CAMERA::BuildMatrix(XE_MATRIX& matrix)
{
if(!PerspectiveMode)
XeCameraOrthoBuild(&matrix,Position.X,Position.Y,Width,Height,Direction.Alpha);
else
XeCameraPerspectiveBuild(&matrix,Direction,Position,LookToPoint);
}

void XE_CAMERA::BuildMatrix(XE_HALFMATRIX& matrix)
{
if(!PerspectiveMode)
XeCameraOrthoBuildHalf(&matrix,(float)Position.X,(float)Position.Y,Width,Height,(float)Direction.Alpha);
else
XeCameraPerspectiveBuildHalf(&matrix,Direction,XE_VECTOHALF(Position),LookToPoint);
}

#endif /* XE_COMPILE_CORE_MATH */

#ifdef XE_COMPILE_CORE_DNA
#ifdef XE_COMPILE_CHAOS
#ifdef XE_COMPILE_CORE_MATH

/*--- XE_DNA_MODEL ---*/
XE_DNA_MODEL::XE_DNA_MODEL()
{
}

bool XE_DNA_MODEL::Create()
{
XeDnaDie(Dna);
XeDnaDestroy(Dna);
XeDnaCreate(&Dna);
return(true);
}

void XE_DNA_MODEL::Prepare(unsigned int cells,unsigned int skin,unsigned int muscles,unsigned int sprites)
{
XeDnaBirth(Dna,cells,muscles,skin);
if(sprites)
{
Sprites.Reserve(sprites);
for(unsigned int i=0;i<Sprites.Size();i++)
{
Sprites[i].Texture=XE_ELM_TEXTURE();
Sprites[i].Muscle=0;
Sprites[i].Xoffset=0;
Sprites[i].Yoffset=0;
Sprites[i].Width=0;
Sprites[i].Height=0;
Sprites[i].Inverted=false;
Sprites[i].Streched=false;
}
}
}

bool XE_DNA_MODEL::LoadEBM(char* fname,XE_CONTAINER<XE_SPRITE>* sprites,XE_MATRIX* transform,XE_VECTOR sprscale,double massfactor,double rangefactor,double resilfactor)
{
if(!fname)return(false);
XE_FILE file;
file.Load(fname);
bool result=LoadEBMfromMemory((char*)file.Data(),file.Size(),sprites,transform,sprscale,massfactor,rangefactor,resilfactor);
file.Free();
return(result);
}

bool XE_DNA_MODEL::LoadEBMfromMemory(char* buff,unsigned int size,XE_CONTAINER<XE_SPRITE>* sprites,XE_MATRIX* transform,XE_VECTOR sprscale,double massfactor,double rangefactor,double resilfactor)
{
if(Dna.IsEmpty()||!buff||!size)return(false);
double val=0;
unsigned int linesc=0;
XE_STRING* lines=XE_STRING::ExplodeBuff(buff,size,"\r\n",linesc);
if(linesc<2||!lines)return(false);
if(lines[0]!="envboxmodel2d"||lines[1]!="2")
{
delete[] lines;
return(false);
}
unsigned int pos=2;
unsigned int count=0;
lines[pos++].Convert(&count,'d');
XeDnaBirth(Dna,count,0,0);
XE_ELM_SUBSTANCE cell;
for(unsigned int i=0;i<count;i++)
{
double x=0,y=0,mass=0,range=0,solid=0;
lines[pos++].Convert(&x,'r');
lines[pos++].Convert(&y,'r');
lines[pos++].Convert(&mass,'r');
lines[pos++].Convert(&range,'r');
lines[pos++].Convert(&solid,'r');
Chaos::XeSubstanceCreate(&cell);
if(!transform)
Chaos::XeSubstanceSetPosition(cell,XE_VECTOR(x,y));
else
Chaos::XeSubstanceSetPosition(cell,transform->Multiply(XE_VECTOR(x,y)));
Chaos::XeSubstanceSetMass(cell,mass*massfactor);
Chaos::XeSubstanceSetRange(cell,range*rangefactor);
Chaos::XeSubstanceSetSolid(cell,(unsigned int)solid);
XeDnaLink(Dna,XE_DNA_CELLS,i,&cell);
}
lines[pos++].Convert(&count,'d');
XeDnaBirth(Dna,0,0,count);
XE_ELM_SURFACE skin;
XE_ELM_SUBSTANCE* cells=(XE_ELM_SUBSTANCE*)XeDnaGet(Dna,XE_DNA_CELLS);
for(unsigned int i=0;i<count;i++)
{
double sub[3]={0},texx[3]={0},texy[3]={0};
lines[pos++].Convert(&sub[0],'r');
lines[pos++].Convert(&sub[1],'r');
lines[pos++].Convert(&sub[2],'r');
lines[pos++].Convert(&texx[0],'r');
lines[pos++].Convert(&texy[0],'r');
lines[pos++].Convert(&texx[1],'r');
lines[pos++].Convert(&texy[1],'r');
lines[pos++].Convert(&texx[2],'r');
lines[pos++].Convert(&texy[2],'r');
char* tex=lines[pos++].Get();
Chaos::XeSurfaceCreate(&skin);
Chaos::XeSurfaceSetSubstance(skin,XE_SURFACE_SUBSTANCE_1,cells[(unsigned int)sub[0]]);
Chaos::XeSurfaceSetSubstance(skin,XE_SURFACE_SUBSTANCE_2,cells[(unsigned int)sub[1]]);
Chaos::XeSurfaceSetSubstance(skin,XE_SURFACE_SUBSTANCE_3,cells[(unsigned int)sub[2]]);
Chaos::XeSurfaceSetCoord(skin,XE_SURFACE_COORD_SUBSTANCE_1,XE_VECTOR(texx[0],texy[0]));
Chaos::XeSurfaceSetCoord(skin,XE_SURFACE_COORD_SUBSTANCE_2,XE_VECTOR(texx[1],texy[1]));
Chaos::XeSurfaceSetCoord(skin,XE_SURFACE_COORD_SUBSTANCE_3,XE_VECTOR(texx[2],texy[2]));
if(sprites)Chaos::XeSurfaceSetTexture(skin,sprites->Access(tex).GetCurrent(),XE_2D);
XeDnaLink(Dna,XE_DNA_SKIN,i,&skin);
}
lines[pos++].Convert(&count,'d');
XeDnaBirth(Dna,0,count,0);
XE_ELM_COVALENCE_FORCE muscle;
for(unsigned int i=0;i<count;i++)
{
double sub[2]={0},resil=0;
lines[pos++].Convert(&sub[0],'r');
lines[pos++].Convert(&sub[1],'r');
lines[pos++].Convert(&resil,'r');
Chaos::XeCovalenceForceCreate(&muscle);
Chaos::XeCovalenceForceSetSubstance(muscle,XE_COVALENCE_FORCE_SUBSTANCE_1,cells[(unsigned int)sub[0]]);
Chaos::XeCovalenceForceSetSubstance(muscle,XE_COVALENCE_FORCE_SUBSTANCE_2,cells[(unsigned int)sub[1]]);
Chaos::XeCovalenceForceSetResilience(muscle,resil*resilfactor);
XE_VECTOR* p1=(XE_VECTOR*)Chaos::XeSubstanceGet(cells[(unsigned int)sub[0]],XE_SUBSTANCE_POSITION);
XE_VECTOR* p2=(XE_VECTOR*)Chaos::XeSubstanceGet(cells[(unsigned int)sub[1]],XE_SUBSTANCE_POSITION);
Chaos::XeCovalenceForceSetForce(muscle,(*p1-*p2).Length());
XeDnaLink(Dna,XE_DNA_MUSCLES,i,&muscle);
}
lines[pos++].Convert(&count,'d');
Sprites.Reserve(count);
XE_ELM_COVALENCE_FORCE* muscles=(XE_ELM_COVALENCE_FORCE*)XeDnaGet(Dna,XE_DNA_MUSCLES);
for(unsigned int i=0;i<count;i++)
{
double xoff=0,yoff=0,width=0,height=0,cov=0,inv=0,strech=0;
char* tex=lines[pos++].Get();
lines[pos++].Convert(&xoff,'r');
lines[pos++].Convert(&yoff,'r');
lines[pos++].Convert(&width,'r');
lines[pos++].Convert(&height,'r');
lines[pos++].Convert(&cov,'r');
lines[pos++].Convert(&inv,'r');
lines[pos++].Convert(&strech,'r');
if(sprites)Sprites[i].Texture=sprites->Access(tex).GetCurrent();
Sprites[i].Xoffset=(int)(xoff*sprscale.X);
Sprites[i].Yoffset=(int)(yoff*sprscale.Y);
Sprites[i].Width=(int)(width*sprscale.X);
Sprites[i].Height=(int)(height*sprscale.Y);
Sprites[i].Muscle=&muscles[(unsigned int)cov];
Sprites[i].Inverted=inv?true:false;
Sprites[i].Streched=strech?true:false;
}
delete[] lines;
return(true);
}

bool XE_DNA_MODEL::LoadEBMtextures(char* fname,char* directory,XE_CONTAINER<XE_SPRITE>& sprites)
{
if(!fname)return(false);
XE_FILE file;
file.Load(fname);
bool result=LoadEBMfromMemoryTextures((char*)file.Data(),file.Size(),directory,sprites);
file.Free();
return(result);
}

bool XE_DNA_MODEL::LoadEBMfromMemoryTextures(char* buff,unsigned int size,char* directory,XE_CONTAINER<XE_SPRITE>& sprites)
{
if(!buff||!size)return(false);
double val=0;
unsigned int linesc=0;
XE_STRING* lines=XE_STRING::ExplodeBuff(buff,size,"\r\n",linesc);
if(linesc<2||!lines)return(false);
if(lines[0]!="envboxmodel2d"||lines[1]!="2")
{
delete[] lines;
return(false);
}
unsigned int pos=2;
unsigned int count=0;
lines[pos++].Convert(&count,'d');
pos+=count*5;
lines[pos++].Convert(&count,'d');
for(unsigned int i=0;i<count;i++)
{
pos+=9;
char* tex=lines[pos++].Get();
if(sprites(XEF_FIND,tex).IsEmpty())
{
XE_STRING str;
str.Format("%s/%s.xet",directory,tex);
sprites(tex)->Prepare(str.Get());
}
}
lines[pos++].Convert(&count,'d');
pos+=count*3;
lines[pos++].Convert(&count,'d');
for(unsigned int i=0;i<count;i++)
{
char* tex=lines[pos++].Get();
pos+=7;
if(sprites(XEF_FIND,tex).IsEmpty())
{
XE_STRING str;
str.Format("%s/%s.xet",directory,tex);
sprites(tex)->Prepare(str.Get());
}
}
delete[] lines;
return(true);
}

bool XE_DNA_MODEL::LoadEBMcomplete(char* fname,char* directory,XE_CONTAINER<XE_SPRITE>& sprites,XE_MATRIX* transform,XE_VECTOR sprscale,double massfactor,double rangefactor,double resilfactor)
{
if(LoadEBMtextures(fname,directory,sprites))
return(LoadEBM(fname,&sprites,transform,sprscale,massfactor,rangefactor,resilfactor));
return(false);
}

bool XE_DNA_MODEL::LoadEBMfromMemoryComplete(char* buff,unsigned int size,char* directory,XE_CONTAINER<XE_SPRITE>& sprites,XE_MATRIX* transform,XE_VECTOR sprscale,double massfactor,double rangefactor,double resilfactor)
{
if(LoadEBMfromMemoryTextures(buff,size,directory,sprites))
return(LoadEBMfromMemory(buff,size,&sprites,transform,sprscale,massfactor,rangefactor,resilfactor));
return(false);
}

void XE_DNA_MODEL::Free()
{
XeDnaDie(Dna);
XeDnaDestroy(Dna);
Dna.Unref();
Sprites.Free();
}

void XE_DNA_MODEL::Draw()
{
XeDnaDraw(Dna);
XE_RECT coords;
coords.Vertices[0]=XE_VECTOR(0,0);
coords.Vertices[1]=XE_VECTOR(1,0);
coords.Vertices[2]=XE_VECTOR(1,1);
coords.Vertices[3]=XE_VECTOR(0,1);
for(unsigned int i=0;i<Sprites.Size();i++)
if(!Sprites[i].Texture.IsEmpty()&&Sprites[i].Muscle)
{
if(Sprites[i].Muscle->IsEmpty())continue;
XE_ELM_SUBSTANCE* sb=0;
XE_ELM_SUBSTANCE* se=0;
if(!Sprites[i].Inverted)
{
sb=(XE_ELM_SUBSTANCE*)Chaos::XeCovalenceForceGet(*Sprites[i].Muscle,XE_COVALENCE_FORCE_SUBSTANCE_1);
se=(XE_ELM_SUBSTANCE*)Chaos::XeCovalenceForceGet(*Sprites[i].Muscle,XE_COVALENCE_FORCE_SUBSTANCE_2);
}
else
{
sb=(XE_ELM_SUBSTANCE*)Chaos::XeCovalenceForceGet(*Sprites[i].Muscle,XE_COVALENCE_FORCE_SUBSTANCE_2);
se=(XE_ELM_SUBSTANCE*)Chaos::XeCovalenceForceGet(*Sprites[i].Muscle,XE_COVALENCE_FORCE_SUBSTANCE_1);
}
if(!sb||!se||sb->IsEmpty()||se->IsEmpty())continue;
XE_VECTOR* pb=(XE_VECTOR*)Chaos::XeSubstanceGet(*sb,XE_SUBSTANCE_POSITION);
XE_VECTOR* pe=(XE_VECTOR*)Chaos::XeSubstanceGet(*se,XE_SUBSTANCE_POSITION);
XE_ANGLEVECTOR angle=XeDirectionDir(*pb,*pe);
Sprites[i].LastDir=angle.Alpha;
double len=((*pe)-(*pb)).Length();
XE_RECT vertices;
vertices.Vertices[0]=XE_VECTOR(-Sprites[i].Xoffset,-Sprites[i].Yoffset);
if(!Sprites[i].Streched)
{
vertices.Vertices[1]=XE_VECTOR(-Sprites[i].Xoffset+Sprites[i].Width,-Sprites[i].Yoffset);
vertices.Vertices[2]=XE_VECTOR(-Sprites[i].Xoffset+Sprites[i].Width,-Sprites[i].Yoffset+Sprites[i].Height);
}
else
{
vertices.Vertices[1]=XE_VECTOR(len,-Sprites[i].Yoffset);
vertices.Vertices[2]=XE_VECTOR(len,-Sprites[i].Yoffset+Sprites[i].Height);
}
vertices.Vertices[3]=XE_VECTOR(-Sprites[i].Xoffset,-Sprites[i].Yoffset+Sprites[i].Height);
Photon::XeMatrixPush();
Photon::XeMatrixIdentity();
Photon::XeMatrixTranslate(pb->X,pb->Y,pb->Z);
Photon::XeMatrixRotate(angle.Alpha,0,0,1);
Photon::XeTextureActivate(Sprites[i].Texture);
Photon::XeDrawData(XE_QUADS,0,4,vertices.Vertices,0,coords.Vertices,0,0,0,XE_DOUBLE);
Photon::XeMatrixPop();
}
}

bool XE_DNA_MODEL::SetCell(unsigned int id,XE_ELM_SUBSTANCE cell)
{
return(XeDnaLink(Dna,XE_DNA_CELLS,id,&cell));
}

bool XE_DNA_MODEL::SetSkin(unsigned int id,XE_ELM_SURFACE skin)
{
return(XeDnaLink(Dna,XE_DNA_SKIN,id,&skin));
}

bool XE_DNA_MODEL::SetMuscle(unsigned int id,XE_ELM_COVALENCE_FORCE muscle)
{
return(XeDnaLink(Dna,XE_DNA_MUSCLES,id,&muscle));
}

bool XE_DNA_MODEL::SetBodyTexture(XE_ELM_TEXTURE tex)
{
return(XeDnaLink(Dna,XE_DNA_BODY_TEXTURE,0,&tex));
}

bool XE_DNA_MODEL::SetMuscleSprite(unsigned int id,MUSCLESPRITE sprite)
{
if(id>=Sprites.Size())return(false);
Sprites[id]=sprite;
return(true);
}

XE_ELM_SUBSTANCE* XE_DNA_MODEL::GetCells()
{
return((XE_ELM_SUBSTANCE*)XeDnaGet(Dna,XE_DNA_CELLS));
}

XE_ELM_SURFACE* XE_DNA_MODEL::GetSkin()
{
return((XE_ELM_SURFACE*)XeDnaGet(Dna,XE_DNA_SKIN));
}

XE_ELM_COVALENCE_FORCE* XE_DNA_MODEL::GetMuscles()
{
return((XE_ELM_COVALENCE_FORCE*)XeDnaGet(Dna,XE_DNA_MUSCLES));
}

XE_ELM_TEXTURE XE_DNA_MODEL::GetBodyTexture()
{
return(*(XE_ELM_TEXTURE*)XeDnaGet(Dna,XE_DNA_BODY_TEXTURE));
}

XE_DNA_MODEL::MUSCLESPRITE* XE_DNA_MODEL::GetMusclesSprites()
{
return(Sprites.Get());
}

unsigned int XE_DNA_MODEL::CellsCount()
{
return(XeDnaCount(Dna,XE_DNA_CELLS));
}

unsigned int XE_DNA_MODEL::SkinCount()
{
return(XeDnaCount(Dna,XE_DNA_SKIN));
}

unsigned int XE_DNA_MODEL::MusclesCount()
{
return(XeDnaCount(Dna,XE_DNA_MUSCLES));
}

unsigned int XE_DNA_MODEL::MusclesSpritesCount()
{
return(Sprites.Size());
}

#endif /* XE_COMPILE_CORE_MATH */
#endif /* XE_COMPILE_CHAOS */
#endif /* XE_COMPILE_CORE_DNA */

#endif /* XE_COMPILE_PHOTON */

/*--- XE_FILE ---*/
#ifdef XE_COMPILE_CORE_VIRTUAL_FILE

XE_ARCHIVE::XE_ARCHIVE()
{
}

bool XE_ARCHIVE::Open(char* fname)
{
if(!XeVirtualFileInfoOpen(fname,&FilesInfo))return(false);
Path.Set(fname);
return(true);
}

void XE_ARCHIVE::Close()
{
Path.Clear();
XeVirtualFileInfoClose(&FilesInfo);
}

char* XE_ARCHIVE::FileName(XE_HANDLE handle)
{
if(!Count()||handle>=Count())return(NULL);
return(FilesInfo[handle].FileName);
}

unsigned int XE_ARCHIVE::FileSize(XE_HANDLE handle)
{
if(!Count()||handle>=Count())return(0);
return(FilesInfo[handle].FileSize);
}

bool XE_ARCHIVE::LoadFile(XE_FILE* file,XE_HANDLE handle)
{
if(!file||!Path.Length()||!Count()||handle>=Count())return(false);
XVF_FILE virt;
if(XeVirtualFileLoad(&virt,Path.Get(),FilesInfo[handle]))
{
file->GetBuffer()->Reserve(XeVirtualFileSize(&virt));
file->Update();
bool status=XeVirtualFileGetData(&virt,file->Data(),file->Size());
XeVirtualFileFree(&virt);
return(status);
}
return(false);
}

bool XE_ARCHIVE::SaveFiles(char* fname,VIRTUAL* files,unsigned int count)
{
if(!files||!count)return(false);
XE_ARRAY<XVF_FILE> virt(count);
for(unsigned int i=0;i<count;i++)
XeVirtualFileMakeFile(&virt[i],files[i].Name.Get(),files[i].File->Data(),files[i].File->Size());
bool status=XeVirtualFileSave(fname,virt.Get(),count);
virt.Free();
return(true);
}

bool XE_ARCHIVE::Find(char* name,XE_HANDLE& result)
{
for(unsigned int i=0;i<FilesInfo.Size();i++)
if(!strcmp(FilesInfo[i].FileName,name))
{
result=i;
return(true);
}
return(false);
}

unsigned int XE_ARCHIVE::Count()
{
return(FilesInfo.Size());
}

XE_ARCHIVE::VIRTUAL::VIRTUAL()
{
File=0;
}

#endif /* XE_COMPILE_CORE_VIRTUAL_FILE */

#ifdef XE_COMPILE_PHOTON

#define XE_GUI_STYLE_INIT_AREA_COORDS(type)\
AreaCoords##type##[0]=XE_HALFVECTOR(0,0);\
AreaCoords##type##[1]=XE_HALFVECTOR(1,0);\
AreaCoords##type##[2]=XE_HALFVECTOR(1,1);\
AreaCoords##type##[3]=XE_HALFVECTOR(0,1);
#define XE_GUI_STYLE_INIT_AREA_COLORS(type)\
AreaColors##type##[0]=XE_HALFVECTOR(1,1,1);\
AreaColors##type##[1]=XE_HALFVECTOR(1,1,1);\
AreaColors##type##[2]=XE_HALFVECTOR(1,1,1);\
AreaColors##type##[3]=XE_HALFVECTOR(1,1,1);

/*--- XE_GUI ---*/
XE_GUI::STYLE::STYLE()
{
XE_GUI_STYLE_INIT_AREA_COORDS(TL);
XE_GUI_STYLE_INIT_AREA_COORDS(TC);
XE_GUI_STYLE_INIT_AREA_COORDS(TR);
XE_GUI_STYLE_INIT_AREA_COORDS(ML);
XE_GUI_STYLE_INIT_AREA_COORDS(MC);
XE_GUI_STYLE_INIT_AREA_COORDS(MR);
XE_GUI_STYLE_INIT_AREA_COORDS(BL);
XE_GUI_STYLE_INIT_AREA_COORDS(BC);
XE_GUI_STYLE_INIT_AREA_COORDS(BR);
XE_GUI_STYLE_INIT_AREA_COLORS(TL);
XE_GUI_STYLE_INIT_AREA_COLORS(TC);
XE_GUI_STYLE_INIT_AREA_COLORS(TR);
XE_GUI_STYLE_INIT_AREA_COLORS(ML);
XE_GUI_STYLE_INIT_AREA_COLORS(MC);
XE_GUI_STYLE_INIT_AREA_COLORS(MR);
XE_GUI_STYLE_INIT_AREA_COLORS(BL);
XE_GUI_STYLE_INIT_AREA_COLORS(BC);
XE_GUI_STYLE_INIT_AREA_COLORS(BR);
AreaColorFilter=XE_HALFVECTOR(1,1,1);
AreaSplitTop=0;
AreaSplitBottom=0;
AreaSplitLeft=0;
AreaSplitRight=0;
AreaSplitTopType=0;
AreaSplitBottomType=0;
AreaSplitLeftType=0;
AreaSplitRightType=0;
TextFont=0;
TextScale=XE_VECTOR(1,1);
TextColor=XE_VECTOR(1,1,1);
TextHalign=XE_FONT::LEFT;
TextValign=XE_FONT::TOP;
TextBorderSize=0;
TextBorderQuality=1;
AsBorder=false;
}

XE_GUI::CONTROL::CONTROL()
{
CurrentUnactive=false;
LastEvents=0;
Gui=0;
Node=0;
Order=0;
Events=0;
Behaviour=0;
MarginTop=0;
MarginBottom=0;
MarginLeft=0;
MarginRight=0;
CutMarginTop=0;
CutMarginBottom=0;
CutMarginLeft=0;
CutMarginRight=0;
Active=true;
Visible=true;
Hitable=true;
NonCorrected=false;
CutArea=true;
}

#define XE_GUI_CONTROL_DRAW_RECT0(type) \
{ \
if(!style->AreaTexture##type##.IsEmpty()) \
Photon::XeTextureActivate(style->AreaTexture##type##); \
else \
Photon::XeTextureUnactivate(); \
XE_HALFVECTOR _coords[4]; \
_coords[0]=style->AreaCoords##type##[0]; \
_coords[1]=style->AreaCoords##type##[1]; \
_coords[2]=style->AreaCoords##type##[2]; \
_coords[3]=style->AreaCoords##type##[3]; \
if(style->AreaTiled##type##.X>0) \
{ \
float f=Size.X/style->AreaTiled##type##.X; \
float ff=style->AreaOffset##type##.X/style->AreaTiled##type##.X; \
_coords[0].X=ff; \
_coords[1].X=f+ff; \
_coords[2].X=f+ff; \
_coords[3].X=ff; \
} \
if(style->AreaTiled##type##.Y>0) \
{ \
float f=Size.Y/style->AreaTiled##type##.Y; \
float ff=style->AreaOffset##type##.Y/style->AreaTiled##type##.Y; \
_coords[0].Y=ff; \
_coords[1].Y=ff; \
_coords[2].Y=f+ff; \
_coords[3].Y=f+ff; \
}

#define XE_GUI_CONTROL_DRAW_RECT1(type) \
XE_HALFVECTOR _colors[4]; \
_colors[0]=XE_HALFVECTOR(style->AreaColors##type##[0].X*style->AreaColorFilter.X,style->AreaColors##type##[0].Y*style->AreaColorFilter.Y,style->AreaColors##type##[0].Z*style->AreaColorFilter.Z,style->AreaColors##type##[0].W*style->AreaColorFilter.W); \
_colors[1]=XE_HALFVECTOR(style->AreaColors##type##[1].X*style->AreaColorFilter.X,style->AreaColors##type##[1].Y*style->AreaColorFilter.Y,style->AreaColors##type##[1].Z*style->AreaColorFilter.Z,style->AreaColors##type##[1].W*style->AreaColorFilter.W); \
_colors[2]=XE_HALFVECTOR(style->AreaColors##type##[2].X*style->AreaColorFilter.X,style->AreaColors##type##[2].Y*style->AreaColorFilter.Y,style->AreaColors##type##[2].Z*style->AreaColorFilter.Z,style->AreaColors##type##[2].W*style->AreaColorFilter.W); \
_colors[3]=XE_HALFVECTOR(style->AreaColors##type##[3].X*style->AreaColorFilter.X,style->AreaColors##type##[3].Y*style->AreaColorFilter.Y,style->AreaColors##type##[3].Z*style->AreaColorFilter.Z,style->AreaColors##type##[3].W*style->AreaColorFilter.W); \

#define XE_GUI_CONTROL_DRAW_RECT2(type) \
if(style->AsBorder) \
{ \
Rect##type##[0].X+=1; \
Rect##type##[3].X+=1; \
Rect##type##[3].Y-=1; \
Rect##type##[2].Y-=1; \
} \
Photon::XeDrawData((style->AsBorder)?(XE_LINELOOP):(XE_QUADS),0,4,Rect##type##,_colors,_coords,0,0,0,XE_SINGLE); \
if(style->AsBorder) \
{ \
Rect##type##[0].X-=1; \
Rect##type##[3].X-=1; \
Rect##type##[3].Y+=1; \
Rect##type##[2].Y+=1; \
} \
}

void XE_GUI::CONTROL::Draw(XE_VECTOR cutmin,XE_VECTOR cutmax,bool forcedunactive)
{
if(!Node)return;
if(!Visible)return;
XE_VECTOR _cutmin=cutmin;
XE_VECTOR _cutmax=cutmax;
if(CutArea)
{
cutmin=XE_VECTOR(RectTL[0].X,RectTL[0].Y).Max(_cutmin);
cutmax=XE_VECTOR(RectBR[2].X,RectBR[2].Y).Min(_cutmax);
}
XeSetState(XE_RENDER_SCISSOR,(int)cutmin.X,Gui->Window->Height-(int)cutmax.Y,max((int)(cutmax.X-cutmin.X),0),max((int)(cutmax.Y-cutmin.Y),0));
if(CutArea)
{
cutmin=XE_VECTOR(RectTL[0].X+CutMarginLeft,RectTL[0].Y+CutMarginTop).Max(_cutmin);
cutmax=XE_VECTOR(RectBR[2].X-CutMarginRight,RectBR[2].Y-CutMarginBottom).Min(_cutmax);
}
if(Active&&!StyleActive.IsEmpty()||!Active&&!StyleUnactive.IsEmpty())
{
XE_GUI::STYLE::ELM style=(Active&&!forcedunactive)?StyleActive:StyleUnactive;
XE_GUI_CONTROL_DRAW_RECT0(TL);
XE_GUI_CONTROL_DRAW_RECT1(TL);
XE_GUI_CONTROL_DRAW_RECT2(TL);
XE_GUI_CONTROL_DRAW_RECT0(TC);
XE_GUI_CONTROL_DRAW_RECT1(TC);
XE_GUI_CONTROL_DRAW_RECT2(TC);
XE_GUI_CONTROL_DRAW_RECT0(TR);
XE_GUI_CONTROL_DRAW_RECT1(TR);
XE_GUI_CONTROL_DRAW_RECT2(TR);
XE_GUI_CONTROL_DRAW_RECT0(ML);
XE_GUI_CONTROL_DRAW_RECT1(ML);
XE_GUI_CONTROL_DRAW_RECT2(ML);
XE_GUI_CONTROL_DRAW_RECT0(MC);
XE_GUI_CONTROL_DRAW_RECT1(MC);
XE_GUI_CONTROL_DRAW_RECT2(MC);
XE_GUI_CONTROL_DRAW_RECT0(MR);
XE_GUI_CONTROL_DRAW_RECT1(MR);
XE_GUI_CONTROL_DRAW_RECT2(MR);
XE_GUI_CONTROL_DRAW_RECT0(BL);
XE_GUI_CONTROL_DRAW_RECT1(BL);
XE_GUI_CONTROL_DRAW_RECT2(BL);
XE_GUI_CONTROL_DRAW_RECT0(BC);
XE_GUI_CONTROL_DRAW_RECT1(BC);
XE_GUI_CONTROL_DRAW_RECT2(BC);
XE_GUI_CONTROL_DRAW_RECT0(BR);
XE_GUI_CONTROL_DRAW_RECT1(BR);
XE_GUI_CONTROL_DRAW_RECT2(BR);
if(Text.Length()&&style->TextFont)
{
XE_FONT::ENUM th=style->TextFont->Halign;
XE_FONT::ENUM tv=style->TextFont->Valign;
style->TextFont->Halign=style->TextHalign;
style->TextFont->Valign=style->TextValign;
if(style->TextBorderSize>0&&style->TextBorderQuality>0)
{
XeSetState(XE_COLOR,style->TextBorderColor);
double rel=360/((double)style->TextBorderQuality*4);
double dir=0;
for(int i=0;i<style->TextBorderQuality*4;i++)
{
XE_VECTOR off=XeLengthdirLen(dir,style->TextBorderSize);
dir+=rel;
style->TextFont->Draw(Text,style->TextOffset+XE_HALFTOVEC(RectTL[0])+off,style->TextScale);
}
}
XeSetState(XE_COLOR,style->TextColor);
style->TextFont->Draw(Text,style->TextOffset+XE_HALFTOVEC(RectTL[0]),style->TextScale);
style->TextFont->Halign=th;
style->TextFont->Valign=tv;
}
XeSetState(XE_COLOR,XE_VECTOR(1,1,1));
if(!Icon.IsEmpty())
{
XE_HALFVECTOR ic[4];
ic[0]=XE_HALFVECTOR(0,0);
ic[1]=XE_HALFVECTOR(1,0);
ic[2]=XE_HALFVECTOR(1,1);
ic[3]=XE_HALFVECTOR(0,1);
Photon::XeTextureActivate(Icon);
Photon::XeMatrixPush();
Photon::XeMatrixTranslate(RectTL[0].X,RectTL[0].Y,RectTL[0].Z);
Photon::XeDrawData(XE_QUADS,0,4,style->IconRect,0,ic,0,0);
Photon::XeMatrixPop();
}
}
Photon::XeMatrixPush();
Photon::XeMatrixTranslate(cutmin.X+ChildOffset.X,cutmin.Y+ChildOffset.Y,cutmin.Z+ChildOffset.Z);
CurrentUnactive=(!Active||forcedunactive)?true:false;
RenderInside();
Photon::XeMatrixPop();
XE_ELEMENTS<CONTROL*> temp;
for(ELM e=Node->FirstChild();!e.IsEmpty();e.Next())
temp.AddPointer(e->Pointer()->Pointer());
temp.Sort(CONTROL::SortFunc);
XE_FOREACH(CONTROL*,temp,e)e()->Draw(cutmin,cutmax,(Active&&!forcedunactive)?false:true);
temp.Clear();
}

void XE_GUI::CONTROL::Update()
{
if(!GetGui()||!GetGui()->GetWindow()||!Node)return;
TREE* parentnode=Node->GetParent();
if(!parentnode)return;
CONTROL* parent=parentnode->Pointer()->Pointer();
if(!parent)return;
if(Behaviour&XEF_FLAG_INHERIT_WIDTH)
{
if(parent==GetGui()->Controls->Pointer())
Size.X=(float)GetGui()->GetWindow()->Width;
else
Size.X=parent->Size.X;
}
if(Behaviour&XEF_FLAG_INHERIT_HEIGHT)
{
if(parent==GetGui()->Controls->Pointer())
Size.Y=(float)GetGui()->GetWindow()->Height;
else
Size.Y=parent->Size.Y;
}
if(Behaviour&XEF_FLAG_FIT_TO_EDGE_TOP)
{
Size.Y+=Position.Y;
Position.Y=0;
}
if(Behaviour&XEF_FLAG_FIT_TO_EDGE_LEFT)
{
Size.X+=Position.X;
Position.X=0;
}
if(Behaviour&XEF_FLAG_FIT_TO_EDGE_BOTTOM)
{
if(parent==GetGui()->Controls->Pointer())
Size.Y=GetGui()->GetWindow()->Height-Position.Y;
else
Size.Y=parent->Size.Y-Position.Y-parent->MarginBottom-parent->MarginTop;
}
if(Behaviour&XEF_FLAG_FIT_TO_EDGE_RIGHT)
{
if(parent==GetGui()->Controls->Pointer())
Size.X=GetGui()->GetWindow()->Width-Position.X;
else
Size.X=parent->Size.X-Position.X-parent->MarginRight-parent->MarginLeft;
}
if(Behaviour&XEF_FLAG_DOCK_TO_MIDDLE)
{
if(parent==GetGui()->Controls->Pointer())
Position.Y=GetGui()->GetWindow()->Height*0.5f-Size.Y*0.5f;
else
Position.Y=parent->Size.Y*0.5f-Size.Y*0.5f-parent->MarginTop;
}
if(Behaviour&XEF_FLAG_DOCK_TO_CENTER)
{
if(parent==GetGui()->Controls->Pointer())
Position.X=GetGui()->GetWindow()->Width*0.5f-Size.X*0.5f;
else
Position.X=parent->Size.X*0.5f-Size.X*0.5f-parent->MarginLeft;
}
if(Behaviour&XEF_FLAG_DOCK_TO_EDGE_TOP)
{
Position.Y=-Size.Y;
}
if(Behaviour&XEF_FLAG_DOCK_TO_EDGE_LEFT)
{
Position.X=-Size.X;
}
if(Behaviour&XEF_FLAG_DOCK_TO_EDGE_BOTTOM)
{
if(parent==GetGui()->Controls->Pointer())
Position.Y=(float)GetGui()->GetWindow()->Height;
else
Position.Y=parent->Size.Y-parent->MarginBottom;
}
if(Behaviour&XEF_FLAG_DOCK_TO_EDGE_RIGHT)
{
if(parent==GetGui()->Controls->Pointer())
Position.X=(float)GetGui()->GetWindow()->Width;
else
Position.X=parent->Size.X-parent->MarginRight;
}
if(Behaviour&XEF_FLAG_DOCK_TO_EDGE_BOTTOM_INSIDE)
{
if(parent==GetGui()->Controls->Pointer())
Position.Y=GetGui()->GetWindow()->Height-Size.Y;
else
Position.Y=parent->Size.Y-Size.Y-parent->MarginBottom;
}
if(Behaviour&XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE)
{
if(parent==GetGui()->Controls->Pointer())
Position.X=GetGui()->GetWindow()->Height-Size.X;
else
Position.X=parent->Size.X-Size.X-parent->MarginRight;
}
STYLE::ELM style=Active?StyleActive:StyleUnactive;
float st=0;
float sb=0;
float sl=0;
float sr=0;
if(!style.IsEmpty())
{
st=style->AreaSplitTop;
sb=style->AreaSplitBottom;
sl=style->AreaSplitLeft;
sr=style->AreaSplitRight;
if(style->AreaSplitTopType=='%')st=st/100*Size.Y;
if(style->AreaSplitBottomType=='%')sb=sb/100*Size.Y;
if(style->AreaSplitLeftType=='%')sl=sl/100*Size.X;
if(style->AreaSplitRightType=='%')sr=sr/100*Size.X;
if(sl>Size.X)sl=Size.X;
if(st>Size.Y)st=Size.Y;
if(sl+sr>Size.X)sr=Size.X-sl;
if(st+sb>Size.Y)sb=Size.Y-st;
}
RectTL[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft,Position.Y+MarginTop)+Offset+parent->ChildOffset;
RectTL[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+MarginTop)+Offset+parent->ChildOffset;
RectTL[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectTL[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectTC[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+MarginTop)+Offset+parent->ChildOffset;
RectTC[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+MarginTop)+Offset+parent->ChildOffset;
RectTC[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectTC[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectTR[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+MarginTop)+Offset+parent->ChildOffset;
RectTR[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight,Position.Y+MarginTop)+Offset+parent->ChildOffset;
RectTR[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectTR[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectML[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectML[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectML[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectML[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectMC[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectMC[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectMC[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectMC[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectMR[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectMR[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight,Position.Y+MarginTop+st)+Offset+parent->ChildOffset;
RectMR[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectMR[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBL[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBL[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBL[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+Size.Y-MarginBottom)+Offset+parent->ChildOffset;
RectBL[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft,Position.Y+Size.Y-MarginBottom)+Offset+parent->ChildOffset;
RectBC[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBC[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBC[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+Size.Y-MarginBottom)+Offset+parent->ChildOffset;
RectBC[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+MarginLeft+sl,Position.Y+Size.Y-MarginBottom)+Offset+parent->ChildOffset;
RectBR[0]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBR[1]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight,Position.Y+Size.Y-MarginBottom-sb)+Offset+parent->ChildOffset;
RectBR[2]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight,Position.Y+Size.Y-MarginBottom)+Offset+parent->ChildOffset;
RectBR[3]=parent->RectTL[0]+XE_HALFVECTOR(Position.X+Size.X-MarginRight-sr,Position.Y+Size.Y-MarginBottom)+Offset+parent->ChildOffset;
for(ELM elm=Node->FirstChild();!elm.IsEmpty();elm.Next())(*elm->Pointer())->Update();
}

int XE_GUI::CONTROL::SortFunc(CONTROL** a,CONTROL** b)
{
if((*a)->Order>(*b)->Order)return(1);
if((*a)->Order==(*b)->Order)return(0);
if((*a)->Order<(*b)->Order)return(-1);
return(0);
}

void XE_GUI::CONTROL::Unregister()
{
if(!Gui||!Node)return;
Gui->ToUnregister.AddPointer(Node);
}

bool XE_GUI::CONTROL::Identify(CONTROL::TREE* control)
{
if(!control)return(false);
if(Node==control)
return(true);
else
if(Node)
for(ELM elm=Node->FirstChild();!elm.IsEmpty();elm.Next())
if(elm->Pointer()->Pointer()->Identify(control))
return(true);
return(false);
}

bool XE_GUI::CONTROL::Identify(CONTROL* control)
{
if(!control)return(false);
if(this==control)
return(true);
else
if(Node)
for(ELM elm=Node->FirstChild();!elm.IsEmpty();elm.Next())
if(elm->Pointer()->Pointer()->Identify(control))
return(true);
return(false);
}

XE_HALFVECTOR XE_GUI::CONTROL::RealPos()
{
return(RectTL[0]);
}

XE_HALFVECTOR XE_GUI::CONTROL::RealSize()
{
return(RectBR[2]-RectTL[0]);
}

bool XE_GUI::CONTROL::IsCurrentUnactive()
{
return(CurrentUnactive);
}

XE_DWORD XE_GUI::CONTROL::GetLastEvents()
{
return(LastEvents);
}

XE_GUI* XE_GUI::CONTROL::GetGui()
{
return(Gui);
}

XE_GUI::CONTROL* XE_GUI::CONTROL::GetParent()
{
if(!Node)return(0);
if(!Node->GetParent())return(0);
return(Node->GetParent()->Pointer()->Pointer());
}

XE_GUI::CONTROL::TREE* XE_GUI::CONTROL::GetNode()
{
return(Node);
}

XE_GUI::__window::__window()
{
Dragged=false;
}

void XE_GUI::__window::DoEvents()
{
XE_STRING type;
Extend.Seek(0);
Extend.ReadString(type);
if(type=="bar")
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)GetGui()->MoveOnTop(GetParent(),true);
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)Dragged=true;
if(Events&XEF_FLAG_EVENT_MOUSE_RELEASE||!(Events&XEF_FLAG_EVENT_MOUSE_HOLD))Dragged=false;
if(Dragged&&Events&XEF_FLAG_EVENT_MOUSE_MOVE)
{
GetParent()->Position+=XE_VECTOHALF(GetGui()->MouseMoveVec);
GetGui()->Perform(GetParent()->Node->FirstChild()->Pointer()->Pointer(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
}
else
if(type=="btnclose")
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
GetParent()->Unregister();
GetGui()->Perform(GetParent()->Node->FirstChild()->Pointer()->Pointer(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
}
}
else
if(type=="btnfull")
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
GetGui()->Perform(GetParent()->Node->FirstChild()->Pointer()->Pointer(),XEF_FLAG_EVENT_USER<<2,XEF_FLAG_ME,false);
}
}
else
if(type=="btnmini")
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
GetGui()->Perform(GetParent()->Node->FirstChild()->Pointer()->Pointer(),XEF_FLAG_EVENT_USER<<3,XEF_FLAG_ME,false);
}
}
}

void XE_GUI::__button::DoEvents()
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
if(Events&XEF_FLAG_EVENT_MOUSE_ENTER)
{
GetParent()->StyleActive=OverStyle;
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
}
if(Events&XEF_FLAG_EVENT_MOUSE_LEAVE)
{
GetParent()->StyleActive=OutStyle;
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<2,XEF_FLAG_ME,false);
}
}

XE_GUI::__scroll::__scroll()
{
Dragged=false;
DraggedOffset=0;
ContentSize=0;
}

void XE_GUI::__scroll::DoEvents()
{
XE_STRING type;
Extend.Seek(0);
Extend.ReadString(type);
if(type=="hscrollf")
{
Size.X=((GetParent()->GetParent()->Size.X-GetParent()->GetParent()->MarginRight)/max(ContentSize,GetParent()->GetParent()->Size.X-GetParent()->GetParent()->MarginRight))*(GetParent()->GetParent()->Size.X-GetParent()->GetParent()->MarginRight);
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
Dragged=true;
DraggedOffset=(float)GetGui()->LastMousePos.X-Position.X;
}
if(Events&XEF_FLAG_EVENT_MOUSE_RELEASE||!(Events&XEF_FLAG_EVENT_MOUSE_HOLD))
{
Dragged=false;
DraggedOffset=0;
}
if(Dragged&&Events&XEF_FLAG_EVENT_MOUSE_MOVE)
{
Position.X=(float)GetGui()->LastMousePos.X-DraggedOffset;
Position.X=max(0,Position.X);
Position.X=min(Position.X,GetParent()->GetParent()->Size.X-GetParent()->GetParent()->MarginRight-Size.X);
CONTROL* box=GetParent()->GetParent()->Node->FirstChild()->Pointer()->Pointer();
if(box->Size.X-Size.X<=0)
box->ChildOffset.X=0;
else
box->ChildOffset.X=-(max(ContentSize,GetParent()->GetParent()->Size.X)+box->MarginLeft+box->MarginRight-box->Size.X)*(Position.X/(box->Size.X-Size.X));
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
}
if(type=="vscrollf")
{
Size.Y=((GetParent()->GetParent()->Size.Y-GetParent()->GetParent()->MarginBottom)/max(ContentSize,GetParent()->GetParent()->Size.Y-GetParent()->GetParent()->MarginBottom))*(GetParent()->GetParent()->Size.Y-GetParent()->GetParent()->MarginBottom);
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
Dragged=true;
DraggedOffset=(float)GetGui()->LastMousePos.Y-Position.Y;
}
if(Events&XEF_FLAG_EVENT_MOUSE_RELEASE||!(Events&XEF_FLAG_EVENT_MOUSE_HOLD))
{
Dragged=false;
DraggedOffset=0;
}
if(Dragged&&Events&XEF_FLAG_EVENT_MOUSE_MOVE)
{
Position.Y=(float)GetGui()->LastMousePos.Y-DraggedOffset;
Position.Y=max(0,Position.Y);
Position.Y=min(Position.Y,GetParent()->GetParent()->Size.Y-GetParent()->GetParent()->MarginBottom-Size.Y);
CONTROL* box=GetParent()->GetParent()->Node->FirstChild()->Pointer()->Pointer();
if(box->Size.Y-Size.Y<=0)
box->ChildOffset.Y=0;
else
box->ChildOffset.Y=-(max(ContentSize,GetParent()->GetParent()->Size.Y)+box->MarginTop+box->MarginBottom-box->Size.Y)*(Position.Y/(box->Size.Y-Size.Y));
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
}
}
}

XE_GUI::__list::__list()
{
Selected=false;
}

void XE_GUI::__list::DoEvents()
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
if(!XE_IO::KeyboardGet(XE_KEY_CTRL))
for(CONTROL::ELM elm=GetParent()->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
((__list*)elm->Pointer()->Pointer())->Selected=false;
elm->Pointer()->Pointer()->StyleActive=((__list*)elm->Pointer()->Pointer())->OutStyle;
}
Selected=!Selected;
if(Selected)
StyleActive=SelectStyle;
else
StyleActive=OverStyle;
}
if(Events&XEF_FLAG_EVENT_MOUSE_ENTER)
if(!Selected)StyleActive=OverStyle;
if(Events&XEF_FLAG_EVENT_MOUSE_LEAVE)
if(!Selected)StyleActive=OutStyle;
}

XE_GUI::__check::__check()
{
Selected=false;
}

void XE_GUI::__check::DoEvents()
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
Selected=!Selected;
if(Selected)
{
StyleActive=OnStyleA;
StyleUnactive=OnStyleU;
}
else
{
StyleActive=OffStyleA;
StyleUnactive=OffStyleU;
}
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
}

XE_GUI::__option::__option()
{
Selected=false;
}

void XE_GUI::__option::DoEvents()
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
for(CONTROL::ELM elm=GetParent()->GetParent()->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
((__option*)elm->FirstChild()->Pointer()->Pointer())->Selected=false;
elm->FirstChild()->Pointer()->Pointer()->StyleActive=((__option*)elm->FirstChild()->Pointer()->Pointer())->OffStyleA;
elm->FirstChild()->Pointer()->Pointer()->StyleUnactive=((__option*)elm->FirstChild()->Pointer()->Pointer())->OffStyleU;
}
if(!XE_IO::KeyboardGet(XE_KEY_CTRL))
{
Selected=true;
StyleActive=OnStyleA;
StyleUnactive=OnStyleU;
}
GetGui()->Perform(GetParent()->GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
}

XE_GUI::__slider::__slider()
{
Dragged=false;
}

void XE_GUI::__slider::DoEvents()
{
XE_STRING type;
Extend.Seek(0);
Extend.ReadString(type);
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)Dragged=true;
if(Events&XEF_FLAG_EVENT_MOUSE_RELEASE)Dragged=false;
if(type=="hbar")
{
if(Dragged)
{
CONTROL* bar=Node->FirstChild()->Pointer()->Pointer();
bar->Position=XE_HALFVECTOR(XE_IO::MouseGetWinX(GetGui()->GetWindow())-RectTL[0].X-bar->Size.X*0.5f,0);
bar->Position.X=max(0,bar->Position.X);
bar->Position.X=min(bar->Position.X,Size.X-bar->Size.X);
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
}
else
if(type=="vbar")
{
if(Dragged)
{
CONTROL* bar=Node->FirstChild()->Pointer()->Pointer();
bar->Position=XE_HALFVECTOR(0,XE_IO::MouseGetWinY(GetGui()->GetWindow())-RectTL[0].Y-bar->Size.Y*0.5f);
bar->Position.Y=max(0,bar->Position.Y);
bar->Position.Y=min(bar->Position.Y,Size.Y-bar->Size.Y);
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
}
}
}

void XE_GUI::__menu::DoEvents()
{
XE_STRING type;
Extend.Seek(0);
Extend.ReadString(type);
if(type=="menu")
{
if(Events&XEF_FLAG_EVENT_MOUSE_ENTER)
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
if(Events&XEF_FLAG_EVENT_MOUSE_LEAVE)
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
if(Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
Node->FirstChild()->Pointer()->Pointer()->Active=true;
Node->FirstChild()->Pointer()->Pointer()->Visible=true;
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<2,XEF_FLAG_ME,false);
}
}
else
if(type=="menulist")
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER)
{
Active=true;
Visible=true;
}
if(Events&XEF_FLAG_EVENT_MOUSE_OVER||GetParent()->Events&XEF_FLAG_EVENT_MOUSE_OVER)
{
XE_STRING t;
GetParent()->GetParent()->Extend.Seek(0);
GetParent()->GetParent()->Extend.ReadString(t);
if(t=="menuitem")
{
GetParent()->GetParent()->GetParent()->Active=true;
GetParent()->GetParent()->GetParent()->Visible=true;
GetGui()->Perform(GetParent()->GetParent()->GetParent(),XEF_FLAG_EVENT_MOUSE_OVER,XEF_FLAG_ME,false);
}
}
if(Events&XEF_FLAG_EVENT_MOUSE_HOLD&&!(Events&XEF_FLAG_EVENT_MOUSE_OVER)&&GetParent()->Events&XEF_FLAG_EVENT_MOUSE_OUT)
{
Active=false;
Visible=false;
}
}
}

XE_GUI::__edit::__edit()
{
Editable=false;
Carrage=0;
CarrageChange=false;
CarrageMode=false;
PassMode=true;
}

XE_GUI::__edit::~__edit()
{
Pre.Clear();
Post.Clear();
}

void XE_GUI::__edit::DoEvents()
{
if(Editable)
{
XE_STRING chars;
XE_IO::CharactersPopString(chars,true);
if(chars.Length())
{
XE_STRING temp;
char bs[2]={8,0};
chars.Replace(temp,bs,"");
temp.Replace(chars,"\t","");
chars.Replace(temp,"\r","");
temp.Replace(chars,"\n","");
}
Carrage-=XE_EVENTS::Use().DeltaTime;
if(Carrage<=0)
{
Carrage=0.5f;
CarrageChange=true;
CarrageMode=!CarrageMode;
}
if(chars.Length())Pre<<chars;
if(!PassMode)
{
if(CarrageMode)
Text.Format("%s|%s",Pre.Get(),Post.Get());
else
Text.Format("%s%s",Pre.Get(),Post.Get());
}
else
{
Text.Clear();
repeat(Pre.Length())Text<<"*";
if(CarrageMode)Text<<"|";
repeat(Post.Length())Text<<"*";
}
CarrageChange=false;
if(Events&XEF_FLAG_EVENT_KEY_PRESS)
{
if(XE_IO::KeyboardGetPressed(XE_KEY_HOME))
{
XE_STRING temp;
temp.Format("%s%s",Pre.Get(),Post.Get());
Post=temp;
Pre.Clear();
}
if(XE_IO::KeyboardGetPressed(XE_KEY_END))
{
XE_STRING temp;
temp.Format("%s%s",Pre.Get(),Post.Get());
Pre=temp;
Post.Clear();
}
if(XE_IO::KeyboardGetPressed(XE_KEY_BACKSPACE)&&Pre.Length())
{
XE_STRING temp;
temp.Copy(Pre,Pre.Length()-1);
Pre=temp;
}
if(XE_IO::KeyboardGetPressed(XE_KEY_DELETE)&&Post.Length())
{
XE_STRING temp;
temp.Copy(&(Post.Get()[1]),Post.Length()-1);
Post=temp;
}
if(XE_IO::KeyboardGetPressed(XE_KEY_LEFT)&&Pre.Length())
{
XE_STRING temp;
temp.Format("%c%s",Pre.Get()[Pre.Length()-1],Post.Get());
Post=temp;
temp.Copy(Pre,Pre.Length()-1);
Pre=temp;
}
if(XE_IO::KeyboardGetPressed(XE_KEY_RIGHT)&&Post.Length())
{
XE_STRING temp;
temp.Format("%s%c",Pre.Get(),Post.Get()[0]);
Pre=temp;
temp.Copy(&(Post.Get()[1]),Post.Length()-1);
Post=temp;
}
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<3,XEF_FLAG_ME,false);
}
if(chars.Length())GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<2,XEF_FLAG_ME,false);
}
if(Events&XEF_FLAG_EVENT_MOUSE_PRESS&&Events&XEF_FLAG_EVENT_MOUSE_OVER)
{
Editable=true;
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
if(Editable&&Events&XEF_FLAG_EVENT_MOUSE_HOLD&&!(Events&XEF_FLAG_EVENT_MOUSE_OVER))
{
Editable=false;
if(!PassMode)
Text.Format("%s%s",Pre.Get(),Post.Get());
else
{
Text.Clear();
repeat((int)(Pre.Length()+Post.Length()))Text<<"*";
}
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
}
}

XE_GUI::__combo::__combo()
{
Selected=0;
}

void XE_GUI::__combo::DoEvents()
{
XE_STRING type;
Extend.Seek(0);
Extend.ReadString(type);
if(type=="comboboxm")
{
if(Events&XEF_FLAG_EVENT_MOUSE_ENTER)
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<1,XEF_FLAG_ME,false);
if(Events&XEF_FLAG_EVENT_MOUSE_LEAVE)
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<2,XEF_FLAG_ME,false);
if(Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
Node->FirstChild()->Pointer()->Pointer()->Active=true;
Node->FirstChild()->Pointer()->Pointer()->Visible=true;
GetGui()->Perform(GetParent(),XEF_FLAG_EVENT_USER<<3,XEF_FLAG_ME,false);
}
}
else
if(type=="comboboxl")
{
if(GetParent()->Events&XEF_FLAG_EVENT_MOUSE_OVER)
{
GetParent()->Active=true;
GetParent()->Visible=true;
}
if(GetParent()->Events&XEF_FLAG_EVENT_MOUSE_HOLD&&(GetParent()->Events&XEF_FLAG_EVENT_MOUSE_OUT)&&GetParent()->GetParent()->Events&XEF_FLAG_EVENT_MOUSE_OUT)
{
GetParent()->Active=false;
GetParent()->Visible=false;
}
}
}

void XE_GUI::__comboitem::DoEvents()
{
if(Events&XEF_FLAG_EVENT_MOUSE_OVER&&Events&XEF_FLAG_EVENT_MOUSE_PRESS)
{
StyleActive=OutStyle;
((__combo*)GetParent())->Selected=this;
GetParent()->GetParent()->Active=false;
GetParent()->GetParent()->Visible=false;
GetParent()->GetParent()->GetParent()->GetParent()->Text=Text;
GetGui()->Perform(GetParent()->GetParent()->GetParent()->GetParent(),XEF_FLAG_EVENT_USER<<0,XEF_FLAG_ME,false);
}
if(Events&XEF_FLAG_EVENT_MOUSE_ENTER)
StyleActive=OverStyle;
if(Events&XEF_FLAG_EVENT_MOUSE_LEAVE)
StyleActive=OutStyle;
}

XE_GUI::XE_GUI()
{
Window=0;
LastMouseAt=0;
CallbackLoadTextureOtherType=0;
CorrectionFlags=XEF_FLAG_EVENT_MOUSE_PRESS|XEF_FLAG_EVENT_MOUSE_ENTER|XEF_FLAG_EVENT_MOUSE_OVER;
}

bool XE_GUI::Setup(XE_WINDOW* win)
{
if(!win)return(false);
Window=win;
Controls->Pointer()->Gui=this;
Controls->Pointer()->Node=&Controls;
return(true);
}

XE_GUI::CONTROL* XE_GUI::Register(CONTROL* control,CONTROL* parent)
{
if(!control)return(0);
CONTROL::ELM elm;
if(!parent)
elm=Controls.AddChild(XE_SMART<CONTROL>(control));
else
elm=parent->Node->AddChild(XE_SMART<CONTROL>(control));
if(elm.IsEmpty())return(0);
elm->Pointer()->Pointer()->Gui=this;
elm->Pointer()->Pointer()->Node=elm.iPointer();
return(elm->Pointer()->Pointer());
}

void XE_GUI::Unregister()
{
XE_ELEMENT_POINTER<CONTROL::TREE*> elm=ToUnregister.LastPointer();
while(!elm.IsEmpty())
{
if(Validate(elm()))(*elm.iPointer())->RemoveSelf();
ToUnregister.ErasePointer(elm);
elm=ToUnregister.LastPointer();
}
}

void XE_GUI::ProgressListen(CONTROL* control,XE_VECTOR cutmin,XE_VECTOR cutmax)
{
if(!Window)return;
int mx=XE_IO::MouseGetWinX(Window);
int my=XE_IO::MouseGetWinY(Window);
if(!control)
{
LastMouseAt=0;
MouseMoveVec=XE_VECTOR(mx,my)-LastMousePos;
}
XE_ELEMENTS<CONTROL*> temp;
CONTROL::ELM elm=Controls.FirstChild();
if(control)elm=control->Node->FirstChild();
for(;!elm.IsEmpty();elm.Next())
temp.AddPointer(elm->Pointer()->Pointer());
temp.Sort(CONTROL::SortFunc);
XE_FOREACH(CONTROL*,temp,e)
{
CONTROL* c=e();
XE_HALFVECTOR rectb=(c->RectTL[0]+XE_HALFVECTOR(c->CutMarginLeft,c->CutMarginTop)).Max(XE_VECTOHALF(cutmin));
XE_HALFVECTOR recte=(c->RectBR[2]-XE_HALFVECTOR(c->CutMarginRight,c->CutMarginBottom)).Min(XE_VECTOHALF(cutmax));
if(c->Active)
{
if(XE_IO::KeyboardGet(XE_KEY_ANY))c->Events|=XEF_FLAG_EVENT_KEY_HOLD;
if(XE_IO::KeyboardGetPressed(XE_KEY_ANY))c->Events|=XEF_FLAG_EVENT_KEY_PRESS;
if(XE_IO::KeyboardGetReleased(XE_KEY_ANY))c->Events|=XEF_FLAG_EVENT_KEY_RELEASE;
if(XE_IO::MouseGet(XE_KEY_ANY))c->Events|=XEF_FLAG_EVENT_MOUSE_HOLD;
if(XE_IO::MouseGetPressed(XE_KEY_ANY))c->Events|=XEF_FLAG_EVENT_MOUSE_PRESS;
if(XE_IO::MouseGetReleased(XE_KEY_ANY))c->Events|=XEF_FLAG_EVENT_MOUSE_RELEASE;
if((int)LastMousePos.X!=mx||(int)LastMousePos.Y!=my)
c->Events|=XEF_FLAG_EVENT_MOUSE_MOVE;
if(XeMouseCheckRectWinPos(Window,(int)rectb.X,(int)rectb.Y,(int)recte.X,(int)recte.Y))
{
if(c->Hitable)LastMouseAt=c;
c->Events|=XEF_FLAG_EVENT_MOUSE_OVER;
bool doit2=false;
if(!RectCollision(LastMousePos,XE_VECTOR(rectb.X,rectb.Y),XE_VECTOR(recte.X,recte.Y)))
c->Events|=XEF_FLAG_EVENT_MOUSE_ENTER;
}
else
{
c->Events|=XEF_FLAG_EVENT_MOUSE_OUT;
if(RectCollision(LastMousePos,XE_VECTOR(rectb.X,rectb.Y),XE_VECTOR(recte.X,recte.Y)))
c->Events|=XEF_FLAG_EVENT_MOUSE_LEAVE;
}
if(!c->CutArea)
ProgressListen(c,cutmin,cutmax);
else
ProgressListen(c,XE_HALFTOVEC(rectb),XE_HALFTOVEC(recte));
}
else
c->Events=0;
}
temp.Clear();
}

void XE_GUI::ProgressCorrect(CONTROL* without,unsigned int exclude,CONTROL* control)
{
if(!Window)return;
CONTROL::ELM elm=Controls.FirstChild();
if(control)elm=control->Node->FirstChild();
for(;!elm.IsEmpty();elm.Next())
{
CONTROL* c=elm->Pointer()->Pointer();
if(c!=without)
if(!c->NonCorrected)
c->Events=c->Events&~exclude;
ProgressCorrect(without,exclude,c);
}
}

void XE_GUI::ProgressEvents(CONTROL* control)
{
if(!Window)return;
CONTROL::ELM elm=Controls.FirstChild();
if(control)elm=control->Node->FirstChild();
for(;!elm.IsEmpty();elm.Next())
{
CONTROL* c=elm->Pointer()->Pointer();
c->DoEvents();
ProgressEvents(c);
c->LastEvents=c->Events;
c->Events=0;
}
if(!control)
LastMousePos=XE_VECTOR(XE_IO::MouseGetWinX(Window),XE_IO::MouseGetWinY(Window));
}

void XE_GUI::Progress()
{
if(!Window)return;
ProgressListen(0,XE_VECTOR(),XE_VECTOR(Window->Width,Window->Height));
ProgressCorrect(LastMouseAt,CorrectionFlags);
ProgressEvents();
}

void XE_GUI::Draw(bool achancare)
{
if(!Window)return;
XE_ELEMENTS<CONTROL*> temp;
for(CONTROL::ELM e=Controls.FirstChild();!e.IsEmpty();e.Next())
temp.AddPointer(e->Pointer()->Pointer());
temp.Sort(CONTROL::SortFunc);
XeSetState(XE_RENDER_SCISSOR_MODE,XE_TRUE);
if(!achancare)
{
XE_FOREACH(CONTROL*,temp,e)
e()->Draw(XE_VECTOR(),XE_VECTOR(Window->Width,Window->Height));
}
else
{
XeSetState(XE_RENDER_MASK,XE_FALSE,XE_FALSE,XE_FALSE,XE_TRUE);
XeSetState(XE_RENDER_BLEND_TYPE,XE_RENDER_BLEND_SRC_ALPHA,XE_RENDER_BLEND_ONE);
XE_FOREACH(CONTROL*,temp,e)
e()->Draw(XE_VECTOR(),XE_VECTOR(Window->Width,Window->Height));
XeSetState(XE_RENDER_BLEND_TYPE,XE_RENDER_BLEND_SRC_ALPHA,XE_RENDER_BLEND_ONE_MINUS_SRC_ALPHA);
XeSetState(XE_RENDER_MASK,XE_TRUE,XE_TRUE,XE_TRUE,XE_FALSE);
XE_FOREACH(CONTROL*,temp,e)
e()->Draw(XE_VECTOR(),XE_VECTOR(Window->Width,Window->Height));
XeSetState(XE_RENDER_MASK,XE_TRUE,XE_TRUE,XE_TRUE,XE_TRUE);
}
XeSetState(XE_RENDER_SCISSOR_MODE,XE_FALSE);
temp.Clear();
}

void XE_GUI::Update()
{
for(CONTROL::ELM elm=Controls.FirstChild();!elm.IsEmpty();elm.Next())
elm->Pointer()->Pointer()->Update();
}

bool XE_GUI::Validate(CONTROL::TREE* control)
{
if(!control)return(false);
if(!Controls.Pointer())return(false);
return(Controls.Pointer()->Pointer()->Identify(control));
}

bool XE_GUI::Validate(CONTROL* control)
{
if(!control)return(false);
if(!Controls.Pointer())return(false);
return(Controls.Pointer()->Pointer()->Identify(control));
}

void XE_GUI::Synchronize()
{
for(CONTROL::NAME nam=ControlNames.FirstPointer();!nam.IsEmpty();)
{
if(Validate(nam()))
nam.Next();
else
{
CONTROL::NAME cur=nam;
nam.Next();
ControlNames.Remove(cur());
}
}
}

void XE_GUI::Perform(CONTROL* control,XE_DWORD events,XE_DWORD who,bool validate,bool cleanafter)
{
if(!control)return;
if(validate)
if(control->Node)
if(!Validate(control->Node))return;
if(who&XEF_FLAG_ME)
if(control->Active)
control->Events|=events;
control->DoEvents();
if(cleanafter)control->Events=0;
if(who&XEF_FLAG_CHILDS)
for(CONTROL::ELM elm=control->Node->FirstChild();!elm.IsEmpty();elm.Next())
Perform(elm->Pointer()->Pointer(),events,XEF_FLAG_ME|XEF_FLAG_CHILDS,false);
}

void XE_GUI::MoveOnTop(CONTROL* control,bool reorder)
{
if(!control->Node->GetParent())return;
float minimum=control->Order;
for(CONTROL::ELM elm=control->Node->GetParent()->FirstChild();!elm.IsEmpty();elm.Next())
minimum=min(minimum,elm()->Pointer()->Order);
if(reorder)
{
for(CONTROL::ELM elm=control->Node->GetParent()->FirstChild();!elm.IsEmpty();elm.Next())
if(control!=elm()->Pointer())
elm()->Pointer()->Order=0.0f;
control->Order=-1.0f;
}
else
control->Order=minimum-1.0f;
}

void XE_GUI::Cleanup()
{
Controls.Free();
ToUnregister.Clear();
Styles.Clear();
ControlNames.Clear();
XE_FOREACH(XE_ELM_TEXTURE,TextureNames,elm)
Photon::XeTextureDestroy(elm());
TextureNames.Clear();
XE_FOREACH(XE_FONT,FontNames,elm)
elm->Cleanup();
FontNames.Clear();
}

XE_WINDOW* XE_GUI::GetWindow()
{
return(Window);
}

XE_VECTOR XE_GUI::GetLastMousePos()
{
return(LastMousePos);
}

XE_VECTOR XE_GUI::GetMouseMoveVec()
{
return(MouseMoveVec);
}

#define XE_GUI_LOAD_THEME_AREA_COLORS(type)\
{\
XE_MARKUP::ETAG __tag=_tag->FirstChild();\
while(!__tag.IsEmpty())\
{\
if(__tag()->Name=="0")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaColors##type##[0],'f');\
else \
if(__tag()->Name=="1")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaColors##type##[1],'f');\
else \
if(__tag()->Name=="2")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaColors##type##[2],'f');\
else \
if(__tag()->Name=="3")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaColors##type##[3],'f');\
__tag.Next();\
}\
}

#define XE_GUI_LOAD_THEME_AREA_COORDS(type)\
{\
xml(".","Tiled",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->AreaTiled##type,'f');\
xml(".","Offset",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->AreaOffset##type,'f');\
XE_MARKUP::ETAG __tag=_tag->FirstChild();\
while(!__tag.IsEmpty())\
{\
if(__tag()->Name=="0")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaCoords##type##[0],'f');\
else \
if(__tag()->Name=="1")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaCoords##type##[1],'f');\
else \
if(__tag()->Name=="2")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaCoords##type##[2],'f');\
else \
if(__tag()->Name=="3")\
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->AreaCoords##type##[3],'f');\
__tag.Next();\
}\
}

#define XE_GUI_LOAD_THEME_AREA_TEXTURE(type)\
if(xml(".","Name",XE_MARKUP::CREATE,_tag.iPointer())->Value.Length())\
style->AreaTexture##type##=TextureNames.Access(xml(".","Name",XE_MARKUP::CREATE,_tag.iPointer())->Value);\
else \
style->AreaTexture##type##.Unref();

bool XE_GUI::LoadTheme(char* fname,char* theme)
{
XE_FILE file;
if(!file.Load(fname))
return(false);
XE_MARKUP xml;
if(!xml.Parse((char*)file.Data(),file.Size()," \t\r\n"))
{
file.Free();
return(false);
}
file.Free();
XE_MARKUP::ETAG elm=xml.Tags.FirstChild();
while(!elm.IsEmpty())
{
if(elm()->Name=="Theme"&&xml(".","Name",XE_MARKUP::CREATE,elm.iPointer())->Value==theme)
{
XE_MARKUP::ETAG tag=elm->FirstChild();
while(!tag.IsEmpty())
{
if(tag()->Name=="Include")
{
XE_STRING path=xml(".","File",XE_MARKUP::CREATE,tag.iPointer())->Value;
XE_STRING them=xml(".","Theme",XE_MARKUP::CREATE,tag.iPointer())->Value;
if(!LoadTheme(path,them))
{
xml.Free();
return(false);
}
}
else
if(tag()->Name=="Texture")
{
XE_ELM_TEXTURE texture;
Photon::XeTextureCreate(&texture);
if(xml(".","Type",XE_MARKUP::CREATE,tag.iPointer())->Value=="XET")
Photon::XeTextureLoad(texture,xml(".","File",XE_MARKUP::CREATE,tag.iPointer())->Value,true);
else
if(CallbackLoadTextureOtherType)
CallbackLoadTextureOtherType(texture,xml(".","File",XE_MARKUP::CREATE,tag.iPointer())->Value.Get());
if(Photon::XeTextureActivate(texture))
{
if(xml(".","MinFilter",XE_MARKUP::CREATE,tag.iPointer())->Value=="LINEAR")
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,XE_TEXTURE_PARAM_LINEAR);
else
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,XE_TEXTURE_PARAM_NEAREST);
if(xml(".","MagFilter",XE_MARKUP::CREATE,tag.iPointer())->Value=="LINEAR")
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,XE_TEXTURE_PARAM_LINEAR);
else
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,XE_TEXTURE_PARAM_NEAREST);
if(xml(".","WrapS",XE_MARKUP::CREATE,tag.iPointer())->Value=="CLAMP")
Photon::XeTextureParameter(XE_TEXTURE_PARAM_WRAP_S,XE_TEXTURE_PARAM_CLAMP);
else
Photon::XeTextureParameter(XE_TEXTURE_PARAM_WRAP_S,XE_TEXTURE_PARAM_REPEAT);
if(xml(".","WrapT",XE_MARKUP::CREATE,tag.iPointer())->Value=="CLAMP")
Photon::XeTextureParameter(XE_TEXTURE_PARAM_WRAP_T,XE_TEXTURE_PARAM_CLAMP);
else
Photon::XeTextureParameter(XE_TEXTURE_PARAM_WRAP_T,XE_TEXTURE_PARAM_REPEAT);
}
TextureNames.Access(xml(".","Name",XE_MARKUP::CREATE,tag.iPointer())->Value)=texture;
}
else
if(tag()->Name=="Font")
{
XE_ESTATE minf;
XE_ESTATE magf;
if(xml(".","MinFilter",XE_MARKUP::CREATE,tag.iPointer())->Value=="LINEAR")
minf=XE_TEXTURE_PARAM_LINEAR;
else
minf=XE_TEXTURE_PARAM_NEAREST;
if(xml(".","MagFilter",XE_MARKUP::CREATE,tag.iPointer())->Value=="LINEAR")
magf=XE_TEXTURE_PARAM_LINEAR;
else
magf=XE_TEXTURE_PARAM_NEAREST;
FontNames(xml(".","Name",XE_MARKUP::CREATE,tag.iPointer())->Value)->Prepare(xml(".","TexFile",XE_MARKUP::CREATE,tag.iPointer())->Value,xml(".","MapFile",XE_MARKUP::CREATE,tag.iPointer())->Value,10,minf,magf);
}
else
if(tag()->Name=="Style")
{
STYLE::ELM style=Styles(xml(".","Name",XE_MARKUP::CREATE,tag.iPointer())->Value);
if(xml(".","Inherit",XE_MARKUP::CREATE,tag.iPointer())->Value.Length())
memcpy_s(style.iPointer(),sizeof(STYLE),Styles(xml(".","Inherit",XE_MARKUP::CREATE,tag.iPointer())->Value).iPointer(),sizeof(STYLE));
XE_MARKUP::ETAG _tag=tag->FirstChild();
while(!_tag.IsEmpty())
{
if(_tag()->Name=="AreaSplit")
{
XE_MARKUP::ETAG __tag=_tag->FirstChild();
while(!__tag.IsEmpty())
{
if(__tag()->Name=="Top")
{
XE_STRING v=xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value;
if(v.Length()&&v.Get()[v.Length()-1]=='%')
style->AreaSplitTopType='%';
v.Convert(&style->AreaSplitTop,'h');
}
else
if(__tag()->Name=="Bottom")
{
XE_STRING v=xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value;
if(v.Length()&&v.Get()[v.Length()-1]=='%')
style->AreaSplitBottomType='%';
v.Convert(&style->AreaSplitBottom,'h');
}
else
if(__tag()->Name=="Left")
{
XE_STRING v=xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value;
if(v.Length()&&v.Get()[v.Length()-1]=='%')
style->AreaSplitLeftType='%';
v.Convert(&style->AreaSplitLeft,'h');
}
else 
if(__tag()->Name=="Right")
{
XE_STRING v=xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value;
if(v.Length()&&v.Get()[v.Length()-1]=='%')
style->AreaSplitRightType='%';
v.Convert(&style->AreaSplitRight,'h');
}
__tag.Next();
}
}
else
if(_tag()->Name=="AreaColors")
{
XE_STRING t=xml(".","Align",XE_MARKUP::CREATE,_tag.iPointer())->Value;
if(t=="TOP-LEFT")
XE_GUI_LOAD_THEME_AREA_COLORS(TL)
else
if(t=="TOP")
XE_GUI_LOAD_THEME_AREA_COLORS(TC)
else
if(t=="TOP-RIGHT")
XE_GUI_LOAD_THEME_AREA_COLORS(TR)
else
if(t=="LEFT")
XE_GUI_LOAD_THEME_AREA_COLORS(ML)
else
if(t=="MIDDLE")
XE_GUI_LOAD_THEME_AREA_COLORS(MC)
else
if(t=="RIGHT")
XE_GUI_LOAD_THEME_AREA_COLORS(MR)
else
if(t=="BOTTOM-LEFT")
XE_GUI_LOAD_THEME_AREA_COLORS(BL)
else
if(t=="BOTTOM")
XE_GUI_LOAD_THEME_AREA_COLORS(BC)
else
if(t=="BOTTOM-RIGHT")
XE_GUI_LOAD_THEME_AREA_COLORS(BR)
else
XE_GUI_LOAD_THEME_AREA_COLORS(MC)
}
else
if(_tag()->Name=="AreaCoords")
{
XE_STRING t=xml(".","Align",XE_MARKUP::CREATE,_tag.iPointer())->Value;
if(t=="TOP-LEFT")
XE_GUI_LOAD_THEME_AREA_COORDS(TL)
else
if(t=="TOP")
XE_GUI_LOAD_THEME_AREA_COORDS(TC)
else
if(t=="TOP-RIGHT")
XE_GUI_LOAD_THEME_AREA_COORDS(TR)
else
if(t=="LEFT")
XE_GUI_LOAD_THEME_AREA_COORDS(ML)
else
if(t=="MIDDLE")
XE_GUI_LOAD_THEME_AREA_COORDS(MC)
else
if(t=="RIGHT")
XE_GUI_LOAD_THEME_AREA_COORDS(MR)
else
if(t=="BOTTOM-LEFT")
XE_GUI_LOAD_THEME_AREA_COORDS(BL)
else
if(t=="BOTTOM")
XE_GUI_LOAD_THEME_AREA_COORDS(BC)
else
if(t=="BOTTOM-RIGHT")
XE_GUI_LOAD_THEME_AREA_COORDS(BR)
else
XE_GUI_LOAD_THEME_AREA_COORDS(MC)
}
else
if(_tag()->Name=="AreaTexture")
{
XE_STRING t=xml(".","Align",XE_MARKUP::CREATE,_tag.iPointer())->Value;
if(t=="TOP-LEFT")
XE_GUI_LOAD_THEME_AREA_TEXTURE(TL)
else
if(t=="TOP")
XE_GUI_LOAD_THEME_AREA_TEXTURE(TC)
else
if(t=="TOP-RIGHT")
XE_GUI_LOAD_THEME_AREA_TEXTURE(TR)
else
if(t=="LEFT")
XE_GUI_LOAD_THEME_AREA_TEXTURE(ML)
else
if(t=="MIDDLE")
XE_GUI_LOAD_THEME_AREA_TEXTURE(MC)
else
if(t=="RIGHT")
XE_GUI_LOAD_THEME_AREA_TEXTURE(MR)
else
if(t=="BOTTOM-LEFT")
XE_GUI_LOAD_THEME_AREA_TEXTURE(BL)
else
if(t=="BOTTOM")
XE_GUI_LOAD_THEME_AREA_TEXTURE(BC)
else
if(t=="BOTTOM-RIGHT")
XE_GUI_LOAD_THEME_AREA_TEXTURE(BR)
else
XE_GUI_LOAD_THEME_AREA_TEXTURE(MC)
}
else
if(_tag()->Name=="AreaColorFilter")
{
xml(".","Value",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->AreaColorFilter,'f');
}
else
if(_tag()->Name=="AsBorder")
{
if(xml(".","Mode",XE_MARKUP::CREATE,_tag.iPointer())->Value=="On")
style->AsBorder=true;
else
style->AsBorder=false;
}
else
if(_tag()->Name=="IconRect")
{
XE_MARKUP::ETAG __tag=_tag->FirstChild();
while(!__tag.IsEmpty())
{
if(__tag()->Name=="0")
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->IconRect[0],'f');
else
if(__tag()->Name=="1")
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->IconRect[1],'f');
else
if(__tag()->Name=="2")
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->IconRect[2],'f');
else
if(__tag()->Name=="3")
xml(".","Value",XE_MARKUP::CREATE,__tag.iPointer())->Value.Convert(&style->IconRect[3],'f');
__tag.Next();
}
}
else
if(_tag()->Name=="TextColor")
{
xml(".","Value",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->TextColor,'v');
}
else
if(_tag()->Name=="TextFont")
{
style->TextFont=FontNames(xml(".","Name",XE_MARKUP::CREATE,_tag.iPointer())->Value).iPointer();
}
else
if(_tag()->Name=="TextHalign")
{
XE_STRING str=xml(".","Mode",XE_MARKUP::CREATE,_tag.iPointer())->Value;
if(str=="LEFT")
style->TextHalign=XE_FONT::LEFT;
else
if(str=="CENTER")
style->TextHalign=XE_FONT::CENTER;
else
if(str=="RIGHT")
style->TextHalign=XE_FONT::RIGHT;
}
else
if(_tag()->Name=="TextValign")
{
XE_STRING str=xml(".","Mode",XE_MARKUP::CREATE,_tag.iPointer())->Value;
if(str=="TOP")
style->TextValign=XE_FONT::TOP;
else
if(str=="MIDDLE")
style->TextValign=XE_FONT::MIDDLE;
else
if(str=="BOTTOM")
style->TextValign=XE_FONT::BOTTOM;
}
else
if(_tag()->Name=="TextOffset")
{
xml(".","Value",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->TextOffset,'v');
}
else
if(_tag()->Name=="TextScale")
{
xml(".","Value",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->TextScale,'v');
}
else
if(_tag()->Name=="TextBorder")
{
if(!xml(".","Color",XE_MARKUP::FIND,_tag.iPointer()).IsEmpty())
xml(".","Color",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->TextBorderColor,'v');
if(!xml(".","Size",XE_MARKUP::FIND,_tag.iPointer()).IsEmpty())
xml(".","Size",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->TextBorderSize,'h');
if(!xml(".","Quality",XE_MARKUP::FIND,_tag.iPointer()).IsEmpty())
xml(".","Quality",XE_MARKUP::CREATE,_tag.iPointer())->Value.Convert(&style->TextBorderQuality,'i');
}
_tag.Next();
}
}
else
if(tag()->Name=="Skin")
{
SKIN::ELM skin=Skins(xml(".","Name",XE_MARKUP::CREATE,tag.iPointer())->Value);
XE_MARKUP::ETAG _tag=tag->FirstChild();
while(!_tag.IsEmpty())
{
if(_tag()->Name=="Style")
{
skin->StyleNames(xml(".","Control",XE_MARKUP::CREATE,_tag.iPointer())->Value)->Set(xml(".","Name",XE_MARKUP::CREATE,_tag.iPointer())->Value);
}
_tag.Next();
}
}
tag.Next();
}
xml.Free();
return(true);
}
else
elm.Next();
}
xml.Free();
return(false);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::WindowCreate(char* skin,char* name,char* caption,XE_HALFVECTOR pos,XE_HALFVECTOR size,unsigned int flags,XE_ELM_TEXTURE icontex,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
CONTROL* area=Register(new __window(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
if(	flags&XEF_FLAG_CAPTION_BAR			||
	flags&XEF_FLAG_BUTTON_CLOSE			||
	flags&XEF_FLAG_BUTTON_FULLSCREEN	||
	flags&XEF_FLAG_BUTTON_MINIMALIZE	)
{
area->MarginTop=24;
area->CutMarginTop=-24;
area->StyleActive=Styles(Skins(skin)->StyleNames("AreaBarActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("AreaBarUnactive")->Get());
}
else
{
area->StyleActive=Styles(Skins(skin)->StyleNames("AreaActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("AreaUnactive")->Get());
}
area->Extend.WriteString("winarea");
CONTROL* box=Register(new T(),area);
if(!box)
{
area->Node->RemoveSelf();
return(false);
}
box->Behaviour=XEF_FLAG_FIT_TO_EDGE;
box->MarginLeft=marginleft;
box->MarginRight=marginright;
box->MarginTop=margintop;
box->MarginBottom=marginbottom;
float rel=0;
if(flags&XEF_FLAG_CAPTION_BAR)
{
CONTROL* bar=Register(new __window(),area);
if(bar)
{
bar->Behaviour=XEF_FLAG_INHERIT_WIDTH|XEF_FLAG_DOCK_TO_EDGE_TOP;
bar->Size=XE_HALFVECTOR(size.X,24.0f);
bar->StyleActive=Styles(Skins(skin)->StyleNames("BarActive")->Get());
bar->StyleUnactive=Styles(Skins(skin)->StyleNames("BarUnactive")->Get());
bar->Text=caption;
bar->Icon=icontex;
bar->Extend.WriteString("bar");
}
}
if(flags&XEF_FLAG_BUTTON_CLOSE)
{
CONTROL* mini=Register(new __window(),area);
if(mini)
{
mini->MarginLeft=-rel;
mini->MarginRight=rel;
mini->Behaviour=XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE|XEF_FLAG_DOCK_TO_EDGE_TOP;
mini->Size=XE_HALFVECTOR(32.0f,24.0f);
mini->StyleActive=Styles(Skins(skin)->StyleNames("ButtonActive")->Get());
mini->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonUnactive")->Get());
mini->Extend.WriteString("btnclose");
mini=Register(new __window(),mini);
if(mini)
{
mini->Position=XE_HALFVECTOR(10.0f,6.0f);
mini->Size=XE_HALFVECTOR(12.0f,12.0f);
mini->StyleActive=Styles(Skins(skin)->StyleNames("ButtonClose")->Get());
mini->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonClose")->Get());
mini->Hitable=false;
}
rel+=32.0f;
}
}
if(flags&XEF_FLAG_BUTTON_FULLSCREEN)
{
CONTROL* mini=Register(new __window(),area);
if(mini)
{
mini->MarginLeft=-rel;
mini->MarginRight=rel;
mini->Behaviour=XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE|XEF_FLAG_DOCK_TO_EDGE_TOP;
mini->Size=XE_HALFVECTOR(32.0f,24.0f);
mini->StyleActive=Styles(Skins(skin)->StyleNames("ButtonActive")->Get());
mini->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonUnactive")->Get());
mini->Extend.WriteString("btnfull");
mini=Register(new __window(),mini);
if(mini)
{
mini->Position=XE_HALFVECTOR(10.0f,6.0f);
mini->Size=XE_HALFVECTOR(12.0f,12.0f);
mini->StyleActive=Styles(Skins(skin)->StyleNames("ButtonFull")->Get());
mini->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonFull")->Get());
mini->Hitable=false;
}
rel+=32.0f;
}
}
if(flags&XEF_FLAG_BUTTON_MINIMALIZE)
{
CONTROL* mini=Register(new __window(),area);
if(mini)
{
mini->MarginLeft=-rel;
mini->MarginRight=rel;
mini->Behaviour=XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE|XEF_FLAG_DOCK_TO_EDGE_TOP;
mini->Size=XE_HALFVECTOR(32.0f,24.0f);
mini->StyleActive=Styles(Skins(skin)->StyleNames("ButtonActive")->Get());
mini->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonUnactive")->Get());
mini->Extend.WriteString("btnmini");
mini=Register(new __window(),mini);
if(mini)
{
mini->Position=XE_HALFVECTOR(10.0f,6.0f);
mini->Size=XE_HALFVECTOR(12.0f,12.0f);
mini->StyleActive=Styles(Skins(skin)->StyleNames("ButtonMin")->Get());
mini->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonMin")->Get());
mini->Hitable=false;
}
rel+=32.0f;
}
}
if(name)ControlNames.Access(name)=box;
return(box);
}

bool XE_GUI::WindowDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->GetParent()->Node->RemoveSelf();
return(true);
}
return(false);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::ButtonCreate(char* skin,char* name,char* text,XE_HALFVECTOR pos,XE_HALFVECTOR size,XE_ELM_TEXTURE icontex,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("AreaActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("AreaUnactive")->Get());
area->Icon=icontex;
area->Text=text;
CONTROL* box=Register(new __button(),area);
if(!box)
{
area->Node->RemoveSelf();
return(0);
}
box->Behaviour=XEF_FLAG_INHERIT_SIZE;
((__button*)box)->OverStyle=Styles(Skins(skin)->StyleNames("AreaOver")->Get());
((__button*)box)->OutStyle=Styles(Skins(skin)->StyleNames("AreaActive")->Get());
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::ButtonDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

bool XE_GUI::ButtonMakeOver(CONTROL* control)
{
if(!control)return(false);
control->StyleActive=((__button*)control->Node->FirstChild()->Pointer()->Pointer())->OverStyle;
return(true);
}

bool XE_GUI::ButtonMakeOut(CONTROL* control)
{
if(!control)return(false);
control->StyleActive=((__button*)control->Node->FirstChild()->Pointer()->Pointer())->OutStyle;
return(true);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::ScrollCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,XE_HALFVECTOR scrsize,XE_HALFVECTOR consize,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
CONTROL* area=Register(new __default(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->CutMarginRight=-scrsize.X;
area->CutMarginBottom=-scrsize.Y;
area->MarginRight=scrsize.X;
area->MarginBottom=scrsize.Y;
area->StyleActive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->Extend.WriteString("scrollarea");
CONTROL* box=Register(new T(),area);
if(!box)
{
area->Node->RemoveSelf();
return(0);
}
box->Behaviour=XEF_FLAG_FIT_TO_EDGE;
box->MarginLeft=marginleft;
box->MarginRight=marginright;
box->MarginTop=margintop;
box->MarginBottom=marginbottom;
CONTROL* scroll=Register(new __scroll(),area);
if(!scroll)
{
area->Node->RemoveSelf();
return(0);
}
scroll->Size.Y=scrsize.Y;
scroll->Behaviour=XEF_FLAG_FIT_TO_EDGE_LEFT|XEF_FLAG_FIT_TO_EDGE_RIGHT|XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
scroll->StyleActive=Styles(Skins(skin)->StyleNames("BarBackH")->Get());
scroll->StyleUnactive=Styles(Skins(skin)->StyleNames("BarBackH")->Get());
scroll->Extend.WriteString("hscrollb");
scroll=Register(new __scroll(),scroll);
if(!scroll)
{
area->Node->RemoveSelf();
return(0);
}
((__scroll*)scroll)->ContentSize=consize.X;
scroll->Behaviour=XEF_FLAG_INHERIT_HEIGHT;
scroll->StyleActive=Styles(Skins(skin)->StyleNames("BarFrontActiveH")->Get());
scroll->StyleUnactive=Styles(Skins(skin)->StyleNames("BarFrontUnactiveH")->Get());
scroll->Extend.WriteString("hscrollf");
scroll=Register(new __scroll(),area);
if(!scroll)
{
area->Node->RemoveSelf();
return(0);
}
scroll->Size.X=scrsize.X;
scroll->Behaviour=XEF_FLAG_FIT_TO_EDGE_TOP|XEF_FLAG_FIT_TO_EDGE_BOTTOM|XEF_FLAG_DOCK_TO_EDGE_RIGHT;
scroll->StyleActive=Styles(Skins(skin)->StyleNames("BarBackV")->Get());
scroll->StyleUnactive=Styles(Skins(skin)->StyleNames("BarBackV")->Get());
scroll->Extend.WriteString("vscrollb");
scroll=Register(new __scroll(),scroll);
if(!scroll)
{
area->Node->RemoveSelf();
return(0);
}
((__scroll*)scroll)->ContentSize=consize.Y;
scroll->Behaviour=XEF_FLAG_INHERIT_WIDTH;
scroll->StyleActive=Styles(Skins(skin)->StyleNames("BarFrontActiveV")->Get());
scroll->StyleUnactive=Styles(Skins(skin)->StyleNames("BarFrontUnactiveV")->Get());
scroll->Extend.WriteString("vscrollf");
if(name)ControlNames.Access(name)=box;
return(box);
}

bool XE_GUI::ScrollDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->GetParent()->Node->RemoveSelf();
return(true);
}
return(false);
}

bool XE_GUI::ScrollSetContentSize(CONTROL* control,XE_HALFVECTOR size)
{
if(!control)return(false);
for(CONTROL::ELM elm=control->GetParent()->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
CONTROL* c=elm->Pointer()->Pointer();
XE_STRING type;
c->Extend.Seek(0);
c->Extend.ReadString(type);
if(type=="hscrollb")
{
CONTROL* d=c->Node->FirstChild()->Pointer()->Pointer();
((__scroll*)d)->ContentSize=size.X;
d->Position.X=0;
d->Size.X=(c->Size.X)*(c->GetParent()->Size.X/max(1,max(c->GetParent()->Size.X,size.X)));
}
else
if(type=="vscrollb")
{
CONTROL* d=c->Node->FirstChild()->Pointer()->Pointer();
((__scroll*)d)->ContentSize=size.Y;
d->Position.Y=0;
d->Size.Y=(c->Size.Y)*(c->GetParent()->Size.Y/max(1,max(c->GetParent()->Size.Y,size.Y)));
}
}
control->ChildOffset=0;
return(true);
}

XE_HALFVECTOR XE_GUI::ScrollGetContentSize(CONTROL* control)
{
if(!control)return(XE_HALFVECTOR());
XE_HALFVECTOR result;
for(CONTROL::ELM elm=control->GetParent()->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
CONTROL* c=elm->Pointer()->Pointer();
XE_STRING type;
c->Extend.Seek(0);
c->Extend.ReadString(type);
if(type=="hscrollb")
result.X=((__scroll*)c->Node->FirstChild()->Pointer()->Pointer())->ContentSize;
else
if(type=="vscrollb")
result.Y=((__scroll*)c->Node->FirstChild()->Pointer()->Pointer())->ContentSize;
}
return(result);
}

XE_GUI::CONTROL* XE_GUI::ScrollGetArea(CONTROL* control)
{
if(!control)return(0);
return(control->GetParent());
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::StaticCreate(char* skin,char* name,char* text,XE_HALFVECTOR pos,XE_HALFVECTOR size,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("AreaActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("AreaUnactive")->Get());
area->Text=text;
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::StaticDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::ProgressBarCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->CutMarginLeft=marginleft;
area->CutMarginRight=marginright;
area->CutMarginTop=margintop;
area->CutMarginBottom=marginbottom;
CONTROL* bar=Register(new __default(),area);
if(!bar)
{
area->Node->RemoveSelf();
return(0);
}
bar->Position=marginleft;
bar->MarginTop=margintop;
bar->MarginBottom=marginbottom;
bar->StyleActive=Styles(Skins(skin)->StyleNames("BarActive")->Get());
bar->StyleUnactive=Styles(Skins(skin)->StyleNames("BarUnactive")->Get());
bar->Behaviour=XEF_FLAG_INHERIT_HEIGHT;
bar->Hitable=false;
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::ProgressBarDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

bool XE_GUI::ProgressBarSetPhase(CONTROL* control,float phase)
{
if(!control)return(false);
control->Node->FirstChild()->Pointer()->Pointer()->Size.X=phase*(control->Size.X-control->CutMarginLeft-control->CutMarginRight);
return(true);
}

float XE_GUI::ProgressBarGetPhase(CONTROL* control)
{
if(!control)return(false);
if(control->Size.X!=0)
return(control->Node->FirstChild()->Pointer()->Pointer()->Size.X/control->Size.X);
else
return(0);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::ListBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float scrsize,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
XE_GUI::CONTROL* list=ScrollCreate<T>(skin,0,pos,size,scrsize,0,margintop,marginbottom,marginleft,marginright,parent);
if(!list)return(0);
list->Extend.WriteString("listbox");
if(name)ControlNames.Access(name)=list;
return(list);
}

bool XE_GUI::ListBoxDestroy(CONTROL* control)
{
return(ScrollDestroy(control));
}

XE_GUI::CONTROL* XE_GUI::ListBoxAddCell(char* skin,char* text,float size,CONTROL* list)
{
if(!list)return(0);
XE_STRING type;
list->Extend.Seek(0);
list->Extend.ReadString(type);
if(type!="listbox")return(0);
float h=0;
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=elm->Pointer()->Pointer()->Size.Y;
}
CONTROL* cell=Register(new __list(),list);
if(!cell)return(0);
cell->Behaviour=XEF_FLAG_FIT_TO_EDGE_LEFT|XEF_FLAG_FIT_TO_EDGE_RIGHT;
cell->Position=XE_HALFVECTOR(0,h);
cell->Size.Y=size;
cell->StyleActive=Styles(Skins(skin)->StyleNames("CellActive")->Get());
cell->StyleUnactive=Styles(Skins(skin)->StyleNames("CellUnactive")->Get());
cell->Text=text;
((__list*)cell)->OverStyle=Styles(Skins(skin)->StyleNames("CellOver")->Get());
((__list*)cell)->SelectStyle=Styles(Skins(skin)->StyleNames("CellSelected")->Get());
((__list*)cell)->OutStyle=Styles(Skins(skin)->StyleNames("CellActive")->Get());
ScrollSetContentSize(list,XE_HALFVECTOR(0,h+size));
return(cell);
}

bool XE_GUI::ListBoxRemoveCell(CONTROL* list,unsigned int id)
{
if(!list)return(false);
unsigned int i=0;
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(id==i++)
{
list->Node->RemoveChild(elm);
float h=0;
for(CONTROL::ELM _elm=list->Node->FirstChild();!_elm.IsEmpty();_elm.Next())
{
_elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=_elm->Pointer()->Pointer()->Size.Y;
}
return(true);
}
return(false);
}

bool XE_GUI::ListBoxClear(CONTROL* list)
{
if(!list)return(false);
XE_STRING type;
list->Extend.Seek(0);
list->Extend.ReadString(type);
if(type!="listbox")return(false);
list->Node->Free();
return(true);
}

unsigned int XE_GUI::ListBoxCellCount(CONTROL* list)
{
if(!list)return(false);
return(list->Node->Count());
}

bool XE_GUI::ListBoxGetCells(CONTROL* list,XE_ELEMENTS<CONTROL*>& con)
{
if(!list)return(false);
con.Clear();
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

bool XE_GUI::ListBoxGetSelected(CONTROL* list,XE_ELEMENTS<CONTROL*>& con)
{
if(!list)return(false);
con.Clear();
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(((__list*)elm->Pointer()->Pointer())->Selected)
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

bool XE_GUI::ListBoxGetUnselected(CONTROL* list,XE_ELEMENTS<CONTROL*>& con)
{
if(!list)return(false);
con.Clear();
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(!((__list*)elm->Pointer()->Pointer())->Selected)
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::CheckBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->Size.Y+=margintop+marginbottom;
area->StyleActive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->CutMarginTop=margintop;
area->CutMarginBottom=marginbottom;
area->CutMarginLeft=marginleft;
area->CutMarginRight=marginright;
area->ChildOffset+=XE_HALFVECTOR(marginleft,margintop);
area->Extend.WriteString("checkbox");
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::CheckBoxDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

XE_GUI::CONTROL* XE_GUI::CheckBoxAddCell(char* skin,char* text,float size,XE_HALFVECTOR chksize,CONTROL* check)
{
if(!check)return(0);
XE_STRING type;
check->Extend.Seek(0);
check->Extend.ReadString(type);
if(type!="checkbox")return(0);
float h=0;
for(CONTROL::ELM elm=check->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=elm->Pointer()->Pointer()->Size.Y;
elm->FirstChild()->Pointer()->Pointer()->Position=XE_HALFVECTOR(max(0,size*0.5f-elm->FirstChild()->Pointer()->Pointer()->Size.X*0.5f),size*0.5f-elm->FirstChild()->Pointer()->Pointer()->Size.Y*0.5f);
}
CONTROL* cell=Register(new __default(),check);
if(!cell)return(0);
cell->Behaviour=XEF_FLAG_FIT_TO_EDGE_LEFT|XEF_FLAG_FIT_TO_EDGE_RIGHT;
cell->Position=XE_HALFVECTOR(0,h);
cell->Size.Y=size;
cell->StyleActive=Styles(Skins(skin)->StyleNames("CellActive")->Get());
cell->StyleUnactive=Styles(Skins(skin)->StyleNames("CellUnactive")->Get());
cell->Text=text;
CONTROL* box=Register(new __check(),cell);
if(!box)
{
cell->Node->RemoveSelf();
return(0);
}
box->Position=XE_HALFVECTOR(max(0,size*0.5f-chksize.X*0.5f),size*0.5f-chksize.Y*0.5f);
box->Size=chksize;
box->StyleActive=Styles(Skins(skin)->StyleNames("CellActiveOff")->Get());
box->StyleUnactive=Styles(Skins(skin)->StyleNames("CellUnactiveOff")->Get());
((__check*)box)->OnStyleA=Styles(Skins(skin)->StyleNames("CellActiveOn")->Get());
((__check*)box)->OnStyleU=Styles(Skins(skin)->StyleNames("CellUnactiveOn")->Get());
((__check*)box)->OffStyleA=Styles(Skins(skin)->StyleNames("CellActiveOff")->Get());
((__check*)box)->OffStyleU=Styles(Skins(skin)->StyleNames("CellUnactiveOff")->Get());
return(cell);
}

bool XE_GUI::CheckBoxRemoveCell(CONTROL* check,unsigned int id)
{
if(!check)return(false);
unsigned int i=0;
for(CONTROL::ELM elm=check->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(id==i++)
{
check->Node->RemoveChild(elm);
float h=0;
for(CONTROL::ELM _elm=check->Node->FirstChild();!_elm.IsEmpty();_elm.Next())
{
_elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=_elm->Pointer()->Pointer()->Size.Y;
}
return(true);
}
return(false);
}

bool XE_GUI::CheckBoxClear(CONTROL* check)
{
if(!check)return(false);
XE_STRING type;
check->Extend.Seek(0);
check->Extend.ReadString(type);
if(type!="checkbox")return(false);
check->Node->Free();
return(true);
}

unsigned int XE_GUI::CheckBoxCellCount(CONTROL* check)
{
if(!check)return(false);
return(check->Node->Count());
}

bool XE_GUI::CheckBoxGetCells(CONTROL* check,XE_ELEMENTS<CONTROL*>& con)
{
if(!check)return(false);
con.Clear();
for(CONTROL::ELM elm=check->Node->FirstChild();!elm.IsEmpty();elm.Next())
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

bool XE_GUI::CheckBoxGetSelected(CONTROL* check,XE_ELEMENTS<CONTROL*>& con)
{
if(!check)return(false);
con.Clear();
for(CONTROL::ELM elm=check->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(((__check*)elm->FirstChild()->Pointer()->Pointer())->Selected)
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

bool XE_GUI::CheckBoxGetUnselected(CONTROL* check,XE_ELEMENTS<CONTROL*>& con)
{
if(!check)return(false);
con.Clear();
for(CONTROL::ELM elm=check->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(!((__check*)elm->Pointer()->Pointer())->Selected)
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::OptionBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->Size.Y+=margintop+marginbottom;
area->StyleActive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->CutMarginTop=margintop;
area->CutMarginBottom=marginbottom;
area->CutMarginLeft=marginleft;
area->CutMarginRight=marginright;
area->ChildOffset+=XE_HALFVECTOR(marginleft,margintop);
area->Extend.WriteString("optionbox");
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::OptionBoxDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

XE_GUI::CONTROL* XE_GUI::OptionBoxAddCell(char* skin,char* text,float size,XE_HALFVECTOR optsize,CONTROL* option)
{
if(!option)return(0);
XE_STRING type;
option->Extend.Seek(0);
option->Extend.ReadString(type);
if(type!="optionbox")return(0);
float h=0;
for(CONTROL::ELM elm=option->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=elm->Pointer()->Pointer()->Size.Y;
elm->FirstChild()->Pointer()->Pointer()->Position=XE_HALFVECTOR(max(0,size*0.5f-elm->FirstChild()->Pointer()->Pointer()->Size.X*0.5f),size*0.5f-elm->FirstChild()->Pointer()->Pointer()->Size.Y*0.5f);
}
CONTROL* cell=Register(new __default(),option);
if(!cell)return(0);
cell->Behaviour=XEF_FLAG_FIT_TO_EDGE_LEFT|XEF_FLAG_FIT_TO_EDGE_RIGHT;
cell->Position=XE_HALFVECTOR(0,h);
cell->Size.Y=size;
cell->StyleActive=Styles(Skins(skin)->StyleNames("CellActive")->Get());
cell->StyleUnactive=Styles(Skins(skin)->StyleNames("CellUnactive")->Get());
cell->Text=text;
CONTROL* box=Register(new __option(),cell);
if(!box)
{
cell->Node->RemoveSelf();
return(0);
}
box->Position=XE_HALFVECTOR(max(0,size*0.5f-optsize.X*0.5f),size*0.5f-optsize.Y*0.5f);
box->Size=optsize;
box->StyleActive=Styles(Skins(skin)->StyleNames("CellActiveOff")->Get());
box->StyleUnactive=Styles(Skins(skin)->StyleNames("CellUnactiveOff")->Get());
((__option*)box)->OnStyleA=Styles(Skins(skin)->StyleNames("CellActiveOn")->Get());
((__option*)box)->OnStyleU=Styles(Skins(skin)->StyleNames("CellUnactiveOn")->Get());
((__option*)box)->OffStyleA=Styles(Skins(skin)->StyleNames("CellActiveOff")->Get());
((__option*)box)->OffStyleU=Styles(Skins(skin)->StyleNames("CellUnactiveOff")->Get());
return(cell);
}

bool XE_GUI::OptionBoxRemoveCell(CONTROL* option,unsigned int id)
{
if(!option)return(false);
unsigned int i=0;
for(CONTROL::ELM elm=option->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(id==i++)
{
option->Node->RemoveChild(elm);
float h=0;
for(CONTROL::ELM _elm=option->Node->FirstChild();!_elm.IsEmpty();_elm.Next())
{
_elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=_elm->Pointer()->Pointer()->Size.Y;
}
return(true);
}
return(false);
}

bool XE_GUI::OptionBoxClear(CONTROL* option)
{
if(!option)return(false);
XE_STRING type;
option->Extend.Seek(0);
option->Extend.ReadString(type);
if(type!="optionbox")return(false);
option->Node->Free();
return(true);
}

unsigned int XE_GUI::OptionBoxCellCount(CONTROL* option)
{
if(!option)return(false);
return(option->Node->Count());
}

bool XE_GUI::OptionBoxGetCells(CONTROL* option,XE_ELEMENTS<CONTROL*>& con)
{
if(!option)return(false);
con.Clear();
for(CONTROL::ELM elm=option->Node->FirstChild();!elm.IsEmpty();elm.Next())
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

XE_GUI::CONTROL* XE_GUI::OptionBoxGetSelected(CONTROL* option)
{
if(!option)return(0);
for(CONTROL::ELM elm=option->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(((__option*)elm->FirstChild()->Pointer()->Pointer())->Selected)
return(elm->Pointer()->Pointer());
return(0);
}

bool XE_GUI::OptionBoxGetUnselected(CONTROL* option,XE_ELEMENTS<CONTROL*>& con)
{
if(!option)return(false);
con.Clear();
for(CONTROL::ELM elm=option->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(!((__option*)elm->FirstChild()->Pointer()->Pointer())->Selected)
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::SliderCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->Extend.WriteString("slider");
CONTROL* box=Register(new __slider(),area);
if(size.X>size.Y)
{
box->StyleActive=Styles(Skins(skin)->StyleNames("BarH")->Get());
box->StyleUnactive=Styles(Skins(skin)->StyleNames("BarH")->Get());
box->Extend.WriteString("hbar");
}
else
{
box->StyleActive=Styles(Skins(skin)->StyleNames("Barv")->Get());
box->StyleUnactive=Styles(Skins(skin)->StyleNames("BarV")->Get());
box->Extend.WriteString("vbar");
}
box->Behaviour=XEF_FLAG_INHERIT_SIZE;
CONTROL* bar=Register(new __default(),box);
if(!bar)
{
area->Node->RemoveSelf();
return(0);
}
float s=min(size.X,size.Y);
bar->Size=XE_HALFVECTOR(s,s);
bar->Position=XE_HALFVECTOR(size.X*0.5f-s*0.5f,0);
bar->StyleActive=Styles(Skins(skin)->StyleNames("DragActive")->Get());
bar->StyleUnactive=Styles(Skins(skin)->StyleNames("DragUnactive")->Get());
if(size.X>size.Y)
bar->Behaviour=XEF_FLAG_DOCK_TO_MIDDLE;
else
bar->Behaviour=XEF_FLAG_DOCK_TO_CENTER;
bar->Hitable=false;
ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::SliderDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

float XE_GUI::SliderGetFactor(CONTROL* control)
{
if(!control)return(0);
XE_STRING type;
control->Node->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
control->Node->FirstChild()->Pointer()->Pointer()->Extend.ReadString(type);
if(type=="hbar")
return(control->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Position.X/(control->Size.X-control->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Size.X));
else
if(type=="vbar")
return(control->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Position.Y/(control->Size.Y-control->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Size.Y));
return(0);
}

bool XE_GUI::SliderSetFactor(CONTROL* control,float factor)
{
if(!control)return(false);
XE_STRING type;
control->Node->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
control->Node->FirstChild()->Pointer()->Pointer()->Extend.ReadString(type);
if(type=="hbar")
{
CONTROL* bar=control->Node->FirstChild()->FirstChild()->Pointer()->Pointer();
bar->Position=XE_HALFVECTOR((control->Size.X-bar->Size.X*0.5f)*factor,0);
bar->Position.X=max(0,bar->Position.X);
bar->Position.X=min(bar->Position.X,control->Size.X-bar->Size.X);
}
else
if(type=="vbar")
{
CONTROL* bar=control->Node->FirstChild()->FirstChild()->Pointer()->Pointer();
bar->Position=XE_HALFVECTOR((control->Size.Y-bar->Size.Y*0.5f)*factor,0);
bar->Position.Y=max(0,bar->Position.Y);
bar->Position.Y=min(bar->Position.Y,control->Size.Y-bar->Size.Y);
}
return(false);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::MenuCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,char* text,XE_ELM_TEXTURE icon,unsigned int listdocktype,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->CutArea=false;
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("AreaActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("AreaUnactive")->Get());
area->Text=text;
area->Extend.WriteString("menubutton");
CONTROL* box=Register(new __menu(),area);
if(!box)
{
area->Node->RemoveSelf();
return(0);
}
box->CutArea=false;
box->Behaviour=XEF_FLAG_INHERIT_SIZE;
box->Extend.WriteString("menu");
CONTROL* list=Register(new __menu(),box);
if(!list)
{
area->Node->RemoveSelf();
return(0);
}
list->CutArea=false;
list->Extend.WriteString("menulist");
list->StyleActive=Styles(Skins(skin)->StyleNames("ListArea")->Get());
list->StyleUnactive=Styles(Skins(skin)->StyleNames("ListArea")->Get());
if(listdocktype>=0x40&&listdocktype<0x4000)list->Behaviour=listdocktype;
list->Visible=false;
list->Active=false;
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::MenuDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::MenuAddItemButton(CONTROL* menu,char* skin,XE_HALFVECTOR size,char* text,XE_ELM_TEXTURE icon)
{
if(!menu)return(0);
float h=0;
for(CONTROL::ELM elm=menu->Node->FirstChild()->FirstChild()->FirstChild();!elm.IsEmpty();elm.Next())
{
elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
elm->Pointer()->Pointer()->Size.X=size.X;
h+=elm->Pointer()->Pointer()->Size.Y;
}
menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Size=XE_HALFVECTOR(size.X,h+size.Y);
return(ButtonCreate<T>(skin,0,text,XE_HALFVECTOR(0,h),size,icon,menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()));
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::MenuAddItemMenu(CONTROL* menu,char* skin,XE_HALFVECTOR size,char* text,XE_ELM_TEXTURE icon,unsigned int listdocktype)
{
if(!menu)return(0);
float h=0;
for(CONTROL::ELM elm=menu->Node->FirstChild()->FirstChild()->FirstChild();!elm.IsEmpty();elm.Next())
{
elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=elm->Pointer()->Pointer()->Size.Y;
elm->Pointer()->Pointer()->Size.X=size.X;
}
menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Size=XE_HALFVECTOR(size.X,h+size.Y);
CONTROL* m=MenuCreate<T>(skin,0,XE_HALFVECTOR(0,h),size,text,icon,listdocktype,menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer());
m->Extend.Free();
m->Extend.WriteString("menuitem");
return(m);
}

bool XE_GUI::MenuCollapse(CONTROL* menu)
{
if(!menu)return(false);
menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Active=false;
menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Visible=false;
for(CONTROL::ELM elm=menu->Node->FirstChild()->FirstChild()->FirstChild();!elm.IsEmpty();elm.Next())
{
XE_STRING t;
elm()->Pointer()->Extend.Seek(0);
elm()->Pointer()->Extend.ReadString(t);
if(t=="menuitem")MenuCollapse(elm()->Pointer());
}
return(true);
}

bool XE_GUI::MenuExpand(CONTROL* menu)
{
if(!menu)return(false);
menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Active=true;
menu->Node->FirstChild()->FirstChild()->Pointer()->Pointer()->Visible=true;
return(true);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::EditBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,char* text,bool password,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("AreaActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("AreaUnactive")->Get());
CONTROL* box=Register(new __edit(),area);
if(!box)
{
area->Node->RemoveSelf();
return(0);
}
box->Behaviour=XEF_FLAG_INHERIT_SIZE;
box->Extend.WriteString("editbox");
box->StyleActive=Styles(Skins(skin)->StyleNames("BoxActive")->Get());
box->StyleUnactive=Styles(Skins(skin)->StyleNames("BoxUnactive")->Get());
((__edit*)box)->Pre=text;
((__edit*)box)->PassMode=password;
if(!password)
box->Text=text;
else
repeat(strlen(text))box->Text<<"*";
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::EditBoxDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

bool XE_GUI::EditBoxPasswordMode(CONTROL* edit,bool mode)
{
if(!edit)return(false);
if(!edit->Node->Count())return(false);
XE_STRING type;
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.ReadString(type);
if(type=="editbox")
{
((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->PassMode=mode;
if(!mode)
edit->Node->FirstChild()->Pointer()->Pointer()->Text.Format("%s%s",((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Pre.Get(),((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Post.Get());
else
{
edit->Node->FirstChild()->Pointer()->Pointer()->Text.Clear();
repeat((int)(((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Pre.Length()+((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Post.Length()))edit->Node->FirstChild()->Pointer()->Pointer()->Text<<"*";
}
return(true);
}
return(false);
}

bool XE_GUI::EditBoxEditMode(CONTROL* edit,bool mode)
{
if(!edit)return(false);
if(!edit->Node->Count())return(false);
XE_STRING type;
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.ReadString(type);
if(type=="editbox")
{
((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Editable=mode;
return(true);
}
return(false);
}

bool XE_GUI::EditBoxGetText(CONTROL* edit,XE_STRING& text)
{
if(!edit)return(false);
if(!edit->Node->Count())return(false);
XE_STRING type;
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.ReadString(type);
if(type=="editbox")
{
text.Format("%s%s",((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Pre.Get(),((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Post.Get());
return(true);
}
return(false);
}

bool XE_GUI::EditBoxSetText(CONTROL* edit,char* text)
{
if(!edit)return(false);
if(!edit->Node->Count())return(false);
XE_STRING type;
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.Seek(0);
edit->Node->FirstChild()->Pointer()->Pointer()->Extend.ReadString(type);
if(type=="editbox")
{
((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Pre=text;
((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Post.Clear();
if(!((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->PassMode)
edit->Node->FirstChild()->Pointer()->Pointer()->Text.Format("%s%s",((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Pre.Get(),((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Post.Get());
else
{
edit->Node->FirstChild()->Pointer()->Pointer()->Text.Clear();
repeat((int)(((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Pre.Length()+((__edit*)edit->Node->FirstChild()->Pointer()->Pointer())->Post.Length()))edit->Node->FirstChild()->Pointer()->Pointer()->Text<<"*";
}
return(true);
}
return(false);
}

XE_GUI::CONTROL* XE_GUI::GroupCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,char* text,CONTROL* parent)
{
CONTROL* area=Register(new __default(),parent);
if(!area)return(0);
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("Area")->Get());
area->Text=text;
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::GroupDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

template<typename T>
XE_GUI::CONTROL* XE_GUI::ComboBoxCreate(char* skin,char* name,XE_HALFVECTOR pos,XE_HALFVECTOR size,XE_HALFVECTOR listsize,float scrsize,char* text,unsigned int listdocktype,float margintop,float marginbottom,float marginleft,float marginright,CONTROL* parent)
{
CONTROL* area=Register(new T(),parent);
if(!area)return(0);
area->CutArea=false;
area->Position=pos;
area->Size=size;
area->StyleActive=Styles(Skins(skin)->StyleNames("ButtonActive")->Get());
area->StyleUnactive=Styles(Skins(skin)->StyleNames("ButtonUnactive")->Get());
area->Text=text;
CONTROL* box=Register(new __combo(),area);
if(!box)
{
area->Node->RemoveSelf();
return(0);
}
box->CutArea=false;
box->Behaviour=XEF_FLAG_INHERIT_SIZE;
box->Extend.WriteString("comboboxm");
CONTROL* list=ScrollCreate<__combo>(skin,0,0,listsize,scrsize,0,margintop,marginbottom,marginleft,marginright,box);
if(!list)
{
area->Node->RemoveSelf();
return(0);
}
list->Extend.WriteString("comboboxl");
list->GetParent()->Behaviour=XEF_FLAG_DOCK_TO_EDGE_BOTTOM;
if(listdocktype>=0x40&&listdocktype<0x4000)list->GetParent()->Behaviour=listdocktype;
list->GetParent()->Visible=false;
list->GetParent()->Active=false;
CONTROL* icon=Register(new __default(),area);
icon->Extend.WriteString("comboboxic");
icon->Behaviour=XEF_FLAG_DOCK_TO_MIDDLE|XEF_FLAG_DOCK_TO_EDGE_RIGHT_INSIDE;
icon->StyleActive=Styles(Skins(skin)->StyleNames("IconActive")->Get());
icon->StyleUnactive=Styles(Skins(skin)->StyleNames("IconUnactive")->Get());
icon->Size=XE_HALFVECTOR(size.Y,size.Y);
icon->Hitable=false;
icon->Order=1;
if(name)ControlNames.Access(name)=area;
return(area);
}

bool XE_GUI::ComboBoxDestroy(CONTROL* control)
{
if(!control)return(false);
XE_FOREACH(CONTROL*,ControlNames,elm)
if(elm()==control)
if(ControlNames.RemovePtr(elm.iPointer()))
{
control->Node->RemoveSelf();
return(true);
}
return(false);
}

XE_GUI::CONTROL* XE_GUI::ComboBoxAddCell(char* skin,char* text,float size,CONTROL* combo)
{
if(!combo)return(0);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
XE_STRING type;
list->Extend.Seek(0);
list->Extend.ReadString(type);
if(type!="comboboxl")return(0);
float h=0;
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
{
elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=elm->Pointer()->Pointer()->Size.Y;
}
CONTROL* cell=Register(new __comboitem(),list);
if(!cell)return(0);
cell->Behaviour=XEF_FLAG_FIT_TO_EDGE_LEFT|XEF_FLAG_FIT_TO_EDGE_RIGHT;
cell->Position=XE_HALFVECTOR(0,h);
cell->Size.Y=size;
cell->StyleActive=Styles(Skins(skin)->StyleNames("CellActive")->Get());
cell->StyleUnactive=Styles(Skins(skin)->StyleNames("CellIUnactive")->Get());
cell->Text=text;
((__comboitem*)cell)->OverStyle=Styles(Skins(skin)->StyleNames("CellOver")->Get());
((__comboitem*)cell)->OutStyle=Styles(Skins(skin)->StyleNames("CellActive")->Get());
ScrollSetContentSize(list,XE_HALFVECTOR(0,h+size));
return(cell);
}

bool XE_GUI::ComboBoxRemoveCell(CONTROL* combo,unsigned int id)
{
if(!combo)return(false);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
unsigned int i=0;
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(id==i++)
{
list->Node->RemoveChild(elm);
float h=0;
for(CONTROL::ELM _elm=list->Node->FirstChild();!_elm.IsEmpty();_elm.Next())
{
_elm->Pointer()->Pointer()->Position=XE_HALFVECTOR(0,h);
h+=_elm->Pointer()->Pointer()->Size.Y;
}
return(true);
}
return(false);
}

bool XE_GUI::ComboBoxClear(CONTROL* combo)
{
if(!combo)return(false);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
list->Node->Free();
return(true);
}

unsigned int XE_GUI::ComboBoxCellCount(CONTROL* combo)
{
if(!combo)return(false);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
return(list->Node->Count());
}

bool XE_GUI::ComboBoxGetCells(CONTROL* combo,XE_ELEMENTS<CONTROL*>& con)
{
if(!combo)return(false);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
con.Clear();
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

XE_GUI::CONTROL* XE_GUI::ComboBoxGetSelected(CONTROL* combo)
{
if(!combo)return(false);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
return(((__combo*)list)->Selected);
}

bool XE_GUI::ComboBoxGetUnselected(CONTROL* combo,XE_ELEMENTS<CONTROL*>& con)
{
if(!combo)return(false);
CONTROL* list=combo->Node->FirstChild()->FirstChild()->FirstChild()->Pointer()->Pointer();
con.Clear();
for(CONTROL::ELM elm=list->Node->FirstChild();!elm.IsEmpty();elm.Next())
if(elm->Pointer()->Pointer()!=((__combo*)list)->Selected)
con.AddPointer(elm->Pointer()->Pointer());
return(true);
}

#endif /* XE_COMPILE_PHOTON */

#ifdef XE_COMPILE_ETHER

/*--- XE_SESSION ---*/
XE_SESSION::XE_SESSION()
{
Type=XEF_NULL;
OnServerClientAccept=0;
OnServerClientUpdate=0;
OnServerClientDisconnect=0;
OnClientAccept=0;
OnClientUpdate=0;
OnClientDisconnect=0;
}

bool XE_SESSION::Start()
{
return(Ether::XeSocketInitiation());
}

void XE_SESSION::Stop()
{
Ether::XeSocketClosure();
}

bool XE_SESSION::Host(XE_WORD port,int maxconnections)
{
Exit();
Ether::XeSocketCreate(&Server);
if(Server.IsEmpty())return(false);
if(!Ether::XeSocketOpen(Server))
{
Ether::XeSocketDestroy(Server);
Server.Unref();
return(false);
}
if(!Ether::XeSocketListen(Server,port,maxconnections))
{
Ether::XeSocketDestroy(Server);
Server.Unref();
return(false);
}
Type=XEF_SERVER;
Ether::XeSocketCreate(&Incoming);
Ether::XeSocketAsync(Server,true);
return(true);
}

bool XE_SESSION::Join(char* address,XE_WORD port,bool udp)
{
Exit();
Ether::XeSocketCreate(&Server);
if(Server.IsEmpty())return(false);
if(!Ether::XeSocketOpen(Server,udp))
{
Ether::XeSocketDestroy(Server);
Server.Unref();
return(false);
}
if(!Ether::XeSocketConnect(Server,address,port))
{
Ether::XeSocketDestroy(Server);
Server.Unref();
return(false);
}
Type=XEF_CLIENT;
Ether::XeSocketNagle(Server,true);
Ether::XeSocketAsync(Server,false);
if(OnClientAccept)
if(!OnClientAccept(this))
{
Exit();
return(false);
}
Ether::XeSocketAsync(Server,true);
return(true);
}

bool XE_SESSION::Disconnect(XE_ELM_SOCKET sock)
{
XE_FOREACH(XE_ELM_SOCKET,Clients,elm)
if(elm.iClone()==sock)
{
Ether::XeSocketDestroy(elm.iClone());
Clients.ErasePointer(elm);
return(true);
}
return(false);
}

void XE_SESSION::Exit()
{
Ether::XeSocketDestroy(Server);
Server.Unref();
XE_FOREACH(XE_ELM_SOCKET,Clients,elm)
Ether::XeSocketDestroy(elm.iClone());
Clients.Clear();
Ether::XeSocketDestroy(Incoming);
Incoming.Unref();
Type=XEF_NULL;
}

bool XE_SESSION::Progress()
{
if(Type==XEF_NULL)return(false);
else
if(Type==XEF_SERVER)
{
if(Server.IsEmpty()||Incoming.IsEmpty())return(false);
if(Ether::XeSocketAccept(Incoming,Server))
{
Ether::XeSocketNagle(Incoming,true);
Ether::XeSocketAsync(Incoming,false);
XE_ELEMENT_POINTER<XE_ELM_SOCKET> inc=Clients.AddPointer(Incoming);
if(OnServerClientAccept)
if(!OnServerClientAccept(this,inc.iPointer()))
{
Ether::XeSocketDestroy(Incoming);
Incoming.Unref();
Clients.ErasePointer(inc);
}
Ether::XeSocketAsync(*inc.iPointer(),true);
Ether::XeSocketCreate(&Incoming);
}
XE_FOREACH(XE_ELM_SOCKET,Clients,elm)
{
XE_FILE buffs;
while(Ether::XeSocketReceive(*elm.iPointer(),&buffs))
{
if(buffs.Size())
if(OnServerClientUpdate)
OnServerClientUpdate(this,elm.iPointer(),&buffs);
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buffs);
}
}
for(XE_ELEMENT_POINTER<XE_ELM_SOCKET> elm=Clients.FirstPointer();!elm.IsEmpty();)
{
if(!Ether::XeSocketIsConnected(elm.iClone()))
{
if(OnServerClientDisconnect)
OnServerClientDisconnect(this,elm.iPointer());
Ether::XeSocketDestroy(*elm.iPointer());
elm.iPointer()->Unref();
Clients.ErasePointer(elm++);
}
else
elm.Next();
}
return(true);
}
else
if(Type==XEF_CLIENT)
{
if(Server.IsEmpty())return(false);
XE_FILE buffc;
while(Ether::XeSocketReceive(Server,&buffc))
{
if(buffc.Size())
if(OnClientUpdate)
OnClientUpdate(this,&buffc);
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buffc);
}
if(!Ether::XeSocketIsConnected(Server))
{
if(OnClientDisconnect)
OnClientDisconnect(this);
Exit();
return(false);
}
return(true);
}
return(false);
}

unsigned int XE_SESSION::Send(XE_FILE& buffer,XE_ELM_SOCKET to,bool allwithout,unsigned int offset,unsigned int size)
{
if(Type==XEF_NULL)return(false);
if(!to.IsEmpty())
{
if(!allwithout)
return(Ether::XeSocketSend(to,&buffer,true,offset,size));
else
{
if(Type==XEF_SERVER)
{
unsigned int s=0;
unsigned int m=0;
XE_FOREACH(XE_ELM_SOCKET,Clients,elm)
if(elm.iClone()!=to)
{
s=Ether::XeSocketSend(elm.iClone(),&buffer,true,offset,size);
m=max(m,s);
}
return(m);
}
else
if(Type==XEF_CLIENT)
if(Server!=to)
return(Ether::XeSocketSend(Server,&buffer,true,offset,size));
}
}
else
{
if(Type==XEF_SERVER)
{
unsigned int s=0;
unsigned int m=0;
XE_FOREACH(XE_ELM_SOCKET,Clients,elm)
{
s=Ether::XeSocketSend(elm.iClone(),&buffer,true,offset,size);
m=max(m,s);
}
return(m);
}
else
if(Type==XEF_CLIENT)
return(Ether::XeSocketSend(Server,&buffer,true,offset,size));
}
return(0);
}

unsigned int XE_SESSION::Receive(XE_FILE& buffer,XE_ELM_SOCKET from)
{
if(Type==XEF_NULL)return(0);
if(from.IsEmpty())from=Server;
return(Ether::XeSocketReceive(from,&buffer));
}

void XE_SESSION::ReceiveEnd(XE_FILE& buffer)
{
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buffer);
}

XEF_ESTATE XE_SESSION::GetType()
{
return(Type);
}

XE_ELM_SOCKET XE_SESSION::GetServer()
{
return(Server);
}

unsigned int XE_SESSION::ClientsCount()
{
return(Clients.Size());
}

bool XE_SESSION::HTTPrequest(char* server,XE_FILE& request,XE_FILE& result,XE_FILE* data,XE_WORD port,bool onlybody,XE_STRING* resheader,unsigned int packetsize)
{
Exit();
Ether::XeSocketCreate(&Server);
if(Server.IsEmpty())return(false);
if(!Ether::XeSocketOpen(Server))
{
Exit();
return(false);
}
if(!Ether::XeSocketConnect(Server,server,port))
{
Exit();
return(false);
}
Type=XEF_HTTP_REQUEST;
XE_FILE buff;
if(!Ether::XeSocketSend(Server,&request,false))
{
Exit();
return(false);
}
if(data)
{
if(packetsize)
{
unsigned int bsize=0;
while(bsize<data->Size())
{
unsigned int ts=Ether::XeSocketSend(Server,data,false,bsize,packetsize);
if(!ts)
{
Exit();
return(false);
}
bsize+=ts;
}
}
else
if(!Ether::XeSocketSend(Server,data,false))
{
Exit();
return(false);
}
}
bool header=true;
result.Free();
while(true)
{
if(Ether::XeSocketReceive(Server,&buff,packetsize))
{
if(onlybody)
{
if(header)
{
if(buff.Size()>=4)
for(unsigned int i=0;i<buff.Size();i++)
if(!memcmp(&((char*)buff.Data())[i],"\r\n\r\n",4))
{
header=false;
unsigned int pos=i+4;
XE_STRING str;
str.Copy(((char*)buff.Data()),i);
if(str.Find(0,"Transfer-Encoding: chunked"))
{
while(pos<buff.Size()&&memcmp(&((char*)buff.Data())[pos],"\r\n",2))pos++;
pos+=2;
}
result.Write(&((char*)buff.Data())[pos],buff.Size()-pos);
if(resheader)resheader->Set(str);
break;
}
}
else
result.Write(((char*)buff.Data()),buff.Size());
}
else
result.Write(((char*)buff.Data()),buff.Size());
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buff);
}
else
break;
}
Exit();
return(true);
}

bool XE_SESSION::HTTPrequestAsync(REQUEST& status,char* server,XE_FILE& request,unsigned int datasize,XE_WORD port)
{
Exit();
status.Status=XEF_NULL;
status.Size=0;
status.Current=0;
Ether::XeSocketCreate(&Server);
if(Server.IsEmpty())return(false);
if(!Ether::XeSocketOpen(Server))
{
Exit();
return(false);
}
if(!Ether::XeSocketConnect(Server,server,port))
{
Exit();
return(false);
}
Type=XEF_HTTP_REQUEST;
if(!Ether::XeSocketSend(Server,&request,false))
{
Exit();
return(false);
}
Ether::XeSocketAsync(Server,true);
status.Status=XEF_SEND;
status.Size=datasize;
status.Current=0;
return(true);
}

bool XE_SESSION::HTTPrequestAsyncKeep(REQUEST& status,XE_FILE& result,XE_FILE* data,unsigned int packetsize)
{
if(Server.IsEmpty()||Type!=XEF_HTTP_REQUEST)
{
status.Status=XEF_NULL;
status.Size=0;
status.Current=0;
return(false);
}
XE_FILE buff;
if(status.Status==XEF_SEND)
{
if(data)
{
if(status.Current<status.Size)
{
unsigned int ts=Ether::XeSocketSend(Server,data,false,status.Current,packetsize);
if(!ts)
{
Exit();
return(false);
}
status.Current+=ts;
}
else
{
status.Status=XEF_HEADER;
status.Size=0;
status.Current=0;
}
}
else
{
status.Status=XEF_HEADER;
status.Size=0;
status.Current=0;
}
}
else
if(status.Status==XEF_HEADER)
{
if(Ether::XeSocketReceive(Server,&buff,packetsize))
{
XE_STRING resheader;
unsigned int s=0;
if(buff.Size()>=4)
for(unsigned int i=0;i<buff.Size();i++)
if(!memcmp(&((char*)buff.Data())[i],"\r\n\r\n",4))
{
unsigned int pos=i+4;
s=buff.Size()-pos;
result.Write(&((char*)buff.Data())[pos],s);
resheader.Copy(((char*)buff.Data()),i);
break;
}
if(resheader.Length())
{
XE_STRING line;
unsigned int pos=resheader.Search(line,"\r\n");
while(pos)
{
if(!line.Length())break;
XE_STRING type,arg;
unsigned int p=line.Search(type," ");
line.Search(arg,"\r",p);
if(type=="Content-Length:")
{
status.Status=XEF_KEEP;
arg.Convert(&status.Size,'d');
status.Current=s;
if(status.Current>=status.Size)
{
status.Current=status.Size;
status.Status=XEF_DONE;
Exit();
}
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buff);
return(true);
}
pos=resheader.Search(line,"\r\n",pos);
}
}
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buff);
return(true);
}
else
return(false);
}
else
if(status.Status==XEF_KEEP)
{
unsigned int ts=Ether::XeSocketReceive(Server,&buff,packetsize);
if(ts)
{
result.Write(((char*)buff.Data()),buff.Size());
status.Current+=ts;
Ether::XeSocketReceive(XE_ELM_SOCKET(),&buff);
if(status.Current>=status.Size)
{
status.Current=status.Size;
status.Status=XEF_DONE;
Exit();
}
return(true);
}
else
return(false);
}
return(false);
}

bool XE_SESSION::HTTPrequestAsyncTerminate(REQUEST& status)
{
if(Type!=XEF_HTTP_REQUEST)return(false);
Exit();
status.Status=XEF_NULL;
return(true);
}

bool XE_SESSION::HTTPdownload(char* server,char* fname,XE_FILE& file,XE_WORD port,unsigned int packetsize)
{
XE_STRING sname=fname;
XE_STRING tname;
sname.Replace(tname," ","%20");
XE_STRING str;
str.Format("GET /%s HTTP/1.1\r\nHost: %s\r\nUser-Agent: XenoN Core\r\nConnection: close\r\n\r\n",tname.Get(),server);
XE_FILE req;
req.Write(str.Get(),str.Length());
return(HTTPrequest(server,req,file,0,port,true,0,packetsize));
}

bool XE_SESSION::HTTPdownloadAsync(REQUEST& status,char* server,char* fname,XE_WORD port)
{
XE_STRING sname=fname;
XE_STRING tname;
sname.Replace(tname," ","%20");
XE_STRING str;
str.Format("GET /%s HTTP/1.1\r\nHost: %s\r\nUser-Agent: XenoN Core\r\nConnection: keep-alive\r\n\r\n",tname.Get(),server);
XE_FILE req;
req.Write(str.Get(),str.Length());
return(HTTPrequestAsync(status,server,req,0,port));
}

bool XE_SESSION::HTTPdownloadAsyncKeep(REQUEST& status,XE_FILE& file,unsigned int packetsize)
{
return(HTTPrequestAsyncKeep(status,file,0,packetsize));
}

bool XE_SESSION::HTTPdownloadAsyncTerminate(REQUEST& status)
{
return(HTTPrequestAsyncTerminate(status));
}

bool XE_SESSION::HTTPsend(char* server,char* fname,char* post,XE_FILE& file,XE_WORD port,unsigned int packetsize)
{
XE_STRING sname=fname;
XE_STRING tname;
sname.Replace(tname," ","%20");
XE_STRING str;
str.Format("POST /%s HTTP/1.1\r\nHost: %s\r\nUser-Agent: XenoN Core\r\nConnection: close\r\nContent-Length: %u\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n%s",tname.Get(),server,strlen(post),post);
XE_FILE req;
req.Write(str.Get(),str.Length());
return(HTTPrequest(server,req,file,0,port,true,0,packetsize));
}

bool XE_SESSION::HTTPsendAsync(REQUEST& status,char* server,char* fname,char* post,XE_WORD port)
{
XE_STRING sname=fname;
XE_STRING tname;
sname.Replace(tname," ","%20");
XE_STRING str;
str.Format("POST /%s HTTP/1.1\r\nHost: %s\r\nUser-Agent: XenoN Core\r\nConnection: keep-alive\r\nContent-Length: %u\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n%s",tname.Get(),server,strlen(post),post);
XE_FILE req;
req.Write(str.Get(),str.Length());
return(HTTPrequestAsync(status,server,req,0,port));
}

bool XE_SESSION::HTTPsendAsyncKeep(REQUEST& status,XE_FILE& file,unsigned int packetsize)
{
return(HTTPrequestAsyncKeep(status,file,0,packetsize));
}

bool XE_SESSION::HTTPsendAsyncTerminate(REQUEST& status)
{
return(HTTPrequestAsyncTerminate(status));
}

#endif /* XE_COMPILE_ETHER */

#ifdef XE_COMPILE_PHOTON

/*--- XE_MODEL ---*/
XE_MODEL::GROUP::GROUP()
{
Effect=0;
}

XE_MODEL::XE_MODEL()
{
prepared=false;
}

bool XE_MODEL::Prepare(char* fname,char* mtlpath,XE_ESTATE minfilter,XE_ESTATE magfilter,unsigned int accessflag,bool forcednovbo)
{
XE_FILE file;
if(!file.Load(fname))return(false);
XE_ARRAY<XE_HALFVECTOR> vertices;
XE_ARRAY<XE_HALFVECTOR> coords;
XE_ARRAY<XE_HALFVECTOR> normals;
XE_CONTAINER< XE_PAIR< XE_ELM_TEXTURE,XE_ARRAY<XE_PERVERTEX> > > groups;
XE_ELEMENT_POINTER< XE_PAIR< XE_ELM_TEXTURE,XE_ARRAY<XE_PERVERTEX> > > activegroup;
XE_CONTAINER< XE_PAIR<XE_ELM_TEXTURE,XE_HALFVECTOR> > materials;
XE_ELEMENT_POINTER< XE_PAIR<XE_ELM_TEXTURE,XE_HALFVECTOR> > activemat;
unsigned int linesc=0;
XE_STRING* lines=XE_STRING::ExplodeBuff((char*)file.Data(),file.Size(),"\r\n",linesc);
file.Free();
for(unsigned int i=0;i<linesc;i++)
{
if(lines[i].Get()[0]=='#')continue;
unsigned int wordsc=0;
XE_STRING* words=lines[i].Explode(" ",wordsc);
if(words[0]=="mtllib"&&wordsc==2)
{
XE_FILE mfile;
XE_STRING str;
str.Format("%s/%s",mtlpath,words[1].Get());
if(mfile.Load(str))
{
unsigned int mlinesc=0;
XE_STRING* mlines=XE_STRING::ExplodeBuff((char*)mfile.Data(),mfile.Size(),"\r\n",mlinesc);
mfile.Free();
for(unsigned int j=0;j<mlinesc;j++)
{
if(mlines[i].Get()[0]=='#')continue;
unsigned int mwordsc=0;
XE_STRING* mwords=mlines[j].Explode(" ",mwordsc);
if(mwords[0]=="newmtl"&&mwordsc==2)
{
activemat=materials(mwords[1]);
}
else
if(mwords[0]=="Kd"&&mwordsc==4)
{
if(!activemat.IsEmpty())
{
mwords[1].Convert(&activemat->Value.X,'h');
mwords[2].Convert(&activemat->Value.Y,'h');
mwords[3].Convert(&activemat->Value.Z,'h');
}
}
else
if(mwords[0]=="map_Kd"&&mwordsc==2)
{
if(!activemat.IsEmpty())
{
Photon::XeTextureCreate(&activemat->Key);
XE_STRING texpath;
texpath.Format("%s/%s",mtlpath,mwords[1].Get());
Photon::XeTextureLoad(activemat->Key,texpath,true);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
}
}
delete[] mwords;
}
delete[] mlines;
}
}
else
if(words[0]=="usemtl"&&wordsc==2)
{
activemat=materials(XEF_FIND,words[1]);
if(!activemat.IsEmpty())
{
activegroup=groups(words[1]);
activegroup->Key=materials(words[1])->Key;
}
}
else
if(words[0]=="v"&&wordsc==4)
{
unsigned int c=vertices.Size();
vertices.Resize(c+1);
words[1].Convert(&vertices[c].X,'h');
words[2].Convert(&vertices[c].Y,'h');
words[3].Convert(&vertices[c].Z,'h');
}
else
if(words[0]=="vt"&&wordsc==3)
{
unsigned int c=coords.Size();
coords.Resize(c+1);
words[1].Convert(&coords[c].X,'h');
words[2].Convert(&coords[c].Y,'h');
}
else
if(words[0]=="vn"&&wordsc==4)
{
unsigned int c=normals.Size();
normals.Resize(c+1);
words[1].Convert(&normals[c].X,'h');
words[2].Convert(&normals[c].Y,'h');
words[3].Convert(&normals[c].Z,'h');
}
else
if(words[0]=="f"&&wordsc==4)
{
if(!activegroup.IsEmpty())
if(!activemat.IsEmpty())
{
unsigned int v[3]={0,0,0};
unsigned int vt[3]={0,0,0};
unsigned int vn[3]={0,0,0};
for(unsigned int k=0;k<3;k++)
{
unsigned int p=0;
XE_STRING s;
p=words[1+k].Search(s,"/",p);
s.Convert(&v[k],'d');
p=words[1+k].Search(s,"/",p);
s.Convert(&vt[k],'d');
words[1+k].Search(s,"/",p);
s.Convert(&vn[k],'d');
}
unsigned int c=activegroup->Value.Size();
activegroup->Value.Resize(c+3);
for(unsigned int k=0;k<3;k++)
{
activegroup->Value[c+k].Vertex=vertices[v[k]-1];
activegroup->Value[c+k].Coord=coords[vt[k]-1];
activegroup->Value[c+k].NormalX=normals[vn[k]-1].X;
activegroup->Value[c+k].NormalY=normals[vn[k]-1].Y;
activegroup->Value[c+k].NormalZ=normals[vn[k]-1].Z;
activegroup->Value[c+k].Color=activemat->Value;
}
}
}
delete[] words;
}
delete[] lines;
vertices.Free();
coords.Free();
normals.Free();
for(XE_ELEMENT_POINTER< XE_PAIR< XE_ELM_TEXTURE,XE_ARRAY<XE_PERVERTEX> > > elm=groups.FirstPointer();!elm.IsEmpty();elm.Next())
{
XE_ELEMENT_POINTER<GROUP> group=Groups.AddPointer(GROUP());
group->Textures.Reserve(1);
group->Textures[0]=elm->Key;
group->Vertices.Create(XE_TRIANGLES,elm->Value.Get(),elm->Value.Size(),0,0,accessflag,0,forcednovbo);
elm->Value.Free();
}
groups.Clear();
materials.Clear();
return(true);
}

void XE_MODEL::Draw(XE_VECTOR position,XE_ANGLEVECTOR angle,XE_VECTOR scale)
{
if(!Groups.Size())return;
XE_FOREACH(GROUP,Groups,group)
{
if(group->Textures.IsEmpty())
Photon::XeTextureUnactivate();
else
for(int i=group->Textures.Size()-1;i>=0;i--)
{
Photon::XeTextureUnit(i);
if(!group->Textures[i].IsEmpty())
Photon::XeTextureActivate(group->Textures[i]);
else
Photon::XeTextureUnactivate();
}
Photon::XeMatrixPush();
Photon::XeMatrixIdentity();
Photon::XeMatrixTranslate(position.X,position.Y,position.Z);
Photon::XeMatrixRotate(angle.Gamma,1,0,0);
Photon::XeMatrixRotate(angle.Beta,0,1,0);
Photon::XeMatrixRotate(angle.Alpha,0,0,1);
Photon::XeMatrixScale(scale.X,scale.Y,scale.Z);
group->Vertices.Draw();
Photon::XeMatrixPop();
}
}

void XE_MODEL::Cleanup(bool leavetex)
{
if(prepared&&!leavetex)
{
prepared=false;
XE_FOREACH(GROUP,Groups,group)
{
for(unsigned int i=0;i<group->Textures.Size();i++)
Photon::XeTextureDestroy(group->Textures[i]);
group->Textures.Free();
}
}
XE_FOREACH(GROUP,Groups,group)
group->Vertices.Destroy();
Groups.Clear();
}

void XE_MODEL::ForcePrepared(bool mode)
{
prepared=mode;
}

/*--- XE_ACTOR3D ---*/
XE_ACTOR3D::XE_ACTOR3D()
{
}

void XE_ACTOR3D::DrawModel()
{
Model.Draw(Position,Direction,Scale);
}

#endif /* XE_COMPILE_PHOTON */

#if defined(XE_COMPILE_PHOTON) && !defined(XE_NOT_USE_RESOURCES) && defined(XE_COMPILE_CORE_MATH)

/*--- XeIntroProgress ---*/
void XeIntroProgress(HWND hwnd,void* inout)
{
struct _data{XE_WINDOW* win;float* vis;XE_SPRITE* spr;}*data=(_data*)inout;
XeCameraOrtho(0,0,data->win->Width,data->win->Height,0);
data->spr->SetColor(XE_HALFVECTOR(1.0f,1.0f,1.0f,min(1.0f,2.0f*sin(XE_MATH::DegToRad(*data->vis)))));
*data->vis+=60*XE_EVENTS::Use().DeltaTime;
if(*data->vis>=180)XE_EVENTS::Use().DoIt=false;
data->spr->Draw();
Photon::XeRenderScene(XE_FLAG_SWAP|XE_FLAG_COLORBUFF|XE_FLAG_TRANSFORMIDENT|XE_FLAG_PREMULTALPHA);
}

/*--- XeIntroScene ---*/
void XeIntroScene()
{
XE_RESOURCE res;
XE_WINDOW window;
window.Name.Set("XenoN Core Intro");
window.OnBar=false;
float splash_visible=0;
window.FromDisplay();
window.X=window.Width/2-320;
window.Y=window.Height/2-130;
window.Width=640;
window.Height=260;
window.ColorDepth=32;
window.Zdepth=16;
window.Layered=true;
window.TopMost=true;
if(!window.Create())
{
window.Layered=false;
if(!window.Create())return;
}
Photon::XeRenderTargetActivate(window.GetTarget());
Photon::XeRenderVsync(XE_FALSE);
XeSetState(XE_RENDER_TEXTURING_2D,XE_TRUE);
XeSetState(XE_SCENE_COLOR,0.0,0.0,0.0,0.0);
XeSetState(XE_RENDER_BLEND,XE_TRUE);
XeSetState(XE_RENDER_BLEND_TYPE,XE_RENDER_BLEND_SRC_ALPHA,XE_RENDER_BLEND_ONE_MINUS_SRC_ALPHA);
XE_SPRITE spr;
res.Load(XeEngineHandle(),MAKEINTRESOURCE(XE_RES_SPLASH),MAKEINTRESOURCE(XE_RES_XENON));
void* tex=res.GetData();
spr.PrepareFromMemory(&tex,1,true,XE_TEXTURE_PARAM_LINEAR,XE_TEXTURE_PARAM_LINEAR);
res.Free();
struct{
XE_WINDOW* win;
float* vis;
XE_SPRITE* spr;
}data;
data.win=&window;
data.vis=&splash_visible;
data.spr=&spr;
ShowCursor(false);
#ifndef XE_COMPILE_NOT_INTRO_SOUND
res.Load(XeEngineHandle(),MAKEINTRESOURCE(XE_RES_INTRO),MAKEINTRESOURCE(XE_RES_XENON));
sndPlaySound((char*)res.GetData(),SND_MEMORY|SND_ASYNC|SND_NODEFAULT);
#endif /* XE_COMPILE_NOT_INTRO_SOUND */
XE_EVENTS::Execute(XeIntroProgress,&data);
ShowCursor(true);
Photon::XeRenderScene(XE_FLAG_ALL);
spr.Cleanup();
res.Free();
window.Destroy();
}

#endif

/*--- XeWndProc() ---*/
LRESULT CALLBACK XeWndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
switch(uMsg)
{
case(WM_SYSCOMMAND):
{
switch(wParam)
{
case(SC_RESTORE):
{
ShowWindow(hWnd,SW_SHOWDEFAULT);
return(0);
}
case(SC_SCREENSAVE):
case(SC_MONITORPOWER):
return(0);
}
return(0);
}
case(WM_CLOSE):
{
PostQuitMessage(0);
return(0);
}
case(WM_CHAR):
{
XE_IO::Use().Characters.AddPointer((char)wParam);
return(0);
}
case(WM_KEYDOWN):
{
if(!XE_IO::Use().PressOnce)
{
XE_IO::Use().Key[wParam]=true;
XE_IO::Use().KeyPressed[wParam]=true;
XE_IO::Use().KeyLast=wParam;
}
else
{
if(!XE_IO::Use().Key[wParam])
{
XE_IO::Use().Key[wParam]=true;
XE_IO::Use().KeyPressed[wParam]=true;
XE_IO::Use().KeyLast=wParam;
}
}
return(0);
}
case(WM_KEYUP):
{
XE_IO::Use().Key[wParam]=false;
XE_IO::Use().KeyReleased[wParam]=true;
return(0);
}
case(WM_LBUTTONDOWN):
{
XE_IO::Use().MouseLb=true;
XE_IO::Use().MouseLbPressed=true;
return(0);
}
case(WM_RBUTTONDOWN):
{
XE_IO::Use().MouseRb=true;
XE_IO::Use().MouseRbPressed=true;
return(0);
}
case(WM_MBUTTONDOWN):
{
XE_IO::Use().MouseMb=true;
XE_IO::Use().MouseMbPressed=true;
return(0);
}
case(WM_LBUTTONUP):
{
XE_IO::Use().MouseLb=false;
XE_IO::Use().MouseLbReleased=true;
return(0);
}
case(WM_RBUTTONUP):
{
XE_IO::Use().MouseRb=false;
XE_IO::Use().MouseRbReleased=true;
return(0);
}
case(WM_MBUTTONUP):
{
XE_IO::Use().MouseMb=false;
XE_IO::Use().MouseMbReleased=true;
return(0);
}
case(WM_MOUSEWHEEL):
{
XE_IO::Use().MouseWheel+=GET_WHEEL_DELTA_WPARAM(wParam);
if(abs(XE_IO::Use().MouseWheel)>=WHEEL_DELTA)
{
XE_IO::Use().MouseWheelSteps=XE_IO::Use().MouseWheel/WHEEL_DELTA;
if(XE_IO::Use().MouseWheel>0)XE_IO::Use().MouseWheelUp=true;
if(XE_IO::Use().MouseWheel<0)XE_IO::Use().MouseWheelDown=true;
XE_IO::Use().MouseWheel%=WHEEL_DELTA;
}
return(0);
}
case(XE_TRAY):
{
if(XE_EVENTS::Use().Tray!=NULL)
XE_EVENTS::Use().Tray(hWnd,(int)wParam,(int)lParam);
return(0);
}
}
if(uMsg>=XE_USER_BEGIN)
if(uMsg<XE_USER_END)
if(XE_EVENTS::Use().User!=NULL)
{
XE_EVENTS::Use().User(hWnd,(unsigned int)uMsg,(int)wParam,(int)lParam);
return(0);
}
if(XE_EVENTS::Use().CustomWindowProc)XE_EVENTS::Use().CustomWindowProc(hWnd,uMsg,wParam,lParam);
return(DefWindowProc(hWnd,uMsg,wParam,lParam));
}

/*--- XeMouseCheckRectPos() ---*/
/*! Sprawdza czy kursor myszy znajduje sie w prostokacie.
\param x1 Pozycja X poczatku.
\param y1 Pozycja Y poczatku.
\param x2 Pozycja X konca.
\param y2 Pozycja Y konca.
\return true jesli znajduje sie w prostokacie.
*/
bool XeMouseCheckRectPos(int x1,int y1,int x2,int y2)
{
if(XE_IO::MouseGetX()>=x1)
if(XE_IO::MouseGetY()>=y1)
if(XE_IO::MouseGetX()<=x2)
if(XE_IO::MouseGetY()<=y2)
return(true);
return(false);
}

/*--- XeMouseCheckRectWinPos() ---*/
/*! Sprawdza czy kursor myszy znajduje sie w prostokacie wzgledem okna.
\param _wnd Wskaznik na okno.
\param x1 Pozycja X poczatku.
\param y1 Pozycja Y poczatku.
\param x2 Pozycja X konca.
\param y2 Pozycja Y konca.
\return true jesli znajduje sie w prostokacie wzgledem okna.
*/
bool XeMouseCheckRectWinPos(XE_WINDOW* _wnd,int x1,int y1,int x2,int y2)
{
if(XE_IO::MouseGetWinX(_wnd)>=x1)
if(XE_IO::MouseGetWinY(_wnd)>=y1)
if(XE_IO::MouseGetWinX(_wnd)<x2)
if(XE_IO::MouseGetWinY(_wnd)<y2)
return(true);
return(false);
}

/*--- GetFromRGBA() ---*/
/*! Pobiera wartosc kanalu z koloru hexadecymalnego.
\param color Kolor.
\param type Typ. Dostepne wartosci:
'R', 'r' - kanal czerwony;
'G', 'g' - kanal zielony;
'B', 'b' - kanal niebieski;
'A', 'a' - kanal przezroczystosci;
\return Wartosc kanalu danego koloru.
*/
inline double GetFromRGBA(int color,int type)
{
if(type=='R'||type=='r')return((double)(color&0x000000FF)/(double)255);
if(type=='G'||type=='g')return((double)((color&0x0000FF00)>>8)/(double)255);
if(type=='B'||type=='b')return((double)((color&0x00FF0000)>>16)/(double)255);
if(type=='A'||type=='a')return((double)((color&0xFF000000)>>24)/(double)255);
return(0);
}

/*--- VecToRGBA() ---*/
/*! Konwertuje wektor na kolor hexadecymalny.
\param color Kolor.
\return Wynikowy kolor.
*/
inline int VecToRGBA(XE_VECTOR color)
{
return(((int)(int)(min(1,max(0,color.X))*255))|(((int)(int)(min(1,max(0,color.Y))*255))<<8)|(((int)(min(1,max(0,color.Z))*255))<<16)|(((int)(min(1,max(0,color.W))*255))<<24));
}

/*--- RGBAtoVec() ---*/
/*! Konwertuje kolor hexadecymalny na wektor.
\param color Kolor.
\return Wektor koloru.
*/
inline XE_VECTOR RGBAtoVec(int color)
{
return(XE_VECTOR((double)(color&0x000000FF)/(double)255,(double)((color&0x0000FF00)>>8)/(double)255,(double)((color&0x00FF0000)>>16)/(double)255,(double)((color&0xFF000000)>>24)/(double)255));
}

/*--- BoxCollision() ---*/
/*! Sprawdza czy nastapila kolizja dwoch prostokatow.
\param b1 Poczatkowy punkt pierwszego prostokata.
\param e1 Koncowy punkt pierwszego prostokata.
\param b2 Poczatkowy punkt drugiego prostokata.
\param e2 Koncowy punkt drugiego prostokata.
\return true jesli operacja powiodla sie.
*/
bool BoxCollision(XE_VECTOR b1,XE_VECTOR e1,XE_VECTOR b2,XE_VECTOR e2)
{
if(max(b1.X,e1.X)>=min(b2.X,e2.X))
if(max(b1.Y,e1.Y)>=min(b2.Y,e2.Y))
if(max(b1.Z,e1.Z)>=min(b2.Z,e2.Z))
if(min(b1.X,e1.X)<=max(b2.X,e2.X))
if(min(b1.Y,e1.Y)<=max(b2.Y,e2.Y))
if(min(b1.Z,e1.Z)<=max(b2.Z,e2.Z))
return(true);
return(false);
}

/*--- RectCollision() ---*/
/*! Sprawdza czy nastapila kolizja punktu z prostokatem.
\param p Pozycja punktu.
\param b Poczatek prostokata.
\param e Koniec prostokata.
\return true jesli operacja powiodla sie.
*/
bool RectCollision(XE_VECTOR p,XE_VECTOR b,XE_VECTOR e)
{
if(p.X>=min(b.X,e.X))
if(p.Y>=min(b.Y,e.Y))
if(p.X<max(b.X,e.X))
if(p.Y<max(b.Y,e.Y))
return(true);
return(false);
}

#endif /* XE_CANIMP */

} // namespace: XeCore

#endif /* XENON_CORE_FRAMEWORK_H */
